package main

import (
	"flag"
	"fmt"
	"log"

	"git.xarth.tv/awsi/eniflowner/pkg/funcs"
)

var (
	inputFiles funcs.StringSlice
	reportType string
)

func main() {
	flag.Var(&inputFiles, "file", "path to input file")
	flag.StringVar(&reportType, "report", "", "report type, valid values: consbyday, errors")
	flag.Parse()

	if len(inputFiles) == 0 {
		log.Fatal("Must provide input files using -file flag; separate multiple with comma.")
	}

	log.Printf("Processing input files: %s", inputFiles)

	users, err := parseFiles()
	if err != nil {
		log.Fatalln("[ERROR]", err)
	}

	log.Printf("Building report of %d logs", len(users))
	start, end, report := buildUserByDayReport(users)

	switch reportType {
	default:
		log.Fatalf("[ERROR] (invalid: %s) specify report type: -report consbyday, errors", reportType)
	case "errors":
		log.Printf("Building lines from %v to %v for %d user errors.", start, end, len(report))

		lines := outputErrorsByDayCSV(start, end, report)
		for _, line := range lines {
			fmt.Println(line)
		}
	case "consbyday":
		log.Printf("Building lines from %v to %v for %d user connections.", start, end, len(report))

		lines := outputUserByDayCSV(start, end, report)
		for _, line := range lines {
			fmt.Println(line)
		}
	}
}
