$(function() {
  $('#servicetable').tablesorter({
    theme: 'ice',
    widthFixed: true,
    widgets: ['zebra', 'stickyHeaders', 'filter'],
    widgetOptions: {
      // Use the $.tablesorter.storage utility to save the most recent filters
      filter_saveFilters: true,
      // jQuery selector string of an element used to reset the filters
      filter_reset: 'button.reset1',
      // add custom selector elements to the filter row
      filter_formatter: {
        1: function($cell, indx) {
          return $.tablesorter.filterFormatter.select2($cell, indx, {
            match: false,
          });
        },
        2: function($cell, indx) { },
        3: function($cell, indx) { },
      }
    }
  }).bind('filterEnd', function() {
    var sum = 0;
    var rows = $(this).find('tbody tr:visible').length;
    var hidden = $(this).find('tbody tr.filtered').length;

    $(this).find('tbody tr:visible .metric').each(function() {
      sum += parseInt($(this).html());
    });
    $(this).prev().html(rows + " destinations shown, " + hidden + " hidden, count sum: " + sum);
  });
  $('#accounttable').tablesorter({
    theme: 'ice',
    widthFixed: true,
    widgets: ['zebra', 'stickyHeaders', 'filter'],
    widgetOptions: {
      // Use the $.tablesorter.storage utility to save the most recent filters
      filter_saveFilters: true,
      // jQuery selector string of an element used to reset the filters
      filter_reset: 'button.reset1',
      // add custom selector elements to the filter row
      filter_formatter: {
        0: function($cell, indx) {
          return $.tablesorter.filterFormatter.select2($cell, indx, {
            match: false,
          });
        },
        1: function($cell, indx) {
          return $.tablesorter.filterFormatter.select2($cell, indx, {
            match: false,
          });
        },
        2: function($cell, indx) { },
        3: function($cell, indx) { },
        4: function($cell, indx) {
          return $.tablesorter.filterFormatter.select2($cell, indx, {
            match: false,
          });
        },
      }
    }
  }).bind('filterEnd', function() {
    var sum = 0;
    var rows = $(this).find('tbody tr:visible').length;
    var hidden = $(this).find('tbody tr.filtered').length;

    $(this).find('tbody tr:visible .metric').each(function() {
      sum += parseInt($(this).html());
    });
    $(this).prev().html(rows + " accounts shown, " + hidden + " hidden, flow sum: " + sum);
  });
});
