package funcs

import "strings"

// StringSlice allows passing in a file list through flags.
type StringSlice []string

// String turns a string slice into a comma-separated list.
func (s StringSlice) String() string {
	return strings.Join(s, ",")
}

// Set turns a comma-separated list into a string slice.
func (s *StringSlice) Set(val string) error {
	*s = StringSlice(strings.Split(val, ","))

	return nil
}
