package funcs

import (
	"fmt"
	"io/ioutil"
	"os"

	"gopkg.in/yaml.v3"
)

// GetIPMap returns the ipmap data from a yaml file.
func GetIPMap(filename string) (map[string]string, error) {
	content, err := os.Open(filename)
	if err != nil {
		return nil, fmt.Errorf("reading file: %w", err)
	}
	defer content.Close()

	var ipmap map[string]string

	if err := yaml.NewDecoder(content).Decode(&ipmap); err != nil {
		return nil, fmt.Errorf("yaml decode: %w", err)
	}

	return ipmap, nil
}

// UpdateIPMap adds new IP:services to the ipmap.
func UpdateIPMap(ipmap map[string]string, svc map[string]string, filename string) error {
	if ipmap == nil {
		ipmap = make(map[string]string)
	}

	for k, v := range svc {
		ipmap[k] = v
	}

	data, _ := yaml.Marshal(ipmap)

	if err := ioutil.WriteFile(filename, data, 0600); err != nil {
		return fmt.Errorf("ipmap write: %w", err)
	}

	return nil
}
