#!/bin/bash
#
# This script uses ncgc and ssh to grab all the usernames that have logged into
# a VPN servers in the last N days. Tee the output into a `vpn.users` file.
# You must be connected to Twitch VPN for this to work.
#

DAYS=60
VPN_SERVER_LIST=$(ncgc l -e prod openvpnas)

for i in $VPN_SERVER_LIST; do
  ssh $i "find /var/log/openvpnas.log* -mtime -$DAYS | \
  xargs grep PUSH_REPLY | \
  grep -o '2021 .* SENT' | cut -d' ' -f2 | cut -d/ -f1|sort -u"
done
