#!/bin/bash
#
# This script takes in a list of users gathered from VPN server logs.
# It returns the users' full names and amazon usernames, and writes a usermap file.
# You must be connected to Twitch VPN for this to work.
#

USERLIST=$(sort -u vpn.users)

echo > usermap

for i in $USERLIST; do
  USERDATA=$(ldapsearch -x -H ldaps://ldap.twitch.a2z.com -b 'dc=justin,dc=tv' "uid=$i" +)

  echo "$USERDATA" | grep -Eq 'ds-pwp-account-disabled: true|numResponses: 1'
  if [ "$?" = 0 ]; then
    # echo "Deleted user: $i"
    continue
  fi

  # Twitch LDAP has full name and amazon username.
  USERDATA=$(ldapsearch -x -H ldaps://ldap.twitch.a2z.com -b 'dc=justin,dc=tv' "uid=$i" twAmazonUID)
  AMZID=$(echo "$USERDATA" | grep -E '^twAmazonUID:' | cut -d' ' -f2)

  echo "$AMZID,$i"
  echo "$AMZID,$i" >> usermap
done
