#!/bin/bash
#
# This script takes in a csv file with first item being amazon ID.
# Polls amazon LDAP and grabs full name and manager username.
# Outputs each user's info into their own file.
# Requires Amazon VPN (Cisco).
#

mkdir -p step3_output

for i in $(<usermap); do
  ID=$(echo "$i" | cut -d, -f1)
  OTHER=$(echo "$i" | cut -d, -f2,3,4,5,6,7,8)

  USERDATA=$(ldapsearch -x -t -LLL -h ldap.amazon.com -b o=amazon.com "(&(uid=$ID)(ou:dn:=people))" manager)
  MANAGER=$(echo "$USERDATA" | grep -E '^manager: cn=' | cut -d\( -f2 | cut -d\) -f1)
  NAME=$(echo "$USERDATA" | grep -E '^dn: cn=' | cut -d= -f2 | cut -d\( -f1)

  echo "$ID,$MANAGER,$OTHER,${NAME%?}" | tee "step3_output/${ID}.csv"
  sleep 1s
done
