#!/bin/bash
#
# This script finds all the missing intermediate managers.
# Requires Amazon VPN (Cisco).
#

# Find all managers of managers up to these managers/directors.
STOPHERE="dharry
farhadr
gstavely
jacobw
forrjere
mintonmm
browarek
tdrobbo
tylerobb
mhess
trcchan
wavrmi
aragonmi
dugsc
damiburn
benestev
kaursuni
ajassy"

mkdir -p step4_managers

check() {
  user=$1
  echo "$STOPHERE" | grep -Eq "^$user\$"
  if [ "$?" != "0" ] && [ ! -f "step3_output/${user}.csv" ] && [ ! -f "step4_managers/${user}.csv" ]; then
    sleep 1s
    USERDATA=$(ldapsearch -x -t -LLL -h ldap.amazon.com -b o=amazon.com "(&(uid=${user})(ou:dn:=people))" manager)
    MANAGERMANAGER=$(echo "$USERDATA" | grep -E '^manager: cn=' | cut -d\( -f2 | cut -d\) -f1)
    if [ "$MANAGERMANAGER" != "" ]; then
      echo "$user,$MANAGERMANAGER" | tee "step4_managers/${user}.csv"
      check $MANAGERMANAGER
    fi
  fi
}

for i in step3_output/*.csv; do
  ID=$(echo "$i" | cut -d. -f1 | cut -d/ -f2)
  MANAGER=$(cat $i | cut -d\( -f2 | cut -d\) -f1)
  check $MANAGER
done
