# go-docker-builder

This repo creates and uploads Go Docker images for use by Manta and Jenkins.
It used to live in [this repo](https://git.xarth.tv/dta/language-build-images/tree/ffcf870552f12a64b8eabc03e847df1c1be6dfa0) (before June 2021).

## Usage

Examples:

- [manta.json](https://git.xarth.tv/systems/nrdc/blob/435985d8c6f7603f55f65f64cce07cd909675052/.manta.json#L2)
- [Jenkinsfile](https://git.xarth.tv/systems/statsparser/blob/80958b723e30e148501bae3c0ec0361abf530f79/Jenkinsfile#L38-L40) (Jenkins Declarative Pipeline)

Migrate from previous devtools images by changing your links from:

```
docker.pkgs.xarth.tv/devtools/bionic/go1.13.8:latest
```

To:

```
docker.pkgs.xarth.tv/awsi/bionic/go1.16.4:latest
```

Current Images can be found in Artifactory [at this link][artifactory-link].
Expand `awsi` -> `bionic` and/or `xenial` on the left side to see all the images.

### Pinning vs latest container

Each container is build with two different tags. A `latest` tag, and a tag for
the current date (`date +%Y%m%dT%H%M%S`). The Date tag is never overwritten.
Latest tag is always overwritten by the latest build of
`main` branch. Using the date tag is called "pinning".

The `latest` tags are only overwritten when someone does a manual deploy of
specific Go versions using the [Jenkins job][jenkins-job]. This may happen on
occasion to update the base image or to address a tooling issue.
See [Rebuild](#rebuild) below for more on that process.

## Logic

The [build scripts](scripts) are run once per day by Jenkins.
The [getlatest.sh](scripts/getlatest.sh) script checks golang.org for latest stable
Go builds (version and file SHA). The [getneeded.sh](scripts/getneeded.sh) script
then checks if the versions from golang.org exist in Artifactory.
If not, new Docker images are built, tested and pushed.

## Rebuild

Unlike the previous system that built the Go docker images, this repo does not
rebuild previously-built images automatically when the base image is changed.

To rebuild old images, you first need to locate the versions in Artifactory,
and then feed them into the VERSIONS parameter on the Jenkins job.

Current Images can be found in Artifactory [at this link][artifactory-link].
Expand `bionic` and/or `xenial` on the left side to see all the images.

To rebuild them, run the Jenkins job from the `main` branch with the versions in the VERSIONS parameter.
[Direct link to job][jenkins-job].
Separate each version with a space, ie: `go1.12.0 go1.12.1 go1.15.6 go1.15.12` - this parameter
value will rebuild all four of these versions on bionic and xenial (8 images).

[jenkins-job]: https://jenkins-og.xarth.tv/job/awsi/job/go-docker-builder/job/main/build
[artifactory-link]: https://pkgs.xarth.tv/artifactory/webapp/#/artifacts/browse/tree/General/docker/awsi
