#!/bin/bash
# This script returns the current stable (or requested) go versions from
# golang.org including hashes and OS names (from env.sh).
# Outputs version:sha:baseos, ex: go1.12.1:abcdef:bionic
##

set -e -o pipefail

source "$(dirname $(realpath $0))/env.sh"

if [ -z "$VERSIONS" ]; then
  # Default behavior is to get latest stable versions.
  JSON=$(curl -s "${URL}?mode=json")
  VERSIONS=$(echo "${JSON}" | jq -r '.[] | .version' | xargs)
else
  # $VERSIONS provided; find the SHA for the requested versions.
  JSON=$(curl -s "${URL}?mode=json&include=all")
fi

for v in ${VERSIONS}; do
  # Parse the values from the json. You _could_ get filename here too.
  files=$(echo "${JSON}"  | jq -r '.[] | select(.version == "'"${v}"'") | .files')
  linux=$(echo "${files}" | jq -r '.[] | select(.os == "linux" and .arch == "amd64")')
  hash=$(echo  "${linux}" | jq -r '.sha256')

  if [ -z "$hash" ]; then
    echo "==> SHA missing for '${v}'. Did you pass the right version name? (VERSIONS: ${VERSIONS}) example: go1.16.4" >&2
    exit 1
  fi

  echo "==> Found Go Version (from GoLang.org): ${v} (OSes: ${BASEOSES})" >&2

  # Append each requested base-OS too. This may create 4+ build pipelines.
  for os in $BASEOSES; do
    # The space at the end of this is intentional. The -n avoids newlines, so
    # all echo'd lines are "appended" with a space between them.
    echo -n "${v}:${hash}:${os} "
  done
done

# do not remove this echo.
echo
