#!/bin/bash
# This script takes in a list of go versions and checks if they exist in artifactory.
# The $LATEST input is expected to be output from getlatest.sh
##

set -e -o pipefail

source "$(dirname $(realpath $0))/env.sh"

if [ -z "$LATEST" ]; then
  echo "Must pass a list of versions as LATEST." >&2
  exit 1
fi

for c in ${LATEST}; do
  v=$(echo "${c}" | cut -d: -f1)
  os=$(echo "${c}" | cut -d: -f3)

  # Check if this image is already in artifactory.
  OUTPUT=$(curl -sI https://${REGISTRY}/artifactory/docker/${NAMESPACE}/${os}/${v}/latest/manifest.json 2>/dev/null)
  if ! (echo "${OUTPUT}" | head -n1 | grep -s '200' >/dev/null 2>&1); then
    # The space at the end of this is intentional. The -n avoids newlines, so
    # all echo'd lines are "appended" with a space between them.
    echo -n "${c} "
    echo "==> Missing from Artifactory: ${os}/${v}" >&2
  else
    echo "==> Exists in Artifactory: ${os}/${v}" >&2
  fi
done

# do not remove this echo.
echo
