#!/bin/bash
# This script sends pre-made slack notifications. The SLACK URL comes from Jenkins secrets.

set -e -o pipefail

source "$(dirname $(realpath $0))/env.sh"

status=$1
if [ -z "${SLACKURL}" ] || [ -z "${status}" ]; then
  echo "==> No Slack URL or no status provided."
  exit 0
fi

# Re-format the versions to look prettier.
for v in $NEWVERSIONS; do
  v1=$(echo $v | cut -d: -f1)
  v2=$(echo $v | cut -d: -f3)
  MYVERS="\n${v2}/${v1}${MYVERS}"
done

send_slack_failed() {
  COLOR=danger
  ICON=darkkappa
  TITLE="Build Failed!"
  CHANNEL=$BUILD_CHANNEL
  send_slack_msg
}

send_slack_finished() {
  COLOR=good
  ICON=homer
  TITLE="Build Finished Successfully!"
  CHANNEL=$BUILD_CHANNEL
  send_slack_msg
}

send_slack_newversion() {
  COLOR="#7E01EE"
  ICON=go
  TITLE="New images pushed to Artifactory!"
  CHANNEL=$NEW_GO_CHAN
  send_slack_msg
}

send_slack_msg() {
  curl -sX POST "${SLACKURL}" --data "payload={ \
    \"channel\": \"${CHANNEL}\", \
    \"attachments\": [{ \
      \"username\":    \"Jenkins\", \
      \"color\":       \"${COLOR}\", \
      \"title\":       \"${TITLE}\", \
      \"title_link\":  \"${BUILD_URL}console\", \
      \"pretext\":     \":${ICON}: <https://git.xarth.tv/awsi/go-docker-builder|Go Docker Image Builder> \", \
      \"text\":        \"*Branch*: ${BRANCH_NAME}\n*Versions Built*:\`\`\`${MYVERS}\`\`\`\", \
      \"mrkdwn_in\":   [\"text\",\"pretext\"] \
    }] \
  }"
}

if   [ "$status" = "ok" ];   then send_slack_finished
elif [ "$status" = "fail" ]; then send_slack_failed
elif [ "$status" = "new" ];  then send_slack_newversion
fi
