package main

import (
	"os"

	"code.justin.tv/awsi/twitch-a2z-com/pkg/backup"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/delegator"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/delidangle"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/slackhook"
	"github.com/aws/aws-lambda-go/cfn"
	"github.com/aws/aws-lambda-go/lambda"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
)

// nolint: gochecknoglobals
var (
	sess = session.Must(session.NewSession())
	awsc = aws.NewConfig().WithMaxRetries(delegator.Retries)
)

// Get the input data and go to Scanning.
func main() {
	Run(os.Getenv("RUNMODE"))
}

// Run runs the app in a specific mode.
func Run(mode string) {
	switch mode {
	case "backup": // Zone Backup -> S3 / CloudWatch Event Trigger.
		lambda.Start(backup.New(sess, awsc).Handler)
	case "worker": // Deligation Checker / SQS Trigger.
		lambda.Start(delidangle.New(sess, awsc).WorkerHandler)
	case "scanner": // Deligation Checker / CloudWatch Event Trigger.
		lambda.Start(delidangle.New(sess, awsc).ScannerHandler)
	case "delegator": // Auto Delegator / SNS Trigger.
		lambda.Start(cfn.LambdaWrapSNS(delegator.New(sess, awsc).LambdaHandler))
	case "notifier": // Slack Notifications / SNS Trigger.
		lambda.Start(slackhook.New().Handler)
	default:
		println("invalid RUNMODE:", mode)
	}
}
