package delegator

//nolint:lll
//go:generate mockgen -destination=../mocks/mock_handler.go -package=mocks code.justin.tv/awsi/twitch-a2z-com/pkg/delegator Handler

import (
	"code.justin.tv/awsi/twitch-a2z-com/pkg/delegate"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/metrics"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/storage"
	"github.com/aws/aws-sdk-go/aws"
)

// Handler allows mocking all library methods inside the handler library.
type Handler interface {
	// Handler
	GetRemoteZone(ctx aws.Context, req *Request) (*delegate.Delegation, error)
	CreateDelegation(ctx aws.Context, req *Request) error
	UpdateDelegation(ctx aws.Context, req *Request, oldZoneID string) error
	DeleteDelegation(ctx aws.Context, req *Request, newZoneID ...string) error
	// Delegate
	GetZone(ctx aws.Context, accountID, zoneID string, svc delegate.Delegator) (*delegate.Delegation, error)
	Create(ctx aws.Context, request *delegate.Delegation) error
	CheckNewZone(ctx aws.Context, delegation *delegate.Delegation) error
	Delete(ctx aws.Context, request *delegate.Delegation) error
	GetNameservers(ctx aws.Context, recordName string) (delegate.NameServers, error)
	SaveOwnZone(ctx aws.Context) error
	// Storage
	Save(ctx aws.Context, delegation *delegate.Delegation, stackid, status string) error
	Get(ctx aws.Context, accountID, subzone string) (*storage.StorePayload, error)
	// Metrics
	Send(metricName, zoneName, accountID string)
}

// SetHandler sets the handler to the provided value, or the default.
func (c *Config) SetHandler(h ...Handler) {
	switch {
	case len(h) != 0 && h[0] != nil:
		c.hw = h[0]
	case c.hw == nil:
		c.hw = struct {
			*Config
			*storage.Storage
			*delegate.Delegate
			*metrics.Metrics
		}{c, c.Storage, c.Delegate, c.Metrics}
	}
}
