package delidangle_test

import (
	"fmt"
	"os"
	"testing"

	"code.justin.tv/awsi/twitch-a2z-com/pkg/delegate"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/delidangle"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/mocks"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	gomock "github.com/golang/mock/gomock"
	"github.com/miekg/dns"
	"github.com/stretchr/testify/assert"
)

type testMocks struct {
	*delidangle.Config
	*mocks.MockDelegator
	*mocks.MockQueuer
	*mocks.MockResolver
	*mocks.MockNotifier
}

// Returns a main Delegate struct with some data and a mocked route53 interface.
func getMocks(mockCtrl *gomock.Controller) *testMocks {
	delegator := mocks.NewMockDelegator(mockCtrl)
	queuer := mocks.NewMockQueuer(mockCtrl)
	resolver := mocks.NewMockResolver(mockCtrl)
	notifier := mocks.NewMockNotifier(mockCtrl)

	return &testMocks{
		Config: &delidangle.Config{
			R53: &delegate.Delegate{
				ZoneName: "main.zone.",
				ZoneID:   "M41N-V3RYC007Z0N31D",
				Svc:      delegator,
			},
			SQSToken: "SQS.TOKEN",
			SNSToken: "SQS.TOKEN",
			SQS:      queuer,
			DNS:      resolver,
			SNS:      notifier,
		}, MockDelegator: delegator,
		MockQueuer:   queuer,
		MockResolver: resolver,
		MockNotifier: notifier,
	}
}

var errTest = fmt.Errorf("test error msg")

//nolint: paralleltest
func TestNewDeliDangle(t *testing.T) {
	os.Setenv("SQS_TOKEN", "http://sqs.stuff")
	os.Setenv("ZONENAME", "ZONENAME")
	os.Setenv("ZONEID", "ZONEID")

	var (
		assert = assert.New(t)
		sess   = session.Must(session.NewSession())
		awsc   = aws.NewConfig()
		config = delidangle.New(sess, awsc)
	)

	assert.Equal(os.Getenv("SQS_TOKEN"), config.SQSToken)
	assert.Equal(os.Getenv("ZONENAME"), config.R53.ZoneName)
	assert.Equal(os.Getenv("ZONEID"), config.R53.ZoneID)
	assert.NotNil(config.R53.Svc)
	assert.NotNil(config.SQS)
	assert.Equal(config.DNS, &dns.Client{Net: "udp"})
}
