package metrics_test

import (
	"context"
	"fmt"
	"testing"

	"code.justin.tv/awsi/twitch-a2z-com/pkg/metrics"
	"code.justin.tv/awsi/twitch-a2z-com/pkg/mocks"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/cloudwatch"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/assert"
)

var errTest = fmt.Errorf("test err")

func TestSend(t *testing.T) {
	t.Parallel()
	assert := assert.New(t)

	mockCtrl := gomock.NewController(t)
	defer mockCtrl.Finish()

	mockstore := mocks.NewMockMaestro(mockCtrl)
	m := &metrics.Metrics{
		Svc:       mockstore,
		Namespace: "myName",
		ZoneID:    "mycool.zon",
	}

	mockstore.EXPECT().PutMetricDataWithContext(gomock.Any(), gomock.Any()).Do(
		func(ctx context.Context, p *cloudwatch.PutMetricDataInput, _ ...request.Option) {
			assert.NotNil(ctx)
			assert.Equal(m.Namespace, *p.Namespace)
			assert.Equal("METRIC_NAME", *p.MetricData[0].MetricName)
			assert.Equal("None", *p.MetricData[0].Unit)
			assert.Equal(float64(1), *p.MetricData[0].Value)
			assert.Equal("subzone", *p.MetricData[0].Dimensions[0].Name)
			assert.Equal("ZONE_NAME", *p.MetricData[0].Dimensions[0].Value)
			assert.Equal("accountid", *p.MetricData[0].Dimensions[1].Name)
			assert.Equal("ACCOUNT_ID", *p.MetricData[0].Dimensions[1].Value)
			assert.Equal("zoneid", *p.MetricData[0].Dimensions[2].Name)
			assert.Equal(m.ZoneID, *p.MetricData[0].Dimensions[2].Value)
		})
	m.Send("METRIC_NAME", "ZONE_NAME", "ACCOUNT_ID")
	mockstore.EXPECT().PutMetricDataWithContext(gomock.Any(), gomock.Any()).Return(nil, errTest)
	m.Send("METRIC_NAME", "ZONE_NAME", "ACCOUNT_ID")
}

/*
_, err := m.Svc.PutMetricDataWithContext(ctx, &cloudwatch.PutMetricDataInput{
  Namespace: aws.String(m.Namespace),
  MetricData: []*cloudwatch.MetricDatum{
    &cloudwatch.MetricDatum{
      MetricName: aws.String(metricName),
      Unit:       aws.String("None"),
      Value:      aws.Float64(1),
      Dimensions: []*cloudwatch.Dimension{
        &cloudwatch.Dimension{
          Name:  aws.String("subzone"),
          Value: aws.String(zoneName),
        }, &cloudwatch.Dimension{
          Name:  aws.String("accountid"),
          Value: aws.String(accountID),
        },
      },
    },
  },
})
*/
