package main

import (
	"context"
	"flag"
	"log"
	"os"

	"code.justin.tv/beefcake/server/cmd/admin/subcmd"
	"github.com/google/subcommands"
)

func main() {
	subcommands.Register(subcommands.HelpCommand(), "")
	subcommands.Register(subcommands.FlagsCommand(), "")
	subcommands.Register(subcommands.CommandsCommand(), "")

	logger := log.New(os.Stderr, "", log.Lshortfile)
	base := &subcmd.Base{Logger: logger}
	subcommands.Register(&subcmd.CreateTask{Base: base}, "admin")
	subcommands.Register(&subcmd.UpdateService{Base: base}, "admin")
	subcommands.Register(&subcmd.BuildLambdas{Logger: logger}, "admin")
	subcommands.Register(&subcmd.UploadLambdas{Logger: logger}, "admin")

	flag.Parse()
	os.Exit(int(subcommands.Execute(context.Background())))
}
