package main

import (
	"context"
	"flag"
	"log"
	"os"

	"code.justin.tv/beefcake/server/cmd/beefcake/subcmd"
	"github.com/google/subcommands"
)

func main() {
	subcommands.Register(subcommands.HelpCommand(), "")
	subcommands.Register(subcommands.FlagsCommand(), "")
	subcommands.Register(subcommands.CommandsCommand(), "")

	logger := log.New(os.Stderr, "", log.Lshortfile)
	subcommands.Register(&subcmd.Serve{Logger: logger}, "beefcake")

	flag.Parse()
	os.Exit(int(subcommands.Execute(context.Background())))
}
