package awsutil

import "github.com/aws/aws-sdk-go/aws/awserr"

// IsStatusCode returns true if an error has a status code.
func IsStatusCode(err error, code string) bool {
	if awsErr, ok := err.(awserr.Error); ok {
		return awsErr.Code() == code
	}
	return false
}
