package legacypermiface

import (
	"context"

	"code.justin.tv/beefcake/server/internal/legacyperm"
	"code.justin.tv/beefcake/server/rpc/beefcake"
)

// LegacyPermissionsAPI ...
type LegacyPermissionsAPI interface {
	All(ctx context.Context) ([]*beefcake.GetLegacyPermissionsResponse_LegacyPermission, error)
	Create(ctx context.Context, id, name, description string) error
	Get(ctx context.Context, id string) (*legacyperm.LegacyPermission, error)
	Update(ctx context.Context, id string, options legacyperm.UpdateOptions) error
	Delete(ctx context.Context, id string) error
	AddRole(ctx context.Context, id, roleID, roleName string) error
	RemoveRole(ctx context.Context, id, roleID string) error
}
