package legacyperm

import (
	"code.justin.tv/beefcake/server/rpc/beefcake"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/golang/protobuf/proto"
)

// Role ...
type Role beefcake.LegacyPermission_Role

// MarshalDynamoDBAttributeValue implements dynamodbattribute.Marshaller
func (r Role) MarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	bs, err := r.MarshalBytes()
	if err != nil {
		return err
	}

	av.SetB(bs)
	return nil
}

// UnmarshalDynamoDBAttributeValue implements dynamodbattribute.Unmarshaller
func (r *Role) UnmarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	return r.UnmarshalBytes(av.B)
}

// MarshalBytes ...
func (r Role) MarshalBytes() ([]byte, error) {
	br := beefcake.LegacyPermission_Role(r)
	bs, err := proto.Marshal(&br)
	if err != nil {
		return nil, err
	}

	return bs, nil
}

// UnmarshalBytes ...
func (r *Role) UnmarshalBytes(in []byte) error {
	var br beefcake.LegacyPermission_Role

	if err := proto.Unmarshal(in, &br); err != nil {
		return err
	}

	*r = Role(br)
	return nil
}
