package optional

import (
	"code.justin.tv/beefcake/server/rpc/beefcake"
	"github.com/golang/protobuf/ptypes/wrappers"
)

// String is an optional string
func String(val string) *string {
	return &val
}

// StringSlice is an optional string
func StringSlice(val []string) *[]string {
	return &val
}

// StringFromWrapper extracts a string pointer from a wrapper.StringValue
func StringFromWrapper(val *wrappers.StringValue) *string {
	if val == nil {
		return nil
	}
	return String(val.GetValue())
}

// StringSliceFromWrapper extracts a string pointer from a wrapper.StringValue
func StringSliceFromWrapper(val *beefcake.StringArrayValue) *[]string {
	if val == nil {
		return nil
	}
	return StringSlice(val.GetValue())
}
