package perm

import (
	"code.justin.tv/beefcake/server/rpc/beefcake"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/golang/protobuf/proto"
)

// Permission is a ddb marshallable permission
type Permission beefcake.Permission

// MarshalDynamoDBAttributeValue implements dynamodbattribute.Marshaller
func (p Permission) MarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	bp := beefcake.Permission(p)
	bs, err := proto.Marshal(&bp)
	if err != nil {
		return err
	}

	av.SetB(bs)
	return nil
}

// UnmarshalDynamoDBAttributeValue implements dynamodbattribute.Unmarshaller
func (p *Permission) UnmarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	var bp beefcake.Permission

	if err := proto.Unmarshal(av.B, &bp); err != nil {
		return err
	}

	*p = Permission(bp)
	return nil
}
