package perm

import (
	"testing"

	"code.justin.tv/beefcake/server/rpc/beefcake"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestPermission(t *testing.T) {
	t.Run("MarshalAndUnmarshal", func(t *testing.T) {
		testPermission := func() beefcake.Permission {
			return beefcake.Permission{
				Value: &beefcake.Permission_Legacy{
					Legacy: &beefcake.Permission_LegacyPermission{
						Id:   "p-id",
						Name: "p-name",
					},
				},
			}
		}

		marshalled, err := dynamodbattribute.Marshal(Permission(testPermission()))
		require.NoError(t, err)

		var unmarshalled Permission
		require.NoError(t, dynamodbattribute.Unmarshal(marshalled, &unmarshalled))
		assert.Equal(t, testPermission(), beefcake.Permission(unmarshalled))
	})
}
