package roleiface

import (
	"context"

	"code.justin.tv/beefcake/server/internal/role"
	"code.justin.tv/beefcake/server/rpc/beefcake"
)

// RolesAPI is a stub for the role.Roles struct
type RolesAPI interface {
	All(ctx context.Context) ([]*role.Role, error)
	Create(ctx context.Context, roleName string) (*role.Role, error)
	Get(ctx context.Context, roleID string) (*role.Role, error)
	Delete(ctx context.Context, roleID string) error
	AddPermission(ctx context.Context, roleID string, permission *beefcake.Permission) error
	AddLegacyPermission(ctx context.Context, roleID, permID string) error
	AddLegacyPermissionDetails(ctx context.Context, roleID string, details *beefcake.Permission_LegacyPermission) error
	RemoveLegacyPermissionDetails(ctx context.Context, roleID, legacyPermID string) error
	RemovePermission(ctx context.Context, roleID, rolePermissionID string) error
	RemoveLegacyPermission(ctx context.Context, roleID, permID string) error
	AddUserMembership(ctx context.Context, roleID string, um *beefcake.Role_UserMembership) error
	RemoveUserMembership(ctx context.Context, roleID, userID string) error
	Override(ctx context.Context, roleID, name string, permissions []*beefcake.Permission, memberships []*beefcake.Role_UserMembership) error
	Update(ctx context.Context, roleID string, options role.UpdateOptions) error
}
