package role

import (
	"code.justin.tv/beefcake/server/rpc/beefcake"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/golang/protobuf/proto"
)

// UserMembership ...
type UserMembership beefcake.Role_UserMembership

// MarshalDynamoDBAttributeValue implements dynamodbattribute.Marshaller
func (r UserMembership) MarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	bs, err := r.MarshalBytes()
	if err != nil {
		return err
	}

	av.SetB(bs)
	return nil
}

// UnmarshalDynamoDBAttributeValue implements dynamodbattribute.Unmarshaller
func (r *UserMembership) UnmarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	return r.UnmarshalBytes(av.B)
}

// MarshalBytes ...
func (r UserMembership) MarshalBytes() ([]byte, error) {
	br := beefcake.Role_UserMembership(r)
	bs, err := proto.Marshal(&br)
	if err != nil {
		return nil, err
	}

	return bs, nil
}

// UnmarshalBytes ...
func (r *UserMembership) UnmarshalBytes(in []byte) error {
	var br beefcake.Role_UserMembership

	if err := proto.Unmarshal(in, &br); err != nil {
		return err
	}

	*r = UserMembership(br)
	return nil
}
