package stringutil

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

// Set is a set of strings
type Set map[string]interface{}

// NewSet returns a new string set from a list
func NewSet(values ...string) Set {
	ss := make(Set)
	for _, value := range values {
		ss.Add(value)
	}
	return ss
}

// Add to the set
func (ss Set) Add(value string) {
	ss[value] = nil
}

// Remove an item
func (ss Set) Remove(key string) {
	delete(ss, key)
}

// MarshalDynamoDBAttributeValue implements dynamodbattribute.Marshaller
func (ss Set) MarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	if len(ss) == 0 {
		return nil
	}

	out := make([]*string, 0, len(ss))
	for k := range ss {
		out = append(out, aws.String(k))
	}

	av.SetSS(out)
	return nil
}

// UnmarshalDynamoDBAttributeValue implements dynamodbattribute.Unmarshaller
func (ss *Set) UnmarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	*ss = NewSet()
	for _, k := range av.SS {
		ss.Add(aws.StringValue(k))
	}
	return nil
}
