package testconfig

import (
	"testing"

	"code.justin.tv/beefcake/server/internal/config"
	"code.justin.tv/hygienic/distconf"
)

// New returns a config for unit tests
func New(t *testing.T) *config.Config {
	dconf := distconf.Distconf{Readers: []distconf.Reader{}}
	return &config.Config{
		LegacyPermissionsHashKey:   dconf.Str("TestLegacyPermissionsHashKey", "TestLegacyPermissionsHashKey"),
		LegacyPermissionsTableName: dconf.Str("TestLegacyPermissionsTableName", "TestLegacyPermissionsTableName"),
		RolesTableName:             dconf.Str("TestRolesTableName", "TestRolesTableName"),
		RolesHashKey:               dconf.Str("TestRolesHashKey", "TestRolesHashKey"),
		UsersTableName:             dconf.Str("TestUsersTableName", "TestUsersTableName"),
		UsersHashKey:               dconf.Str("TestUsersHashKey", "TestUsersHashKey"),
	}
}
