package user

import (
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

// Permissions are a map of role permission IDs to unmarshalled permissions
type Permissions map[string][]byte

// Add adds a raw permission to this set
func (rp Permissions) Add(rolePermID string, perm []byte) {
	rp[rolePermID] = perm
}

// Remove a key from this set
func (rp Permissions) Remove(rolePermID string) {
	delete(rp, rolePermID)
}

// MarshalDynamoDBAttributeValue implements dynamodbattribute.Marshaller
func (rp Permissions) MarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	if len(rp) == 0 {
		av.SetM(map[string]*dynamodb.AttributeValue{})
		return nil
	}

	out, err := dynamodbattribute.Marshal(map[string][]byte(rp))
	if err != nil {
		return err
	}

	*av = *out
	return nil
}
