package user

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestPermissions(t *testing.T) {
	t.Run("Add", func(t *testing.T) {
		t.Run("Success", func(t *testing.T) {
			const testRolePermID = "testRolePermID"
			const testPerm = "testPerm"

			perms := make(Permissions)
			perms.Add(testRolePermID, []byte(testPerm))

			assert.Equal(t, Permissions(map[string][]byte{
				testRolePermID: []byte(testPerm),
			}), perms)
		})
	})
}
