package user

import (
	"code.justin.tv/beefcake/server/rpc/beefcake"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/golang/protobuf/proto"
)

// roleMembership is a marshallable User_RoleMembership
type roleMembership beefcake.User_RoleMembership

// MarshalDynamoDBAttributeValue implements dynamodbattribute.Marshaller
func (r roleMembership) MarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	br := beefcake.User_RoleMembership(r)
	bs, err := proto.Marshal(&br)
	if err != nil {
		return err
	}

	av.SetB(bs)
	return nil
}

// UnmarshalDynamoDBAttributeValue implements dynamodbattribute.Unmarshaller
func (r *roleMembership) UnmarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	var br beefcake.User_RoleMembership

	if err := proto.Unmarshal(av.B, &br); err != nil {
		return err
	}

	*r = roleMembership(br)
	return nil
}
