package useriface

import (
	"context"
	"time"

	"code.justin.tv/beefcake/server/internal/user"
	"code.justin.tv/beefcake/server/rpc/beefcake"
)

// UsersAPI ...
type UsersAPI interface {
	Get(ctx context.Context, userID string) (*user.User, error)
	AddRoleMembership(ctx context.Context, userID string, role *beefcake.User_RoleMembership, perms user.Permissions) error
	RemoveRoleMembership(ctx context.Context, userID, roleID string, perms user.Permissions) error
	RemovePermissions(ctx context.Context, userID string, perms user.Permissions) error
	UpdateAccessTime(ctx context.Context, userID string, lastAccessTime time.Time) error
}
