// Code generated by protoc-gen-twirp v5.4.1, DO NOT EDIT.
// source: rpc/beefcake/service.proto

/*
Package beefcake is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.4.1.

It is generated from these files:
	rpc/beefcake/service.proto
*/
package beefcake

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==================
// Beefcake Interface
// ==================

type Beefcake interface {
	// GetRoles gets all role
	GetRoles(context.Context, *GetRolesRequest) (*GetRolesResponse, error)

	// CreateRole creates a role
	CreateRole(context.Context, *CreateRoleRequest) (*CreateRoleResponse, error)

	// GetRole gets a role
	GetRole(context.Context, *GetRoleRequest) (*Role, error)

	// UpdateRole updates an existing role
	UpdateRole(context.Context, *UpdateRoleRequest) (*UpdateRoleResponse, error)

	// OverrideRole overrides all permissions for a role
	OverrideRole(context.Context, *OverrideRoleRequest) (*OverrideRoleResponse, error)

	// DeleteRole deletes a role
	DeleteRole(context.Context, *DeleteRoleRequest) (*DeleteRoleResponse, error)

	// AddRolePermission adds a permission for a role
	AddRolePermission(context.Context, *AddRolePermissionRequest) (*AddRolePermissionResponse, error)

	// RemoveRolePermission removes a permission for a role
	RemoveRolePermission(context.Context, *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error)

	// Add a legacy string permission to a role
	AddLegacyPermissionToRole(context.Context, *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error)

	// Remove a legacy string permission to a role
	RemoveLegacyPermissionFromRole(context.Context, *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error)

	// AddUserToRole adds a user to a role
	AddUserToRole(context.Context, *AddUserToRoleRequest) (*AddUserToRoleResponse, error)

	// RemoveUserFromRole removes a user to a role
	RemoveUserFromRole(context.Context, *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error)

	// User returns a user
	GetUser(context.Context, *GetUserRequest) (*User, error)

	// GetLegacyPermissions returns a single legacy permission
	GetLegacyPermissions(context.Context, *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error)

	// CreateLegacyPermission creates a legacy permission
	CreateLegacyPermission(context.Context, *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error)

	// GetLegacyPermission returns a single legacy permission
	GetLegacyPermission(context.Context, *GetLegacyPermissionRequest) (*LegacyPermission, error)

	// UpdateLegacyPermission updates a legacy permission
	UpdateLegacyPermission(context.Context, *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error)

	// DeleteLegacyPermission deletes a legacy permission
	DeleteLegacyPermission(context.Context, *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error)
}

// ========================
// Beefcake Protobuf Client
// ========================

type beefcakeProtobufClient struct {
	client HTTPClient
	urls   [18]string
}

// NewBeefcakeProtobufClient creates a Protobuf client that implements the Beefcake interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewBeefcakeProtobufClient(addr string, client HTTPClient) Beefcake {
	prefix := urlBase(addr) + BeefcakePathPrefix
	urls := [18]string{
		prefix + "GetRoles",
		prefix + "CreateRole",
		prefix + "GetRole",
		prefix + "UpdateRole",
		prefix + "OverrideRole",
		prefix + "DeleteRole",
		prefix + "AddRolePermission",
		prefix + "RemoveRolePermission",
		prefix + "AddLegacyPermissionToRole",
		prefix + "RemoveLegacyPermissionFromRole",
		prefix + "AddUserToRole",
		prefix + "RemoveUserFromRole",
		prefix + "GetUser",
		prefix + "GetLegacyPermissions",
		prefix + "CreateLegacyPermission",
		prefix + "GetLegacyPermission",
		prefix + "UpdateLegacyPermission",
		prefix + "DeleteLegacyPermission",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &beefcakeProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &beefcakeProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *beefcakeProtobufClient) GetRoles(ctx context.Context, in *GetRolesRequest) (*GetRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	out := new(GetRolesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) CreateRole(ctx context.Context, in *CreateRoleRequest) (*CreateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	out := new(CreateRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) GetRole(ctx context.Context, in *GetRoleRequest) (*Role, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	out := new(Role)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest) (*UpdateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	out := new(UpdateRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) OverrideRole(ctx context.Context, in *OverrideRoleRequest) (*OverrideRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	out := new(OverrideRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest) (*DeleteRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	out := new(DeleteRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) AddRolePermission(ctx context.Context, in *AddRolePermissionRequest) (*AddRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	out := new(AddRolePermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) RemoveRolePermission(ctx context.Context, in *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	out := new(RemoveRolePermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) AddLegacyPermissionToRole(ctx context.Context, in *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	out := new(AddLegacyPermissionToRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) RemoveLegacyPermissionFromRole(ctx context.Context, in *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	out := new(RemoveLegacyPermissionFromRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) AddUserToRole(ctx context.Context, in *AddUserToRoleRequest) (*AddUserToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	out := new(AddUserToRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) RemoveUserFromRole(ctx context.Context, in *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	out := new(RemoveUserFromRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) GetUser(ctx context.Context, in *GetUserRequest) (*User, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(User)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) GetLegacyPermissions(ctx context.Context, in *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	out := new(GetLegacyPermissionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) CreateLegacyPermission(ctx context.Context, in *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	out := new(CreateLegacyPermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) GetLegacyPermission(ctx context.Context, in *GetLegacyPermissionRequest) (*LegacyPermission, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	out := new(LegacyPermission)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) UpdateLegacyPermission(ctx context.Context, in *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	out := new(UpdateLegacyPermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeProtobufClient) DeleteLegacyPermission(ctx context.Context, in *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	out := new(DeleteLegacyPermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================
// Beefcake JSON Client
// ====================

type beefcakeJSONClient struct {
	client HTTPClient
	urls   [18]string
}

// NewBeefcakeJSONClient creates a JSON client that implements the Beefcake interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewBeefcakeJSONClient(addr string, client HTTPClient) Beefcake {
	prefix := urlBase(addr) + BeefcakePathPrefix
	urls := [18]string{
		prefix + "GetRoles",
		prefix + "CreateRole",
		prefix + "GetRole",
		prefix + "UpdateRole",
		prefix + "OverrideRole",
		prefix + "DeleteRole",
		prefix + "AddRolePermission",
		prefix + "RemoveRolePermission",
		prefix + "AddLegacyPermissionToRole",
		prefix + "RemoveLegacyPermissionFromRole",
		prefix + "AddUserToRole",
		prefix + "RemoveUserFromRole",
		prefix + "GetUser",
		prefix + "GetLegacyPermissions",
		prefix + "CreateLegacyPermission",
		prefix + "GetLegacyPermission",
		prefix + "UpdateLegacyPermission",
		prefix + "DeleteLegacyPermission",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &beefcakeJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &beefcakeJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *beefcakeJSONClient) GetRoles(ctx context.Context, in *GetRolesRequest) (*GetRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	out := new(GetRolesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) CreateRole(ctx context.Context, in *CreateRoleRequest) (*CreateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	out := new(CreateRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) GetRole(ctx context.Context, in *GetRoleRequest) (*Role, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	out := new(Role)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest) (*UpdateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	out := new(UpdateRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) OverrideRole(ctx context.Context, in *OverrideRoleRequest) (*OverrideRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	out := new(OverrideRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest) (*DeleteRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	out := new(DeleteRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) AddRolePermission(ctx context.Context, in *AddRolePermissionRequest) (*AddRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	out := new(AddRolePermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) RemoveRolePermission(ctx context.Context, in *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	out := new(RemoveRolePermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) AddLegacyPermissionToRole(ctx context.Context, in *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	out := new(AddLegacyPermissionToRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) RemoveLegacyPermissionFromRole(ctx context.Context, in *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	out := new(RemoveLegacyPermissionFromRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) AddUserToRole(ctx context.Context, in *AddUserToRoleRequest) (*AddUserToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	out := new(AddUserToRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) RemoveUserFromRole(ctx context.Context, in *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	out := new(RemoveUserFromRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) GetUser(ctx context.Context, in *GetUserRequest) (*User, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(User)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) GetLegacyPermissions(ctx context.Context, in *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	out := new(GetLegacyPermissionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) CreateLegacyPermission(ctx context.Context, in *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	out := new(CreateLegacyPermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) GetLegacyPermission(ctx context.Context, in *GetLegacyPermissionRequest) (*LegacyPermission, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	out := new(LegacyPermission)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) UpdateLegacyPermission(ctx context.Context, in *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	out := new(UpdateLegacyPermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beefcakeJSONClient) DeleteLegacyPermission(ctx context.Context, in *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	out := new(DeleteLegacyPermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =======================
// Beefcake Server Handler
// =======================

type beefcakeServer struct {
	Beefcake
	hooks *twirp.ServerHooks
}

func NewBeefcakeServer(svc Beefcake, hooks *twirp.ServerHooks) TwirpServer {
	return &beefcakeServer{
		Beefcake: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *beefcakeServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// BeefcakePathPrefix is used for all URL paths on a twirp Beefcake server.
// Requests are always: POST BeefcakePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const BeefcakePathPrefix = "/twirp/code.justin.tv.beefcake.Beefcake/"

func (s *beefcakeServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "Beefcake")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.beefcake.Beefcake/GetRoles":
		s.serveGetRoles(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/CreateRole":
		s.serveCreateRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/GetRole":
		s.serveGetRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/UpdateRole":
		s.serveUpdateRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/OverrideRole":
		s.serveOverrideRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/DeleteRole":
		s.serveDeleteRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/AddRolePermission":
		s.serveAddRolePermission(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/RemoveRolePermission":
		s.serveRemoveRolePermission(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/AddLegacyPermissionToRole":
		s.serveAddLegacyPermissionToRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/RemoveLegacyPermissionFromRole":
		s.serveRemoveLegacyPermissionFromRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/AddUserToRole":
		s.serveAddUserToRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/RemoveUserFromRole":
		s.serveRemoveUserFromRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/GetUser":
		s.serveGetUser(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/GetLegacyPermissions":
		s.serveGetLegacyPermissions(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/CreateLegacyPermission":
		s.serveCreateLegacyPermission(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/GetLegacyPermission":
		s.serveGetLegacyPermission(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/UpdateLegacyPermission":
		s.serveUpdateLegacyPermission(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.beefcake.Beefcake/DeleteLegacyPermission":
		s.serveDeleteLegacyPermission(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *beefcakeServer) serveGetRoles(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRolesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRolesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveGetRolesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRolesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRolesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRolesResponse and nil error while calling GetRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetRolesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRolesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRolesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRolesResponse and nil error while calling GetRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveCreateRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveCreateRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoleResponse and nil error while calling CreateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveCreateRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoleResponse and nil error while calling CreateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveGetRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Role
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Role and nil error while calling GetRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Role
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Role and nil error while calling GetRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveUpdateRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveUpdateRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoleResponse and nil error while calling UpdateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveUpdateRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoleResponse and nil error while calling UpdateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveOverrideRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOverrideRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOverrideRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveOverrideRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OverrideRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OverrideRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OverrideRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OverrideRoleResponse and nil error while calling OverrideRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveOverrideRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OverrideRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OverrideRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OverrideRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OverrideRoleResponse and nil error while calling OverrideRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveDeleteRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveDeleteRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoleResponse and nil error while calling DeleteRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveDeleteRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoleResponse and nil error while calling DeleteRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveAddRolePermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddRolePermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddRolePermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveAddRolePermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddRolePermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddRolePermissionResponse and nil error while calling AddRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveAddRolePermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddRolePermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddRolePermissionResponse and nil error while calling AddRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveRemoveRolePermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveRolePermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveRolePermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveRemoveRolePermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveRolePermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveRolePermissionResponse and nil error while calling RemoveRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveRemoveRolePermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveRolePermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveRolePermissionResponse and nil error while calling RemoveRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveAddLegacyPermissionToRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddLegacyPermissionToRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddLegacyPermissionToRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveAddLegacyPermissionToRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddLegacyPermissionToRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddLegacyPermissionToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddLegacyPermissionToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLegacyPermissionToRoleResponse and nil error while calling AddLegacyPermissionToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveAddLegacyPermissionToRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddLegacyPermissionToRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddLegacyPermissionToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddLegacyPermissionToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLegacyPermissionToRoleResponse and nil error while calling AddLegacyPermissionToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveRemoveLegacyPermissionFromRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveLegacyPermissionFromRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveLegacyPermissionFromRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveRemoveLegacyPermissionFromRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveLegacyPermissionFromRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveLegacyPermissionFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveLegacyPermissionFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveLegacyPermissionFromRoleResponse and nil error while calling RemoveLegacyPermissionFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveRemoveLegacyPermissionFromRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveLegacyPermissionFromRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveLegacyPermissionFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveLegacyPermissionFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveLegacyPermissionFromRoleResponse and nil error while calling RemoveLegacyPermissionFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveAddUserToRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddUserToRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddUserToRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveAddUserToRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddUserToRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddUserToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddUserToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserToRoleResponse and nil error while calling AddUserToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveAddUserToRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddUserToRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddUserToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddUserToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserToRoleResponse and nil error while calling AddUserToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveRemoveUserFromRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveUserFromRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveUserFromRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveRemoveUserFromRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveUserFromRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveUserFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveUserFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserFromRoleResponse and nil error while calling RemoveUserFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveRemoveUserFromRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveUserFromRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveUserFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveUserFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserFromRoleResponse and nil error while calling RemoveUserFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveGetUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *User
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *User and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *User
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *User and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetLegacyPermissions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyPermissionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyPermissionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveGetLegacyPermissionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyPermissionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyPermissionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermissions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyPermissionsResponse and nil error while calling GetLegacyPermissions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetLegacyPermissionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLegacyPermissionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyPermissionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermissions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyPermissionsResponse and nil error while calling GetLegacyPermissions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveCreateLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveCreateLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLegacyPermissionResponse and nil error while calling CreateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveCreateLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLegacyPermissionResponse and nil error while calling CreateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveGetLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LegacyPermission
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LegacyPermission and nil error while calling GetLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveGetLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LegacyPermission
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LegacyPermission and nil error while calling GetLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveUpdateLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveUpdateLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLegacyPermissionResponse and nil error while calling UpdateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveUpdateLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLegacyPermissionResponse and nil error while calling UpdateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveDeleteLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *beefcakeServer) serveDeleteLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLegacyPermissionResponse and nil error while calling DeleteLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) serveDeleteLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLegacyPermissionResponse and nil error while calling DeleteLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *beefcakeServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *beefcakeServer) ProtocGenTwirpVersion() string {
	return "v5.4.1"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.4.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1400 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xdd, 0x72, 0xd3, 0xc6,
	0x17, 0x8f, 0x6c, 0x93, 0x84, 0x63, 0x30, 0xf6, 0x62, 0x20, 0x88, 0x24, 0x7f, 0xff, 0xc5, 0x14,
	0xc2, 0x97, 0x42, 0x4d, 0x4b, 0x29, 0x17, 0x74, 0x1c, 0x12, 0x12, 0xcf, 0x34, 0x40, 0xd5, 0x50,
	0x68, 0x99, 0x8e, 0x47, 0xb1, 0x96, 0x44, 0xc5, 0xb6, 0xd4, 0x95, 0x1c, 0x48, 0x67, 0x7a, 0xd5,
	0xf6, 0xa2, 0xb7, 0xbd, 0xeb, 0x25, 0x8f, 0xd0, 0x19, 0x6e, 0xfa, 0x02, 0xbd, 0xe8, 0x1b, 0xf4,
	0x29, 0xfa, 0x06, 0x9d, 0xce, 0xae, 0xd6, 0xd6, 0xf7, 0x4a, 0x76, 0xc3, 0x9d, 0xe5, 0x3d, 0x1f,
	0xbf, 0x3d, 0x67, 0xcf, 0x6f, 0xcf, 0x59, 0x90, 0x89, 0xdd, 0x5d, 0xdd, 0xc5, 0xf8, 0x45, 0x57,
	0x7f, 0x89, 0x57, 0x1d, 0x4c, 0x0e, 0xcc, 0x2e, 0x56, 0x6d, 0x62, 0xb9, 0x16, 0x3a, 0xd7, 0xb5,
	0x0c, 0xac, 0x7e, 0x33, 0x74, 0x5c, 0x73, 0xa0, 0xba, 0x07, 0xea, 0x48, 0x4c, 0xfe, 0xdf, 0x9e,
	0x65, 0xed, 0xf5, 0xf0, 0x2a, 0x13, 0xdb, 0x1d, 0xbe, 0x58, 0x75, 0xcd, 0x3e, 0x76, 0x5c, 0xbd,
	0x6f, 0x7b, 0x9a, 0xf2, 0x72, 0x54, 0xe0, 0x15, 0xd1, 0x6d, 0x1b, 0x13, 0xc7, 0x5b, 0x57, 0x2e,
	0x43, 0xed, 0x3e, 0xc1, 0xba, 0x8b, 0x35, 0xab, 0x87, 0x35, 0xfc, 0xed, 0x10, 0x3b, 0x2e, 0x42,
	0x50, 0x1a, 0xe8, 0x7d, 0xbc, 0x20, 0x35, 0xa4, 0x95, 0xe3, 0x1a, 0xfb, 0xad, 0xdc, 0x01, 0x14,
	0x14, 0x74, 0x6c, 0x6b, 0xe0, 0x60, 0x54, 0x81, 0x82, 0x69, 0x70, 0xb9, 0x82, 0x69, 0x8c, 0x35,
	0x0b, 0x01, 0xcd, 0xd7, 0xb0, 0xd0, 0x32, 0x0c, 0xaa, 0xf6, 0x18, 0x93, 0xbe, 0xe9, 0x38, 0xa6,
	0x35, 0x18, 0x79, 0x3a, 0x07, 0x73, 0xc4, 0xea, 0xe1, 0xce, 0xd8, 0xc8, 0x2c, 0xfd, 0x6c, 0x1b,
	0xe8, 0x3e, 0x80, 0x3d, 0x96, 0x66, 0xe6, 0xca, 0xcd, 0x8b, 0x6a, 0x4a, 0x18, 0xd4, 0x80, 0xe1,
	0x80, 0x9a, 0x72, 0x01, 0xce, 0x27, 0x78, 0xf6, 0xa0, 0x2b, 0x7d, 0x68, 0xb4, 0x0c, 0xe3, 0x53,
	0xbc, 0xa7, 0x77, 0x0f, 0xfd, 0xe5, 0x1d, 0x2b, 0x18, 0x88, 0x54, 0x78, 0x37, 0xa1, 0xde, 0x63,
	0x9a, 0x1d, 0xdf, 0x1d, 0x95, 0xf2, 0xf6, 0x8d, 0x7a, 0x11, 0xab, 0x6d, 0x43, 0xb9, 0x08, 0xff,
	0x17, 0xb8, 0xe3, 0x98, 0x08, 0xbc, 0xa7, 0xe1, 0xbe, 0x75, 0x80, 0xa3, 0x72, 0x0f, 0x88, 0xd5,
	0x7f, 0x47, 0xc0, 0x56, 0xe0, 0x52, 0x96, 0x4f, 0x8e, 0xee, 0x2f, 0x09, 0x4e, 0x3f, 0x3a, 0xc0,
	0x84, 0x98, 0x46, 0xe8, 0xb8, 0xe4, 0x38, 0x04, 0x68, 0x03, 0xca, 0x3e, 0x20, 0x67, 0xa1, 0xd8,
	0x28, 0xe6, 0x4d, 0x68, 0x50, 0x0f, 0x3d, 0x85, 0xea, 0xd0, 0xc1, 0xa4, 0xd3, 0xc7, 0xfd, 0x5d,
	0x4c, 0x9c, 0x7d, 0xd3, 0x76, 0x16, 0x4a, 0xcc, 0xd6, 0xf5, 0x54, 0x5b, 0x14, 0xaa, 0xfa, 0xc4,
	0xc1, 0x64, 0x7b, 0xac, 0xa4, 0x9d, 0x1a, 0x86, 0xbe, 0x1d, 0xe5, 0x2c, 0xd4, 0xc3, 0x5b, 0xe3,
	0x7b, 0xae, 0xc1, 0xa9, 0x4d, 0xec, 0xd2, 0xbf, 0x1c, 0xbe, 0x5d, 0xe5, 0x47, 0x09, 0xaa, 0xfe,
	0x7f, 0xbc, 0x10, 0xd6, 0xe1, 0x18, 0xcd, 0x80, 0xb3, 0x20, 0x31, 0x34, 0x6a, 0x2a, 0x9a, 0xa8,
	0x26, 0x83, 0xa7, 0x79, 0xca, 0xf2, 0x55, 0x28, 0xd1, 0xcf, 0x5c, 0x65, 0xd5, 0x80, 0x0a, 0xb7,
	0x95, 0x92, 0x07, 0xe5, 0xf7, 0x42, 0x7e, 0x73, 0x89, 0x91, 0x2d, 0x1e, 0x41, 0x64, 0xd1, 0x76,
	0x38, 0xf3, 0x5e, 0xb6, 0xae, 0xa5, 0xda, 0x6c, 0xb9, 0xae, 0xde, 0xdd, 0xc7, 0x46, 0xca, 0x09,
	0x90, 0x31, 0x54, 0xc2, 0x1e, 0x69, 0x2d, 0x30, 0xe4, 0x7e, 0x2d, 0xd0, 0xcf, 0xb6, 0x81, 0xee,
	0x02, 0xe0, 0xd7, 0xb6, 0x49, 0x74, 0xd7, 0xe7, 0x10, 0x59, 0xf5, 0x08, 0x51, 0x1d, 0x11, 0xa2,
	0xba, 0x33, 0x62, 0x4c, 0x2d, 0x20, 0xad, 0xac, 0x40, 0xf5, 0x73, 0x97, 0x98, 0x83, 0xbd, 0x16,
	0x21, 0xfa, 0xe1, 0x17, 0x7a, 0x6f, 0x88, 0x51, 0x1d, 0x8e, 0x1d, 0xd0, 0x1f, 0x2c, 0xc7, 0xc7,
	0x35, 0xef, 0x43, 0x79, 0x2b, 0x41, 0xed, 0x89, 0x6d, 0x44, 0x28, 0x34, 0x1a, 0xf2, 0x9b, 0x81,
	0x90, 0x97, 0x9b, 0x8b, 0x31, 0x14, 0x9e, 0x33, 0xe6, 0x87, 0x27, 0xe4, 0x6b, 0x38, 0x93, 0x54,
	0xc9, 0x34, 0x2b, 0xd4, 0xc4, 0x95, 0xd4, 0x08, 0x46, 0x71, 0x6b, 0xa7, 0xe3, 0x55, 0xef, 0x28,
	0x75, 0x40, 0x41, 0xd4, 0xfc, 0xb8, 0x1b, 0x70, 0xc1, 0x23, 0x83, 0x09, 0xe9, 0xfa, 0x3a, 0x20,
	0xb6, 0x90, 0x44, 0x3a, 0x55, 0x12, 0xb2, 0xd5, 0x36, 0x94, 0x65, 0x58, 0x4c, 0xf6, 0xc2, 0x51,
	0xfc, 0x2a, 0x41, 0xbd, 0x65, 0x18, 0x34, 0xcf, 0x39, 0xf9, 0x38, 0x70, 0x06, 0x0a, 0xa1, 0x33,
	0xf0, 0x08, 0xce, 0xf8, 0x27, 0xba, 0x13, 0x38, 0x0e, 0xc5, 0xcc, 0xe3, 0x50, 0xf7, 0x15, 0x37,
	0xfc, 0x83, 0x71, 0x0e, 0xce, 0x44, 0xa0, 0x71, 0xd0, 0xdb, 0x70, 0xde, 0xdb, 0x14, 0x5d, 0xcb,
	0xcd, 0xd7, 0x69, 0xc0, 0x95, 0x45, 0x90, 0x93, 0xcc, 0x71, 0x67, 0x17, 0xa1, 0xb6, 0x8e, 0x7b,
	0x58, 0x78, 0xe6, 0x68, 0x8a, 0x83, 0x42, 0x5c, 0xd5, 0xe3, 0x0d, 0x6a, 0x35, 0x4d, 0xef, 0x8f,
	0x02, 0x94, 0xe8, 0x7a, 0xec, 0x10, 0x3f, 0x05, 0x96, 0xcb, 0x10, 0x47, 0x14, 0x32, 0x38, 0x82,
	0x1a, 0x62, 0x44, 0x11, 0xe4, 0x08, 0x12, 0xfa, 0x8e, 0x71, 0x44, 0xf1, 0x3f, 0x72, 0xc4, 0x4f,
	0x12, 0x54, 0xc2, 0x2e, 0x73, 0x51, 0xe0, 0x91, 0x9f, 0x95, 0x25, 0xb8, 0xb0, 0x89, 0xdd, 0xe8,
	0xbd, 0x3a, 0xbe, 0x48, 0xfe, 0x96, 0x60, 0x31, 0x79, 0x9d, 0x5f, 0x2a, 0x43, 0x40, 0x31, 0x0a,
	0x18, 0xdd, 0x30, 0x0f, 0x44, 0x37, 0x4c, 0xaa, 0x49, 0x35, 0xba, 0xa2, 0xd5, 0xa2, 0xe4, 0xe0,
	0xc8, 0xcf, 0xa0, 0x1a, 0x15, 0xcb, 0x15, 0xbf, 0x06, 0x94, 0x0d, 0xec, 0x74, 0x89, 0x69, 0x8f,
	0xa3, 0x76, 0x5c, 0x0b, 0xfe, 0xa5, 0x60, 0x58, 0xf2, 0x9a, 0xc8, 0x18, 0x8c, 0x09, 0x5a, 0x89,
	0x6c, 0x37, 0x0d, 0x58, 0x4e, 0x73, 0xc3, 0x8b, 0xe0, 0x3a, 0xc8, 0x09, 0x61, 0x4a, 0x2b, 0x88,
	0x3f, 0xa5, 0x77, 0x15, 0x11, 0xbf, 0x6f, 0x28, 0x65, 0xf4, 0x0d, 0x51, 0xff, 0x53, 0xf7, 0x0d,
	0x6f, 0x24, 0x58, 0xf2, 0x98, 0x3f, 0x6f, 0x12, 0x26, 0xbf, 0xbb, 0xee, 0xc5, 0xf7, 0x9d, 0xa5,
	0x18, 0x4d, 0x60, 0x1a, 0x44, 0x9e, 0xc0, 0x55, 0x58, 0xf2, 0xb8, 0x2d, 0x6f, 0x0e, 0x1b, 0xb0,
	0x9c, 0xa6, 0xc0, 0x4d, 0xfe, 0x56, 0x02, 0x08, 0xe4, 0xf7, 0x21, 0xcc, 0x7a, 0xa5, 0xc1, 0x8c,
	0x94, 0x9b, 0x1f, 0xe4, 0x68, 0x56, 0x63, 0x59, 0xda, 0x9a, 0xd1, 0xb8, 0x15, 0xf4, 0x1c, 0xca,
	0xee, 0x2b, 0xd3, 0xed, 0xee, 0x77, 0x28, 0xc3, 0xf3, 0x60, 0xde, 0xc9, 0x63, 0x74, 0x87, 0xa9,
	0x51, 0x22, 0x0d, 0x19, 0x06, 0x77, 0xfc, 0xbf, 0x7c, 0x7b, 0xba, 0x03, 0x2a, 0xbf, 0x2d, 0x40,
	0x3d, 0xc9, 0x3c, 0x7a, 0x0e, 0xb3, 0x7a, 0x97, 0x25, 0x8f, 0x1a, 0xa8, 0x34, 0xef, 0x4f, 0x0b,
	0x54, 0x6d, 0x31, 0x33, 0x3b, 0x87, 0x36, 0xd6, 0xb8, 0x49, 0xf4, 0x0c, 0x8a, 0xfa, 0xe0, 0x90,
	0x87, 0x60, 0x7d, 0x7a, 0xcb, 0x83, 0x43, 0x0d, 0x3b, 0xd6, 0x90, 0x74, 0xf1, 0xd6, 0x8c, 0x46,
	0x4d, 0xa2, 0x4b, 0x50, 0x09, 0x04, 0x99, 0xde, 0xaa, 0xac, 0xe6, 0xb6, 0x66, 0xb4, 0x13, 0x7e,
	0xb4, 0xda, 0x86, 0x7c, 0x12, 0xca, 0x01, 0x6d, 0x45, 0x01, 0xf0, 0x61, 0xa2, 0x39, 0x28, 0xb6,
	0x1e, 0x7e, 0x59, 0x9d, 0x41, 0x65, 0x98, 0xdb, 0xdc, 0xd8, 0xe9, 0x3c, 0x6e, 0xb7, 0xab, 0xd2,
	0x1a, 0xc0, 0x3c, 0xe1, 0xf2, 0x6b, 0x73, 0xbc, 0x13, 0x54, 0x4c, 0x40, 0xf1, 0xcb, 0x28, 0x16,
	0xf9, 0xa3, 0x18, 0x66, 0x9b, 0xff, 0x54, 0x61, 0x7e, 0x8d, 0xcb, 0xa0, 0x0e, 0xcc, 0x8f, 0x06,
	0x09, 0xb4, 0x92, 0x63, 0xd6, 0x60, 0x35, 0x21, 0x5f, 0xc9, 0x3d, 0x95, 0x20, 0x0c, 0xe0, 0x8f,
	0xfb, 0xe8, 0x6a, 0xaa, 0x62, 0xec, 0xf1, 0x40, 0xbe, 0x96, 0x4b, 0x96, 0xbb, 0xf9, 0x0c, 0xe6,
	0xb8, 0x6b, 0x74, 0x39, 0x0b, 0xdc, 0xc8, 0xc1, 0x92, 0x70, 0x1e, 0xa1, 0xc8, 0xfd, 0xc6, 0x56,
	0x80, 0x3c, 0xd6, 0xb3, 0x0b, 0x90, 0xc7, 0x3b, 0x65, 0xf4, 0x12, 0x4e, 0x04, 0x07, 0x46, 0x94,
	0xde, 0x01, 0x25, 0x8c, 0xcc, 0xf2, 0x8d, 0x9c, 0xd2, 0x7e, 0x36, 0xfc, 0x4e, 0x4e, 0xb0, 0xa7,
	0x58, 0x4f, 0x28, 0xd8, 0x53, 0xbc, 0x35, 0x44, 0xdf, 0x41, 0x2d, 0xf6, 0x5e, 0x82, 0xde, 0x4f,
	0x6f, 0xc3, 0x52, 0x5e, 0x75, 0xe4, 0xe6, 0x24, 0x2a, 0xdc, 0xf7, 0x0f, 0x12, 0xd4, 0x93, 0x86,
	0x02, 0x94, 0xce, 0xbb, 0x82, 0x49, 0x45, 0xfe, 0x70, 0x42, 0x2d, 0x8e, 0xe2, 0x17, 0x89, 0x3d,
	0x19, 0x25, 0x3f, 0xd3, 0xa0, 0x8f, 0x45, 0xfb, 0x12, 0xbe, 0x24, 0xc9, 0x77, 0xa7, 0x51, 0xe5,
	0xa0, 0xde, 0x48, 0xb0, 0x2c, 0x7e, 0xa2, 0x41, 0xf7, 0x32, 0xb6, 0x9b, 0xf1, 0x9e, 0x24, 0x7f,
	0x32, 0xb5, 0x3e, 0xc7, 0x38, 0x80, 0x93, 0xa1, 0xb1, 0x08, 0xdd, 0x10, 0x6d, 0x38, 0x36, 0xd9,
	0xc9, 0x6a, 0x5e, 0x71, 0xee, 0xef, 0x7b, 0x40, 0xf1, 0xf1, 0x08, 0x35, 0x33, 0xb6, 0x91, 0x30,
	0x9a, 0xc9, 0xb7, 0x26, 0xd2, 0x09, 0xf1, 0x16, 0x1b, 0x92, 0x84, 0xbc, 0x15, 0x18, 0xb3, 0x04,
	0xbc, 0xc5, 0xec, 0xd0, 0x02, 0x48, 0x6a, 0xdd, 0x05, 0x05, 0x20, 0x18, 0x2e, 0x04, 0x05, 0x20,
	0x1c, 0x39, 0x7e, 0x96, 0xe0, 0x6c, 0x72, 0xef, 0x8c, 0x6e, 0x67, 0x10, 0x7b, 0x4a, 0x27, 0x26,
	0x7f, 0x34, 0xb1, 0xde, 0x78, 0xfc, 0x39, 0x9d, 0x80, 0x15, 0xdd, 0x9a, 0x64, 0x67, 0xd9, 0x57,
	0x5f, 0xcc, 0x3e, 0x0d, 0x41, 0x72, 0xf7, 0x29, 0x08, 0x81, 0xb0, 0xa3, 0x16, 0x84, 0x40, 0xdc,
	0xe6, 0x32, 0x2c, 0xc9, 0x6d, 0xab, 0x00, 0x8b, 0xb0, 0x31, 0x16, 0x60, 0x11, 0xf7, 0xc7, 0x6b,
	0xf0, 0xd5, 0xfc, 0x48, 0x74, 0x77, 0x96, 0xf5, 0xf0, 0xb7, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff,
	0x97, 0xe3, 0xda, 0x46, 0xb5, 0x18, 0x00, 0x00,
}
