resource "aws_iam_role" "ecs-deploy" {
  name               = "${local.prefix}-ecs-deploy"
  path               = "/deploy/"
  assume_role_policy = "${data.aws_iam_policy_document.ecs-deploy-arp.json}"
}

data "aws_iam_policy_document" "ecs-deploy-arp" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["${local.aws_root_arn}", "${var.allowed_deployment_arns}"]
    }
  }
}

resource "aws_iam_role_policy" "ecs-deploy" {
  role   = "${aws_iam_role.ecs-deploy.id}"
  policy = "${data.aws_iam_policy_document.ecs-deploy-rp.json}"
}

data "aws_iam_policy_document" "ecs-deploy-rp" {
  statement {
    actions = [
      "ecs:RegisterTaskDefinition",
      "ecs:UpdateService",
      "ecr:DescribeRepositories",
      "ecr:GetAuthorizationToken",
    ]

    resources = [
      "*",
    ]
  }

  statement {
    actions = ["s3:GetObject"]

    resources = [
      "${aws_s3_bucket.config.arn}/config.json",
    ]
  }

  statement {
    actions = [
      "s3:Get*",
      "s3:List*",
      "s3:Put*",
    ]

    resources = [
      "${aws_s3_bucket.lambdas.arn}",
      "${aws_s3_bucket.lambdas.arn}/*",
    ]
  }

  statement {
    actions = ["iam:PassRole"]

    resources = [
      "${aws_iam_role.ecs-execution.arn}",
      "${aws_iam_role.service.arn}",
    ]
  }
}
