resource "aws_dynamodb_table" "legacy-permissions" {
  name             = "${local.prefix}-legacy-permissions"
  read_capacity    = 10
  write_capacity   = 10
  hash_key         = "ID"
  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  attribute {
    name = "ID"
    type = "S"
  }

  lifecycle {
    ignore_changes = [
      "read_capacity",
      "write_capacity",
    ]
  }
}

resource "aws_lambda_event_source_mapping" "sync-legacy-permissions-to-roles" {
  batch_size        = 100
  event_source_arn  = "${aws_dynamodb_table.legacy-permissions.stream_arn}"
  enabled           = true
  function_name     = "${aws_lambda_function.sync-legacy-permissions-to-roles.arn}"
  starting_position = "LATEST"
}
