data "aws_s3_bucket_object" "sync-legacy-permissions-to-roles" {
  bucket = "${aws_s3_bucket.lambdas.bucket}"
  key    = "${local.sync_legacy_permissions_to_roles_lambda_key}"
}

resource "aws_lambda_function" "sync-legacy-permissions-to-roles" {
  function_name     = "${local.prefix}-sync-legacy-permissions-to-roles"
  handler           = "main"
  role              = "${aws_iam_role.sync-legacy-permissions-to-roles.arn}"
  runtime           = "go1.x"
  s3_bucket         = "${data.aws_s3_bucket_object.sync-legacy-permissions-to-roles.bucket}"
  s3_key            = "${data.aws_s3_bucket_object.sync-legacy-permissions-to-roles.key}"
  s3_object_version = "${data.aws_s3_bucket_object.sync-legacy-permissions-to-roles.version_id}"
  timeout           = "900"

  environment {
    variables {
      BEEFCAKE_ENVIRONMENT = "${var.env}"
    }
  }

  tags {
    Project = "${local.prefix}"
  }
}

resource "aws_iam_role" "sync-legacy-permissions-to-roles" {
  name               = "${local.prefix}-sync-legacy-permissions-to-roles"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-arp.json}"

  tags {
    Project = "${local.prefix}"
  }
}

resource "aws_iam_role_policy" "sync-legacy-permissions-to-roles" {
  role   = "${aws_iam_role.sync-legacy-permissions-to-roles.name}"
  policy = "${data.aws_iam_policy_document.sync-legacy-permissions-to-roles-rp.json}"
}

data "aws_iam_policy_document" "sync-legacy-permissions-to-roles-rp" {
  statement {
    actions   = ["sts:AssumeRole"]
    resources = ["${aws_iam_role.config-read.arn}"]
  }

  statement {
    actions = [
      "logs:PutLogEvents",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
    ]

    resources = ["*"]
  }

  statement {
    actions = [
      "dynamodb:UpdateItem",
    ]

    resources = ["${aws_dynamodb_table.roles.arn}"]
  }

  statement {
    actions = [
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:DescribeStream",
      "dynamodb:ListStreams",
    ]

    resources = ["${aws_dynamodb_table.legacy-permissions.stream_arn}"]
  }
}
