data "aws_s3_bucket_object" "sync-roles-to-legacy-permissions" {
  bucket = "${aws_s3_bucket.lambdas.bucket}"
  key    = "${local.sync_roles_to_legacy_permissions_lambda_key}"
}

resource "aws_lambda_function" "sync-roles-to-legacy-permissions" {
  function_name     = "${local.prefix}-sync-roles-to-legacy-permissions"
  handler           = "main"
  role              = "${aws_iam_role.sync-roles-to-legacy-permissions.arn}"
  runtime           = "go1.x"
  s3_bucket         = "${data.aws_s3_bucket_object.sync-roles-to-legacy-permissions.bucket}"
  s3_key            = "${data.aws_s3_bucket_object.sync-roles-to-legacy-permissions.key}"
  s3_object_version = "${data.aws_s3_bucket_object.sync-roles-to-legacy-permissions.version_id}"
  timeout           = "900"

  environment {
    variables {
      BEEFCAKE_ENVIRONMENT = "${var.env}"
    }
  }

  tags {
    Project = "${local.prefix}"
  }
}

resource "aws_iam_role" "sync-roles-to-legacy-permissions" {
  name               = "${local.prefix}-sync-roles-to-legacy-permissions"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-arp.json}"

  tags {
    Project = "${local.prefix}"
  }
}

resource "aws_iam_role_policy" "sync-roles-to-legacy-permissions" {
  role   = "${aws_iam_role.sync-roles-to-legacy-permissions.name}"
  policy = "${data.aws_iam_policy_document.sync-roles-to-legacy-permissions-rp.json}"
}

data "aws_iam_policy_document" "sync-roles-to-legacy-permissions-rp" {
  statement {
    actions   = ["sts:AssumeRole"]
    resources = ["${aws_iam_role.config-read.arn}"]
  }

  statement {
    actions = [
      "logs:PutLogEvents",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
    ]

    resources = ["*"]
  }

  statement {
    actions = [
      "dynamodb:UpdateItem",
    ]

    resources = ["${aws_dynamodb_table.legacy-permissions.arn}"]
  }

  statement {
    actions = [
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:DescribeStream",
      "dynamodb:ListStreams",
    ]

    resources = ["${aws_dynamodb_table.roles.stream_arn}"]
  }
}
