/*
Package envoy provides service healthchecks over HTTP.

Initialize Envoy:

        envoy.Init(&envoy.Config{
            Service: "Query Aggregator",
            ServerConf: &envoy.HTTPServerConf{
                Host: "0.0.0.0",
                Port: "5555",
            },
        })

This starts an HTTP server listening on port 5555 on the path /health.

Now add some states and set them into starting conditions:

        backendState := envoy.NewState("backends", "Backends", envoy.ConditionUnknown)
        queryTimeState := envoy.NewState("query_time", "Average Query Duration", envoy.ConditionNormal)
        ratioSuccessState := envoy.NewState("ratio_success", "Ratio of successful queries", envoy.ConditionNormal)

Envoy will report a global meta-state for your service. The condition of this state is simply the worst of any
of the states you define.

After we start up, we measure the number of backends and set the condition accordingly.

        backendState.Normal("12 out of 12 connected")

More time passes and some backends become unhealthy.

        backendState.Warning("6 out of 12 connected")
*/
package envoy
