package dbopt

import (
	"fmt"

	"code.justin.tv/common/envoy"
)

const criticalAfter = 10

func EnvoyErrorHandler() chan error {
	state := envoy.NewState("dbopt", "DB Option updates", envoy.ConditionUnknown)
	c := make(chan error, 100)

	go func() {
		failed := 0

		for err := range c {
			if err == nil {
				failed = 0
				state.Normal("Receiving db option updates")
			} else {
				failed++
				msg := fmt.Sprintf("Failed to update db options for %d consecutive updates; last error = %s",
					failed, err)

				if failed >= criticalAfter {
					state.Critical(msg)
				} else {
					state.Warning(msg)
				}
			}
		}
	}()

	return c
}
