require 'liquid'

class FormTag < Liquid::Block
  def render(context)
    body = super
    variables = YAML.load(body)

    unless variables.is_a?(Hash)
      raise "Expected variables to be a hash"
    end

    context["form_parameters"] = variables

    variables.each do |var, data|
      context[var] = data["default"]
    end

    return ''
  end
end

class Templates
  def initialize()
    Liquid::Template.register_tag('form', FormTag)
  end

  def render_file(file, args = {})
    render(File.read(file), args)
  end

  def render(text, args = {})
    args = Hash[args.map{|k,v| [k.to_s, v]}]
    templ = parse(text)
    context = opt_context(templ, args)
    return templ.render(context)
  end

  def parse(text)
    templ = Liquid::Template.parse(text)

    class << templ
      attr_accessor :raw_query, :form_parameters, :form_context
    end

    templ.raw_query = text
    templ.form_context = form_context(templ)
    templ.form_parameters = templ.form_context.scopes[0]["form_parameters"] || {}

    return templ
  end

  def form_context(template)
    context = Liquid::Context.new
    template.render(context)
    return context
  end

  def opt_context(query, opt_values)
    context = query.form_context
    context = context.merge(opt_values)
    return context
  end
end
