package backend

import (
	model "code.justin.tv/bootcamp/aws-example/rpc/aws_example_service"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/aws/aws-sdk-go/service/s3/s3iface"
)

const (
	DEFAULT_REGION = "us-west-2"
)

type Backend struct {
	BackendIface
	ddb       dynamodbiface.DynamoDBAPI
	tableName string
	s3        s3iface.S3API
	s3Bucket  string
}

func New(region, s3Bucket, tableName string) *Backend {
	s := session.New()

	r := region
	if r == "" {
		r = DEFAULT_REGION
	}

	c := &aws.Config{
		Region: aws.String(r),
	}
	return &Backend{
		ddb:       dynamodb.New(s, c),
		tableName: tableName,
		s3:        s3.New(s, c),
		s3Bucket:  s3Bucket,
	}
}

func (*Backend) UploadToS3(path string, data []byte) error {
	return nil
}

func (*Backend) RemoveFromS3(path string) error {
	return nil
}

func (*Backend) WriteToDDB(a *model.AssetMetadata) error {
	return nil
}

func (*Backend) GetFromDDB(id string) (*model.AssetMetadata, error) {
	return &model.AssetMetadata{}, nil
}

func (*Backend) RemoveFromDDB(id string) error {
	return nil
}
