package main

import (
	"log"
	"net/http"

	"code.justin.tv/bootcamp/aws-example/backend"
	"code.justin.tv/bootcamp/aws-example/rpc/aws_example_service"
	"code.justin.tv/bootcamp/aws-example/rpc/server"
	"code.justin.tv/common/config"
)

const (
	s3Bucket          = "twitch-aws-bootcamp"
	dynamodbTableName = "aws-example"
)

func main() {
	// To add app-specific config flags, you can call config.Register()
	// https://godoc.internal.justin.tv/code.justin.tv/common/config
	err := config.Parse()
	if err != nil {
		log.Fatal(err)
	}
	region := config.AwsRegion()
	backend := backend.New(region, s3Bucket, dynamodbTableName)

	conf := &server.ServerConfig{
		Backend: backend,
		Noop:    true,
	}
	server := server.New(conf)
	twirpHandler := aws_example_service.NewAwsExampleServiceServer(server, nil, nil)

	log.Fatal(http.ListenAndServe(":8080", twirpHandler))
}
