package mocks

import "github.com/stretchr/testify/mock"

import "net/http"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// Close provides a mock function with given fields:
func (_m *Client) Close() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Error provides a mock function with given fields: level, err
func (_m *Client) Error(level string, err error) {
	_m.Called(level, err)
}

// ErrorWithExtras provides a mock function with given fields: level, err, extras
func (_m *Client) ErrorWithExtras(level string, err error, extras map[string]interface{}) {
	_m.Called(level, err, extras)
}

// ErrorWithStackSkip provides a mock function with given fields: level, err, skip
func (_m *Client) ErrorWithStackSkip(level string, err error, skip int) {
	_m.Called(level, err, skip)
}

// ErrorWithStackSkipWithExtras provides a mock function with given fields: level, err, skip, extras
func (_m *Client) ErrorWithStackSkipWithExtras(level string, err error, skip int, extras map[string]interface{}) {
	_m.Called(level, err, skip, extras)
}

// GetCodeVersion provides a mock function with given fields:
func (_m *Client) GetCodeVersion() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetCustom provides a mock function with given fields:
func (_m *Client) GetCustom() map[string]interface{} {
	ret := _m.Called()

	var r0 map[string]interface{}
	if rf, ok := ret.Get(0).(func() map[string]interface{}); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]interface{})
		}
	}

	return r0
}

// GetEnvironment provides a mock function with given fields:
func (_m *Client) GetEnvironment() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetServerHost provides a mock function with given fields:
func (_m *Client) GetServerHost() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetServerRoot provides a mock function with given fields:
func (_m *Client) GetServerRoot() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetToken provides a mock function with given fields:
func (_m *Client) GetToken() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Message provides a mock function with given fields: level, msg
func (_m *Client) Message(level string, msg string) {
	_m.Called(level, msg)
}

// MessageWithExtras provides a mock function with given fields: level, msg, extras
func (_m *Client) MessageWithExtras(level string, msg string, extras map[string]interface{}) {
	_m.Called(level, msg, extras)
}

// RequestError provides a mock function with given fields: level, r, err
func (_m *Client) RequestError(level string, r *http.Request, err error) {
	_m.Called(level, r, err)
}

// RequestErrorWithExtras provides a mock function with given fields: level, r, err, extras
func (_m *Client) RequestErrorWithExtras(level string, r *http.Request, err error, extras map[string]interface{}) {
	_m.Called(level, r, err, extras)
}

// RequestErrorWithStackSkip provides a mock function with given fields: level, r, err, skip
func (_m *Client) RequestErrorWithStackSkip(level string, r *http.Request, err error, skip int) {
	_m.Called(level, r, err, skip)
}

// RequestErrorWithStackSkipWithExtras provides a mock function with given fields: level, r, err, skip, extras
func (_m *Client) RequestErrorWithStackSkipWithExtras(level string, r *http.Request, err error, skip int, extras map[string]interface{}) {
	_m.Called(level, r, err, skip, extras)
}

// SetCodeVersion provides a mock function with given fields: codeVersion
func (_m *Client) SetCodeVersion(codeVersion string) {
	_m.Called(codeVersion)
}

// SetCustom provides a mock function with given fields: custom
func (_m *Client) SetCustom(custom map[string]interface{}) {
	_m.Called(custom)
}

// SetEnvironment provides a mock function with given fields: environment
func (_m *Client) SetEnvironment(environment string) {
	_m.Called(environment)
}

// SetServerHost provides a mock function with given fields: serverHost
func (_m *Client) SetServerHost(serverHost string) {
	_m.Called(serverHost)
}

// SetServerRoot provides a mock function with given fields: serverRoot
func (_m *Client) SetServerRoot(serverRoot string) {
	_m.Called(serverRoot)
}

// SetToken provides a mock function with given fields: token
func (_m *Client) SetToken(token string) {
	_m.Called(token)
}
