package ctxloggoji

import (
	"code.justin.tv/feeds/ctxlog"
	"goji.io"
)

// GojiMiddleware is usable by goji.UseC.  Will log the request as well as inject the needed headers
func GojiMiddleware(elevateKey interface{}, Ctxlog *ctxlog.Ctxlog, logger ctxlog.Logger) func(h goji.Handler) goji.Handler {
	return func(h goji.Handler) goji.Handler {
		return &ctxlog.CtxHandler{
			NextC:  h,
			Ctxlog: Ctxlog,
			Logger: logger,
		}
	}
}
