// Code generated by go-bindata.
// sources:
// data/almanac.json
// data/audrey.json
// data/autohost.json
// data/channels.json
// data/cohesion.json
// data/digestion.json
// data/discovery.json
// data/flowsdproxy.json
// data/friendship.json
// data/im-store.json
// data/partnerships.json
// data/presence.json
// data/pubsub-broker.json
// data/rails.json
// data/recommendations.json
// data/similar-channels.json
// data/skadi.json
// data/streams-api.json
// data/tmi-api.json
// data/tmi-clue.json
// data/tmi-pubsub.json
// data/tmi-room.json
// data/users-service.json
// data/video-origin-origin.json
// data/video-origin-origindb.json
// data/video-usher-api-find.json
// data/video-usher-api-usher.json
// data/video-usher-api-video.json
// data/video-usher-api-videoapi.json
// data/video-usher-api-viewcount.json
// data/videoshim.json
// data/visage-api.json
// data/visage-kraken.json
// data/visage-v1.json
// data/visage-v2.json
// data/visage-v3.json
// data/visage-v4.json
// DO NOT EDIT!

package routes

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _dataAlmanacJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x8e\x3d\x4f\x04\x21\x10\x40\x7b\x7e\xc5\x84\xfa\x02\xd1\xf2\x3a\x63\xf4\xec\x24\x39\x3b\x63\x81\x30\xde\xa2\x7c\x5c\x60\xc0\xe2\x72\xff\xdd\x40\xee\x4c\x5c\xd7\xc2\x42\x9b\xcd\x64\x67\x78\xef\xb1\x03\x03\xe0\xa5\x19\xbe\x06\x6e\x92\x45\xf1\x5a\x0b\xb9\x28\xa8\xc9\xe6\x2c\x26\xa9\x7d\xd0\x51\x1b\x69\x82\x3d\xcf\x7c\xd5\x1f\xe5\x54\x09\x0b\x5f\xc3\x23\x03\x00\x38\x8c\x2f\x00\xdf\x6b\x22\xcc\xb1\x03\x65\xbb\x94\x5f\xa1\x62\x40\xc5\x09\x24\x4c\xb0\x9f\xb3\xde\x3b\xd1\x2e\xc4\xd5\xc9\xb7\x41\x52\x19\x5f\x30\x67\xb4\x2a\xa9\x32\xa4\x43\x10\x75\xc0\x4e\xff\xf9\x22\x20\x4d\xc9\xf6\x1b\x75\xbf\x7d\xe0\xe3\xf7\x71\xf5\x57\x99\x5b\xef\x0c\x2e\xf7\xcd\x57\xff\x1b\x76\xeb\xd3\xfb\x72\xd7\x6c\xf3\xdb\x2c\x8b\xcf\x75\x27\x73\x8d\xd1\xc5\xdd\x77\xc1\x1d\x6a\x4f\xd3\xf5\x84\xe6\x6d\xc9\xb1\xb9\x39\x2b\x18\xc0\x13\x3b\xb2\x8f\x00\x00\x00\xff\xff\xcd\x22\x74\x8d\x85\x02\x00\x00")

func dataAlmanacJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataAlmanacJson,
		"data/almanac.json",
	)
}

func dataAlmanacJson() (*asset, error) {
	bytes, err := dataAlmanacJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/almanac.json", size: 645, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataAudreyJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x93\xcd\x6e\xea\x30\x10\x85\xf7\x79\x0a\xcb\x6b\x84\x75\xb7\xd9\xde\x46\xed\xa2\x12\xa8\x65\x57\x55\xc8\xd8\x07\x92\x2a\xb1\x91\x33\x49\xa9\x10\xef\x5e\x25\xb8\xaa\x4a\x7e\xa0\x21\x74\x03\x96\x3d\x39\xdf\xcc\x99\x99\x7d\xc0\x18\xcf\x4b\xc5\x43\xc6\x95\xd5\x98\xbe\x15\x39\x25\x66\x4a\xa5\x78\xc7\x4a\xc8\x42\x3b\x7c\x08\x95\x69\x7f\xe4\x93\xea\x03\x67\x0b\x42\xce\x43\xf6\x12\x30\xc6\xd8\xbe\xfe\x65\x8c\x6f\x25\x11\x9c\xa9\xc4\x44\xf9\x4f\xac\x01\x2d\x42\x15\x4b\x63\x90\x2e\x13\x2d\xb6\x36\xa7\xbc\x96\xa8\xc3\x8d\xcc\x50\xc5\x6e\x40\xf3\x9f\x2f\x19\x28\xb6\xba\x7a\xbb\x8f\x16\xbc\xbe\x3d\x4c\xce\xb3\x1c\x14\x0c\x35\x01\xa7\xf7\x03\xe5\x2f\x28\x45\x39\x48\x42\x55\x4d\x1b\x6d\x3e\x7b\xbe\x06\x27\xc2\xea\x6f\x99\xe8\x4e\x0b\xc7\x2f\xb1\x87\xa9\x91\xa2\xbb\xd6\xbb\xe8\x31\x5a\x44\x63\x90\x85\x83\x54\x94\x58\xd3\xe9\xf7\x93\x0f\x58\xd8\x5b\x3b\xff\x9d\x8b\x08\x91\x59\x42\x8f\x33\xe7\xb3\x1a\xd1\x23\x65\xb3\x0c\xa6\x63\xbb\xfe\xfb\xc7\xd9\xfa\xc6\x43\xd2\x93\xc6\xb1\x53\x3e\x93\x71\x5b\xf4\x05\x15\xa1\x3f\x75\xad\x48\x0f\x7d\xb0\x01\x97\xc1\x8f\x13\xd1\xc3\xbf\x66\x14\xda\x52\xf8\xcd\xd2\xfc\x59\x53\x86\x6d\xcf\x08\xae\x35\x21\x89\xd1\xd8\x0d\x1e\x04\x8d\x55\xb1\x11\x31\x64\x4a\x71\x53\xfb\xf4\x7e\x90\x78\x29\x5d\x4b\xeb\xb0\xdb\x96\xd2\x3d\x48\xa3\x53\xb8\x36\x82\x97\x0f\x18\x7b\x0d\x0e\xc1\x67\x00\x00\x00\xff\xff\xc7\x62\x8a\xdf\xdf\x07\x00\x00")

func dataAudreyJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataAudreyJson,
		"data/audrey.json",
	)
}

func dataAudreyJson() (*asset, error) {
	bytes, err := dataAudreyJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/audrey.json", size: 2015, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataAutohostJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x91\x41\x6b\x03\x21\x10\x85\xef\xfe\x8a\xc1\x73\x88\xf7\xbd\x97\x1e\x1b\x68\x7b\x2a\x25\x58\x1d\x8c\xa5\xab\xc1\x79\x2e\x94\x90\xff\x5e\x14\xda\x1e\x36\x59\x92\xbd\x2c\xac\xef\xcd\xf7\x31\x7a\x52\x44\x5a\x26\xa7\x07\xd2\x2e\x7b\xde\x7e\x56\x41\x4c\x5b\x4c\xc6\x47\x71\x79\xe2\xf2\x6d\x6c\x45\x3e\x64\x81\x71\xa3\xff\xfb\xd1\x9b\x36\x5a\x72\x05\x8b\x1e\xe8\x4d\x11\x11\x9d\xfa\x97\x48\x1f\x2d\xc0\x25\x35\xac\x11\x06\x62\x0a\x62\x86\xe8\xfb\x54\x6f\x24\x3b\x72\x8b\x03\x63\xff\xdb\xf8\x4f\x47\xc6\x21\xfb\x96\x3f\x3e\xbc\xe8\x7e\x7a\xde\xac\x55\xd4\xa3\xb7\xe0\x45\xcb\xee\xf5\x06\xcb\x57\x14\x5c\x5f\x02\xb6\x04\xc6\xfa\x1d\xae\xd3\x65\x99\xbe\x7b\x7a\xbe\x01\x8f\x12\x43\xe0\x32\xa7\xcf\x82\x7b\xc9\x02\x8b\xba\xf4\xba\x3d\x5f\x7d\x2f\x9e\x3f\x6a\x30\xa5\xa6\x14\x53\xb8\x6c\xe8\x95\xfd\xac\x72\x49\xa4\x88\xde\xd5\x59\xfd\x04\x00\x00\xff\xff\xc7\x1c\xad\x53\xf8\x02\x00\x00")

func dataAutohostJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataAutohostJson,
		"data/autohost.json",
	)
}

func dataAutohostJson() (*asset, error) {
	bytes, err := dataAutohostJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/autohost.json", size: 760, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataChannelsJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x74\x8d\x31\xce\x83\x30\x0c\x46\xf7\x9c\xe2\x93\x67\x04\x3b\xfb\xaf\xff\x02\xdd\xaa\x0a\x01\xb1\x02\x55\x71\xaa\xc4\xa1\x03\xe2\xee\x55\xb2\x55\x69\x17\x0f\x7e\xcf\xcf\x87\x01\x28\xee\x33\xf5\xa0\xd9\x5b\x6e\xef\x29\xea\x2a\xad\xee\xdd\x8b\xa7\x6e\x5e\x46\x11\x7e\x44\x6a\xb2\x17\x7c\x52\x8e\xd4\xe3\x6a\x00\xe0\x28\x13\xa0\xe7\xa8\xca\x41\x72\xe3\xf3\xa2\x50\x19\x37\x2e\xf9\x8a\x6c\xac\x8b\xb7\x99\xfd\xff\x5d\xa8\x6c\xcf\xe6\x77\xda\xf2\x94\x5c\x17\x92\xc8\x2a\xae\xee\x3b\xd6\xa1\x28\x43\xa5\x7c\x7b\x64\x80\x9b\x39\xcd\x3b\x00\x00\xff\xff\xca\x68\x9e\x39\x01\x01\x00\x00")

func dataChannelsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataChannelsJson,
		"data/channels.json",
	)
}

func dataChannelsJson() (*asset, error) {
	bytes, err := dataChannelsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/channels.json", size: 257, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataCohesionJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x93\x3f\x6b\xf3\x30\x10\xc6\x77\x7d\x8a\x43\x73\x88\x70\x46\x6f\x2f\x6f\x4d\x3b\x14\x5a\xa8\x3b\x95\x62\x14\xe9\xa8\xd5\xc4\x92\xb1\x4e\x2e\x25\xe4\xbb\x17\xdd\x90\x50\xc8\x9f\x0e\xc6\xed\x62\xac\x7b\xee\x4e\x3f\xf4\xf0\xec\x04\x80\x8c\xa3\x91\x25\x48\x13\x2c\x2e\xdf\x53\x24\xe7\x97\x34\xaa\x0f\x5c\x2b\x13\x5a\x8c\x2e\x78\x65\x3a\x7b\x38\xc8\x45\x1e\x1a\x42\x22\x8c\xb2\x84\x17\x01\x00\xb0\xe3\x2f\x80\xec\x35\x11\x0e\x3e\x2f\x54\x63\xa1\x74\x8c\xc1\x38\x4d\x2e\xf8\xa8\x4a\x67\x8b\x66\xe3\xbc\xe5\x3f\x55\xb2\xd8\xd0\x67\x8f\xb9\xb0\x3a\x48\x2b\xbe\x82\xd7\x79\xdd\x61\xde\x35\x16\x8d\x19\x50\x13\x36\x3c\x74\x6c\xe8\x90\xda\x60\x73\xcb\xe3\x73\x2d\xb9\xba\x5f\xcc\x85\x94\x7a\x7b\x19\xe9\xe1\x69\x62\xa6\x75\xda\x6e\x58\x3b\xc9\xc3\xea\x9f\x83\xd2\x64\xda\xeb\x54\xff\xea\xff\x77\x73\xfb\x67\x71\x8b\x97\xa0\x6e\xaa\xfb\xaa\xae\x66\x77\xf0\x57\xb1\x94\x09\xc9\xd3\xe9\x04\x7e\x57\x8e\x40\xb7\xd5\xec\xd1\x7b\x43\x3a\xff\x40\x93\xf3\xfc\xc0\xb4\xe9\x81\x38\x38\xe7\x23\x75\x25\xdb\x02\xe0\x55\xec\xc5\x57\x00\x00\x00\xff\xff\x27\xcb\x80\x34\xe2\x05\x00\x00")

func dataCohesionJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataCohesionJson,
		"data/cohesion.json",
	)
}

func dataCohesionJson() (*asset, error) {
	bytes, err := dataCohesionJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/cohesion.json", size: 1506, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataDigestionJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x93\x3f\x6b\xc3\x30\x10\xc5\x77\x7f\x0a\xa1\x39\xe4\xe8\xea\xad\x24\xa6\x1d\x0a\x2d\x38\x5b\xe9\x20\xa4\xa3\x76\x91\xa5\xa2\x3b\x0b\x4a\xc8\x77\x2f\x96\x13\xd3\xc1\xc5\x7f\x70\x3c\x9d\xd1\x7b\xba\x1f\x4f\x77\xe7\x4c\x08\x21\x24\x45\x2d\x73\x21\xb5\x37\xb8\xff\x6a\x89\x6b\xb7\xe7\x08\xb1\x36\xe8\xc1\xd4\x9f\x48\x5c\x7b\x07\xba\x31\x40\x18\x22\x06\xb9\xeb\x7d\xc1\xb7\x8c\x24\x73\xf1\x9e\xfe\xbb\xef\x3c\x54\x49\xe1\x54\x83\xdd\xd5\x4f\xc8\xcf\xa8\x2c\x57\x57\xeb\x20\xf8\x56\xcc\x18\x5c\xa7\x81\xf8\x00\xd5\xa8\xa8\x41\xae\xbc\x49\xf7\x14\x27\x39\x9c\x5d\x76\x33\xda\x96\x1c\x50\x35\x13\x6d\x75\xa5\x9c\x43\x0b\xf9\xad\xa0\xe4\x82\x9c\x46\xdd\xab\x79\x8e\x68\x91\xf1\xbe\x48\xc7\xe2\xa5\x38\x15\x0b\x53\x3a\xf4\x4d\x16\x32\x6d\x9c\xcb\xd6\x10\xcb\x93\x78\xb4\xb6\x7f\x1c\x9a\x80\xe8\x1f\x81\x40\xd9\xed\x42\x18\x86\xf5\xe0\x5b\xc7\x33\x01\xf4\x98\x76\x35\x42\x79\x43\x98\xb5\xac\x13\x23\x7a\x5d\xe6\x9f\xff\xe9\xde\x5e\xcb\xbf\x78\xa9\xfa\xc8\x2e\xd9\x6f\x00\x00\x00\xff\xff\x76\x0e\xb5\xfc\x97\x04\x00\x00")

func dataDigestionJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataDigestionJson,
		"data/digestion.json",
	)
}

func dataDigestionJson() (*asset, error) {
	bytes, err := dataDigestionJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/digestion.json", size: 1175, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataDiscoveryJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x92\xbb\x6e\xeb\x30\x0c\x86\x77\x3f\x05\xa1\x39\x88\xf6\x6c\x07\xa7\x46\x3b\x74\xe8\x90\x4e\x45\x61\x30\x16\x61\xab\x50\x2c\xc3\xa2\xdd\x4b\x90\x77\x2f\x24\x74\xa8\x23\x19\xbe\xa0\x8b\x06\xfe\xf4\xf7\x99\xa2\x2e\x19\x80\x70\x43\x29\x0e\x20\x4a\xab\x68\xff\xd6\x3b\xd6\xcd\x9e\x07\xf9\x4e\x27\xa9\xb4\x2b\xed\x40\xdd\xa7\xd8\xf9\xc6\xce\xf6\x4c\x4e\x1c\xe0\x25\x03\x00\xb8\x84\x13\x40\xb4\xc8\x4c\x5d\xe3\x21\xd2\xf5\x55\x45\x8e\xc3\x07\x21\x6c\xf0\x4c\x3e\x89\x82\x33\x71\x6d\x95\x8f\xee\xf3\xa3\x08\xd5\xeb\x6e\x1a\xcc\xb6\x8d\xa1\xa3\xe2\x4a\x60\xe5\x19\x11\x71\x5c\xdd\x80\x94\x46\xa7\xc6\xf7\x51\x31\x8e\x36\xc0\x5d\x0c\x46\xa5\x8a\xa9\x9f\x7e\x7a\x5e\xc0\xf5\x00\x34\x1a\x27\xd8\x37\xd1\x4a\x78\xb8\x91\x70\xb4\x9d\x6d\xa9\x63\x9d\x9a\xa1\x6f\x15\x32\x15\xa9\x96\x5f\xbe\x7f\xc7\xff\x0f\xf3\x46\x63\x4b\x34\xfa\x0b\x59\xdb\x26\xa1\xaa\x88\x8b\x89\x96\x95\xfb\x98\x11\xfd\xcc\x34\xeb\x5a\x74\x8d\x33\x2e\x45\x86\x96\xb8\xee\xf2\xc7\xfc\x98\xaf\xd4\x49\x34\x66\x52\x89\xc6\xfc\x9d\x36\x3c\xb5\xd4\xfb\xf0\x4b\xf3\xa6\xa8\x61\xe5\xca\x62\xb2\x6e\x14\x7d\x6c\xe6\x29\x3a\xf5\x95\xac\x09\x0d\xd7\x31\xfb\xb6\x9e\x82\x67\x00\xaf\xd9\x35\xfb\x0e\x00\x00\xff\xff\xe6\xa7\x81\x00\x88\x05\x00\x00")

func dataDiscoveryJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataDiscoveryJson,
		"data/discovery.json",
	)
}

func dataDiscoveryJson() (*asset, error) {
	bytes, err := dataDiscoveryJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/discovery.json", size: 1416, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataFlowsdproxyJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x74\x8e\xc1\x4a\x04\x31\x0c\x86\xef\x7d\x8a\xd0\xf3\x92\xa0\xc7\xbd\x8a\xae\x37\x17\xf4\x26\x1e\x6a\x1b\x77\xaa\xd3\x76\x68\xd3\xaa\x2c\xfb\xee\xd2\xa2\xa0\x8c\x7b\x09\xe4\xff\xc9\xf7\x45\x1d\x15\x80\x2e\xcd\xea\x2d\x68\x9b\x1c\xe3\x6b\x2d\xe2\x23\x4a\xa3\xe6\x1d\x27\x32\x73\x30\xd1\x58\xb2\xc1\xd1\xcb\x9c\xde\x8b\x5b\x72\xfa\xf8\xd4\x9b\x7e\x98\x53\x15\x2e\x7a\x0b\x8f\x0a\x00\xe0\x38\x26\x80\x5e\x8c\x08\xe7\xd8\xa1\xd4\x2e\xe9\x2f\x18\x07\x18\xbf\xc1\x68\x83\xc3\x5f\x60\x34\x8b\xc7\x76\x81\x37\x23\xda\xf7\x88\x76\x2c\x63\x1d\xd2\x21\x88\x26\x70\xa7\xaf\x9b\xc0\x32\x25\xd7\xbb\xfd\xdd\xfd\x83\x1e\xf1\x69\x73\xfe\x3d\xc7\xcf\xf5\x40\xb9\xc6\xe8\xe3\x61\x2d\xb8\x65\x33\xcb\x74\x35\xb1\x7d\xfb\xcf\xb1\xbb\xfe\x51\x28\x80\x27\x75\x52\x5f\x01\x00\x00\xff\xff\x4a\x3f\xbc\xa3\x51\x01\x00\x00")

func dataFlowsdproxyJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataFlowsdproxyJson,
		"data/flowsdproxy.json",
	)
}

func dataFlowsdproxyJson() (*asset, error) {
	bytes, err := dataFlowsdproxyJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/flowsdproxy.json", size: 337, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataFriendshipJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x56\x3d\x0f\x9b\x30\x10\xdd\xf9\x15\x16\x73\x14\x2b\x2b\x73\x51\x97\x4a\x8d\xd4\x74\xaa\x2a\xe4\xda\x97\xe2\x34\xd8\xd4\x3e\x58\xa2\xfc\xf7\xca\x04\x4a\x93\x98\x8f\x12\x9c\x05\x24\x73\xbe\xf7\xfc\xee\xee\x99\x4b\x44\x48\x6c\x6b\x1e\x27\x24\xe6\x5a\xc0\xf6\x54\x59\x94\x6a\x8b\x35\xe5\x39\x43\x7a\x34\x12\x94\xb0\xb9\x2c\x29\x2b\xcb\x78\xe3\xc2\x8d\xae\x10\x6c\x9c\x90\x6f\x11\x21\x84\x5c\x9a\x27\x21\x71\xc9\x10\xc1\x28\x97\x8a\x56\x16\x8c\xa5\x89\x7b\x65\x52\x74\x69\xa8\x81\xdf\x15\x58\xb4\x4d\xa2\x66\x93\x62\x05\xb8\x1d\x3f\x01\xb3\x5b\x54\xf6\x1c\x54\x00\xe6\x5a\xb8\xb0\x8f\xe9\x21\x6e\x56\xaf\x9b\xc5\xe0\x34\x69\x81\xa4\x78\xe6\xc1\x84\x68\x79\xf8\xe0\xf7\x5f\x03\xc3\x1b\x38\x01\xc7\x4e\x02\x1f\x85\x0f\xe9\xa7\xf4\x90\x2e\x66\xa1\x34\xca\xa3\xe4\x0c\xa5\x56\x03\x65\x18\x08\x59\xa7\x08\x13\xf8\x06\xec\x03\x83\x00\x1a\x18\xe0\xba\x28\x40\x09\xf0\x54\xc0\x29\xe0\x0d\x58\xab\x09\xff\xa6\xa6\x09\x32\xe3\xe0\x7c\x8d\x20\xa4\x2d\xa4\xb5\x53\x54\x5e\x53\x62\x6c\x0c\xd7\xae\xbc\xe7\x88\x70\x06\x84\xcc\xc5\x05\x28\xf2\xd8\x94\xfd\x73\xca\x5c\x96\x6b\x97\x78\xd4\x5e\x38\x87\x12\x03\x39\xcc\x18\x70\x2b\xf6\x30\xf0\x5c\xb9\xeb\xdd\x2a\xe6\x9e\xd5\xbb\xc5\xba\x0f\x53\xe8\x15\x18\x61\x73\xef\xb1\x03\x44\x5e\x97\xe3\xce\xe9\x28\xd7\x95\xc2\x19\x7e\x1b\x46\x97\xff\x76\xdd\x60\xaa\xf4\x9e\x47\x7f\x9c\x35\xff\xe5\x61\xd3\xac\x37\xb6\x30\xc0\x62\xff\xf9\xcb\x6b\x5d\x32\xcd\xa1\x1d\x97\x1b\x95\x40\x5a\x8c\xfa\x52\xa0\xf9\xe8\x4f\xfe\xe8\x04\x1d\x07\x69\xbb\x51\x0d\x3c\xa1\x53\xb6\xfc\x7e\xfc\xfe\xdf\x2f\x54\xe3\xcd\xbd\x19\x86\xf0\xe7\x5c\x0e\xcb\xe0\xef\xee\x87\x77\x4c\xff\x91\x15\xf2\x2c\x99\xf1\x77\xe0\xd3\x47\x5f\x03\x44\x84\x7c\x8f\xae\xd1\x9f\x00\x00\x00\xff\xff\xdb\x7e\xfd\x81\xc4\x0c\x00\x00")

func dataFriendshipJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataFriendshipJson,
		"data/friendship.json",
	)
}

func dataFriendshipJson() (*asset, error) {
	bytes, err := dataFriendshipJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/friendship.json", size: 3268, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataImStoreJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x93\x41\x4b\xc4\x30\x10\x85\xef\xfd\x15\x43\xce\x6b\x83\xd7\xde\x45\x6f\x2e\xa8\x27\x91\x12\x93\xa1\x89\xb6\x69\x49\x26\x41\x58\xf6\xbf\x4b\x52\x17\x76\x6d\x2d\xad\xec\x25\x84\xbc\x97\xf7\xf1\x26\xe4\x50\x00\x30\x1f\x25\xab\x80\xc9\x5e\x61\xf9\x11\x3c\x19\x5b\x52\xe4\x52\x0b\xe2\xa6\xbb\xf1\xd4\x3b\xe4\x79\x65\xbb\x64\x77\x7d\x20\xf4\xac\x82\xd7\x02\x00\xe0\x90\x57\x00\x36\x08\x22\x74\x36\x45\xf1\x78\xcb\x49\x3b\x14\xca\xf3\x6a\xdc\xd4\x46\xf1\x0e\xbd\x17\x0d\xfa\x9c\x93\xef\x58\xd1\x61\xba\xd0\x20\xd5\x53\xb5\x43\xd2\xbd\x4a\xfa\xfd\xdd\x33\xcb\xa7\xc7\xdd\x1a\xe8\x3c\x60\x22\x5e\x31\x7f\x08\x8b\xf9\xfb\x97\x4d\xf9\x67\x43\x5b\xaa\x72\x85\x26\x8b\xa4\xa1\xf7\x4b\xa8\xfd\xe3\xd3\x3a\x56\xb0\x97\x11\xe7\x4d\x7e\x6b\x1b\x9b\x28\x7c\x0f\x0d\x77\xc1\x5a\x63\x9b\x29\x41\xa3\x68\x49\x4b\x8d\xf2\xf3\xdf\x08\x4f\x82\x8c\xe4\x0e\x25\x9a\x88\xae\xd4\xd4\xb5\x53\xd2\xe8\xaa\x4f\xae\xfa\xd2\xb5\x11\x69\x6c\xda\x8a\x36\x0d\xef\xef\x4f\x73\x72\xd5\xf9\x9d\x96\xbe\xcf\xba\x97\x1a\x67\x19\x85\x9b\x61\xe1\xd7\x10\x85\x7b\x10\x56\xb5\xe8\xe6\x10\x3f\xf1\x05\xc0\x5b\x71\x2c\xbe\x03\x00\x00\xff\xff\xab\x4f\xf6\xe3\x58\x04\x00\x00")

func dataImStoreJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataImStoreJson,
		"data/im-store.json",
	)
}

func dataImStoreJson() (*asset, error) {
	bytes, err := dataImStoreJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/im-store.json", size: 1112, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataPartnershipsJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x8f\x31\x4b\x04\x31\x10\x85\xfb\xfc\x8a\x21\xf5\x71\xe9\xb7\x13\x11\x2d\x2d\xae\x13\x09\xb9\xcd\xb0\x1b\xe1\x26\x61\x32\x59\x85\x65\xff\xbb\x24\x8a\x8d\x41\x96\xc5\x26\x45\xf8\xde\xfb\xe6\xad\x0a\x40\xe7\x65\xd4\x03\xe8\x31\x7a\x3c\xbf\x95\x2c\x81\xce\xb2\x98\x77\xbc\x9a\xe4\x58\x08\x39\xcf\x21\x65\x7d\xaa\x2c\xc7\x22\x98\xf5\x00\x2f\x0a\x00\x60\x6d\x2f\x80\x4e\x4e\x04\x99\x6a\xcf\x4f\xca\x0c\x25\x23\xdb\xe0\x4d\xe2\x98\x90\x25\xe0\x57\x4b\x4b\x90\xbb\x61\xc5\x27\x14\xfb\x9d\xb0\x3d\xee\x86\x32\x47\x5f\xc9\xc7\x87\x8b\x6e\xbf\xdb\xe9\xbf\xe4\xc9\xc9\x38\xef\xd4\x3f\xdf\x5d\xee\x9f\xf6\x1f\xf0\xe7\xd2\xe3\xfb\xfa\xb5\x81\x3c\x7e\x1c\xee\xf4\x78\x2d\x93\xe1\x42\x14\x68\xea\x0b\x1a\x62\x7f\x21\x3d\x91\x02\x78\x55\x9b\xfa\x0c\x00\x00\xff\xff\x36\xca\x70\xc0\x5b\x02\x00\x00")

func dataPartnershipsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataPartnershipsJson,
		"data/partnerships.json",
	)
}

func dataPartnershipsJson() (*asset, error) {
	bytes, err := dataPartnershipsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/partnerships.json", size: 603, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataPresenceJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x90\xb1\x4e\xc3\x30\x10\x40\x77\x7f\xc5\xc9\x73\x55\x2b\x8c\x5d\x11\xa2\x1b\x95\x80\x09\xa1\xc8\xd8\x47\x62\x48\xcf\x96\x7d\xb6\x90\xaa\xfe\x3b\x4a\xca\xe6\x34\x0a\xb0\x78\xf0\xb3\xdf\xd3\xdd\x49\x00\xc8\x54\x8c\xdc\x81\x34\xde\xe2\xf6\x23\x27\x76\xb4\xe5\xa2\x4c\xaf\x59\x85\x88\x09\xc9\xa0\xd2\x21\xc8\xcd\xf8\x38\xfa\xcc\x98\xe4\x0e\x5e\x04\x00\xc0\x69\x3a\x01\x64\xd0\xcc\x18\x69\x14\xa9\xd2\xa8\xf7\xe8\x90\x6c\x9a\xfe\x4c\x9c\xf4\x11\x47\xd8\x21\xb7\x15\x3c\x22\xf7\xde\x8e\xf8\xfe\xee\x49\x4e\xb7\xe7\xcd\xa2\xdf\xd3\xe0\x08\x6b\x7d\xf0\x89\xdb\x0b\x6c\x4b\x33\x57\x38\x3c\x3c\xae\x49\xdc\xac\x49\xfc\xc3\xdf\xa8\x84\xcc\x8e\xba\x2b\x3b\xaa\xe9\xef\x97\x74\xbd\x10\xf2\x72\xe1\xf0\xbc\xa2\x60\xf1\x2d\x77\x2a\x66\x22\x47\x5d\xdd\xd8\xa3\x1e\xb8\xbf\xed\xd1\x7c\xfe\x79\x88\x4b\xa2\xe8\x38\x33\x03\x7e\x85\xa2\xe3\x5e\x93\x1d\x30\xce\x15\x7e\xf4\x02\xe0\x55\x9c\xc5\x77\x00\x00\x00\xff\xff\x43\x57\xe3\x44\xeb\x02\x00\x00")

func dataPresenceJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataPresenceJson,
		"data/presence.json",
	)
}

func dataPresenceJson() (*asset, error) {
	bytes, err := dataPresenceJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/presence.json", size: 747, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataPubsubBrokerJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x91\x4d\x6b\xc4\x20\x10\x40\xef\xfe\x8a\xc1\xf3\x76\xa5\xd7\xbd\x97\x1e\x5b\x68\x6f\xa5\x2c\x9a\x0c\x6b\x3f\xa2\xd6\x19\xa5\x10\xf2\xdf\x8b\x86\x52\x88\x09\xa4\x87\xbd\x24\xe0\x73\xde\x43\x1d\x05\x80\xa4\xdc\xc9\x13\xc8\xce\xf7\x78\x7c\x4f\xc4\x6f\xee\xc8\x59\x75\x56\xb3\x0a\xc9\x50\x32\x37\x26\xfa\x0f\x8c\x6a\xfe\xc9\x43\x19\x8a\x3e\x31\x92\x3c\xc1\x8b\x00\x00\x18\xeb\x17\x40\x06\xcd\x8c\xd1\x15\xa1\xea\xd1\xa4\x8b\xb2\xa8\x3f\xd9\xd6\xa9\xba\xc3\xe9\x01\x0b\xae\xf4\xbc\xa4\x03\xb2\xf5\x7d\xe1\xf7\x77\xcf\xb2\xae\x4e\x87\xed\xc4\x80\x44\xfa\x82\xd4\xea\x83\x27\x3e\xb7\xf8\xcf\xff\xf8\xf0\xb4\x23\x90\x6f\x7f\x1b\x57\x4b\xcc\xd7\x94\x75\x5c\x39\x05\x7e\x87\xac\xe3\x9a\x7b\xaf\x37\xe2\x57\x42\xe2\x15\xf7\xfc\x00\x2d\xff\x7f\x03\x33\xba\xed\xc2\x92\x36\x7e\x01\xf0\x2a\x26\xf1\x13\x00\x00\xff\xff\x58\xb8\xf6\x6e\x8d\x02\x00\x00")

func dataPubsubBrokerJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataPubsubBrokerJson,
		"data/pubsub-broker.json",
	)
}

func dataPubsubBrokerJson() (*asset, error) {
	bytes, err := dataPubsubBrokerJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/pubsub-broker.json", size: 653, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataRailsJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xd4\xbd\x4d\x8f\xe4\x38\x92\x26\x7c\xaf\x5f\x91\x28\xbf\x54\x37\x06\xad\x7e\xab\x7b\xe6\x10\xb7\x77\x77\x1b\x8b\x05\x16\xdb\x03\x4c\xcf\x69\xb1\x20\xe8\x12\xc3\x9d\x15\x92\xa8\x26\x29\x8f\x8c\x1e\xcc\x7f\x5f\x88\xd4\xb7\xe4\xa2\x91\x66\x8a\xc8\x3d\x54\x66\x56\x84\x19\x9f\x47\x46\xa3\xf1\xcb\x48\xfe\xc7\x4f\xdf\xbe\xfd\x6c\x1e\xf9\xcf\x2f\xdf\x7e\xce\x55\x21\xfe\xf0\x5b\x6b\xac\xac\xff\x60\x1f\xd9\xbb\xb8\x76\xff\xfd\xfc\x4f\x9d\x88\x56\xad\x15\xe6\xe7\x97\x6f\xff\xfb\xa7\x6f\xdf\xbe\x7d\xfb\x0f\xf7\xe7\xb7\x6f\x3f\x37\xdc\x5a\xa1\xeb\x4e\x3d\xe3\xc6\x08\x6b\x9c\xbc\xfb\x5d\xcd\x2b\xb1\xfb\x8b\x4a\xd8\xbb\x2a\xba\x5f\xfd\xec\x7e\xf4\x9f\xff\xf4\xbc\xd0\x87\x14\xef\x42\x67\x25\xaf\x6f\x2d\xbf\x89\x5f\xfe\xf0\xf2\xaa\x74\xc5\xed\xef\xb6\x38\xbc\x91\x99\x7d\x97\x36\xbf\xf7\x5a\x97\x41\x6b\x0f\xfa\xbf\xff\xe5\x6f\x61\xf4\x2d\xc8\xab\x56\xb5\x65\x0d\xbf\x89\xcb\xf4\xcf\xb4\x4f\x9b\xf4\xb3\x52\x3e\x04\x6b\x4a\xfe\x21\xf4\xd1\x17\xce\xc0\x67\x1a\x69\xe8\x5d\x01\x40\x2c\xec\x87\xf2\xa2\x92\x75\x56\x70\x73\xbf\x2a\xae\x8b\x23\x54\x88\x6c\x64\x1d\xba\x12\x0f\xfd\x66\x09\x79\x91\x75\x21\xbe\x63\xbe\xb4\x35\x42\x9b\xec\xa5\xfb\x8b\xc9\x22\xe3\x05\xd3\xe2\x21\xea\x56\xb0\x5c\xd5\xaf\xf2\x66\xb2\x2b\xb7\xf9\x9d\xf1\xdc\x4a\x05\xa0\xb6\x2d\xe0\x32\x2f\x60\x8f\xea\xbf\xfe\xf5\xdf\xa0\xa6\x09\xd3\x4d\x62\xf8\xd4\x8a\xf0\x4a\x3b\x89\x59\xae\x05\xb7\xbb\xae\x4c\x6a\xb5\xac\x16\xef\x49\xfc\x6a\xf1\x7e\xb6\xdd\xb2\x17\x59\x64\xa2\x90\x36\x89\x60\xa7\xf8\x19\x0c\x93\xc8\x99\xbb\xfa\x14\xf3\x25\x91\x6b\x9b\xe2\x99\xeb\xfd\xfb\x0f\x40\xaf\x10\xc6\x6a\xf5\xb1\xc7\xef\xbf\xfd\xe5\x7f\xfe\xe5\x6f\x7f\x81\x52\x74\x7f\x4a\x63\x35\xb7\x4a\xc7\x87\xbb\xb9\x32\x69\xa8\x5b\x16\x1d\x4d\x85\x22\xa6\xad\x4c\x03\xac\xaa\x05\x0d\x02\x17\xe7\xfa\xca\xde\xc4\x47\x74\xd5\xf4\x6a\xb4\x95\xd2\x17\x1a\x01\x4f\x52\x11\xf1\xb0\x34\x3d\xc7\x68\x7b\x58\x07\x31\x80\xe3\xbb\x85\x11\x38\x22\xfa\x0f\xe8\x04\x31\x7f\x0e\x1f\x81\x4c\xe9\xed\x71\xc8\x24\xd1\x3a\x11\x9b\x2e\x14\xeb\xfc\x2e\x1f\xc2\x57\x7a\x21\x4a\x61\x8f\x27\x51\x0b\xa5\x8b\x57\x40\x9b\x60\x46\xa1\xad\xab\x36\x8a\x82\x57\xa0\xa2\x10\x1b\xef\x7a\x12\xb4\xf1\xce\x17\x1a\x01\x4f\x13\xef\xa6\x5a\x88\x80\xa6\x68\x7e\x6d\x21\xaf\xa5\x60\x15\xbf\xc9\x9c\x69\x61\x1a\x55\x9b\x58\x77\xd8\x2f\xe3\xc8\x3b\x62\xaa\xe4\x09\xc3\x48\x6f\x79\xc2\x91\xd4\x79\xf6\x31\xd2\xc9\x91\xb8\x16\x35\x29\xa2\x8e\xf6\x49\xad\xc2\xfa\xdd\x27\xd4\x08\xba\xe1\x83\xe6\x00\xec\x95\x9f\x70\xa3\xe8\xa4\x9f\x93\x4b\xe7\x75\x6e\x0c\x41\x04\x0f\x92\x0e\xfe\x0c\x66\x74\xdd\x7f\x5b\x48\x0b\x6c\x89\x96\x26\x1a\x5c\x4b\x9e\xbf\x95\xd2\x58\x26\x6a\xab\x65\x74\x18\xdd\xe8\x93\x06\xd0\x4d\xe9\x29\x84\x4e\x31\x53\x0a\x11\x9a\x40\xb9\xad\x31\x50\x88\xdc\xd2\xc1\x07\xc7\x2d\x15\x50\x3b\xda\x52\x21\x6b\x41\xab\xe5\x96\xfc\xce\x1b\x2b\xa2\x17\x35\x06\xb5\x33\x57\x6e\x07\x8c\x08\x36\x27\xac\xd2\x26\xb0\x38\x65\x45\x76\xac\x28\x90\x2f\x8f\x5c\xc8\x57\x5f\x47\x1e\xf0\xfe\x7d\x24\x43\xbf\xd2\x3a\x67\x13\x41\x84\x7e\x55\x35\x91\xc8\x19\x2b\xa8\x89\x54\xc8\x22\x4c\x5e\x19\x26\x2a\x2e\xcb\xe8\xa0\x32\x2a\x92\x86\x95\xa9\xd8\x28\x0a\x14\xb1\x24\x11\x9a\x26\x80\xcc\xea\x01\x16\x33\x26\x02\xf8\xa8\x31\x03\x8f\x08\x14\x13\x03\x82\x50\xb1\xa4\x10\x85\x4e\x10\x1f\x10\xe8\x24\x41\x21\x57\xcd\x87\x96\xb7\xbb\x65\x77\x55\x16\x09\x3d\xfc\x5a\x9f\xb6\x4d\xae\x4b\x4f\x21\x44\xd2\x42\x29\x88\x10\xb5\xd7\x4d\x8d\xc1\x9a\xed\x86\x0e\x41\xeb\xdd\x50\x89\x68\xc4\x1b\x3e\x14\x6d\x79\x8f\x50\x0a\x17\x8a\x96\x4d\xc5\xe5\xa4\x76\x9e\xc8\x86\xac\xff\x07\x65\xc6\xac\x44\x49\xda\xf2\x58\x5a\x66\x04\xd7\xf9\x9d\x3d\x64\x21\x14\xa0\x45\x4f\x34\x16\x8a\x64\x74\x64\xc5\x6f\x82\xb5\x4d\xa9\x78\x9c\x51\x66\x7a\xd8\xe8\x32\xb1\x69\x6b\x7b\xd7\xca\xda\x52\x30\xf1\x3d\x17\x4d\x17\xcf\xa3\x8c\xb4\x5b\x00\xd6\x58\x55\xce\x99\xe5\x6f\xa2\x50\xef\x75\x6c\x5f\xb5\x54\x26\xed\xa8\x96\x45\x47\x53\xa1\x70\x6b\x51\x29\x2b\x73\x55\x03\x5b\xf6\x28\x4e\xd7\xa2\x17\x0c\xb2\x46\xd4\x85\xac\x6f\xe0\xda\x99\x08\x2d\x35\x91\x81\x6f\x2c\x36\x86\x01\x4d\x4f\x3d\xd9\x23\xce\x4f\x27\x1e\x94\x2e\x9a\x64\x08\x52\xc7\xfc\xca\x1a\x88\x6c\x13\x24\x7d\xee\xd7\xb7\xc8\x57\xc1\x6d\xab\x45\xc1\xf2\x3b\xaf\x6b\xd1\xcf\xb2\x3a\x7f\x7a\x70\xc8\xfe\xe3\x46\xff\x32\xe8\x22\x4d\xb3\x25\x16\xd7\x44\xb6\xc4\x28\x9b\xca\xa6\xf4\x14\x42\x14\x4d\x87\x84\x08\x4d\x53\xda\xd6\x18\x68\xda\xb1\xa5\x83\x9f\x76\xec\x7b\x35\x6c\xda\xb1\xe5\x43\x30\xed\xd8\x25\x94\xc2\x85\x60\xda\x41\xc6\x85\x24\x04\x92\xb1\x21\x0b\x89\x37\x5e\x41\x36\x9d\x9c\x18\x49\x1b\x76\x25\x65\xbc\x00\x7c\xb6\x07\xe5\x05\x7a\x14\x3f\x62\xb2\x5a\xd5\xec\x26\x79\x6d\xaf\xaa\xba\x46\x30\x58\x2a\xd2\xf1\xe9\xfe\xc5\x78\x29\x39\xb8\x0e\x96\x5a\x68\x26\xa5\xba\xf2\x92\x5d\x3b\xb7\x2a\xd8\xbb\xd2\x05\x84\xc8\x56\x89\xc4\x35\xee\x5c\x17\x0c\x9a\x9d\x36\x13\xa6\x06\xcf\xa0\xdd\xee\x9c\x03\x4d\x57\xeb\x4f\xf4\x68\xf5\xfd\x83\xdd\xb4\x6a\x9b\xd8\x81\xc0\x46\x9f\x74\x20\xb0\x29\x3d\x85\x10\x45\x65\x91\x10\xa1\x19\x08\x6c\x6b\x0c\x34\x10\xd8\xd2\xc1\x0f\x04\xb6\x54\xe0\x03\x81\x2d\x1f\x82\x81\xc0\x2e\xa1\x14\x2e\x04\x03\x01\x32\x2e\x24\x03\x01\x32\x36\x64\x03\x81\x8a\x1b\xc3\x1a\xae\x6d\x2d\x34\xb3\x4a\x41\x06\xd7\x5b\x1d\x92\xd6\xbd\x2d\x16\x1c\x91\x77\x18\xd1\x84\xbe\x5a\x59\xf9\x2a\x73\xee\x56\xed\xb2\x8a\xeb\xb7\x42\xbd\xd7\xac\xd1\xe2\x21\x21\xed\x7d\xa1\x7f\x59\xeb\x23\x0d\xb6\x24\x17\xd7\x63\x2c\x89\x51\xf6\x16\x8b\x92\x63\x89\x50\xf8\x11\x8a\x00\x4d\xef\xb0\xac\x19\x50\xcf\xb0\xa4\x81\xef\x15\x96\x14\xe0\x3d\xc2\x92\x07\x41\x6f\xb0\x21\x12\xcb\x81\xa0\x17\x40\x73\x20\x89\xfe\x68\x16\x64\x51\x5f\xf1\xd6\xde\x59\x5e\x4a\x51\x5b\xef\x1c\xef\x77\x69\x45\x29\x0d\xc0\x43\x16\xca\x97\x51\x11\xdb\x66\x96\x9c\xe2\xa2\xd9\x92\x12\x65\x34\x5b\x94\x1c\x4b\x84\x22\x9a\xa1\x08\xd0\x44\xb3\x65\xcd\x80\xa2\xd9\x92\x06\x3e\x9a\x6d\x1d\x16\x16\xcd\x96\x3c\x08\xa2\xd9\x86\x48\x2c\x07\x82\x68\x86\xe6\x40\x12\xcd\xd0\x2c\xe8\xa2\x99\xdb\x54\x65\xc6\xdd\xff\x11\x9d\x72\xbe\xd2\xa6\x8d\x1e\xcb\xb2\xe3\xc9\x90\x44\x10\x2c\x09\xa2\x28\xb2\xaa\x25\x58\x1c\x59\x51\x21\x88\x24\x2b\x1a\x11\xb1\x64\xc5\x85\x22\x9a\x6c\xc9\xc4\xf3\xa0\x88\x28\x14\x3c\x68\xa2\x0a\x05\x13\xb2\xc8\xd2\xf0\x5b\x74\x3c\x71\x3a\xa4\x51\xc4\x95\x08\x05\xa6\x88\x18\x51\x80\x34\xd1\xc1\x5b\x1a\x14\x13\x3c\x2c\x3e\x12\x78\x48\x78\xfb\xf7\xb8\x04\xad\x7e\x04\x86\x62\x12\xb4\xf0\x68\x4c\x92\xd6\x1c\x8d\x4a\xd8\x72\x3f\x54\xeb\x4e\x04\x49\x2b\x23\x4f\xc0\xaf\x74\x8f\x0e\xc2\x47\x79\xf8\x92\x51\x6c\x54\x59\x72\xa2\x8d\x2f\x8b\xb2\xe3\xc9\xd0\xc4\x1c\x24\x09\xaa\x38\xb4\xac\x25\x60\x44\x5a\x52\xa1\x88\x4d\x5b\xf7\x85\x46\xa9\x25\x17\x92\x78\xb5\x21\x13\xcf\x83\x24\x86\x11\xf0\xa0\x89\x6b\x42\x57\xd2\x18\xd8\x02\xe3\x4c\x98\xa6\xa5\xdc\x35\x8f\xbf\xa0\xa0\xd7\xa2\x0d\x1c\xbe\x4c\x38\x38\xe1\xe7\xc3\x41\x89\x02\x43\x6f\x75\x58\x40\xe8\xa1\x09\x02\x41\x0f\x1b\x11\x00\x7a\x6c\x8a\x86\x3f\x81\xc3\x71\x29\x1a\x7a\x0a\x2e\x4d\xc3\x4e\x41\xa6\x1b\xb4\xb4\x3a\xbf\x73\x23\x58\xc3\x3f\x2a\xb7\xac\x22\xab\x46\x69\xcb\xf2\x3b\xd7\x37\x71\xe5\xf9\x1b\xcb\xcd\x03\xc0\x6c\x5d\xd0\x65\xb7\x20\x74\x9b\xd8\xf0\x7d\x95\x75\xc1\xa6\x1f\x6b\xf5\x2a\x4b\xc8\x88\x6b\xc3\x77\xb7\x20\x7a\xbe\x91\x31\x74\x43\x93\x34\x9a\xae\x4b\x4f\xaa\x67\x8a\x08\xbb\x31\x13\xac\x39\x6c\xc8\x50\x84\x82\x95\x0b\xf4\x23\x79\xc5\x6a\x65\x99\x16\xb0\x68\xbc\x2e\xe3\x32\xd7\xa7\xab\xb6\x39\xc3\x9c\xd7\xb9\x28\x19\xaf\x0b\xa6\xc5\x6b\x5b\x47\xd9\x6f\xa0\xb9\x29\xe4\x24\xae\xae\x83\x64\xa2\x6a\xec\xc7\x50\x79\x49\x74\x77\xca\x39\x87\xb1\x16\x95\x7a\x08\x0c\xd7\x65\x09\xf4\x2c\x53\x03\xcb\xc0\xef\x9c\xc0\xd2\x97\x9e\x42\x88\x36\xb0\xcc\x2b\x13\x38\xac\xd9\x30\xa2\x18\xe0\xec\x11\x4a\xe1\x72\x56\xa4\x4b\xe1\x42\x32\x10\x1a\xae\x87\xd5\xa2\x1b\x37\x0c\xad\x4e\xb7\x00\x67\x5e\xa9\x5e\x9c\x1a\xd6\x87\xd7\x7c\xd2\x98\xec\xf3\x88\xa8\xa4\x35\x8d\xb8\x66\xbe\xe6\x43\xd9\xc8\x57\x65\xc7\x93\xa1\x68\xe0\x3b\x5e\x13\x4f\x84\xa0\x2d\x99\xb6\x71\xc3\x5d\x60\x42\xdb\x42\x9c\xc4\x10\x8b\x12\xc1\x69\x6c\x4b\x1e\x34\x7e\x61\x05\xaf\xfa\x03\x4f\x45\xc1\xba\xff\x63\xad\x39\x7e\x6a\x60\xa6\x78\x59\x28\x21\x63\xca\x44\xa5\xef\x7d\xa3\xd9\xac\xf5\xf0\x53\x2e\xcf\x29\xae\x19\x7b\x2e\x94\x8d\xd7\x95\x08\x05\xa6\xf0\xcf\x28\x40\x9a\x05\x14\x6f\x69\xd0\x80\xdd\xc3\xe2\x17\x4f\x26\x87\x83\x8d\x31\x3c\x2e\xc1\xb8\x62\x04\x86\x62\x12\xc4\xbc\x68\x4c\x92\x71\x42\x34\x2a\xd9\x62\x89\x95\xf9\x9b\xb0\xdd\xb0\xa7\x68\xf3\xae\xaf\x59\xfe\x80\xc9\x62\x25\x82\x7c\x89\xe3\xb8\x30\xda\x70\x80\xfd\x34\xf4\xd7\x90\xc4\x98\x2f\xff\x0a\xa2\xc0\x85\x76\x34\x58\xd0\x3b\xfe\x16\x82\x68\x88\xfe\x8e\x88\x48\x7a\xfc\x31\x14\x21\x96\xe2\x6b\xd0\x1f\x42\x11\xb7\x7f\x88\x0f\xa1\xe9\x0c\x7e\x88\x4f\x39\xaf\x87\x71\x39\x04\xf0\x7b\x03\x56\xfa\x97\x49\x97\x3c\x24\xb9\x31\x75\x3a\x33\x7d\x2a\xb3\xe9\xbb\x59\x21\x4d\xae\x5a\xd0\xda\xf6\x73\xeb\x4d\xa5\x9c\xc1\xd6\xb4\x57\x93\x6b\x79\x15\xcc\xaa\xe1\x37\xf1\x6c\xf7\x4a\x39\x83\xad\x3b\xf9\x54\xd4\x90\x19\xd4\x8a\xe1\xa0\x79\x06\xab\x7e\x25\x18\x51\xdb\xeb\x12\x4e\xa9\xe9\x8f\x3a\x67\xdf\x8d\x2a\x4b\x8e\xa8\xe8\x6d\x21\x67\x70\xf5\xf1\x79\x00\x72\xa7\x00\xe3\xb9\xee\x14\x72\x06\xd7\xd8\x3b\x8f\xd6\x34\x49\x6f\x3e\x3a\x30\xe6\x95\x17\x81\x57\x25\x8f\xac\xe8\xb4\xcf\x09\xe4\x6e\x91\x23\x91\xdd\x5c\x9b\x9a\x1d\x66\xc2\x74\xea\x0c\x29\x9e\xcc\x09\x13\x9c\xd4\x20\x47\x5d\x4b\x09\xb3\x8d\x53\xa6\x17\x89\x93\x85\x73\x66\x07\xf1\xe3\xca\x73\x06\xf7\x29\x3c\x68\xc6\xe6\x9a\xe7\x6f\x8c\x37\x8d\xe0\xc3\x05\x58\x4d\xa3\xd5\xf1\x43\xb0\x3b\xaa\x97\x5e\x0d\xed\xb5\x1b\x3e\x5a\xfc\x26\x40\x3d\xf0\x82\x8e\xd7\xa2\x65\x13\x19\xe7\x16\x7c\x48\xa3\xdc\xbc\xe4\x58\x22\x24\x11\x0e\x43\x80\x28\xba\x2d\x6a\x06\x16\xdb\x16\x34\x08\x22\xdb\xc6\x55\x81\x71\x6d\xc1\x83\x22\xaa\xad\x89\xc4\x72\xa0\x88\x68\x58\x0e\xe7\x44\xb3\x58\x16\xe7\x1d\x34\x98\xff\xe0\x83\x75\xa3\x4d\x23\x34\xc3\x65\xff\xef\x15\x71\xe6\x11\x00\xe0\x57\x24\x12\x3f\x27\x53\x1f\x68\x78\x50\x04\xd9\xa5\x7d\x42\x56\x3f\x8c\x32\xc8\xbd\x77\x29\x53\x3f\x84\xd3\x4d\x9a\xd5\xab\x05\xdf\xd6\xe5\xd4\x2e\x33\x15\x6c\xa5\x4f\x3c\xda\x3a\x8e\xc4\x20\x4f\xc8\xc0\xcf\x03\xa7\xf4\x7e\x30\x95\xb5\x22\x32\x18\x4e\x94\xfc\x27\xb2\x57\x9e\x8b\xab\x52\x6f\x2c\x57\x75\x2d\x22\x62\xcc\x70\xd6\x69\xaf\x04\x3a\xc3\x5d\x39\x98\xce\x95\x13\xe2\xb6\x75\x04\xb2\x13\xa6\xc3\x7e\x93\x65\xc9\x8c\xd5\x82\x57\x50\x06\x33\x15\x3a\x1e\x6e\x41\xcd\x55\x29\xcb\xef\x1c\x30\x88\xe9\xdd\x62\xa9\x46\xc7\x47\x0b\x23\x6c\xff\x95\xec\x4d\x7c\x40\x09\xad\xf5\xe8\x18\xb9\xcb\xb6\x78\x5d\x2b\xeb\x6f\x5d\x61\x90\x95\x36\x4f\x6a\x47\xf5\x44\x5e\x85\x7a\x07\x7b\xf3\xae\xf2\x89\xdc\xf2\x52\x70\xc0\x9a\xf4\x13\x72\x4e\xfb\x44\x76\xa2\xe6\x57\xc8\xb1\x84\x27\xf4\xbc\xfa\x99\x35\x2b\x0d\x8a\x60\xaf\x4f\xc7\x30\xbf\xf3\xfa\x26\x58\xc3\x8d\x79\x57\x90\xb7\x2a\x3c\xb1\x95\x1a\x65\xd4\xe8\xe0\xe0\xb1\xc2\xfd\x94\x2e\x86\xfa\x3e\xb2\x11\xda\x48\x63\x45\x6d\x59\xae\xd4\x1b\x78\x3c\x3c\x76\xb2\xdb\x02\x08\x6b\xac\x6b\x42\x2e\x56\xb3\x2b\x87\x9c\x52\xec\x6b\x6c\xa9\x46\x6e\x33\x23\xad\x60\xfe\x1a\x18\xab\xde\x44\xec\xb0\x64\xad\x4e\xc7\x4f\x56\x5d\x6d\xa8\x1a\xb4\x7d\xea\x39\xcd\x54\xe8\x78\xbc\x6a\xde\x16\x2c\x62\x9c\x32\x2a\xd0\x71\x70\x39\x9f\x6a\xbc\x4f\xb1\xd1\xea\xa6\xe1\xc3\x96\x7d\x6d\xca\xb6\xef\x36\x38\x5e\xb5\xaa\x52\x29\x1e\x14\x41\xc7\xd3\x88\xba\x18\x4b\x97\xf5\x4d\x18\xeb\xdf\x2c\x03\x4f\x9b\x9e\x15\x40\xc9\xd1\xb2\x46\x4b\xa5\xdd\xf4\xd3\x41\xc0\xd9\x6d\x54\x29\x47\xea\xaf\xaa\x2c\xd5\x3b\xe3\x25\xd8\x5c\x73\x1d\xc2\x38\xaa\xea\xbc\xd5\xba\x8b\xd1\xc6\x72\xc8\x26\x4f\x1f\x48\x57\x7a\xc8\x95\x83\x89\xd0\x43\x8a\xf7\xab\x8a\x64\xb3\x50\x22\xa3\xd2\xc5\xe1\x0f\xa6\xc5\xad\xeb\xc4\xc0\xa3\xbd\xa5\x16\x61\xd4\x72\xe5\x16\x22\x8d\xcf\xa4\x47\xcd\xc8\x46\x34\xaa\x49\x83\x86\x85\x7f\xa1\x0b\xde\xa4\x3b\x69\x12\xf7\x88\x5f\xde\x3c\xe1\x75\x64\x70\x47\x4e\xf7\x10\x32\x78\x6f\xc0\x23\xd3\xbd\xf1\x0b\x5d\x22\xa4\x7c\xce\x17\x8e\x49\xf6\xd8\xbe\x65\xa5\x8a\xce\xdc\x9e\x14\x49\x7d\x6c\x2a\x36\x8a\x02\x85\xb7\xcd\x4c\x01\xaa\x85\x19\x3c\x41\xf5\x3f\x54\xb1\xda\xb8\x35\xaa\x84\x6c\x24\xcf\x14\x2f\xbd\x12\xb6\x12\xe6\x5c\xe2\xbc\x62\x4e\x86\xd2\x2d\x66\xe5\xc6\x91\xa0\x70\x8c\x55\xd5\xc4\x11\x20\x70\x8d\x21\x11\xae\xe4\xd1\x37\x92\xcf\x55\x49\x2b\x64\x5e\x70\x24\x0d\x8a\x2a\x41\xc0\xd3\x6c\x94\x2d\xea\x04\xb4\xfd\xb5\x20\x81\xdf\xf6\xfa\x50\xad\x6d\xaf\x82\xa5\x0c\x0d\x16\xba\xa4\x6e\xb1\x28\x39\x96\x08\x51\x5b\x8d\xbb\x97\xae\x53\x20\xba\x8c\x6e\xc4\x86\x6f\xa3\x39\x74\xaa\x5d\x34\x87\x1f\x1d\xaf\xc9\x03\x35\x2c\x42\xd3\x56\x37\x10\x92\xe4\xed\xe5\x2a\xe5\x96\x9b\x41\x8d\xf8\x0d\xf3\x0a\x78\xa7\xcd\x08\x4f\xf3\x62\x79\x34\x2c\xd5\xfb\xe4\x55\xc4\xd5\x39\x23\x38\xae\xd6\x73\xeb\x76\x02\xba\x22\x8f\x30\x83\x82\x91\xb8\x7e\x55\x36\xfc\x34\xb2\xa8\xae\x42\x5f\xe6\xd2\xec\xb7\xf4\xd5\x08\x57\x1a\x2b\xc4\xf1\x2b\x50\x1e\xb3\x10\x8d\xa8\x0b\x51\xe7\x4f\xd6\xd8\x41\x80\x2e\x81\x48\xd6\xb7\x4c\x8b\x42\xea\x40\xaa\xe2\x20\x7c\x19\x84\x93\x61\x75\x5b\xd7\xb2\xbe\x1d\x81\xf5\x22\xc8\x16\xd3\x97\x92\xb9\x52\x3e\x0f\xce\x34\xbc\x38\xec\x7e\x06\x38\x27\x98\x0e\x27\x8c\x38\xac\xb1\xae\x63\xf7\xdb\xca\x9f\x81\xc1\x1a\x85\x59\xe4\x71\x65\x64\xa6\xbd\x56\xc7\x8b\x0d\x33\x40\x2f\x8c\xfb\xb6\x14\x44\x8a\x2f\x75\xb7\x75\x1d\x6f\xf8\xcd\x70\xbd\x70\xf2\x97\xbe\x69\xfe\x26\xfa\xc7\x0a\x7e\xcd\xc6\x07\x0e\xfc\x3f\xd8\x94\xb3\x20\x72\x7d\x5c\xdb\xbb\x05\x5d\xe6\xda\xe9\x66\xd9\x2d\x3b\x9e\x0c\xb6\xb3\xdb\xb7\x55\x60\x92\xb1\x4f\x05\x33\xcf\x78\x52\x65\xc7\x5d\xef\x3e\x0d\x54\x0f\x4c\xc8\x03\xb9\x64\xb6\x2c\xb4\xfb\x53\xd4\x56\xe6\x81\xed\xcd\xa5\x96\x16\x7f\x6f\x85\xb1\x97\xb9\x36\x91\x69\x4a\x75\x3b\x1e\xa3\xec\x33\x71\x6a\x54\xde\xda\xfd\xa9\xb4\xfc\x47\xa2\x45\x9c\x2a\x91\x39\x78\x59\xaa\x88\x26\x33\xd2\xe8\xd4\xa8\xcc\x51\x8a\x1b\x3f\xdc\x6c\x7b\x52\x25\x9d\x1a\x91\x19\x82\x29\x01\xfb\x14\x90\xa9\x00\xfb\x5e\xe1\x52\x69\xe2\x9a\xee\xc0\x87\x20\xeb\xd6\x17\x0c\x80\xf6\x7f\x21\x87\x62\x7d\x59\x57\x6e\x20\x6d\xa1\x87\xec\xa4\xb1\x88\x3e\x7f\xcf\x8c\x2f\x5d\x03\xd0\x7b\x95\xcb\xa0\x42\x45\xc1\xb4\x55\xc5\xf5\x61\xfe\xe1\x8a\x41\xaf\x81\x25\xe0\x5f\x85\xb6\xea\x30\xcb\x70\x2e\x7b\xb1\x6a\x37\xad\x30\x1e\x34\xc2\xec\x1e\x99\xca\xe8\x3e\x5f\x00\x32\x5e\xe9\x25\x69\x1c\xfc\x21\x0b\xa1\xa0\xb6\xf6\xc2\x14\xc6\xee\x61\x7d\x7a\x02\xc8\xda\x3d\xf6\xa0\x41\x44\x00\x16\xcc\x7a\x6c\x8a\x71\x50\xbf\x4f\xe8\x8e\x26\xc8\x22\xbb\x96\x2a\x7f\x83\x54\xba\x17\xa4\xa9\xf3\x5d\x0e\x40\x53\xf4\x3c\x4e\x33\x45\x1c\x0d\x9a\x11\x21\x01\x11\xb2\xfe\x6d\x4d\xc6\xfb\xbb\x71\xe9\xa6\xb5\x38\xde\x3f\xeb\x4b\xe8\x55\x4e\xf1\x95\x35\x1d\xa0\x95\x06\x4a\x27\xb8\x0d\x92\xd1\x29\x1e\x84\xe4\x74\x9a\x33\x35\xad\xb9\xb3\xfe\x1a\x96\xf0\xda\x64\x5f\xc6\x56\xe9\x14\xcf\xda\xc2\x00\xad\xb6\xc3\xef\x04\x37\xa3\xa4\x77\x8a\xcf\x51\x12\x3c\xcd\x01\x53\xf8\x39\xdd\xd3\xea\x17\x4c\xe1\xab\x50\xe9\x9c\x05\x0c\x49\xd6\xbc\x7f\xbc\x80\xf3\x43\x86\x99\x1f\x34\xb8\xfc\xa0\x21\xe5\x2a\x2c\x1f\xa7\xa8\x9a\xd7\x85\x3a\x4c\x72\xdf\xd1\xba\x78\x2d\x6c\xd5\xcd\x7b\xf7\xa1\xef\x06\x30\x19\xd4\xfa\xa9\x4c\xfa\xe6\xdb\x2e\x0d\x3f\x1b\x8d\xe3\xd1\xeb\x90\x12\x71\xdb\xb7\x3a\x97\xa0\xf5\xb3\x91\xca\xa4\x85\x5e\xbb\x5a\xb0\x81\x1d\xa6\x5c\xb3\x39\x3e\x4a\x19\xe9\xb6\x0b\x3e\x7e\x42\x19\xc3\xc5\x6b\x90\x56\x91\x28\xa4\x55\xc7\x79\x3e\x6b\x16\xbd\x0a\x29\x8d\xe0\xbd\xdb\x6b\x12\x4e\x81\x8e\x42\xff\xaf\xcd\xf0\x04\xb2\xec\x45\xdf\x49\x85\x79\x01\x63\x30\x7d\x57\x15\x39\x9b\x99\x9a\xd1\x17\x62\xd3\xf4\x86\x7d\x71\x31\xc0\x94\xce\xf0\x25\x1f\xdc\x58\xf8\x48\x75\x10\xa7\xaa\x6a\x9b\x89\x4a\x59\x99\xc3\x5a\x61\xa7\x70\x19\x14\x18\x95\xe1\x27\x0e\x4c\x56\xa1\xc7\x9f\xf7\x99\x38\x35\x12\x2a\x2e\x5c\xa7\x9a\x84\x8e\x82\xbb\x41\x11\x8c\xef\xa5\xa9\xc0\xa1\xa8\x14\x2e\xe8\x4f\xfd\xc4\xac\xb9\x79\x8d\xcb\xa0\x41\x44\xc0\xed\x30\xc0\xd1\x9d\x38\x11\x74\x3f\x54\x86\x83\xf7\x0a\x44\xf0\xc1\x0c\xe4\x25\xb8\x13\x27\x82\x0e\xe5\xc0\x2e\x91\x3b\x69\x1a\x60\x38\x26\x49\x88\x83\x0e\xbb\x28\x1e\x58\x99\x17\x05\x6c\xcb\x04\x6f\x80\x0c\x93\xd1\xe1\xc5\x46\xf1\xbd\xfb\x15\x2f\x33\x2d\xf2\x56\x97\x90\xa9\xc0\x46\xf7\xd2\xeb\xa2\xa7\x27\x5b\x56\x0d\xff\x68\x40\xb3\xa5\x2d\x29\xaf\x7a\x02\x27\x7f\xea\x21\x89\x93\x57\xa5\xaf\xbc\xfe\x20\x86\x69\xaf\x08\x5a\x9d\x3a\x7e\x86\xb9\x4d\x83\x73\xb3\x34\x77\xa4\xb8\x05\x75\x93\x7d\x62\xd3\x5c\x0d\x6b\xb1\xdf\x37\xdc\x42\x62\x49\x9f\xb2\x90\x2b\x6d\x58\xa3\xc5\x6b\x29\x6f\xf7\xdd\xe4\xbb\xbf\xfe\xeb\xdf\xfe\xc7\x5f\xff\xd7\xbf\x9d\x45\x40\xab\xd6\xca\xfa\xc6\x84\xd6\x6a\xf7\xa0\x71\x18\xb8\x12\x96\x17\xdc\xf2\x4c\x3c\x42\x29\x7f\x2b\x51\x64\x5c\x43\x00\x63\xb3\x0c\x57\xe5\x85\xa2\xea\x1a\x1e\x97\x54\xdf\x34\x26\xfb\x7e\x55\xdf\x55\x2d\x7e\xc9\x5e\x1e\x52\xbc\xff\xee\x30\xa1\xbf\x69\xcc\xa5\x97\xc7\x81\x36\x25\xff\x30\xfe\x4a\x9f\x3f\x83\x91\xe7\x4a\x38\x78\x79\xbc\x66\xe3\xd0\x24\x62\x95\x86\x37\x32\x93\x75\x1f\xe8\x78\x5b\xc8\x6b\x29\x58\xc5\x6f\x32\x67\x5a\x98\x46\xd5\xa1\x47\xde\x01\xfa\xd8\x33\x24\x9f\x41\x11\x7d\xde\x04\x00\x12\x3c\x85\x02\x21\x8a\x3d\xc4\x3d\xc7\xe8\xaf\x35\x81\x5b\x6f\x50\xa0\xac\xd1\x57\x2d\x45\x5d\x98\xbb\x6c\x4c\x37\x05\xe0\xf5\x2d\x70\x6b\xc4\x13\xe5\xcb\xa0\x7c\x02\x2d\x51\x17\xac\x56\x56\xbe\xca\x9c\x07\x8f\x6f\x3d\xe5\xb7\x2e\x85\xca\xdb\x74\x7e\x97\x8f\xce\xbd\xfa\x7f\xb9\xf5\x3b\xa1\x1f\x42\xb3\x52\x06\xae\xbd\xd8\x2b\xe8\x32\x53\x26\x6a\xb5\xe4\x14\xfb\xdb\x3b\x03\x4c\xe3\x9b\xc4\x2e\xd3\xb6\x79\x13\xe2\xf8\xfe\xc1\x27\x24\x3b\x3d\x62\x62\x0f\x5e\xca\x22\x74\x41\xd6\x2e\x9d\x41\x93\xb8\x4e\xb5\x68\x4a\x97\x95\x1e\x11\xdc\x06\x4a\x93\x2e\x31\xa9\x9c\xe7\xf7\x14\x42\x5e\x8f\x98\x4c\xdb\x94\x8a\x17\x80\x41\xfa\x33\x37\x9a\xa9\x9f\x43\xad\x14\xf5\xed\x78\x08\x7d\x48\xcd\xab\x13\x53\xbb\x6a\xc5\x8b\x9c\x1b\xcb\x72\x5e\x96\x57\x9e\xbf\xc5\xf3\xdb\x96\x71\x8e\xfd\x5e\x65\x2d\x4d\x92\xc3\xad\x0a\xa0\xee\x13\xfa\xe2\x1b\xad\x72\x61\x0c\x82\xe0\x58\x02\x35\x43\x77\x94\x5d\xaa\x9a\xbd\x73\x1d\x3a\x62\xb9\xcf\x70\x5d\x02\x35\xc3\x6e\xcc\x6f\x98\x7b\x01\x2b\xb9\xa3\x9a\x95\x71\x62\x47\xe5\xb9\x45\x87\x18\xd6\xeb\x61\xe7\x68\x67\xd3\xa3\x1c\xfb\x0e\x04\xe3\x6b\x94\x72\x36\x93\x4c\x82\x76\xbe\x32\x56\x56\xcc\x04\x65\x1c\x2d\x9e\xe0\x34\x29\x3c\x28\xbd\xe3\xca\xeb\xfe\x25\x7c\x30\x8f\x49\x85\xb6\x72\xae\x25\xcf\xdf\xba\x01\xae\x28\x58\x37\x19\x89\xb1\xcd\x4a\xf7\xc7\x25\x46\xf1\x44\xc2\xbc\x7c\x37\x8c\x8b\x62\xe4\x34\xe8\x79\xec\xe5\x56\xf8\xb5\x57\x9e\x77\xfd\x29\x9c\xdf\x22\x2d\xa7\xd7\xa6\x69\x76\x23\xc9\x94\x8e\x6e\x95\x06\x40\xdf\xd1\x41\xf3\x30\x8e\x58\x91\x31\xf1\x29\x0a\x89\x76\xf2\x09\x0b\x27\xda\x09\x94\x40\xb1\xcf\x8a\x2e\x88\xe3\x78\x50\xd6\x97\xcf\x28\xd5\xaa\x11\x3a\xf8\x4e\xce\x5a\xcf\x5c\x26\x45\x1a\xbb\xac\xf2\xd2\xbb\x49\xef\x4d\x1d\x1f\x75\xdc\x61\x35\xa8\x11\xc5\xf0\x15\x29\xe8\x66\xd2\x0e\x31\x92\x0d\xa5\x43\x83\x81\xd2\x3b\xf7\x4c\x46\x90\xe1\x79\x68\x34\xd5\xcd\xcd\x95\xe6\x37\xc1\x8a\x56\xc7\x2d\x10\xf6\xc6\xdb\x29\x82\xc6\x88\x80\x33\x9e\x7b\xf2\x94\x83\x5c\x77\xe5\x96\x7b\x63\x27\x62\x72\xe7\x6e\xdf\xea\x95\x08\x69\x68\x91\x2b\x5d\x44\x13\x19\xd5\x08\xa9\xa4\x74\x22\xfe\xf6\xb7\x93\x3a\x10\xc7\xea\x55\xd6\xbc\x94\xff\x10\xac\x92\xb7\x48\x57\x76\xe4\xb6\xfa\x44\x8d\x2e\x78\x4f\xdc\x86\x0a\xe9\x60\x17\x74\x6f\xdc\x86\x02\x5d\xaf\x9a\x86\x4f\xd9\x9b\xa6\x31\xa0\x1e\x50\x97\xf2\x21\xb2\xe8\xf5\xc0\x4e\xeb\x72\xb4\x02\x98\xe0\x11\xc3\x55\x94\xe6\xce\xb5\xac\x6f\xd9\x8b\xfd\x68\xc4\x70\x10\xa1\x09\xde\xe6\x78\x50\xd4\x65\x28\x00\xc7\x34\xd7\xaa\x66\xbf\xa9\xab\xc9\x60\x1d\xfa\x28\x7f\x21\xe8\xc5\x57\x7d\x64\xc9\xeb\x5b\xcb\x03\x2f\x69\x0f\x6a\x97\x41\x1a\xe5\xb8\x4f\x0e\xc8\xfa\x3b\x17\x3a\x87\x08\x71\xe9\x24\xd9\x70\x40\xb6\x53\xa0\x34\xc8\x82\x4e\x14\x13\x7c\xcf\x7c\x68\x19\x40\x0b\x5f\xd0\x41\x87\x38\x52\x36\x04\x01\x8f\x94\x0f\x51\xf8\x43\x9c\xd0\x77\x2d\xbb\x5f\x7b\xa0\x73\xa1\xf9\xee\x78\xf8\xea\xde\xa5\x02\x32\x75\x76\xf6\x41\xcb\x65\x95\x86\xbb\x1f\x29\x5d\x84\x13\x08\xbc\xec\xc5\xc9\x22\xa3\xec\x01\x15\xbf\x75\x02\xe4\xe2\x85\xcf\x23\x93\xb7\xc6\xba\x97\x76\x02\xc7\x3b\x66\x94\xe6\x2a\x67\xd5\x17\x90\x0a\xde\x65\xf1\x1c\x28\x06\x94\x47\x35\x04\x08\x2e\xa3\xaf\xa0\xc3\x1c\x0d\x11\xa2\xf8\xb6\x38\x9d\xd7\xbf\xb8\x0f\x0c\x6a\x6e\xa1\xa6\x93\x27\x72\x0e\x59\x64\x7e\x6d\x15\xf0\x34\xda\x9c\xc5\x5c\xe9\x07\xa7\x02\x4e\xaf\xdd\xd0\x71\xf7\xf8\x82\x79\x38\x69\x3a\x5b\xcc\x8f\x17\x7e\x9d\x73\x74\xd3\xee\x08\x1b\x78\xf1\x1f\x10\x3e\xdd\x09\xdc\xbb\x84\xf0\x65\xd5\xe9\xa4\xf5\x52\x8f\xce\x26\x8d\x56\xaf\xb2\x14\xec\xda\xfd\x0c\x6e\x9b\xa5\x1a\x55\x58\xf7\xcf\x87\xfb\xc7\x1b\xe7\xc9\x7e\x91\x6d\xf8\xa0\x8c\x53\x3a\xa0\xd9\x0b\xe8\xe1\xd0\xbf\x7c\xde\xfc\xd9\x0c\xe0\xab\xf8\x9c\xd8\x4d\xcf\x58\x05\xdf\xf0\xd8\x61\x86\x7a\xc4\x03\xc6\x2a\xf8\xee\xd5\x0e\x2d\xdc\xfb\x57\x9f\xea\x53\x5f\x48\xe9\xbc\x31\x17\x82\x14\xf9\xf8\x6b\xb3\x4d\x5d\xf1\x9a\xdf\x84\xee\x9f\x98\x2a\xb9\x15\x05\x0b\xdf\x25\xd1\x15\xba\xd0\xbf\x2c\x75\xe9\xeb\x76\xcb\xd6\xc7\x01\x76\x97\xb7\xbb\x3b\x69\x14\xc7\x77\xad\x7d\x42\x3c\xd9\x52\x16\xdf\x21\x29\x27\x4b\xa2\x5e\xe7\x6c\x7a\x71\x9c\x4e\xe8\x12\x96\xc6\x6a\xb8\xb1\x6c\x4c\xee\x8c\x74\xc5\x95\xf2\xd9\xbe\x38\xba\x50\x24\xcd\x49\xef\x6c\x86\x5a\x8c\xd6\x88\x6d\xd4\xa3\xe2\xe9\xed\xe3\x4d\x96\x25\x4b\x66\xba\xd6\xfe\xb1\xda\xcb\x49\xab\x1b\x08\x46\xa7\x0d\xa2\x96\x95\x0a\x18\x44\x2d\x79\x9d\x32\x84\xda\x09\xc4\x80\x61\xd4\x2a\x0c\x9f\x32\x88\xda\x30\xa3\x89\xc3\x5f\x4a\xea\xac\x81\x14\x92\xd6\x09\x4b\x59\xe0\xd9\x1e\xba\x9e\x8c\x15\xbc\x82\x40\x3a\x41\x3c\x9e\x5f\x57\xc8\x64\xfd\xaa\x42\x88\xf6\x5d\xda\xfc\xde\x6b\x5c\x3a\x0d\x0a\x64\xd0\x6c\x7a\x09\x8d\x5f\x9a\x3b\x01\x3b\x6a\x19\x66\x4c\x61\xa9\x2a\x51\x17\xe1\xc3\x1c\x63\xee\x4a\x2f\x8f\xfb\xf8\xe1\xb1\xc2\x98\x35\x49\xc7\x80\x6c\x69\x74\xa4\xe0\x56\x46\x0a\x6e\x0f\xef\x89\x18\xf1\x47\x69\x1a\xf0\xaa\xed\xe6\x31\xee\x69\xb1\xf0\x88\xce\xa5\x31\xcd\x14\x88\xbe\xdf\x4f\x4e\xfc\x93\xb1\x30\x1b\xcc\x35\x50\xb1\xf7\x54\x12\xe0\xb1\xc5\x99\x2c\xe2\xdb\xa4\x5b\xf5\xf3\xe7\xa4\xec\xbd\xad\xae\x35\x97\x30\x2e\x6b\x25\x1a\xa3\x00\xa1\xd1\xdd\x70\x14\x1e\x51\xff\x0a\x7d\xd8\x79\x29\x4a\x30\xc2\xb6\x32\x7f\x13\x6e\x01\xbb\x68\x73\x3b\x6e\x49\x54\xd2\xb2\xe1\xda\xb3\x60\x9f\xb0\x2c\xe2\xb2\x52\xc7\x55\xfe\x01\x3f\x77\x2d\x5a\x22\x39\xa7\x4b\xcf\x4c\x8b\x4a\x3d\x44\xb2\xe5\x56\xea\x58\xa7\xda\x61\x18\x6d\x2e\xec\x90\x8a\x80\x03\x7d\xf6\x8b\x47\x08\xb6\xb4\x5e\x8c\x2e\x37\x29\x7a\xb1\xd1\x27\x8e\x11\x2e\x32\x4e\x44\xdc\x73\x67\xac\x3f\x3c\xaf\x82\xf3\xe8\x3e\x85\x6d\xa9\x44\x44\x65\x78\x8a\x26\xbb\x2b\x63\x01\x59\xcc\xab\x8b\x9f\x45\xc1\x7a\x45\x1a\x3e\x30\x53\x10\x79\x25\x0c\x0c\xef\x81\xd3\x33\x3d\x29\xeb\xdd\xa4\x3e\x08\x7b\x31\x68\x86\x8d\x0e\x42\xc3\xd3\x52\x0c\x94\x97\xb8\x94\x26\xb0\xbd\xd2\x57\x69\x62\x5e\x6a\x1a\x95\x18\xd5\x63\x4d\xe7\xd3\x88\x1a\x5e\x2e\xa8\x80\x2a\x65\xc1\x03\x77\x3f\xe7\x99\x04\x70\x56\xc8\x5e\x4c\x2e\x98\x95\xb6\x14\x2c\xdc\x3a\x36\x8c\x68\x2d\x72\x02\x99\x74\xeb\x04\x9e\x55\xdb\x30\xc0\xbc\xac\x76\x16\x78\xfa\xd7\x87\xef\x35\xdd\x70\xf0\x2a\x74\x36\x20\xa5\x90\x6c\x89\x28\x7c\xe2\xc0\x0d\xe8\xaf\x96\x9f\x8f\xed\xb5\x50\xe8\x04\xc3\x93\x19\x7e\xd2\xc7\xfb\x7f\x13\x98\xc0\x2f\x27\xc4\x55\x3e\xc5\x4e\x8f\x47\x07\xdc\x1d\x3f\x0a\x5f\xaa\x0f\xd6\xcb\x13\x7c\x37\x21\x72\x42\x8b\xeb\x4b\x1b\x37\x23\x60\x34\xc8\xbf\x9e\x0e\x3f\xc1\x06\xc3\x6d\x9f\xc0\x2a\xe8\xa5\x09\x5a\x1d\x1d\x70\xc2\x57\x03\xae\x2c\x9f\xb0\xb1\xd7\x95\xd3\xc3\xa6\x7c\x31\xbc\x77\xa3\xeb\x59\x69\x40\x53\x5a\xb6\xaa\x5f\xe5\x0d\x78\xa6\xbb\x6f\x56\x73\x15\x8a\xc6\x7d\x02\x85\x74\x4f\x8f\x98\x01\x90\xcd\x3d\x28\xa1\x11\x5f\x1e\x35\x0f\xa4\x9c\x87\xd2\x13\x40\x58\x21\xae\x8f\x21\x0f\x79\x74\xf8\x09\x36\x00\xde\xa5\xe0\xa1\x7b\x61\x82\x4f\xa7\x82\x4d\xf8\x62\xd8\x15\x58\x1e\xd9\xcb\x52\x8c\x23\x69\x50\x13\x3e\x97\xb7\xf6\xae\xb4\xfc\x47\x70\xaf\xc4\x63\x8f\xe2\x04\x95\xcc\x5f\xad\xd0\x2c\x96\xc0\x52\x89\xa2\xb7\x19\xde\x15\x00\xf6\x34\x83\x38\x85\x05\x72\x77\x97\x05\x83\xe4\x94\xf4\x9f\x3f\xd3\xc0\x13\x70\x76\x74\x2e\x20\x6a\xeb\xee\xa4\x85\x4d\xa3\x3a\x8d\xcb\x5c\x8d\x8a\x8a\xdb\x42\x88\xe0\xe0\xe4\x09\xda\xdf\x64\x08\xb8\x2b\x4e\x56\xc0\x7b\x62\x7f\xd2\xba\xfb\x0b\x72\xd6\x9a\x60\xfd\xe0\xfb\x55\x7d\x8f\x1b\x68\x75\x1a\x84\x43\x3d\x47\x00\x3a\x93\x71\xd8\x87\x33\x28\x70\x7d\x3b\x5c\xdf\x49\x82\x7b\x56\x07\xef\x75\xf0\xdf\x6c\x4c\xb0\xad\x7b\x3c\xb3\xdb\xc2\x23\xbf\xb4\xd1\xf2\x21\x4b\x11\xde\x0b\x77\x98\xa3\x34\x01\x72\x21\x4d\xae\xea\x5a\x84\x8f\xb5\x3a\xe8\x49\x9c\x00\x1b\xd6\x9d\x3a\x5c\x8a\x3e\xbc\x50\x96\xff\xba\xcd\xd0\xcc\x2a\x6e\xf3\x3b\x28\x69\xcb\x95\x70\x99\xe4\x51\x6e\x96\x87\x0f\x28\x92\x9c\x2e\x37\x59\xc5\x1b\x08\x56\x27\x86\x85\x8a\x6c\xb2\xb9\xa1\x68\xb0\x6e\xa1\x50\x3e\x44\x66\xf9\x0d\x70\x99\x8c\x17\xbe\x74\xc2\xe8\x38\xf1\xa7\x7f\xf9\x63\xc6\x0b\xa6\x45\x21\x35\xb0\x0d\xfd\xe9\x5f\xfe\x78\x99\xa9\x50\x53\x60\xbf\x26\x90\x60\xbf\x92\xd0\x88\xee\xa9\x3a\x1a\x74\x9d\x55\xa5\xae\xb2\x14\x71\x2c\xbc\x0e\x21\x89\x3b\x2f\x55\x1c\x85\xa6\xe4\xb6\x13\x20\x24\x31\x14\xd9\xdf\xfa\xf4\x03\x91\xb9\x89\x5a\x68\xc0\x10\x76\xe4\x31\x28\xe0\x62\xff\x82\x43\xcc\x50\x7a\xe4\x11\x1a\x48\x27\x72\x81\xf7\xbf\x23\x13\xaa\x3e\x58\xab\xb7\xf6\xcb\x9d\xc3\x91\xf8\x22\xa7\x70\xd8\x5f\xec\x0c\x8e\xc3\x17\x3a\x41\x78\x2a\xe3\x32\xee\xba\xd1\x0e\x41\x26\x61\x7f\x16\x64\x40\xdc\x07\x3c\x3c\x08\x12\x07\x94\xbd\xf0\xbc\x73\x51\x00\xe0\x4b\x5b\xbf\xd5\xea\x7d\xd7\x9b\x23\x92\xa2\x58\x53\xf2\x0f\xa1\xb3\x46\x68\x77\x49\xa8\xaa\xcd\x31\xf8\x5c\xeb\x32\xd3\x4a\xe7\xe1\x5f\x09\xd6\x4a\x55\xfd\x23\xc5\xc7\x04\x02\xef\x13\x03\x63\xda\x44\xdc\x3d\x4c\x57\x4a\x63\x67\x43\xec\xa8\xdb\x62\xb8\xb6\x15\xaf\xfd\x61\x96\x71\x0d\xc9\x45\x9a\x8b\x69\x44\x6e\x35\x6e\x16\x3f\xd1\xdb\x3b\xac\x15\x3c\xa6\xe4\x19\x64\x8d\x56\xdf\x3f\xfc\x1e\x39\xc5\x7e\x29\x25\xa9\xfe\x1a\xd6\x03\x5a\xe0\x9d\xcc\x63\x5a\xf3\x9a\x1e\xfe\x99\x66\xc2\x41\xfb\x44\x1b\x4e\xbf\x8e\xe3\xd7\x1f\xca\x38\x62\x18\xd5\xf5\x9f\x6d\xcf\xbe\xf6\x0f\xf9\xfe\x40\xd5\xdf\x1f\xbe\x38\xe4\x1b\x93\x30\x3f\x71\x0a\xbe\xbd\xba\x53\xd7\x74\x0f\xc0\x8a\xea\x2a\x8a\x4c\x75\xe1\x8b\x99\x36\xf8\xa2\x82\x13\xbf\x2c\xc4\x93\xdb\x82\x2b\x2b\x0c\x86\x5b\x5a\x68\x0e\xf3\xe9\x9a\x06\x59\xbc\xe1\xaf\xc2\x7e\x30\x2b\x8f\x57\x2e\x1a\x7e\x13\xb8\x61\x49\xae\xaa\xaa\xad\xa5\xfd\x60\xb7\x56\x16\xa2\x94\xf5\xf1\x56\x2e\x1e\xf1\x2e\xca\x86\x69\x61\x54\xab\xf3\xb3\xb1\x78\xf1\x10\xda\x4a\x73\x38\xc8\xc3\xc3\xf8\x43\xbe\x9d\xf3\x1e\xe1\xf8\x13\xbe\x9d\x14\x12\x08\x36\x5c\xf6\x70\x14\xe3\x64\x8f\x0a\xb9\xdb\xd9\x63\xa2\x5f\x74\xb3\x42\x98\xc6\xdd\xdd\x1c\xb2\xe9\x28\x89\xb3\xeb\x04\x08\xb3\xed\x04\x4b\x61\xdf\x09\xbd\xe4\x6d\x1d\x7a\x1e\x71\xc2\x1e\xa4\x93\x3f\xdb\xdd\x41\xdd\x28\x23\x43\x93\x5f\x77\xf9\xf4\x20\x98\x36\x4a\xee\x8a\x38\xb7\x15\x56\xa2\x90\x87\x4b\xd8\x78\x08\x57\xdb\x0f\xa1\x3f\xfc\xa5\xe2\x87\x60\xae\x47\xf5\x13\xf5\x92\x8d\x8a\x87\xeb\x9e\x80\x80\x36\x6c\xe4\x31\x23\xf2\x56\x1f\x32\xf8\xff\x1b\xf9\xf2\xf2\x5f\xfd\x70\xe5\x22\x4c\xf9\xfc\x9c\x77\x18\xf7\xda\xde\xfa\x37\xb4\x0e\x2b\x71\x26\x86\x4e\x5f\x9d\x95\x15\xba\x8d\x64\x0e\x8b\xb9\x87\x64\x0e\x19\x48\x17\x9e\x43\xa2\x5c\xca\xf2\xef\xcc\xdd\x37\xff\x90\xe2\x3d\xf4\xa1\x0b\x61\xd4\xa7\xe6\xaa\xb6\xfc\x38\xc8\x51\x59\xf5\xc6\x99\x7b\x69\x9e\xbd\xea\xd0\xce\x71\xcd\xcb\x0f\x2b\x73\x73\x59\xea\xa4\xf9\xac\x6f\x67\x81\x97\x7c\xdc\x55\xa8\xc8\x0b\x51\x47\xa0\x3e\x13\x2c\x70\xfe\xef\x24\xc8\xec\xf7\xbc\x3c\xdc\x70\xa2\xc5\xfd\x6c\xb0\xac\x31\x7f\xfe\x5c\xc0\xef\xd7\xff\xef\x73\x01\x3f\xb7\x02\x35\xaf\x0b\x55\x7d\x1e\x5e\xf8\xf8\xcb\x19\x78\x9f\x6c\x54\x7f\xea\x2c\x94\x21\x43\x81\xf9\x61\x41\xbb\xcc\x14\x50\xf3\xfb\x9d\x4f\xaf\x40\x63\xd5\xf1\xb0\xc6\x09\x20\xa7\xd7\x1f\x82\xeb\x5f\xb2\x97\xee\xaf\xdf\x1d\xf6\xb7\xee\xae\x20\xa6\x85\xd5\xca\x2d\x95\xc8\x07\x16\xba\x71\x13\xe0\xe0\x30\xb5\x9f\x25\x23\xf7\xc8\x9b\xec\xa5\x0e\xf8\xe2\xe1\xa0\x18\x30\x64\x82\xdc\xfa\x17\xf0\x8b\x08\x94\xec\xb5\x2a\xc5\x9f\x0e\x47\x2d\x83\xe8\xc5\x89\x92\xe0\x31\xbf\xdf\x17\x01\xdb\x6b\x60\xd1\x6f\xc2\x32\x9f\x20\xc2\xde\xc4\xe1\x38\x66\xc2\x5f\xea\x60\x19\x68\x61\x12\x38\xac\xb5\xb0\x2c\xba\xd2\x5e\x5b\xdb\x6a\x11\xcc\x42\x9d\x48\xac\x94\x28\xea\xc2\x1d\x25\x86\x57\x83\x13\xc7\xe2\x16\xdc\xdc\xaf\x8a\xeb\xe3\xd3\x83\x93\xd4\x05\x37\xc3\xdc\x03\x06\xf5\x34\xf1\x9a\x64\xb4\xb2\x97\xd0\x5a\x77\xaa\x3e\x92\xe2\x57\xd5\x58\xd8\x20\x27\xa0\x1b\x1b\x78\x42\xde\x09\x20\xbb\xcf\x15\x5c\xd7\x2a\xc3\x90\xdd\x9f\x69\x5f\xe7\x5f\xb5\xbb\x73\xcb\x2a\x51\xb7\xcc\x6f\x2e\x1d\x01\xfa\x07\xed\x56\x0a\x08\x6c\x58\xe4\x75\xa8\xd8\x70\xeb\xf0\x34\x97\xa5\x01\x3c\x34\xeb\x10\xe7\xc2\x38\xfb\xba\x2d\xb5\x46\x35\xaa\x3d\xac\xce\xc1\xba\x33\xf1\x44\x5c\x75\x0b\x40\xb5\x46\xe8\x8b\x17\x4b\x5f\xc3\x0a\xc3\x0c\x69\x17\x07\x50\xb0\x61\x73\xf0\x24\xa6\x97\x38\x38\x86\x09\x5e\x34\xea\x73\x36\x84\xd6\x4a\x03\x1e\xe3\xef\xb5\x2e\x5b\xad\x34\x16\x46\x58\x2b\xeb\x9b\xf9\x25\x7b\x31\xc2\xa5\xb7\x1c\x8e\xe1\x5d\x45\xa2\x2e\x01\x1e\x01\x43\x28\x07\x37\x16\xc0\x36\x5a\x7a\xa0\xcc\xb6\xfa\xaa\xb2\x5c\x95\xc7\xb7\x5a\xfd\xad\x13\xfb\xf7\x09\x99\x39\x8d\x5d\x7c\xc8\x96\xf7\x0a\x3e\x78\x39\xdd\x06\xfe\xf9\x95\x74\x09\xf0\xa2\x52\x56\x30\x23\x6c\x68\x29\x76\xa2\xc1\x8b\x82\x8d\x6a\xb4\x3c\x6e\x5a\xb5\x4d\xf6\xe2\xfe\x62\xa1\x39\xd5\xc4\x68\x76\x1d\x5e\x5f\xc6\x1e\x2d\xe8\x06\xff\x10\xf9\xc6\x75\xd2\x21\xbf\xeb\xb0\xf9\xad\x95\xb0\xa9\x5e\xdd\x2c\x38\xd0\x0b\x1a\xa3\x2e\xdd\x2f\x93\x9b\x1c\x14\x64\x90\x43\x6c\xbe\xb9\x4a\x6e\xf8\x77\x11\x98\xc4\x86\x25\x63\x57\xfe\xbb\xf2\x40\x7d\x83\x93\xc4\xe1\x64\x2f\x6e\x0b\xaa\xad\x2d\xcb\x55\x71\x68\x57\xb0\x42\x24\x0f\x59\x5f\xd5\x77\xd0\xf7\x3a\xc9\x64\x1c\xd5\x5a\x28\x90\x17\x45\xec\x38\x1a\xc3\x6f\xc2\x84\x3f\xad\x97\xbc\xa0\x92\xbc\x46\xb8\xf0\x17\x12\xe3\xd9\xfb\xf1\x35\x7f\x94\x70\x99\xb9\xab\xf7\x50\xcc\x1f\x00\x91\x1b\xc6\x1e\xb0\x63\xfd\x69\x5f\x97\xab\xaa\x51\xc7\x09\x29\x03\x1e\x66\xd3\x2d\x01\x0e\xbb\x61\x3b\x40\x5e\xb9\x3d\x1e\x89\x0e\x80\x4e\x10\x8f\x57\x88\x52\x58\x01\xf5\x18\x2f\x9d\xd6\xf5\x8d\x5f\x58\xaa\xfc\x0d\x0a\xe8\x84\x93\x07\x23\x03\x64\x5b\x47\x81\xf6\xe2\x98\xc1\x86\x4b\xc6\xcb\xb4\xf8\x7b\x2b\x8c\x0d\xa7\x2e\x3b\xf1\xcb\x42\x3c\xcd\xc8\x1e\x17\x9a\x31\xed\x61\x43\x17\xd9\x43\x51\x6d\xc7\xbd\xff\x86\x30\xea\x5c\x1a\xf5\xad\x90\x13\xdd\x2a\x7c\x90\x3b\x22\x7d\xa4\x98\x2d\xce\x0e\x57\xaa\x1a\x51\x1f\x27\xaf\xee\x2a\x5f\xbc\x62\x7a\x33\xde\x2f\x36\x81\x08\xf2\xac\x28\x15\x0d\xf4\xb5\x6d\xfb\x75\x14\x7a\x90\x67\x9f\x0c\xea\x55\x9e\xe7\xce\x12\x7c\x85\x67\x9f\x0d\xee\x29\x9e\xa7\x74\x12\x98\xe0\xb2\x4a\x29\x99\x60\x6f\x39\xa4\xe4\x42\xf0\x12\xc0\x8b\xbb\xec\x02\x3f\x20\x06\x23\xe1\xc7\xc2\x60\x28\x5e\x54\xb2\x0e\xfa\x7e\x3e\x64\xdc\x3d\x71\xf6\x48\xb8\xf0\x92\xf3\x00\x88\x59\x6b\xf6\xd9\x84\xfd\x8d\xea\xa1\x2d\xb6\xbc\x14\xbc\xf6\xb2\x97\x49\x03\xb3\xec\x35\x81\x47\xe1\xa2\x21\x8d\xbc\xd5\xed\xe1\x66\xbc\xc7\xf4\x72\x17\xff\x17\x1a\xf5\x95\xe7\xe2\xaa\xd4\x5b\x06\xc8\x34\xf6\xf8\x83\xc6\x05\x9f\xcb\xed\x29\x34\xdc\x98\x77\xa5\x7d\xb7\x0f\x20\x30\xc8\xfb\x9d\x5d\x3a\xf8\xce\x77\x8f\x17\x19\x57\xf8\x5e\x21\x9d\x40\x57\x50\xa3\xb4\x0d\x7b\xdb\x20\xf9\xdc\xd5\x60\x29\x18\x03\x60\xd8\xd7\x46\xc4\xe7\x7e\x16\x07\x09\x49\xd9\x1f\x41\xd1\x59\xfb\x23\x6c\xe8\x51\x80\x85\x20\x7a\xbc\xb4\x28\x2d\xd4\xf1\x2d\xa1\x51\xa3\x00\x04\x2e\xb2\xcf\x1f\x0b\x1b\x03\x09\xd8\xe2\x63\x20\xe9\x34\xf0\x9f\x1e\x13\xc9\xb6\x1c\x7a\x25\x86\x4c\xa8\x22\x25\x83\x58\x48\x1e\xce\x5c\x87\x06\x08\x9d\x20\x72\x2c\x0c\x79\x54\xd0\xc3\x20\x5d\x6d\xfc\xa8\xfe\x3d\x2c\x59\xf1\x9b\xdb\x5d\x09\x6e\x88\x0d\xf0\x3b\x6a\x69\x43\x94\x91\x0a\x2f\x0a\x26\xad\xe8\xfe\xc7\x8a\x8a\x85\x0e\x62\x78\x22\x83\x12\x12\xbb\xdf\xcf\x59\xc1\xf7\xff\x84\xd4\xc7\xac\x00\x24\x95\x43\x22\xd9\x4b\x21\x0f\x23\x82\x67\x43\xc2\xa5\x72\x89\x7d\x26\x9c\xff\xd1\x89\xb3\x40\x12\x08\x14\xd4\xfd\xe9\x53\x40\xba\x28\x0e\x84\x4d\xcf\x73\x9c\xa1\x8e\x1b\x69\x40\x50\x2d\x1e\xa2\x6e\x13\x07\xe6\xf0\x96\x8e\xea\xcc\xdc\x61\x8b\x4f\xc0\xf1\xd5\xe6\xb3\x6a\x4b\xf9\x10\xc3\x75\x11\x90\x04\xb3\x1e\x7e\xa3\x8c\xfc\xe8\x1f\x85\xcd\xd8\xb0\x5d\x61\xbe\x51\xb1\xd0\xd6\x84\x67\xb1\xd6\xc0\xbb\xc1\x57\x92\x18\xba\x64\x66\xee\xdc\x9d\x8a\x1c\xc6\x09\x85\xe4\xa5\x3a\xcc\xc2\x5d\xab\x5e\x96\xaa\xe9\x9d\xfb\x79\x9c\x18\x6a\x9f\x7c\xc3\x2b\x74\x60\x76\xc3\x06\x75\x6e\x76\x17\x9e\x41\xa6\x1d\xbb\x3c\x18\x7a\x0e\xf2\xac\x9e\x52\x2a\x88\xde\x81\x93\x0c\xb3\x56\xa6\xa3\x55\x48\xc3\xaf\xc7\xf9\xcc\x1b\x36\xbd\x0e\x61\x4b\xf2\x69\x7c\x2c\x2f\x03\xdb\x94\x1b\x2a\x73\xc5\x64\xa3\x7c\xa8\xd6\xb6\x57\x01\x6e\x3f\x2b\xf9\xa7\xcd\x27\x0d\x19\xe4\x21\x7b\x14\x0e\xbd\x23\x9e\x0b\xec\x14\xfc\x9a\x08\xc9\x59\xf8\x77\xd9\xfd\x0f\xb8\x3e\x56\xf2\x88\xfa\xd8\x43\x06\xd5\xc7\x1e\x05\x64\x7d\xac\xb9\x00\x6f\x25\x58\x11\x21\xb9\x23\xad\xb5\xf7\xec\x5a\x0b\xd8\x62\xd2\x95\x5b\x5b\x8a\x5a\x58\xe2\xb0\x3e\xb1\x78\xe5\xb2\x0c\x9c\x7b\x7f\x42\xa2\xd7\x4c\xe6\xb0\x29\x16\xee\x21\x67\x99\x65\x4b\x09\xe6\x28\x5b\x3e\x14\xae\x52\x54\x39\x0f\x2f\xab\x76\x52\xe3\xae\x01\x66\xdd\x27\x16\x0e\xf9\x61\x96\xbf\x89\x42\xbd\x87\xc1\x06\x41\x8a\xcf\x8b\x06\xc5\xd7\x5e\x20\x5f\x7d\xb0\x27\x26\x57\xdd\x41\x19\x51\x87\x81\x3a\x21\x1c\xcc\xb0\x71\xc0\x82\x1b\x1d\x3b\xe2\xf8\xcd\xfc\x9d\x42\x43\x3b\xf9\xbb\x3c\x30\xfb\xf8\x7b\x1c\x42\x6b\x94\xbb\x24\x50\x4b\x96\x14\xb5\x41\xb0\x98\xc9\x64\xfd\x90\xd6\xdd\xa6\xe8\x72\x8c\x1a\xd0\xaa\xc7\x4c\xeb\xe2\xb5\x66\x3f\x41\xcd\xf8\xe7\x7c\x0a\x91\x97\xb2\x0e\x66\xb2\xad\x09\xf5\x6a\x64\x8c\xa6\xbb\x2c\xfd\x53\xf5\xc2\xb2\x7e\x09\x2b\x7b\x79\xf0\xb2\x0d\xae\xb6\xce\x4a\xb8\xcc\xb4\x67\x3f\x4e\x5f\x0b\xdb\x63\xe7\x97\x01\xd3\xb8\x39\xdd\xd3\x98\x35\x5a\x56\x5c\x7f\xb0\xee\xf7\xb1\xcc\xe6\xba\x74\xac\xfa\xf5\xe7\x7e\xcd\xf6\x2e\x0f\x37\x24\xd7\xb4\x36\xca\x98\x5d\x3b\x6d\x6b\xa1\x41\xbb\xa2\x73\x49\x7c\x48\x5e\x96\x17\x8a\xc6\x6b\x74\x4c\x20\x5e\x21\x87\x62\xf0\x1a\x1a\x15\x7e\xd3\xed\x8d\xdc\x24\x4d\x85\x45\xef\x91\xa6\x02\x13\x24\x41\x0d\x45\xfa\x37\xbf\x20\xe0\xfd\xeb\x60\x64\xce\xed\xcb\x83\x3a\xf7\x80\x4e\xe1\xdc\x3d\x32\xd4\xb9\x07\x68\x12\xe7\x8e\xb7\x37\x89\x73\xc7\xc3\x12\x39\x77\x3c\x30\x81\x73\xbb\x74\x87\xf0\xa9\xcf\xd6\x1f\x7f\xc3\x3d\x5b\xe3\xb0\x8c\xa8\x0b\xf6\x10\x5a\xbe\xca\x3c\x78\x4d\xbf\xcf\xeb\x58\x6b\x20\x19\x04\x67\x99\xf3\x53\xbc\x88\x5c\x21\xff\xb9\xc1\x88\x35\xa2\x21\xf3\x84\x60\xdf\x36\x1c\x84\xc6\xcc\xa0\x81\x1f\xe6\x2b\x0f\x99\x64\xe7\xb0\xfc\x29\x0f\xd6\x3f\x44\x17\xc4\x5c\x8a\xe3\xb6\x64\xf0\xf8\xc8\x6f\x1f\xbe\xc2\x17\x7a\x38\x95\x70\xe0\x2b\x79\xdc\x87\xfb\x9b\x5f\x86\x89\x1b\x20\x40\xcc\xc5\x29\xa1\x5d\x25\x46\xe2\x13\x54\xfc\x89\x24\x22\x5c\x20\xb2\x16\x5c\xbc\x5c\x4e\xb6\x99\xa8\xb8\xdc\xbf\x3c\x3f\xa2\x15\xfa\xcd\x22\x78\x33\x58\xca\xe3\x6a\xc2\x67\x8a\xc2\x8d\xb0\x92\xc7\xba\x01\x2f\xcb\x0f\x16\x6b\x80\x7d\x35\xaa\x78\xe0\x4b\x8d\x08\x08\xbd\x02\xce\x14\xbc\xb5\x8a\xf5\x79\x60\x8d\x56\xaf\xb2\x14\xac\x91\xb9\x0d\xac\xe2\x7b\x26\xcf\x75\xd3\xa6\xc4\xbe\xcb\x13\x37\x7e\x98\xdb\xe1\xbb\xbc\x4e\x0a\x81\x52\x54\xf9\xe1\x6d\xc4\xde\xe3\xab\x7c\xf7\x15\xbd\x98\xce\x9b\x35\xaa\x69\x1b\x66\xaa\xc0\x4d\x87\x53\x47\x3e\xd7\x40\xa0\x8f\xcb\x01\x00\xbf\xee\x25\x11\x68\x7e\x5c\xe0\xa9\x03\x07\x11\x5e\x18\x81\xf9\xaa\xf4\x4d\x59\xd6\xfd\xbb\x0e\xdc\xf9\xe0\x60\x57\xf2\x34\x35\x1b\x53\xa7\x08\xc4\xe1\xe1\x0c\x68\xbc\x5c\xc9\x23\x90\xdd\x48\xfd\xc3\xf7\x38\x41\xd8\xb9\x30\x02\xb3\xb9\xab\x5a\xb0\xba\xad\xae\x23\x81\x10\xf4\x42\xc7\xf4\x44\x90\xb1\x79\x5e\x64\x24\x3e\x6a\xea\x8a\x05\x47\x4e\x60\x5d\x89\xee\xb4\x2e\xd4\xf6\x4e\x98\xc8\xe8\x1e\xd8\x54\xc1\x0b\x7d\x06\x54\xb3\xff\x52\x7d\x34\xa4\x16\x37\x69\x2c\xc0\xd8\x3d\xee\x20\x4f\x01\x0e\xfe\x56\xb4\x5b\xd9\x77\xc5\x5e\x79\x6e\x95\x8e\xf8\xe0\x51\x67\xfc\x68\x82\xc1\x38\x11\x13\xac\xf9\x27\x16\xa2\x0e\x25\x5c\xad\x39\x78\x0d\x5a\x5b\xa4\xb2\xa0\xb6\x43\xb0\x8f\xd9\x52\x40\x8e\x45\x67\x14\x00\xc9\x6f\x6b\x0a\xc3\xb0\x9c\xb4\x32\xd2\x79\xd0\x55\x07\x74\x66\xb0\x43\x82\xae\x42\xdc\x24\x14\x18\xaa\x26\x1a\x93\x56\xba\x39\x22\x96\xc0\x90\x49\x1d\x51\x4b\x60\xd8\x04\x12\xc8\x25\xa4\xe3\x52\xe2\x28\x9d\x8c\x57\xf1\x9a\xdf\xc2\x01\xf6\xd2\xcb\x11\x5c\x6e\xed\x27\x84\x41\xc0\x61\xe2\x88\x06\x0c\xdf\x60\x4f\x8b\x07\x7a\x4d\x62\xac\xc1\x51\x1a\x8f\xc7\x8c\xd0\x0f\x99\x8b\x2d\xda\x91\x4c\xcc\x18\xfc\xc6\xab\x2e\x8e\x6e\x18\x8f\x38\xcf\x04\x62\x07\xfa\xcc\xdd\x83\xb3\x8f\xf1\xe4\xf7\xb1\x10\xe6\x49\xd1\x89\xe7\xdc\xf2\xd6\x58\x55\xb1\x86\xd7\xa2\xdc\x2b\xfa\xc9\xef\x63\x20\xfe\xde\xd6\x72\xe7\x35\xd4\xf5\xcf\xa3\x58\xdf\xb9\x0d\xbf\xbc\xe7\xde\x5a\x75\x52\x69\x28\x04\x2f\x1e\xc0\x41\xb2\xf0\x7d\xb4\xc3\xd5\x0b\xcf\xaf\xa2\x05\x35\xbc\x11\x11\xf4\x74\xa1\x7e\x6e\xc1\x38\xb4\xae\x36\xc2\x60\x9d\x14\x1e\xcb\xbf\x33\x1f\x46\xf3\x72\x78\xbc\xc0\xce\xf7\x18\x35\x31\x5b\xde\x23\x98\x2a\x61\x9d\xac\x2a\x09\x6a\x2d\xb4\xb3\x3e\xa2\x21\x2e\x20\x19\xb0\xe0\x97\x8f\x0c\xb7\x8c\x56\xc2\x72\xf6\x0c\x19\x36\x1c\x9b\xda\x5f\xb8\x83\xa7\x78\x71\x64\x8d\x97\x35\xdc\xd8\xff\x32\xdc\x33\x7e\xd8\xdf\x8f\xb6\x5e\xaa\xd0\x52\x61\x57\x10\x97\x53\x4c\x71\x97\xb7\xbb\x7b\x0c\xf6\xf3\xa1\x3f\xed\x2d\xad\x27\xc8\x42\x7f\xde\x37\xc7\x3e\x18\x80\x5c\x7e\x3b\x03\x37\xae\x69\xc7\x02\xa7\x1f\xdc\xde\x42\xba\x37\x6f\x85\xce\xe5\xf1\x26\xd0\x0c\x7d\x52\xa0\xfc\xf4\xac\x10\x25\x3f\x5c\xf9\x9c\x51\x70\xb2\xa4\xe8\x6e\x05\x3d\xbc\xc3\x30\xe3\x30\xd3\x20\x74\xf9\x9e\x48\xff\xc8\xd4\x35\xd0\xec\x36\x74\x66\x7a\xa4\xe6\xf1\x17\x6b\xb3\xc0\xe1\xde\x19\x9d\x49\x81\xd2\x38\x53\xa9\x59\x5b\x17\x6a\xb8\xf0\x3b\x70\xd7\xc4\xbc\xc9\xd6\x85\x62\x5e\x89\x92\x57\xf0\xb2\x87\x79\xe3\xed\x64\x29\xc1\xa7\x94\xe4\xe3\x27\x65\x27\x31\xe4\xe5\x90\x34\x1c\xb0\xc9\x9d\x34\x2c\x28\x2e\xf9\xdb\x21\xe2\x13\x0d\x43\x19\xe5\x33\xaf\x98\x69\x90\x3a\xe6\xec\xb1\xba\xcf\xef\xbf\x17\xf0\x59\xc3\x3f\x2a\x51\x7f\xe2\xd8\xe9\x09\x8f\xcf\x78\x03\x31\xc4\x61\x7c\xb6\xfa\x0b\x88\x34\x5a\x15\xed\xf1\x91\xc8\xb9\x63\x7a\x69\xda\x68\xa9\x05\xaf\x02\x8f\xf8\x2c\x22\x66\x2f\x7f\x0a\x09\x56\xa9\x02\x3c\xf6\x59\x69\x51\x12\xb2\xf2\x9f\x81\x24\xac\xfc\x67\x4a\x60\x77\x55\x49\xa1\x2c\xff\x95\xdd\x78\x25\xa0\xfd\xd8\x5a\x8d\xb4\x72\xf8\x43\xb0\x8a\xdb\xfc\xce\x0a\x6e\x0f\x13\x87\xe6\x95\xc3\x47\x46\x93\x2e\x69\x07\x93\xb7\x5a\x8b\xda\x6e\x40\xa0\x23\xe7\x27\xea\x04\x0b\x4a\xe1\xed\x06\x90\x70\xd2\x5c\xa2\x2f\xef\xcb\xa6\xe7\x4f\xf0\x33\xf1\xbd\x91\x9f\x1a\x63\x07\x22\x5f\xb0\x4e\xb0\x81\x3e\x76\x86\x53\xb0\x5f\xfc\x9b\x56\xb2\x98\x58\x7c\x1a\x87\xf0\x6e\xd4\xb8\x3a\xe5\x45\xf1\x90\xaf\xe5\xe3\xf8\x46\x74\x9d\xdf\xe5\x43\x5c\x1a\x2d\x1f\xa8\x2b\xa0\xa6\x8f\x0c\x1d\x86\x25\x35\xe9\x15\x89\x16\x0b\x05\xf3\x9a\xb1\x1a\x47\x69\xa2\x2f\xf5\x0f\x1b\x86\xa2\x79\x5f\xa9\x4e\xee\x32\x6a\x50\x51\x78\x48\xf1\x2e\x74\x1c\x89\x99\x0e\x15\x0d\x7f\xf6\x01\xe2\xdb\xcf\xdf\x0f\x39\x1b\xf7\xe9\xb4\x2d\xb2\x73\xbf\xc2\xae\xf0\xef\x71\x89\xd6\xf2\x3d\xa8\x1b\xaf\xbc\x2a\x2d\x1e\xc7\xc1\x7a\x00\x9f\xcb\x13\x90\xc8\x3f\xaf\x7d\xe7\xc0\xea\xcd\xef\xbc\xb1\xe3\x09\x20\x82\x3d\xbd\x68\x5c\x2a\xb7\xca\x41\x6e\x35\xe0\x12\xb9\x95\x16\x25\x0f\x9c\x71\x1a\x76\xa8\x7a\x51\xd6\xff\x3f\x41\x77\x58\xf1\xd0\x21\x86\x01\xdb\x4b\xe2\x11\xfd\x79\xca\xe0\xa9\xa2\xe9\x93\x47\x71\xa4\x3b\x7f\xfa\x9b\x9b\x5b\x64\x58\x3e\x3a\x81\x4f\xdd\xcb\xf0\xcb\xb7\xf7\xd4\xd4\x8b\xe9\xbb\x86\x75\xeb\xec\xa5\x5f\x70\x08\xdd\x1f\x2c\xf3\x37\x81\x3d\xb2\xbc\x85\x07\xf8\x11\x9b\x2f\xe4\x5c\x78\x9d\xbe\x2a\x31\xc6\x0a\x58\x5a\x45\x9e\xfa\xbc\x6f\x6f\x51\x33\xb7\x6d\x36\xbc\x67\x18\x7c\x1d\x65\x14\x44\x1e\x0f\xdf\x23\xe1\x6b\x31\x93\xb5\xb4\x92\xdb\xae\xf2\xfd\x1a\x21\x6b\xb4\xea\x86\xe9\xc7\x97\x36\xf7\x2e\x30\x68\x9f\x42\x2d\x57\x55\xe3\x1f\x54\x4b\xa1\x36\x68\xff\x3f\x46\x0d\x78\xbb\xc2\x01\xb7\x40\xc2\xc9\x40\x02\x75\xc5\xc2\x01\x7c\xf0\xd2\xf9\x1e\x1f\x77\xcf\xc2\x73\x02\xa7\x47\x2e\x24\x36\xf6\xc6\x85\x11\x3d\xf0\xce\x43\x2f\x87\x7c\x60\xca\x0f\x7f\xa7\xe9\x21\xe8\x96\xc1\x61\xd0\xbc\xd5\x4a\x0b\xa2\x03\x8b\x7e\x88\x88\x9c\xa4\xc0\xf1\xfa\xf3\x9e\xe1\x37\xe8\x07\xd4\x85\x02\xf6\x5b\x4b\xe1\xf6\x57\xdf\xb9\xae\x65\x7d\x8b\x32\xfc\x53\x65\x0a\x7b\xc0\x0d\x41\x62\xfd\x46\xab\x5c\x18\x73\x3c\xb4\x5e\x55\xc0\xa8\x93\xc6\xa0\x1b\x58\x65\x4d\xc9\x3f\xa6\x51\xca\xcb\xb8\xb6\xe9\xde\x34\x98\xfe\xaf\xe1\xc7\xb7\x8f\xb8\x41\x5a\xf3\x24\x65\x02\x92\xcb\x2e\xcb\xfc\x2e\xab\x06\x74\xeb\xe9\x28\x7d\xf8\x86\x0e\x20\xff\xba\xd7\xce\x2a\x61\xf9\x68\x84\x3f\x7c\xaf\x0e\xf7\x6a\xdc\xa7\x76\x1a\xe9\x56\xcf\xef\x22\x7f\x03\x25\xd7\x3a\xb0\x51\x25\xd1\xd3\x5a\x7b\xcf\xca\x82\xc3\x8c\xeb\x5e\x41\x7b\x79\xe9\x94\x44\x6d\xfb\xfb\x5c\x0e\x0d\x1d\x71\xb1\x2d\xe0\x36\xd9\x7d\x7c\xec\x65\xb2\xfe\x6d\xb7\x65\xa1\x99\xb1\x01\xaf\xde\xe7\xe2\xd4\x90\x4c\x5c\x7a\xc4\xe1\x5e\x4a\x40\x2e\x16\x35\xb7\xf2\x21\x98\x2b\xf4\x17\xb7\x3f\x7d\x38\x9f\x84\xca\x27\x7d\xfb\x6f\xea\x7a\xdc\xcd\x8c\x52\xd8\x27\x46\xc7\x82\x82\xef\x33\x4e\x90\xb8\x81\x44\x0a\x22\xf6\x45\x4a\x57\xd2\xad\x54\x57\x5e\xb2\x6b\x17\x51\x0a\xf6\xae\x74\x01\xb0\xf1\x8e\x12\x89\xc9\xc9\xc8\xa0\xdf\x76\x7d\x56\x32\xac\x7a\xf6\x28\x11\xa4\xf3\xf8\x65\x22\x93\x09\x53\xba\x97\x4c\x74\xe0\x1c\x3e\x2f\x2e\x73\x51\x86\xbd\xe5\x6b\xc0\x07\x62\x93\xe3\xda\xe9\x11\x17\x00\xfc\x4a\x1a\xcd\x82\x17\x99\x7c\xd5\xbc\x12\xce\xfe\x5a\xe4\x96\xd7\xb7\xe3\xac\xf7\xbe\x02\x46\xd9\xe4\xe6\x51\x08\xf3\x96\x55\x6d\x69\x65\xc3\xcd\x71\x1a\x84\x30\x6f\x97\x51\x32\x19\x50\x67\x65\xf6\xd2\xbf\x32\xd3\x68\xd5\x08\x6d\xa5\x30\xd9\xcb\xbd\xe2\xf9\xef\x1b\x1e\xb8\xeb\x5f\x73\x77\x54\xeb\x52\xca\xfa\xed\xf0\x78\x1d\x84\xc8\x8b\x7f\x30\x6b\xce\xc2\x1d\x08\xeb\x06\x9a\x71\x74\x9c\x1a\x8e\x4e\x10\x4c\x68\xad\xb4\xb9\xdc\x79\x5d\x94\xe2\xcf\x7f\xfc\x73\x1a\xcc\x09\x07\xbf\xba\x36\x60\x32\x59\xbf\xaa\x6c\x32\xe5\xd1\x97\x4c\x0a\x97\x49\xe1\x00\xfb\xa7\x6f\xdf\xfe\xcf\x4f\xff\xf9\xd3\xff\x0d\x00\x00\xff\xff\x34\x45\x87\x94\x8f\xe9\x01\x00")

func dataRailsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataRailsJson,
		"data/rails.json",
	)
}

func dataRailsJson() (*asset, error) {
	bytes, err := dataRailsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/rails.json", size: 125327, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataRecommendationsJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x8e\xc1\x4a\x04\x31\x0c\x86\xcf\xc9\x53\x2c\x39\x2f\xdb\xfb\xdc\xc5\x17\xf0\x26\x52\xc6\x26\xac\x15\x9b\x48\x9b\x2d\x0c\xc3\xbc\xbb\x14\x2f\x52\x3d\xc8\xde\xca\xdf\x8f\xef\xcb\x8e\x40\xad\x27\x5a\x4e\x94\x8c\xe5\xf2\x7e\x6b\x9e\xf5\xe2\x3d\x70\x6e\xc9\xba\xd4\x2d\x54\x49\x56\x8a\x28\xaf\x9e\x4d\x1b\x9d\x11\xa8\xda\xcd\xa5\xd1\x72\x7a\x46\x80\x1d\x01\x80\x3e\x57\x77\xa9\x3a\x54\xc1\xab\x28\x67\xbd\x0e\x16\x80\x74\x2d\x32\xf6\x69\x2e\xe2\x6f\xc6\xe3\xe3\xf1\xe1\x89\x10\xe0\x38\xff\x69\xeb\xc6\x2d\xb0\xf4\x9c\xa4\x85\xe5\xfb\x11\x33\x4f\xf2\x6e\x1c\xa7\x53\xe3\xeb\x16\x67\xfc\xbe\xe8\x87\x5d\xb3\xfe\x2f\xf8\x13\xfd\x1d\x43\x78\xc1\x03\xbf\x02\x00\x00\xff\xff\xf1\x74\x65\x29\x77\x01\x00\x00")

func dataRecommendationsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataRecommendationsJson,
		"data/recommendations.json",
	)
}

func dataRecommendationsJson() (*asset, error) {
	bytes, err := dataRecommendationsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/recommendations.json", size: 375, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataSimilarChannelsJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x92\xc1\x6e\xf3\x20\x10\x84\xef\x7e\x0a\xc4\x39\x09\xf7\xdc\x7f\xfd\xc7\x56\x6a\x6f\x55\x85\x28\xbb\xb5\xb7\x32\x10\x01\x26\xad\xa2\xbc\x7b\x65\x1a\x27\x69\x1d\xa5\xc4\x49\x2f\x96\x0c\x33\xfb\xb1\x3b\xbb\xa9\x18\xe3\x21\x69\xbe\x64\x5c\x3b\xc0\xc5\x5b\x17\x22\xd9\x45\x4c\x02\x28\x68\x97\xd0\x7f\x88\x40\x86\x5a\xe5\xe7\xba\x51\xd6\x62\x1b\x84\x36\x30\x3a\xe4\xb3\xbe\x94\x77\x5d\xc4\xc0\x97\xec\xa9\x62\x8c\xb1\x4d\xfe\x32\xc6\x57\x2a\x46\xf4\xb6\xc7\x88\x10\x3d\x2a\x13\x86\x0a\x62\xd9\x05\xf4\x02\xdf\x29\xc4\xaf\x2a\xd9\x61\x95\xc1\x5e\xde\xa8\x20\x3d\x6a\x67\x0c\x5a\x40\x90\x3b\xb7\x6c\x5d\x4d\xf6\x20\x37\x18\x1b\x07\xbd\xe1\xff\xbf\x47\x9e\x4f\xb7\xb3\x0b\xdf\x30\x86\xd7\x18\xff\x10\xbe\x56\x51\x37\x73\xeb\xd6\x63\xf0\xca\x85\x28\xf3\xbd\xfc\x76\x7f\x20\xdd\xdf\x3d\x14\xa0\xf6\x91\x15\x34\xba\x93\xc8\xc1\x73\x65\x97\x7b\xf4\xab\x4a\xce\x53\xc4\x73\xec\x41\x73\x2b\x78\x46\x49\x82\x51\xd0\x17\xae\xd9\xcd\x1f\x50\xbc\x63\xd7\x93\x7f\x66\x5f\x96\xfa\x0d\xb9\x43\xa8\x85\x91\x4f\x26\x27\x02\x74\x47\x2b\x9e\x1c\x48\x82\xf3\xed\x26\x07\xd3\x81\xba\xa5\xd5\x11\xaf\xff\xfd\x15\x98\x3d\xd3\x87\x0b\x98\x48\x63\x3f\xde\x5a\x19\x2c\x9e\x6d\x16\x4f\xa6\x02\xbe\x74\xb5\xf0\x9d\xb5\x64\xeb\xd3\xa4\x2c\x91\x23\xc9\x29\x50\xc5\xd8\x73\xb5\xad\x3e\x03\x00\x00\xff\xff\xe2\x84\xad\x94\x73\x06\x00\x00")

func dataSimilarChannelsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataSimilarChannelsJson,
		"data/similar-channels.json",
	)
}

func dataSimilarChannelsJson() (*asset, error) {
	bytes, err := dataSimilarChannelsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/similar-channels.json", size: 1651, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataSkadiJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x56\xcb\x6e\xdb\x30\x10\xbc\xeb\x2b\x08\x9d\x83\x10\xb9\xea\xdc\xa2\xc8\xa5\x0e\x90\xdc\x8a\x22\xa0\xc9\xb5\xcd\x86\x22\x05\x3e\x14\x34\x82\xfe\xbd\x90\x5a\xb4\xb5\x4d\xca\x5d\xd2\x76\x73\x31\x20\xef\xec\xcc\xce\x0e\x45\x68\xa8\x08\xa9\x5d\xcf\xeb\x86\xd4\xdc\x08\xb8\xfd\x16\x9c\x97\xfa\xd6\xf7\xd4\x82\x02\xe6\x80\xba\x17\x26\x64\x7d\x33\x01\xad\x09\x1e\x5c\xdd\x90\x2f\x15\x21\x84\x0c\xf3\x2f\x21\x75\xc7\xbc\x07\xab\x27\x12\xda\xdf\xd1\x57\x58\xef\x8c\x79\x99\x7b\xe6\xba\x66\x2d\x24\x8b\x2d\xf8\x9d\x11\x53\xf9\xd3\xc7\xa7\x7a\xfe\x77\xbc\x49\xf3\xdb\xa0\xb5\xd4\xdb\x08\xf9\x51\x05\xc9\xdc\xdf\xd1\x75\x90\x4a\xc4\xe7\x3e\x28\xe1\xb9\x39\xd3\x42\x0a\xe6\x81\xf2\x60\x2d\x68\x1f\xd7\x59\x80\xfd\x5f\xcd\xd5\xc3\xd3\xfd\xea\xf3\x23\x52\xb7\xb3\xd0\x4b\x13\xdc\x29\xe1\x63\x5c\x89\xdb\x73\xa8\x62\xfc\x0a\xe8\x94\xf9\xde\x82\xf6\x09\xc9\x28\xe0\x8f\xd6\xc3\xea\xf1\xdf\x2c\x96\x0a\x65\x9a\xa2\x8d\x14\xd4\x79\xe6\x53\x2b\xfd\x1b\x3b\xdc\x7f\x18\x8f\xc0\xf8\x34\x2f\x24\x7f\xcd\x58\x33\xac\x5e\x3d\x55\x65\x62\x77\x69\x6c\xa7\x7b\xc8\xf2\x3c\x8b\x85\x31\xae\x37\x16\xe0\x0d\x28\xb7\xc0\x3c\xc4\x65\x13\x90\x8c\x97\xf4\x1c\x62\x19\xe6\xb6\x90\xb8\xde\x63\x75\x7c\x7e\x65\x2a\x19\x7e\x04\x28\x38\xb1\xbf\x43\x48\x7e\x58\x45\x62\x19\xe6\x94\x74\xcb\x7b\xdc\x07\x20\xe3\x62\xc1\xef\x8c\x95\x6f\x31\x43\x91\x1a\x92\x7d\x2b\xfd\x2e\xac\x9f\xcd\xc4\xf4\xcc\x99\x52\x6b\xc6\x63\x5f\x7b\x27\x70\x48\x55\x6e\xf4\x46\xc6\xae\x8c\xc3\x02\xfe\x68\x5b\xe8\x8c\xa3\x8d\x79\xd5\x60\x69\x33\x11\x53\x07\xde\x4b\xbd\x4d\xdc\xc7\x3f\x1b\x86\xb9\x61\xa4\xc3\x54\x1a\x23\x2d\xef\x71\x12\xcc\x59\x5d\x98\x86\x0a\xd8\xb0\xa0\x12\x67\x78\x71\xaa\xe3\xd6\xb3\xee\xe9\x42\x93\xa1\xf7\xb6\xa0\x5f\xec\x1c\xc9\x9d\x9f\xf9\xf4\x44\xb9\x69\x3b\x66\x81\x36\xdc\xb4\xad\x4c\x7d\xa3\x1c\x6c\x76\x7a\x1c\x7f\xb7\x0e\xbf\x5a\xc7\xf3\x85\x7e\x95\xd1\x30\x9b\x0b\x0e\xec\x52\x3c\xb1\x3a\x7e\x09\x65\x2a\x58\x3f\x69\x8d\x52\x0f\x38\xe6\xfd\xb9\x2b\x42\xbe\x56\x63\xf5\x23\x00\x00\xff\xff\x09\xc4\x4e\x61\xbd\x10\x00\x00")

func dataSkadiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataSkadiJson,
		"data/skadi.json",
	)
}

func dataSkadiJson() (*asset, error) {
	bytes, err := dataSkadiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/skadi.json", size: 4285, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataStreamsApiJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x8d\xb1\x0e\x82\x30\x14\x45\xf7\x7e\xc5\xcd\x9b\x91\xee\xec\xc6\x1f\x70\x33\x0e\x15\x9e\x01\xa1\x2d\x69\x1f\x30\x10\xfe\xdd\xb4\xc6\x89\x68\x1c\x5c\x3a\xf4\x9e\x77\xce\xaa\x00\x8a\x73\x4d\x15\xa8\xf6\x0d\x97\x8f\x29\x4a\xe7\x4a\x99\xf5\xc2\x37\x1d\x25\xb0\xb1\xf1\x60\xc6\x8e\x8a\x84\x06\x3f\x09\x47\xaa\x70\x51\x00\xb0\xe6\x17\xa0\xd1\x88\x70\x70\x49\xa3\xfb\x60\x7a\x76\xef\x5b\x7d\xf7\xc3\xe0\x17\x6e\xb2\x20\xc3\xce\x58\x4e\xe4\x7e\xb1\x2c\xad\x6f\xd2\x76\x3a\x9e\x29\xff\x6e\xc5\xcf\xa5\xaa\x6e\x8d\x73\x3c\xec\x4b\x2f\xe2\x4f\x9d\x4f\xfa\xf8\xdd\xaf\x80\xab\xda\x9e\x01\x00\x00\xff\xff\xd3\x42\xaa\x24\x71\x01\x00\x00")

func dataStreamsApiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataStreamsApiJson,
		"data/streams-api.json",
	)
}

func dataStreamsApiJson() (*asset, error) {
	bytes, err := dataStreamsApiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/streams-api.json", size: 369, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiApiJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x90\x41\x6a\xc6\x20\x10\x85\xf7\x9e\x62\x70\x1d\xe2\x3e\x27\xe8\xa6\x27\x28\xa5\x4c\x75\x9a\xa4\xc4\x51\x74\x94\x42\xc8\xdd\x8b\x76\xd1\x85\x6d\xa1\x3f\xff\xc6\xc5\x7c\xcf\xef\xc1\x3b\x15\x80\xce\xd5\xea\x05\xb4\x0d\x8e\xe6\xf7\x92\x65\xe7\x59\xaa\xb1\x1b\x8a\x11\xbf\x1b\x8c\xbb\x9e\x5a\x2e\x85\x22\x94\xf5\x02\x4f\x0a\x00\xe0\xec\x2f\x80\x8e\x28\x42\x89\x9b\xc3\x38\x7a\x2d\xab\xa9\x98\x72\xff\xd3\x39\xa3\xa7\x06\xe9\x23\x56\x4c\xdf\x77\x4f\xb2\x05\xd7\x88\xee\xa7\x6b\xfa\xdd\x3b\xda\x38\xc8\x5b\x28\xec\x6e\xf3\xad\x29\x94\x68\x4a\xa6\x64\x16\xbb\x21\x33\x1d\x63\x45\x0f\xdd\xcd\xdf\x17\x15\xfa\x69\x99\x9e\x7e\x19\xf9\x7f\x1a\x3d\xe5\x8c\x2b\x8d\xf2\xc7\x2f\xf0\x80\xec\x0e\xfa\x6b\x7e\x05\xf0\xac\x2e\xf5\x19\x00\x00\xff\xff\x55\x31\x1b\x6c\x14\x02\x00\x00")

func dataTmiApiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiApiJson,
		"data/tmi-api.json",
	)
}

func dataTmiApiJson() (*asset, error) {
	bytes, err := dataTmiApiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-api.json", size: 532, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiClueJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x56\xcd\x6e\xdb\x3c\x10\x3c\x53\x4f\x11\xe8\x1c\x84\x77\xdd\x3e\x7c\x35\xda\x43\x81\x06\x68\x7a\x2a\x0a\x81\x26\xb7\x16\x53\x89\x24\xb8\x2b\x1b\x41\x90\x77\x2f\x28\x0b\x72\x4c\x53\x12\x63\xf7\x24\x81\x43\xcd\xec\xcf\x90\xda\xd7\x82\x95\xb8\x97\x65\x75\x57\x4a\xab\xe0\xe1\xb9\x47\xd2\xe6\x81\xf6\x5c\x36\x82\x38\x75\x9a\xcb\xb6\x87\xf2\xbe\x60\xa5\xb7\x3d\x01\x96\xd5\xdd\xcf\x82\xb1\xd7\x82\x31\x56\x3a\x41\x04\xde\x84\xcf\xb9\x82\x6d\xbf\xe3\xbe\x37\x46\x9b\x5d\xf8\x80\xb1\xd2\x88\x0e\x02\xd8\x80\x68\xa9\x91\x0d\xc8\x3f\x23\xd2\x01\x35\x56\x05\xec\xf3\xe6\xa9\x2c\x18\x7b\xbb\x4f\xb2\x8a\x9e\x1a\x30\xa4\xa5\x20\x88\x48\x13\xd0\x89\xf5\xf1\xdb\xf7\x25\x5a\x69\x8d\xa9\x45\xdb\xda\x03\xa8\x88\x36\x01\x65\xd3\x3e\x5b\x6d\x6a\x07\xbe\xd3\x88\xda\x9a\x88\x39\x8d\x66\x93\xa3\x03\xa9\x45\x5b\xf7\x08\xbe\x6e\x35\x52\x44\x3f\xe2\x01\xc6\x8f\x72\x3b\xaf\xf7\x1d\xc6\x6d\x3b\x5f\xcd\x26\xdb\xb5\x76\x2b\x5a\xbe\x15\xc6\x80\xaa\x0f\xd6\x2b\x8c\x88\x77\x40\xf5\x71\x57\x9d\xd8\x95\xeb\x8d\x84\x0e\xaf\xc2\x23\x36\x8a\x52\x09\xb5\xcb\xac\x7e\xfc\x0b\x31\x05\x2d\x10\xe4\xe8\x7d\xda\x7c\xdd\x3c\x6d\x16\x24\xbd\xb5\x1d\xf2\x6a\xe8\xb7\x56\x6b\xf5\x94\x4d\xc0\x6f\x2a\x68\xbe\x20\xe6\x0a\x2e\x17\x75\x14\x0c\x8f\xa0\x96\x91\x56\xda\xdd\x59\x69\x4d\x2a\xc7\x0c\x17\xb4\x86\x02\x8c\x82\x48\x82\xfa\x5b\x15\xe3\x2b\xe6\x94\x53\xfd\x2e\x94\x6b\xab\x96\xcc\x67\xca\xc5\xcc\xaa\xe4\x1a\x70\x2d\x8d\x83\x76\xb0\xdc\x9f\x55\xa5\xe1\xb3\xc9\x79\x89\xd6\x0c\x88\xf3\xd6\x81\x27\x0d\x1f\xed\xc7\x22\x7d\x67\x95\xfe\xfd\xb2\xaa\xb0\xdc\x93\x73\x05\xae\x77\xc6\x7a\x40\x5e\x91\xf0\x53\xf8\x17\xca\xe3\x5d\x31\x6e\xbe\xb5\x6a\x99\xa2\xae\xa7\x59\xc5\x7c\xdf\x75\x56\xcd\x9f\xa3\xce\x5e\x79\x6e\x16\xfb\xe4\x04\xc9\x66\xc6\x60\x8f\xff\x3d\xfd\xff\x25\x2f\xf4\x44\xbc\x61\xf9\x7a\x73\xcd\x73\x8f\xce\x5a\xa3\x5f\xae\xba\x36\xe1\x55\xb4\x1c\x5f\x90\xa0\xe3\x7b\xad\xc0\x72\x24\x0f\xa2\xab\x95\x3d\xc4\x53\xc6\x25\x92\xfd\xe3\x9e\xa4\x8e\xb3\x9c\x36\x7b\xd1\x6a\x25\x08\x6a\x29\x64\x13\xcf\x5f\x33\xf0\xc7\xd5\x22\x1b\x2b\x8d\x61\x06\x03\x19\x0f\x38\x27\x60\xe6\xd6\xcc\xd4\x13\xdb\x1e\x81\x6b\xc7\x2b\xed\xf8\x99\x4f\xa7\xd4\x5c\x3d\x6c\xba\xce\xc5\xc2\x69\x3e\xde\x8d\xc8\xab\xf1\x2d\x52\xe8\xdd\xb1\x70\x67\x60\xae\x25\x1a\x8b\x94\xfa\x57\xbe\x5f\xcf\x0d\x36\xc5\xe5\x2c\xce\x91\xad\xcd\xa8\xe0\xf7\xa7\xf3\x79\x9a\x16\x86\xd5\xf7\x43\xeb\x65\x78\x05\xfb\x55\xbc\x15\x7f\x03\x00\x00\xff\xff\x3f\x57\xa9\xf1\x91\x0c\x00\x00")

func dataTmiClueJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiClueJson,
		"data/tmi-clue.json",
	)
}

func dataTmiClueJson() (*asset, error) {
	bytes, err := dataTmiClueJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-clue.json", size: 3217, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiPubsubJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\xcf\xbb\xaa\xc3\x30\x0c\x06\xe0\xdd\x4f\x21\x34\x87\x78\xcf\xab\x1c\xce\xe0\xc4\xa2\x71\xc1\x17\x2c\xd9\x04\x42\xde\xbd\xd8\x14\x4a\xe8\x05\xda\x45\xc3\xff\x4b\x1f\x68\x57\x00\xc8\x75\xc1\x09\x70\x89\x96\xc6\x6b\x61\x71\x61\x94\xaa\x97\xd5\x88\x16\xef\x74\x2a\x33\x97\x19\x87\xb6\x9a\x63\x11\x62\x9c\xe0\x4f\x01\x00\xec\x7d\x02\x60\x32\x22\x94\x43\x63\xb4\xa5\xb9\x5c\x74\x35\x99\xfb\x4d\xef\x83\xf1\xd4\x4a\xda\x52\x35\xf9\x91\x7b\x92\x35\xda\xd6\x60\x8f\x8e\xe1\xbd\xfb\xac\xb9\x60\x69\xfb\x0d\x4b\xf7\x8f\x4e\xde\x29\xfc\x46\xe3\x57\x1a\x7f\xd4\x14\xc0\xbf\x3a\xd4\x2d\x00\x00\xff\xff\x79\x7b\xdb\xef\x81\x01\x00\x00")

func dataTmiPubsubJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiPubsubJson,
		"data/tmi-pubsub.json",
	)
}

func dataTmiPubsubJson() (*asset, error) {
	bytes, err := dataTmiPubsubJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-pubsub.json", size: 385, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiRoomJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x8d\x3d\x0a\xc3\x30\x0c\x85\x77\x9f\x42\x68\x0e\xf1\x9e\xab\x94\x52\x9c\x58\x34\x2e\xf5\x0f\x96\x6c\x0a\x21\x77\x2f\xf6\x52\x4a\x68\x86\x2e\x1a\xde\x7b\xfa\xbe\x4d\x01\x20\xd7\x05\x27\xc0\x25\x5a\x1a\x1f\x85\xc5\x85\x51\xaa\x5e\x56\x23\x5a\xbc\xd3\x39\x46\x8f\x43\x1b\xe6\x58\x84\x18\x27\xb8\x28\x00\x80\xad\x5f\x00\x4c\x46\x84\x72\x68\x10\x6d\x69\x2e\x77\x5d\x4d\xe6\xfe\xd3\xfb\x60\x3c\xb5\x92\x5e\xa9\x9a\xfc\xc9\x3d\xc9\x1a\x6d\x6b\xb0\x47\xfb\xf0\x9b\xeb\xc9\xcf\x94\x79\x75\xe9\x56\x92\x35\x42\x47\xfc\xc9\xe4\x4f\xd3\xd3\xb1\x9c\x7a\xbe\x07\x07\x8b\x02\xb8\xaa\x5d\xbd\x03\x00\x00\xff\xff\x5a\xf3\xeb\xac\x66\x01\x00\x00")

func dataTmiRoomJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiRoomJson,
		"data/tmi-room.json",
	)
}

func dataTmiRoomJson() (*asset, error) {
	bytes, err := dataTmiRoomJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-room.json", size: 358, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataUsersServiceJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x93\x3d\x4f\xf3\x30\x10\xc7\xf7\x7c\x8a\x93\xe7\x3e\xcd\x9e\xed\x11\x44\x30\x30\x30\x84\x09\x21\xcb\x2f\xa7\xc4\xb4\xb1\x23\xbf\x04\x50\xd5\xef\x8e\xec\x2e\x55\x6d\x02\x69\x97\x0c\xbe\x9f\xf3\xd3\xff\xce\x77\xa8\x00\x88\x9b\x05\x69\x80\x08\x23\x71\xfb\x1e\x9c\x57\x7a\xeb\xe7\xfa\x03\x79\x1d\x1c\x5a\xf7\xcf\xa1\x9d\x95\x40\xb2\x89\xb0\x35\xc1\xa3\x23\x0d\xbc\x56\x00\x00\x87\xf4\x05\x20\x13\xf3\x1e\xad\x8e\x3f\x3a\x5d\x4b\x78\x2a\x69\x36\x62\x3c\xef\xd1\x53\x1e\xf6\x3b\x1a\xeb\x74\xb2\x66\x42\xeb\x15\x9e\x91\x23\xfa\xc1\xc8\xc8\x3e\xb4\x1d\x49\xa7\xc7\xcd\xcf\x1e\xce\xb4\x46\x49\x97\x74\x45\x62\xa5\x26\xdd\xae\x1b\x25\xcb\x8e\x8b\x34\x94\x7f\xd1\x73\xf4\x5a\x59\x4c\x97\x0b\x83\xe6\x4c\x27\x65\xc9\x70\xdf\x3e\xb5\x5d\x7b\xb3\x64\x49\xf1\xfc\xb2\x2a\x84\x60\x62\xc0\xdc\x80\x9f\x93\xb2\x78\x9a\x0b\xbd\x60\x6e\x88\x93\x8b\x5c\x3e\xa0\x62\xaa\xff\xdd\xdd\xe3\x9a\x5c\x72\x14\x8c\x3a\x6f\xd5\xae\x90\x8e\x49\x49\x8b\xc0\xd5\x6d\x5c\xd4\x59\x1c\xcd\x8c\xbf\x19\xff\xda\x4c\x31\xc4\x9d\xd9\x17\x16\x2a\xaf\xac\x7c\xdb\x12\x79\xe8\x6b\x1b\xb4\x56\xba\x2f\x2f\x53\x42\x68\x86\x94\x44\x15\xc0\x5b\x75\xac\xbe\x03\x00\x00\xff\xff\x65\xbc\x8a\xe8\xc3\x04\x00\x00")

func dataUsersServiceJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataUsersServiceJson,
		"data/users-service.json",
	)
}

func dataUsersServiceJson() (*asset, error) {
	bytes, err := dataUsersServiceJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/users-service.json", size: 1219, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoOriginOriginJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\xd4\xc1\x6a\xc2\x40\x10\x06\xe0\x7b\x9e\x62\xc9\x49\x41\x76\x29\xbd\x94\x5c\xdb\xd2\xa3\x42\xa4\x97\x52\xc2\x9a\x8c\xba\x92\xdd\x09\x3b\x63\xda\x22\xbe\x7b\xc9\x1a\x2d\xa9\x52\xd2\x43\xf4\x12\x36\xe1\x9f\xe1\x63\xc8\xce\x2e\x12\x22\xa6\x3a\x8f\x13\x11\xe7\x58\x80\xdc\x6c\x89\x8d\x93\x5c\xab\xda\x14\x80\x0a\xbd\x59\x19\xa7\x72\x5b\xb4\xc7\x78\xd2\x94\x78\xdc\x32\x50\x9c\x88\xb7\x48\x08\x21\x76\xe1\x29\x44\x5c\x69\x66\xf0\xae\x69\xa7\x88\x3d\x68\x4b\x2a\x21\x20\x32\xe8\x32\x53\x28\xe3\x0a\xf8\x1c\xc9\x64\x89\xde\x6a\x1e\x87\x66\xa1\xd0\x69\x0b\x4d\xd5\x0a\x38\xb3\x9a\x18\x7c\x56\x95\xfa\xab\x34\xc4\x3f\x21\x0b\xbc\xc6\xa2\x89\xbd\x3c\xcf\xe3\xf0\x75\x3f\xf9\x1f\x20\xa9\xb5\x37\xda\xb1\x1a\x25\xc7\xfe\x63\x69\xef\xb7\x0f\x97\x29\x6d\xfa\x64\xc9\xba\xd1\xa1\x40\x1b\x42\xd7\x13\xd4\x8d\x0e\x05\xaa\x16\x3d\x39\x95\x47\xc6\xa1\x3c\x04\x2b\x0b\x8e\xc7\x92\xe9\x32\xa7\x0d\xdc\xea\x8f\xa9\x90\xce\x47\x72\x09\x33\x9b\xa6\x03\x4f\x23\x50\xfe\x18\x47\x3f\x01\x7f\x18\x5f\xa9\xee\x62\x90\x61\x31\xc8\xc3\x36\x90\xbe\xca\xdb\x63\xce\xa5\x9c\x86\xd3\x23\x3a\xf6\x58\xbe\xde\xa9\x94\xb5\xe7\xf4\xa0\x3f\x37\x9e\xea\x32\x6a\x72\x19\xfd\x0e\x5e\x9b\xfb\x04\x94\x7b\xb3\x80\x1e\xe2\xa2\x8d\xde\x1e\x3d\x07\x6f\x8d\xd3\xdc\x47\xcd\xc7\xec\x75\xd9\x4b\x44\x6e\xdd\x73\x08\x6f\xe9\xda\x58\x95\x02\xcf\xce\x2e\x49\x17\xdd\x64\x33\x82\xde\xb7\x29\x12\xe2\x3d\xda\x47\xdf\x01\x00\x00\xff\xff\x80\x8d\x17\x89\xd7\x06\x00\x00")

func dataVideoOriginOriginJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoOriginOriginJson,
		"data/video-origin-origin.json",
	)
}

func dataVideoOriginOriginJson() (*asset, error) {
	bytes, err := dataVideoOriginOriginJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-origin-origin.json", size: 1751, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoOriginOrigindbJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x8f\xc1\x8a\xc2\x30\x14\x45\xf7\xf9\x8a\x47\x96\x43\x69\xf6\x5d\x4f\x98\xcd\x80\x82\x75\x25\x52\xda\xe4\x51\xa3\x6d\x52\xd2\xd7\x8a\x94\xfe\xbb\x24\x28\x22\x58\x04\xdd\x84\x90\x93\x7b\x2e\x77\x62\x00\xbc\x1f\x15\xcf\x80\x2b\xa7\x31\x3d\x0e\x3d\x19\x9b\xd2\x28\x46\xa3\xd1\x09\xe7\x4d\x6d\xac\x50\xad\xbe\x5d\x75\xc5\x93\x10\xf2\x6e\x20\xec\x79\x06\x3b\x06\x00\x30\xc5\x13\x80\x77\x25\x11\x7a\x1b\x84\xa2\x6a\x5c\x25\x7e\x4e\x78\x89\x91\x88\x6d\xd9\x62\x60\x35\x52\x11\xf0\x83\xb4\x48\x07\xa7\x03\xfb\x93\x39\x8f\xaf\x73\xf2\x91\xbb\x1b\x96\xdd\xeb\xed\x77\x6e\x8d\x0d\x12\x2e\xea\x7f\xe5\xbf\xcc\xe5\xfb\x06\xe5\xb1\x24\x2c\xce\xde\x10\xfa\x85\xaa\xa7\x3f\x2f\xb7\xac\x36\xf7\x31\x0c\x60\xcf\x66\x76\x0d\x00\x00\xff\xff\x42\x8d\xe4\x4b\xcf\x01\x00\x00")

func dataVideoOriginOrigindbJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoOriginOrigindbJson,
		"data/video-origin-origindb.json",
	)
}

func dataVideoOriginOrigindbJson() (*asset, error) {
	bytes, err := dataVideoOriginOrigindbJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-origin-origindb.json", size: 463, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiFindJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\xd0\xb1\x4a\x04\x31\x10\xc6\xf1\x7a\xe6\x29\x8e\xa9\x14\x8e\x9d\x3e\x9d\xe0\xa1\x0f\x60\x27\xb2\xc4\xcd\x2c\x89\x5e\x92\x25\x99\xac\xc5\x71\xef\x2e\xb9\x3b\x0b\xbb\x15\xfb\xff\xcc\x0f\xbe\x13\x02\xd5\x75\x22\xb3\xa3\x29\x3b\x19\x3e\x5a\xd5\x90\x06\x5d\x79\x0d\x4e\x32\xb7\xea\xa5\xb0\x5d\x02\xcf\x21\x39\xda\x23\x50\xc9\x4d\xa5\x92\xd9\xbd\x22\xc0\x09\x01\x80\x16\xab\x2a\x25\xf5\x2f\x5c\xb5\x88\x8d\x3c\x1f\xf3\x57\x65\x2f\xf6\xa8\xfe\x6e\x30\x73\x2e\xd1\xea\x7d\x7f\x00\x40\xc9\x46\xe9\xf1\xb5\x1d\x2f\xed\x78\x6d\x6f\x45\x14\xf5\xd9\xf5\xe6\xf9\xf0\xf0\x48\x08\x70\xde\x6f\xe5\xc6\x77\x3b\x7d\xb6\xe5\x2f\xea\xed\xe4\x5f\x78\x1f\x88\x4d\x70\xdb\xdc\x9f\x39\x7f\x71\x4f\x87\x97\x8b\x86\xf0\x86\x67\xfc\x0e\x00\x00\xff\xff\x87\xb0\x08\x17\x9c\x01\x00\x00")

func dataVideoUsherApiFindJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiFindJson,
		"data/video-usher-api-find.json",
	)
}

func dataVideoUsherApiFindJson() (*asset, error) {
	bytes, err := dataVideoUsherApiFindJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-find.json", size: 412, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiUsherJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x97\xcf\x8f\xdb\x2a\x10\xc7\xcf\xf6\x5f\xb1\xf2\xe9\x3d\x69\x15\xdf\x73\x7b\xd2\x5b\xb5\xb7\x56\x6a\x6f\x55\x85\x08\x9e\xc4\x6c\x30\x20\x18\x3b\x1b\xad\xf6\x7f\xaf\xb0\x61\xf3\x9b\x18\xd2\x9b\x15\xbe\xdf\xf9\x30\x30\x30\xe4\xbd\x2c\x2a\x3b\xb0\x6a\xf9\x54\x31\xd5\xc0\xe2\xb5\xb7\xc8\xe5\x02\x87\x7a\xe0\x0d\xa8\xba\xb7\x2d\x98\x9a\x6a\x3e\x7d\x55\xcf\x65\x51\x19\xd5\x23\xd8\x6a\xf9\xf4\xab\x2c\x8a\xf7\xb2\x28\x8a\x4a\x53\x44\x30\xd2\x85\xa9\x4d\x2f\x25\x97\x9b\x7f\x16\xcb\xb5\x32\x1d\xc5\x7f\x9d\xa9\x28\x2a\x49\x3b\x70\x02\x3f\xee\x7f\xed\x00\x5b\xd5\xb8\xdf\xbf\xbe\xfc\xf7\x7f\x55\x16\xc5\xc7\xf3\xf5\xb0\x6a\xa5\xd0\x2e\xf0\x0d\xcf\xe3\x8d\x03\xe4\x30\x70\x08\xf9\xe5\xe5\xa7\x8f\x78\x35\xa4\x4b\x8b\xb5\x54\x4a\x10\x75\x2b\x6c\xbd\xe4\xcd\xcd\x59\x53\xcd\x89\xd7\x92\x56\xd8\x08\xea\x1a\x89\x51\x4d\x19\xc7\x7d\xcd\x5a\x60\xdb\x9b\x90\x20\x23\xa3\x2c\x95\xe1\x33\xd9\x72\x21\x88\x45\x03\xb4\x8b\xa7\x14\xd2\x39\x36\x5c\x30\xbf\x7f\xfb\x31\x07\xaa\x8d\xd2\x60\x70\x4f\x7a\xdd\x50\x84\x59\xdc\x33\x4f\x2e\xda\x82\x6c\x08\x53\x5d\x07\x86\x71\x2a\xc8\xca\x00\xdd\xce\x9a\xc0\x55\x67\xe6\xaa\xa3\xb2\x64\xe0\x4a\x50\xe4\x4a\xce\xa2\x9f\x38\x32\x93\x0f\x6b\xc8\xc1\xba\x0a\x76\xc9\x68\x8a\x7c\xc5\x85\x2b\xb6\x84\x4d\xe0\x60\xc9\x45\x80\xbc\xa5\x38\x9e\x93\xe0\x03\x4c\x71\xa7\x31\x9b\x32\x9f\x0b\x73\xea\x7c\x44\x6f\x11\x4c\x2d\xb8\xc5\xdb\xdc\x49\x44\x9c\x28\x33\xbe\x54\x0d\xdc\x39\x69\x1e\x32\x2a\x33\x29\xb6\x55\xbb\x59\x10\x27\xcc\x64\xcc\x39\xbc\x9e\x92\x79\x66\x8d\xb2\xb6\x51\x1d\xe5\x72\xf1\xd6\x89\xf3\xd8\x87\x51\x72\x18\x9d\x9b\x44\xb3\x52\x7a\x3c\x7c\x54\x88\x68\x0a\x41\x48\xa8\xc8\x66\x6c\x00\xe7\x31\x36\x90\x5a\x56\xae\xe2\xd1\x50\x69\x5d\x43\xae\x99\x81\x7b\x5b\x72\x62\x20\x93\x21\x75\x63\x4e\xa1\xee\x30\x10\x19\x7a\xc2\x4c\xf0\xa9\xe9\xa1\xa4\x3b\x2a\xf9\x1a\x6c\x7c\x89\x4f\xe9\xc1\xf2\x57\xb8\x64\x0b\xfb\xb9\x69\x9f\x78\x1e\xa2\x6b\xba\x17\x8a\x36\x29\xf0\x63\xcb\x43\x6c\x77\x69\x84\x7b\x36\x61\xd5\x8f\x6d\x89\x7c\x2e\xdd\x27\x15\x35\x97\x1b\xb7\x7c\x9d\x92\x1c\x95\x71\xa9\x44\x27\x10\x7c\xe4\xd2\x97\x38\x83\x57\xb5\x1a\x1f\x0f\x51\xdc\xab\x5a\x8d\xef\x84\xd4\x03\xe5\xae\xfa\x7a\x2d\xd4\x2e\xde\x19\x9c\x8c\x8c\xb2\xc4\xc9\xcb\x70\x4e\xe3\xa1\x33\xda\xda\x18\x59\x72\x46\x3a\xfa\x06\xb7\x0b\x71\x0c\xff\x29\xcb\x5a\x9e\x5e\x5b\x30\x48\x58\x23\xe3\x94\x83\x2e\x0b\x73\xb7\x73\xca\x50\xca\x39\x2b\x35\xe7\xa5\x3d\x01\xb2\x2e\x46\xab\x81\xa1\x81\x5a\x2a\x49\xfc\xf7\xfd\xc7\x54\x10\x5e\x33\x65\xf2\x0d\xac\x0d\xd8\xd6\x67\x11\xcd\x36\x10\x4f\x2d\xa9\x5b\x77\x0e\x1e\x38\xec\x98\xea\x65\xbc\x29\x9c\xb3\x3f\x5d\xb9\xf8\x69\xf2\xa4\xd7\xb3\xb0\x9f\xea\x5c\xdc\x8c\x17\xd8\xe3\xac\x69\x0b\xc3\x8b\xbb\xa3\x5a\x73\xb9\x89\x54\xd3\x04\x3a\xd7\xa7\x16\xd2\x44\x5d\x2b\xc3\xdc\xf6\x68\xc1\xd9\xfd\xff\x4a\x1e\x7d\x61\xca\x4c\x39\x7a\x5f\x7a\x56\xc6\x8d\xe9\xa3\xdb\xbe\xeb\xa8\xd9\xdf\x03\x78\x59\x1e\x63\x47\x39\x72\xb9\x19\xeb\x1a\x4c\xfc\xd6\xf1\xbc\x33\x4b\x22\x17\xc1\xa2\x67\x6f\x40\x82\xa1\x08\x77\x5b\xf4\xc1\x43\x8e\x3d\xa9\x9b\x36\xa8\x78\x6b\x1e\xd4\x65\x57\x0e\xc9\x94\xc5\xef\xf2\xa3\xfc\x13\x00\x00\xff\xff\x80\x00\xd7\xf2\xde\x12\x00\x00")

func dataVideoUsherApiUsherJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiUsherJson,
		"data/video-usher-api-usher.json",
	)
}

func dataVideoUsherApiUsherJson() (*asset, error) {
	bytes, err := dataVideoUsherApiUsherJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-usher.json", size: 4830, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiVideoJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\xd0\xc1\x4a\xc4\x30\x10\x80\xe1\xf3\xe4\x29\x96\x39\x29\x2c\xcd\xbd\x77\xf1\xa8\xa0\x37\x91\x92\x6e\xc6\x6d\x64\x93\x09\xc9\xa4\x82\xcb\xbe\xbb\xc4\x56\x0f\xea\xd6\xa5\xc7\x32\x7f\xf3\x31\x73\x54\x80\x79\xdc\x61\xbb\xc1\x1d\x5b\x6a\x5e\x4b\x16\x17\x1a\x19\xf5\xe8\x2c\xb1\x2e\x79\xa0\xa4\x4d\x74\xd3\x37\x6e\x15\x60\xe2\x22\x94\xb1\xdd\x3c\x29\x80\xa3\x02\x00\x8c\x46\x84\x52\xa8\xcf\x68\xdb\x73\x14\xc7\x41\xef\x49\x74\xeb\xec\x55\xd3\xbe\x70\xf2\x46\xae\xeb\xdf\x00\x18\x8c\xa7\x5a\x7e\x85\xdd\x9e\x64\x1e\x79\x92\x81\x6d\x1d\xde\xde\x3c\xa2\x02\x38\x6d\xff\x34\x02\x5b\xd2\xb1\xf4\x07\x97\x87\x8e\x82\xe9\x0f\x74\xde\xa9\x71\xf7\x23\x5e\xe3\x95\x68\x8d\xd0\xe2\x4a\x9f\xd4\xd4\xfd\x12\xee\xef\x1e\x96\x88\x2c\x89\x8c\xd7\xa6\xc8\xc0\xc9\xbd\xd3\x59\x63\x0a\xbb\xef\x70\x25\x64\xf9\x2d\x2c\xee\x32\x3b\xb5\x5b\x49\x5c\x70\xb0\x19\xf9\xef\x64\x0a\x9e\xd5\x49\x7d\x04\x00\x00\xff\xff\x3d\x9c\xc2\x2d\xad\x02\x00\x00")

func dataVideoUsherApiVideoJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiVideoJson,
		"data/video-usher-api-video.json",
	)
}

func dataVideoUsherApiVideoJson() (*asset, error) {
	bytes, err := dataVideoUsherApiVideoJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-video.json", size: 685, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiVideoapiJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x94\x41\x8f\xdb\x20\x10\x85\xcf\xf0\x2b\x56\x9c\xb6\xd2\x2a\xdc\x73\xab\xd4\x55\x7b\x6b\xa5\xf6\x56\x55\x88\x98\x71\x4c\xd6\x61\x10\x0c\x8e\xda\xd5\xfe\xf7\x0a\xdb\x55\xeb\x26\x61\x17\xe7\x68\xfb\xbd\xf7\xc1\xf0\xcc\x33\x67\x22\x0e\x8d\xd8\xde\x89\x06\x0d\x6c\x0e\x29\x92\x75\x1b\x1a\xe4\x60\x0d\xa0\x4c\xb1\x83\x20\xb5\xb7\xd3\xb3\xf6\x56\x3c\x70\x26\x02\x26\x82\x28\xb6\x77\xdf\x39\x63\xcf\x9c\x31\x26\xbc\x26\x82\xe0\x72\x92\x0c\xc9\x39\xeb\xf6\xf7\x9b\x6d\x8b\xe1\xa8\xe9\x5d\x36\x31\x26\x9c\x3e\x42\x16\xcc\xdf\xe7\xb7\x47\xa0\x0e\x4d\x7e\xff\xe9\xf1\xfd\x07\xc1\x19\x7b\x79\xe0\x17\x73\x75\xa2\x0e\x83\xfd\xa5\xc9\xa2\x93\x01\x3c\x06\x52\xba\x21\x3b\xc0\x55\xd6\xc2\xa3\x16\x9e\x33\xfe\x97\xcf\x5f\xbf\xcd\xfc\x4b\xf8\xa6\xd3\xce\x41\xaf\x7c\x40\x0f\x81\x2c\x44\xd9\xdb\x48\x9b\xfb\x2b\xe8\x73\xbd\xca\xfa\x33\xec\xc7\xc7\x6a\xea\x00\xaa\xeb\xa3\x9a\xbf\xc5\xab\xbb\xbf\xb8\x84\xff\xcc\xb7\xaf\x27\x76\x78\x92\x5b\x6b\x6a\x96\x91\x3d\xb7\x93\x93\x37\x9a\xa0\x96\x3d\xb9\x6a\x8f\xdf\xec\xd0\x8f\xc5\xdb\x03\x15\x89\x7f\x84\x6a\x0f\xb5\x87\xdd\xf6\x78\x92\x83\x85\x53\x83\xc9\x51\x54\x2d\x06\xe5\xd0\x94\x77\x98\x4d\xea\x82\xa9\x76\x83\xb9\x14\x14\xb4\x8b\xf9\x2a\x90\x4f\xb6\xef\x8b\xd8\x85\x5c\x65\xf9\x6d\xc0\x00\xda\xfc\xac\x20\x8e\xfa\xdb\x90\xaf\x16\x77\x49\x5c\xd1\xd9\x25\xef\x0d\x75\x5d\x12\xd7\x35\xf5\x80\x3b\x19\xc1\x99\x22\xe8\x80\x3b\x95\x45\xb5\xe1\x63\x1d\x73\xe5\x62\x39\x3f\xeb\xd4\xa4\xab\x9c\xd9\x48\xc8\x37\x65\x39\x7b\xc5\x5d\x3a\x26\x53\xd0\x6d\x6b\x1b\x65\x5d\x8b\x65\xc2\xbf\xca\xda\x31\x45\x0a\xa0\x8f\x72\x97\xfa\xa7\xe9\x10\xaf\xa2\x26\xa5\xfa\xab\x5c\x89\x2a\x4e\x6c\x86\xac\x98\xd9\x9c\xfe\xea\xaf\x32\x13\x8a\xff\x08\x67\x3f\xf8\x0b\xff\x1d\x00\x00\xff\xff\xfc\xe4\xe2\x8f\x75\x08\x00\x00")

func dataVideoUsherApiVideoapiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiVideoapiJson,
		"data/video-usher-api-videoapi.json",
	)
}

func dataVideoUsherApiVideoapiJson() (*asset, error) {
	bytes, err := dataVideoUsherApiVideoapiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-videoapi.json", size: 2165, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiViewcountJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\x8e\xc1\x4a\xc5\x30\x10\x45\xd7\x33\x5f\xf1\x98\x95\xc2\xa3\xd9\x77\x27\x28\xb8\x53\xd0\x9d\x88\x84\x66\x4c\x23\x36\x29\x93\x49\x5c\x94\xfe\xbb\x84\x76\xa5\x16\x7c\xdb\x3b\x67\xee\xb9\x0b\x02\xe5\x3a\x50\x7f\xa2\x21\x39\xee\x3e\x4a\xd6\x10\x3b\xad\xa6\x06\xc7\xc9\x94\x3c\xb2\x18\x3b\x07\x53\x03\x7f\x0d\xa9\x44\xa5\x33\x02\x49\x2a\xca\x99\xfa\xd3\x0b\x02\x2c\x08\x00\x34\x5b\x55\x96\xd8\xaa\x8c\x94\x18\x43\xf4\x57\x5d\xff\x9e\x64\xb2\x7a\xdd\x9e\x00\x28\xda\x89\x1b\xb0\xdf\xf7\x74\x62\x1d\x93\x6b\xf9\xfd\xdd\xcd\x2d\x21\xc0\x7a\xfe\xb3\xb6\x6d\xb0\xde\x0b\x7b\xab\x49\x9c\x29\x73\x66\xd1\x43\xcb\x0f\xfc\x6d\xc3\x7f\x49\x1f\x1f\x9e\x9e\x2f\x90\x3a\xfe\x64\xe5\x7f\x4b\x37\xfc\x58\x8a\xf0\x8a\x2b\x7e\x07\x00\x00\xff\xff\xb0\x29\x67\xf3\x88\x01\x00\x00")

func dataVideoUsherApiViewcountJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiViewcountJson,
		"data/video-usher-api-viewcount.json",
	)
}

func dataVideoUsherApiViewcountJson() (*asset, error) {
	bytes, err := dataVideoUsherApiViewcountJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-viewcount.json", size: 392, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoshimJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x94\x4f\x6b\xdc\x30\x10\xc5\xef\xfe\x14\xc2\xe7\x10\xdd\xf7\x56\x88\x69\x0f\x85\x16\x9a\x9e\x4a\x11\x5a\x69\xb0\xd5\x58\x7f\xd0\x8c\x1c\x4c\xc8\x77\x2f\xf2\x2e\x34\xc4\x52\xb2\xae\xb3\x17\xc1\xae\x7e\x9a\xf7\xe6\x69\xe4\xa7\x86\xb1\x16\x27\xd5\x1e\x58\xab\xbc\x86\xdb\x3f\x09\xc9\xb8\x5b\x9a\xf8\x64\x34\xf8\xd3\x8a\x83\xb1\xed\x4d\x46\xa3\x4f\x04\xd8\x1e\xd8\xaf\x86\x31\xc6\x9e\x96\x95\xb1\x36\x48\x22\x88\x2e\x97\xe1\x64\x0d\x37\x2e\xff\x94\x23\xc7\x19\x09\xec\xb9\x18\x52\x04\x69\x85\xf6\x8f\x6e\x29\xb7\x1c\x75\xd2\x42\x3e\x17\x3c\x92\x28\x12\x16\x68\xf0\x3a\x33\xdf\xbf\xfd\xb8\x6f\x97\xbf\x9f\x6f\xea\x06\x64\x78\x61\x20\x21\x44\x1e\xa2\x0f\x10\xc9\x00\xae\x75\x7b\x20\x91\x21\x51\x82\xfe\x49\x7f\xee\x2e\x51\x4e\x34\x9c\xbb\x7c\x80\xb9\xac\x95\x19\x51\x60\xb6\x4a\xbd\x6c\x72\x34\x13\x70\x25\xc7\xf1\x28\xd5\x43\x25\xda\xcc\x88\x35\xb3\x2b\xdc\xd9\x27\x4a\x47\x10\x38\xc8\x68\x5c\xcf\x0f\x34\x07\xe0\x07\xa3\xb9\xf2\x36\x8c\x40\x50\x31\xf3\xea\xa0\x58\xe3\xbb\x7c\xc9\xa4\xcd\x71\x04\x61\x65\x6f\x94\x88\x80\xc1\x3b\x2c\x5d\xfe\x62\xe6\x5d\xfa\x1a\x5e\x72\x4a\x05\x3f\xa9\x66\xa7\xe8\xe6\xe7\xd5\x82\x39\x4d\xea\xc5\xb9\x6c\x1f\xd9\xd3\xa8\x4c\x06\x1e\x51\x28\x9f\x1c\x95\xc3\x28\x02\x7b\x12\x98\xbc\x46\x6e\x0d\xa2\x71\x7d\xb9\xed\x4c\x88\x15\xb1\xa7\xd7\x45\x33\x82\xf2\x51\xbf\xad\x5a\x60\x76\xeb\x16\xe7\xec\xac\x78\x6d\x99\xe5\x06\xcb\x32\xff\x77\x73\x95\x17\x5c\xd3\xd8\xfe\x5a\xeb\xbd\x68\xc8\x1f\xa8\x9a\xd4\x5d\xf7\xb5\xbb\xef\x2e\x12\x1b\x40\x8e\x34\x54\x9e\xdc\x7a\x7b\xe3\xcd\xc4\xe4\x5c\x75\xc8\x56\x9b\x1f\x55\x7c\x00\xa9\xdf\xaa\xfe\xa5\xfb\x74\xf7\x7e\x79\x0d\xc7\x54\x71\xfe\x6a\xab\xe4\xbb\x61\xec\x77\xf3\xdc\xfc\x0d\x00\x00\xff\xff\x5c\xc6\xfd\x30\xd3\x08\x00\x00")

func dataVideoshimJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoshimJson,
		"data/videoshim.json",
	)
}

func dataVideoshimJson() (*asset, error) {
	bytes, err := dataVideoshimJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/videoshim.json", size: 2259, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageApiJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x9b\xcd\x8e\xdb\x36\x10\xc7\xcf\xf6\x53\x04\xd6\x35\x88\x82\x04\xc8\xc1\xe7\x2e\x8a\x02\x45\x13\x20\xdb\x53\x51\x08\x34\x39\xb6\xd8\x95\x44\x81\xa4\xbc\xbb\x0d\xf2\xee\x85\x3e\x2c\x4b\x16\x29\x89\x43\xd6\x7b\xca\x66\xf9\x17\x7f\x1c\xcd\x68\x66\x44\x71\x7f\x6c\x37\x3b\x75\xa6\xbb\xfd\xbb\x1d\x15\x0c\x3e\xfc\x53\x29\xcd\x8b\x0f\xfa\x1c\x03\x3b\x41\x7c\xe6\x8a\x9c\x20\xa6\x39\xeb\x7e\xdc\xbd\xdf\x6e\x76\x52\x54\x1a\xd4\x6e\xff\xee\xaf\xed\x66\xf3\x63\xbb\xd9\x6c\x76\x25\xd1\x1a\x64\x51\xcf\x13\x93\x92\xc7\x95\x02\xa9\xe2\x7d\xfd\x4f\xc2\x59\x9c\x91\xe2\x54\x75\x97\x6f\x36\xbb\x82\xe4\x50\x4b\x7b\x65\x74\x23\xc8\x41\xa7\x82\xd5\x92\x6f\x7f\x3e\xee\xb6\x9b\xcd\xcf\xf7\x6b\x51\x47\x91\x65\xe2\x59\xc5\x27\x92\x83\x8a\x33\x7e\x36\x41\xeb\xc1\xa4\x53\x46\x03\xcd\x95\xfb\xeb\x83\x0f\x77\x09\xc9\x0b\x06\x2f\x81\x99\xf1\x9e\xb3\x25\xae\x4a\xc5\xf3\x1b\x60\xab\x92\x11\x1d\xdc\xb7\x2b\xc0\x0c\x94\x96\xe2\x75\x42\xfe\xe5\xe1\xf7\x87\xc7\x07\x1c\x9c\xa6\xa4\x28\x20\x33\xf9\xb8\x1b\xf2\x76\xf3\x51\x72\x28\x98\x4a\x79\xa9\xda\x55\x18\x58\x03\x4d\x34\xd4\xb8\x70\x2e\xa6\xc4\xfb\xcb\xca\x39\x8b\x4b\xd2\xfc\x4a\x48\x06\xd2\xc0\x6d\x87\xa3\xe1\xf0\xc0\xa3\x5f\xbf\xfb\x30\xab\x32\x13\xc4\xe4\xd4\x0e\x3a\x1a\x0f\x46\xa5\x95\xd2\x22\x4f\x9a\xff\xd9\xd9\x06\x55\xa0\x5b\x6d\x67\x62\xe3\x07\x05\xa3\x12\x8c\x0f\xa9\xdf\xcd\x35\x3f\xa4\xbd\x3f\x91\x79\x01\x4d\xf4\x4a\x08\x57\x6a\x4d\x93\x82\x55\x54\xdb\xb3\x80\x8a\xc6\x12\x9c\x03\x39\x8b\x09\xa5\xa0\x54\xa2\xc5\x13\x14\x73\x38\x83\xee\x6d\x99\x5f\xbf\x3d\xfe\xf6\xf5\x8f\xef\x2e\x5c\xc8\x0f\xc6\xac\xd3\x03\x87\x02\xb4\x75\xaa\x3a\x28\x2a\x79\xa9\xb9\x98\xb5\x2e\x90\x03\xcf\x1c\x9e\xe7\xad\x1a\x29\xee\xcf\x41\x38\x8a\xa6\x44\x27\xa5\x14\x25\x48\xcd\x8d\x0d\x4f\x0f\x35\x4b\xd1\x56\x96\x52\x1c\x79\x06\xc9\xa1\xfe\xdd\xac\xb5\x46\x25\x32\xb3\x71\x56\x57\xe2\xa4\xb1\xa5\x10\x9a\x1f\x39\x25\x75\xf8\x2c\x3f\x22\xcb\x97\x85\x48\xb6\xaf\xa2\xd2\x09\x14\x9a\xeb\x57\x63\xf6\xbb\x8e\x73\xb0\xf4\x81\xf7\x00\x07\x2f\x32\x03\x7c\x5c\xc0\xf3\x8a\x25\x5c\x55\x01\x4a\xea\x10\x0f\x8c\x9b\xca\xc1\x2d\x7f\x20\x0b\xbb\x00\xac\xdf\xef\xc4\x0e\x5d\xec\xdd\xe8\x81\x0a\xff\x60\x05\x67\xce\x40\x24\x39\x29\xc8\x09\x64\x93\x20\x24\x64\x44\x03\x4b\x9a\x11\x53\x4a\x1c\x5d\x12\x19\xe5\xde\x6e\x99\x2e\xab\x7d\xe6\x92\x94\x9f\xd2\x8c\x9f\x52\x53\x8c\x8e\x17\x66\xb9\xc0\xff\x71\x9d\xae\x0d\x5e\x4a\x21\x97\x57\x34\x92\x05\x5e\xc7\x22\x3c\x58\xb2\x1c\x9b\x5f\x12\xa5\x93\x83\x14\x84\x51\xa2\xf4\x72\xb8\x98\xf5\x81\xe3\xa5\xf7\xf9\xf2\x7a\x26\xd2\xc0\x4b\x91\xd0\x1b\xbb\xe2\x51\xba\xd5\x86\x0e\xd6\x27\x9e\x65\x89\xcb\x92\x2c\x17\xdc\x3b\x78\x83\xbe\x42\xba\xa1\x03\xd7\xfa\xb1\x3f\xcc\xb5\x7e\xbc\x80\x80\x95\xde\x90\xb9\xcc\xd5\xfe\x26\x6f\x05\xac\xf5\x93\x25\xe0\x12\xd7\xdd\xe8\x61\xeb\xbd\x3b\x3f\xd8\xab\xfe\x5c\x73\x8f\xbc\xc5\x4a\x03\xc9\x2d\x73\x37\x63\xd8\x89\xdb\x17\xbc\x98\x17\x47\x61\x98\x5a\x3f\x73\x4d\xd3\x4e\x14\x0d\x44\x08\x84\xed\xbd\x67\xcc\xc0\x6e\x46\x04\x80\xac\x7b\xa9\x3d\x0b\xb6\x6a\xc7\xa3\xd6\xf9\xee\xb0\xf4\xac\xe6\x75\x90\x11\x4d\x6c\xa0\x5b\x01\x8a\x92\x57\x75\x77\xa9\x25\xa1\x4f\xc6\x6a\x5e\x83\x0c\x1a\x9c\x45\x6d\xcb\x48\xca\x12\x88\x69\x13\xb5\xb5\xca\x20\x72\x49\x0c\x41\x69\xcb\x55\x28\x24\xce\x2d\x18\x6d\x0c\x74\x4a\x5d\x9a\xd8\x2b\x57\x9e\x05\xeb\xcc\xb6\x84\xd9\x65\x14\xdd\x8c\x68\x4e\x9f\xa0\xd9\x43\x62\x15\xd5\xfd\x1e\x5e\xce\x75\x02\xb9\xd0\x9c\x1a\xb7\xf1\x6e\xae\x8a\xcc\x57\x38\x85\xc4\xcc\x42\x0e\x84\x19\xbf\x6f\x5a\x56\x31\x94\x7b\x2f\x41\x42\x2e\xce\xe0\x72\x2f\xcc\x57\x38\x3a\xde\xb0\x94\x35\x37\x00\x57\xd9\x70\xb0\x50\x5f\x1e\xdb\x79\x4d\xf1\xdd\x8d\xf8\x7e\xd2\x5d\xb3\x7d\xd0\x7e\x2a\xf7\xde\x36\xb8\x12\x33\x71\xe2\x45\x72\x26\x19\x67\x44\x0b\x53\x47\xdf\x7d\x9d\x37\xea\x70\xcc\xf6\xdb\x28\xb0\x38\x15\x4a\xf3\xe2\x34\xd7\x5d\x5d\xb4\xc9\x58\x8b\x02\x5b\x8d\xf3\x0a\x11\xeb\xac\xd8\x70\x68\xbd\xea\xb0\x9d\x14\x20\x20\xae\x4c\x3b\x04\xf9\xd4\x1e\x81\xe8\x4a\x02\x4b\x6c\xc7\x22\xc6\x02\xf4\x6d\x13\xf2\xc0\xd5\xc5\x90\x4b\xd8\x18\x70\x8d\xae\xbb\x53\xd1\x8d\xee\xed\x78\xeb\xba\x83\x11\xd3\x76\x3f\x47\xc0\xa1\x08\x6d\x9d\x07\x09\x69\x57\xbc\x57\x14\x12\xcd\x75\x06\x89\x31\x26\x27\xe8\x10\x36\x06\xa0\x22\xec\xd5\xa2\x5c\x42\x5d\x25\x68\xfb\x90\x14\x84\x3d\x0a\x88\xa4\xe9\x12\x6c\xa4\x42\x5b\xe5\xc5\x72\xb7\x6d\x09\x14\x24\x77\x99\x93\xf0\xd8\x20\x5c\x2a\x76\xc5\xa0\xeb\xe2\x00\xb4\xd6\x9c\xf6\x67\xb4\x51\xed\xb9\xa0\x45\x07\xe1\x37\x24\x5b\x4c\xd7\x97\xd8\x30\x51\xfe\x9a\x8c\x25\xee\x96\x78\x20\x5c\x02\xba\x9b\xa3\xdf\x61\xb3\xf2\x02\xd9\x83\x07\xb9\x58\x95\x83\x26\x96\x5d\x95\xee\xee\x8d\x05\xee\x41\x8d\x27\xb8\xd8\xa1\xb4\x04\x92\x5b\xc3\x39\x1a\x8f\xbb\x3b\x05\x3b\xbf\x93\x0d\xb3\xb9\xd9\xb7\x00\xe0\x66\x77\x7a\x42\x44\x71\xe4\xa7\x4a\x12\xcb\x19\xa1\x2e\x6a\x0d\x2a\xc4\x43\x12\x80\x85\x88\xaf\xf9\xce\xce\xb3\x79\xf4\x61\x60\x6c\x59\xea\xc1\xfd\x9b\x7d\x7f\x12\xc6\xae\xc5\xc4\x19\x28\x19\xe0\x41\x2e\x56\xf1\xe2\x04\xe6\x6f\xdd\x2d\x63\x3c\xee\x6e\x0c\x76\x7e\x17\x1b\x24\x58\x8e\x2c\xb4\x88\xd1\x30\xa2\xc9\xc0\x4d\xef\x62\x00\xa9\x74\x2a\x24\xff\xd7\xb4\x5b\xd9\x42\x6e\x15\xee\x8e\x20\x47\x0d\x32\x59\x41\x32\xea\x10\x29\x34\xe3\x50\xe8\x99\xf7\xb6\xe8\x56\x81\xb0\x89\x52\x51\xd5\x53\x98\x3f\xae\x75\x06\x4d\x45\xce\xa4\xe6\x7e\x34\x6e\x82\x42\x73\x7a\xed\x59\xa7\x9d\x6d\x2d\x8a\x0c\x4a\x24\xb3\xd9\xe8\x9b\x87\x0d\x25\xee\xe1\x7d\x35\x6d\x36\x2e\xae\x76\x61\xc3\xa2\xfb\x13\x91\xc1\x6b\xfa\xed\x1f\x89\xa0\x5f\xa4\x5e\x0e\xe2\x65\xb1\x66\xd7\x22\xef\xf6\xa0\x21\xcd\xf4\x9c\x0d\xc4\xde\xd4\x2e\xfb\xa4\x01\xb4\x89\x7d\xae\x00\x34\x9c\x56\x86\xb5\x42\x29\xd3\x33\xd3\x4e\xac\xa6\x4f\xca\xda\xb5\x97\x92\x9f\x79\x06\xc6\x2f\x2f\xcd\xe4\xb7\x02\x77\x04\xe3\x8a\x8a\xa2\x00\xe3\x59\xff\x86\x31\x51\xb8\x43\xac\x59\xbf\x01\xe0\x6b\x0a\x13\x9a\x7c\x9a\x9e\xa8\x88\x73\xa2\x69\x6a\xfb\x04\xdd\x5c\x14\x4d\x24\x4e\x67\x48\x8c\x27\xc2\x3d\xfe\xa2\x45\xc5\x39\x29\x2d\x93\x0e\x46\x1c\xe7\x5c\x0e\x7d\xaa\xf0\x81\xdf\xec\x37\xf0\x33\xc4\x9a\x9c\x8c\x4b\xef\xc6\xa3\xc1\xb8\xeb\x83\xf5\xf9\xcb\xc7\x98\xb0\x44\x02\xe3\xd2\x1e\xa2\x9f\xbf\x7c\x8c\xa6\x2a\x4f\x56\xf2\x69\x1d\xad\xd7\x61\x78\x6b\xf2\x6c\xcd\xf3\x4d\xb5\xb9\x38\xf0\x0c\x16\x71\xad\xcc\x9b\x96\x92\x4c\x2c\xb2\xca\x8c\xe8\xa3\x90\xb9\x37\xed\x32\x51\x7b\x98\xe1\x4d\xa8\x27\x28\x40\x9a\x1b\x99\x1e\x78\xa3\x71\xca\x73\x23\xd8\x42\xe7\xd4\x03\x67\xfb\x26\x57\xe8\x6c\x99\xe8\x91\x7e\xa5\x42\x8a\xa7\xea\x7e\x0e\x6c\x68\xff\xb7\xe3\x1a\xc8\xbd\x1c\xd6\xc0\xee\xe1\x28\x63\xd3\xd9\x9c\x25\xa8\xeb\x29\xfa\x08\x44\x77\x68\xf0\xc3\xbe\x5e\x22\x31\xad\xdf\x7e\x76\x70\xe5\xdc\xf1\x9e\xd0\x3a\x5e\x96\x18\xfb\xaa\x78\x2a\xc4\xf3\x34\xae\xd6\x9c\x44\x92\x40\x45\x9e\x43\xc1\x8c\xbb\x28\xcd\x89\xa4\xa9\x64\x7a\xa7\xb6\x9b\xbf\xb7\x3f\xb7\xff\x05\x00\x00\xff\xff\x69\xca\x8e\x13\xc3\x40\x00\x00")

func dataVisageApiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageApiJson,
		"data/visage-api.json",
	)
}

func dataVisageApiJson() (*asset, error) {
	bytes, err := dataVisageApiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-api.json", size: 16579, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageKrakenJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x9b\x5d\x8f\xa3\x36\x17\xc7\xaf\xc9\xa7\x58\x85\xbb\x47\xab\xb5\xf4\x5c\xe6\xba\xa3\xaa\x52\xd5\x5d\x69\xb7\x57\x55\x85\x1c\x7c\x92\xb8\x03\x98\xda\x26\x33\xe9\x6a\xbf\x7b\x85\x31\x13\xc0\x2f\x80\xcd\xcc\xf4\x26\x89\xc6\x7f\xce\xcf\x3e\xc7\xc7\xf8\x6d\xbe\xef\x92\xbd\xb8\xe6\xfb\xc3\x87\x7d\xce\x08\x7c\xfa\xab\x11\x92\x56\x9f\xe4\x15\x01\x39\x03\xba\x52\x81\xcf\x80\xf2\x92\xe8\x9f\xfb\x8f\xbb\x64\xcf\x59\x23\x41\xec\x0f\x1f\xfe\xd8\x25\xc9\xf7\x5d\x92\x24\xfb\x1a\x4b\x09\xbc\x6a\xed\xa0\x47\x8e\x1f\xa1\x42\x42\x72\xc0\xa5\x40\x27\x56\x14\xec\x09\x48\xfb\x68\x92\xec\x2b\x5c\x42\x2b\x9b\xfc\xb9\x04\x79\x61\xa4\x2d\xf8\xf9\xe1\xdb\x7e\x97\x24\x3f\x3e\x2e\x31\x7e\xc8\x2f\xb8\xaa\xa0\x98\x18\xef\x8a\xa3\x4c\x5b\x2d\x8a\x30\x93\x8d\x00\x2e\xd0\xa1\x60\x67\x5a\xa1\xfc\x82\xe5\xc4\xb8\x96\x0d\x4a\x62\x01\xe8\x88\xc9\x19\xa6\x8d\x18\x70\xc6\x82\xb7\xc2\xa5\x75\x63\xb6\xf0\xcb\xef\x41\x48\x1d\x79\x67\x1f\xe8\x1e\xcc\xce\x20\xb3\xf6\xe1\x4c\xab\xb2\x2d\xbd\x6c\xd4\xc1\xe7\x08\xb3\x2a\xdb\xc6\x60\x5d\x65\xea\x66\x59\x65\x16\x45\xa7\x4f\x47\x0e\x39\x2b\x4b\xa8\x08\x10\x84\xaf\x98\x16\xf8\x58\x80\xbd\x57\x2c\x79\x24\x70\x50\x18\x98\x9c\xb0\xe7\x95\x2b\x91\x0c\x37\xf2\xf2\x7f\x94\x17\x14\x2a\xd9\x7a\x5e\xfd\xc8\x28\x41\x1c\x04\xc8\x4c\x40\xce\xc1\x91\xee\xe3\x67\x53\xcb\x03\x83\x28\x7c\xfe\xba\xba\x36\x8b\xa8\x39\x07\x2c\x4d\x7f\x87\xf0\x50\x05\x4f\x8b\x98\x77\x5d\xa4\xb7\xe9\x34\xbe\x76\x9e\xb8\xb0\xb7\x05\x36\x35\xb1\x3a\x75\x49\x2a\x69\x53\xed\x27\x54\x92\xe6\x77\x43\x76\x26\x87\xbf\x1b\x10\x32\xb5\x3c\x10\xd6\x58\x35\xa2\x2c\x42\x0e\x95\x81\x5d\xa7\xfd\x64\x9c\xfe\xb3\xbc\x8d\x43\x75\x58\x03\x71\x3b\xf1\x58\xc6\x1b\x28\x03\x1b\x58\xc0\x19\xdb\xdf\x4c\x86\x37\x07\xca\xb0\x86\x49\xf6\x08\xcb\x22\x37\x54\x46\x46\x0e\x4b\xca\xaa\xd9\xcc\xe8\xc1\x04\x84\xe4\xec\x66\xa0\x7f\x7a\xf8\xf5\xe1\xdb\xc3\x2c\xdc\xce\xe8\xbe\x52\x5a\x11\x78\x0e\x73\xe0\x11\x0b\x47\x0f\xd4\xb6\x07\x82\xc0\x97\xd2\x09\xb0\x6c\xb8\xf1\x46\x1a\xab\xd2\x89\x2a\x90\x25\x9a\xb2\xc4\xfc\xe6\x47\x8d\x45\x2b\x49\x67\x5c\x82\x40\x92\xd5\x76\x86\x2a\x4e\xef\xc5\x41\xd6\xfd\x1e\xeb\x10\x71\xfe\xa2\xd5\x19\x84\xeb\x45\xa9\x0b\x63\xba\xd5\x95\x12\x60\x1e\x37\x75\xe5\xe1\x7e\xd2\xf6\x1d\x2b\xac\x31\x24\x6e\xbd\xa5\x49\xce\x34\xd7\x90\xf0\x37\xad\x9e\xce\xaa\x19\x29\x25\xe8\x58\xb0\xfc\xd1\x11\x98\xae\x2c\x26\x2e\x56\x98\xbb\x71\x1a\xb8\x71\xe3\x66\x79\x31\xb3\x88\x30\x62\xe4\xe8\x3c\xa5\x76\x5d\x4e\xbc\x2c\x4c\xec\x6c\xad\xda\x30\x9e\x53\xae\xbb\xdd\x3d\x7b\xb3\xd0\xae\x47\x6f\x18\xe5\xf5\xf0\x8d\x03\x5e\x37\xe2\x92\x89\xe6\x28\x72\x4e\xeb\x76\x5e\xe0\x08\xb9\xa9\xdb\x30\xfa\xa6\x71\xb7\x1f\x2c\x15\xd9\xac\x2b\x44\xd6\x63\xc3\x7e\x11\x59\x93\x8d\x3b\xc9\xc2\x8a\x28\xf9\xc6\xa1\xf1\xb1\x62\xcd\xfb\x2c\x47\x76\xee\x77\xcc\xab\xf7\xcd\xa6\xf7\xce\xa1\xf7\xce\x9c\x23\x48\x7c\xdf\xab\xc2\x15\x61\xa5\xe3\xfd\x3d\x10\xa6\x23\xe1\x4a\xaf\x0f\x5f\x1d\xfd\x5b\xc2\xb9\xab\xab\x94\xe9\x58\x15\xc5\xeb\x26\xf3\xb3\xc0\xb1\x2c\x86\xa8\x76\xff\x78\x4e\x5d\x4b\xf4\x17\xa6\x21\x5c\xbb\x6a\x1e\x61\xbb\x48\x65\x8f\xe0\x58\xa2\xbd\x60\x0d\xe1\xfa\x3e\x34\x02\x77\xd3\xf4\x19\xe8\x48\x14\xe3\x5d\x20\x54\x32\x3e\x87\x1b\xab\x62\x78\xd2\x72\x6e\x33\xa5\xc9\xf0\x53\x1c\x63\x7f\xdd\x78\x9b\x39\x16\xdc\x5b\x0d\xc8\xf3\x15\x70\x8f\x4e\x5b\x0d\xcb\xf3\x73\xcb\x7b\xe7\x7d\x0b\x48\xcc\x10\xef\x3b\x37\xba\x13\xe2\x03\xf6\xba\x4d\xa8\xa5\x77\x6e\xd3\x2b\xe2\xc2\x21\x11\x94\x4c\xd2\xdc\xd9\xc9\x5b\x4d\xda\x6b\xb2\x38\x9f\xdd\x61\x19\x2d\xb1\xf7\x5c\x31\xb5\x2b\x43\x98\x6a\xc4\x5a\xd1\xc8\x58\xd6\xdc\x91\x69\x1a\x73\x3a\xd8\x53\x3c\xe6\xc3\xfb\x83\x00\xcc\xf3\xcb\xcc\xb2\xbe\x13\xa5\x13\x51\x18\x49\xed\xf5\x79\x31\x43\x45\x18\xc3\x7e\xec\x3f\xa6\x44\x5d\x02\xd0\x1c\xb5\x22\xf0\x52\x86\x8a\x30\xc6\x95\x11\x3f\x62\x20\x08\x22\x78\x8d\x47\x24\xbf\xe7\x0d\xae\x8a\xa2\x6d\xbb\x73\xa2\xb3\x1f\x9e\x14\x35\xbe\x95\xea\x90\x10\x9e\xdb\x22\x5c\x20\x0e\x79\xc3\x0b\xc7\x14\xcf\x90\xa7\x63\xf9\xda\xf9\xa5\x89\xaf\xf1\xad\x76\xcd\x6b\x4d\xfa\x48\x1d\x0f\x7f\x16\xac\x28\xf0\x52\xf8\x48\x1d\xed\xf7\xce\x5a\xbb\x14\x5b\xc7\x1f\x3c\xb1\x7a\x76\x6f\x9e\xff\xab\x59\x74\x26\x24\x96\x8d\x6b\x90\xd7\xa7\xc5\x16\xe5\x4a\x1f\xfc\xaf\xc6\xd2\x91\x93\xfa\xfc\x2a\x67\x5c\x64\x35\x87\x53\x41\xcf\x17\xf3\x7a\xc1\xe7\x2f\xdf\x7e\xf9\xfc\xdb\xd7\x2d\x48\x9c\x35\x92\x56\xe7\x0c\x38\x67\xdc\x00\xcd\x13\x70\x23\xd9\x85\x09\x89\x04\xc8\xd6\x90\xc3\x79\x2e\xd9\x4a\xcf\x85\xd2\xc2\x2f\x32\xbd\x98\x2a\xa8\x70\x5c\x0c\x19\x49\xde\x8e\x14\xe9\xc1\xa5\xed\x21\x50\x80\x65\xba\xbb\x74\x3d\x7b\x0f\x85\x27\xb5\xec\xa2\xd0\x55\x88\xa0\x25\x2d\xb0\x63\x87\xcf\xa1\x8a\xbf\xba\xf4\x9f\xbc\x40\x35\x2b\x0c\x3b\x57\xd4\xbe\x43\x87\x2b\x23\x99\xe3\x0d\xad\xae\xcf\x69\x61\x76\x65\x81\xc0\x13\x00\x41\x27\xc6\x1c\xe7\x22\xe3\xd2\x10\xdb\x1c\x72\xa8\x1c\x89\x60\x0a\x42\x08\x87\xf6\x53\xed\xeb\x33\xd7\xe1\xb5\xf2\xd5\xb0\x38\x9e\x83\x6a\xe0\x25\x15\xc2\xb9\xcf\xd1\xf1\x32\x53\xb6\x01\xfb\xd0\x7e\x79\x3b\x86\x12\x1c\x6f\x77\xcd\xab\x53\xbb\x71\xcc\x07\x5e\x3a\xa4\xf9\xd8\x88\x03\xce\xdd\x9b\x4b\x1d\x7e\xaa\x59\x3b\x7d\x89\xa9\x80\x76\x83\xbb\x0a\x9b\x78\xa1\x1b\x66\x7c\xbd\x7d\xa2\xd8\x30\xfc\x33\x70\xa5\xd2\x92\xd7\xf0\xbf\x9f\xae\xdd\xef\x6c\xfd\xa6\xde\x47\x07\xfd\x6b\x2e\x29\x7a\xd9\x2b\xe6\x85\xad\x4e\xef\x9f\x2c\x21\xb5\x9a\xf8\x2c\x3e\x93\xba\xeb\x53\x87\xf6\xab\xc5\x13\x90\x98\x3a\xb6\x69\x54\xea\x28\x7d\x36\x96\x05\xdd\xd8\x9a\x22\xdd\x07\xa3\xf7\xbb\xf0\xdb\xc3\xbd\x53\xf9\x41\x83\xe3\x56\x0e\xf2\x89\xb6\x7f\x53\x5b\x79\xb8\x71\x2c\x8a\x14\x4d\x2b\xb3\x81\x2a\x90\x95\xe3\xa2\x38\xe2\xfc\x71\x9e\x35\x51\x86\xb7\x6d\x16\x15\xdc\x4b\x47\xff\xc0\xe0\x99\xcc\x77\x59\xeb\x98\xc8\x2f\x4b\x59\x0b\x0a\x9d\x38\x85\xca\xb1\x4d\xa6\xda\xa7\x05\x51\x0b\x73\x1b\x78\xbe\x7b\x76\x57\x1f\x3a\xd9\x5b\x71\x95\x93\xbd\xe0\xe5\xae\x9e\x9c\x49\xe5\x1c\x08\x75\xcc\x88\xe7\xe4\x41\x17\x3a\xd1\x91\x4a\xee\xbc\x37\x6f\xd5\xac\x5d\xb6\x30\x22\xfa\xc5\x0a\xc2\x15\x2e\x6e\x92\xe6\x9e\x88\xb6\x4a\x25\x13\x34\xb0\x27\xd9\x89\xa8\xa0\x27\x90\xb4\xb4\x37\xf5\x05\xdd\xab\x22\xeb\x60\xfe\x83\xd1\x82\xa6\xf7\x47\x95\xaf\x86\x5e\xe0\x83\xbe\x0e\x1b\xf9\x61\x14\x0b\xc2\x9e\xaa\x82\x61\xcf\x40\xd9\x0a\x27\xaa\xb5\xf7\xfb\xa1\x3c\xba\x96\xe2\xa3\xb2\x98\x86\x94\x8c\x00\x57\xb7\xf9\xfd\x4d\x31\x74\x26\x74\x97\xfc\xb9\xfb\xf1\x6f\x00\x00\x00\xff\xff\x0a\x6c\x47\xd0\x5b\x3a\x00\x00")

func dataVisageKrakenJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageKrakenJson,
		"data/visage-kraken.json",
	)
}

func dataVisageKrakenJson() (*asset, error) {
	bytes, err := dataVisageKrakenJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-kraken.json", size: 14939, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV1Json = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x99\x5d\x8f\xa3\x36\x14\x86\xaf\xe1\x57\xac\xe0\xae\x5a\x2d\x4a\x2f\x73\xdd\xa8\xaa\x54\x75\x56\xda\xe9\x55\x55\x21\xc7\x9c\x21\xee\x00\xa6\xb6\x61\x27\x1d\xcd\x7f\xaf\xf8\xc8\x60\xf0\x81\xc4\x86\xd9\xdc\xcc\x44\x39\x6f\xde\x07\x9f\xe3\x8f\x03\xbc\xfa\x5e\x20\x6b\x1a\xec\x3f\x05\x94\x27\xf0\xe5\x9f\x4a\x2a\x56\x7c\x51\x75\x04\x49\x0a\x51\xcd\x24\x49\x21\xa2\x79\xd2\x7f\x0c\x3e\xfb\x5e\x20\x78\xa5\x40\x06\xfb\x4f\x7f\xf9\x9e\xf7\xea\x7b\x9e\x17\x94\x44\x29\x10\x45\xe3\x13\xd5\xbb\x48\x2a\x01\x24\x97\xd1\x13\xcf\x32\xfe\x1d\x92\xe6\x67\x9e\x17\x14\x24\x87\x46\x32\xf9\x3a\x07\x75\xe2\x49\x13\xf8\xf5\xf0\x18\xf8\x9e\xf7\xf6\xf9\x9a\xf1\x9e\x9e\x48\x51\x40\x36\x31\xee\xc2\xce\xb6\xa8\x9b\xb4\xb7\xe3\xa4\x52\xa7\x9f\x23\x9a\x31\x28\x54\x73\xb1\xed\x87\x98\x25\x91\x00\x09\x2a\x96\x40\x05\xa8\x09\xcd\xf8\x5d\x88\x88\x87\x8b\xf8\xfa\xf0\xcd\xea\x2a\xae\xd2\xa8\x00\xa2\x60\x35\x27\x2a\xe0\xfb\x55\xd6\xa0\x59\x91\x55\x36\x9d\x56\x26\x47\x9e\xf8\x8f\x01\x55\x65\x82\x26\xef\xcf\xdb\x50\xcd\x5f\x28\x14\xa3\x83\x89\xc9\x12\xf0\x6f\x05\x52\x85\x88\xd8\x7e\x70\x19\x4f\x59\x71\x15\xa5\xab\x1c\xa6\x44\xf3\x97\x0b\xf6\xdf\x6d\x63\xd2\x95\xf6\x03\x22\xcd\x96\x72\x9d\xa3\xa9\x1c\x06\x94\x41\x4a\xa6\x7b\x0e\x92\x35\x4d\x65\x3f\x10\xc5\x9f\xe1\x7a\x65\x74\xd5\x8a\xca\x10\xc5\x78\xb1\x38\xc3\x2f\xc0\x04\xa4\x12\xfc\x6c\x20\x7f\x39\xfc\x7e\x78\x3c\x2c\x42\x4d\xef\x7a\x17\xb2\x22\x81\x17\xfb\x24\x1d\x89\x44\x66\x53\xbd\x0b\xb5\x80\xc3\x79\xf2\x04\x44\x55\xc2\x38\xa8\x06\x45\x38\x51\x38\x30\x64\x95\xe7\x44\x9c\xe7\x11\x63\x81\x05\x21\x25\x39\xc8\x48\xf1\xd2\xf4\x6e\x43\xe1\x10\xb2\x76\x9d\xcf\x4c\x67\xed\x9e\x17\x56\xa4\x20\xb1\x83\xa9\x0f\xb8\x4e\x91\x9a\x25\xc0\x67\xd2\xd1\xc5\xdc\xf2\xd1\xfb\xce\xf4\x34\x83\xb9\x7b\x77\xd3\x13\xd0\xe5\xd8\x9b\xbb\x9d\x68\x95\x04\x21\xa3\x7d\xf3\xaf\xe9\x42\x8e\x19\xa7\xcf\x48\xe2\xbb\xef\x5d\xf3\x8e\x42\xf0\xc1\xf4\xa0\x0d\x07\xb3\xc8\x71\x3d\x9d\xed\x49\x2b\x76\xc9\x29\xad\x9b\x46\x32\xea\x3b\x5d\xa4\x5c\xbd\x62\xa3\x7a\x4d\x79\xf8\x38\x2f\xcc\x4d\x4a\x67\x87\xdc\xa8\x8a\x76\xd0\x0d\x0b\x5a\x56\xf2\x14\xcb\xea\x28\xa9\x60\x65\x73\xee\x22\x25\x35\x35\x1b\x55\xd7\x34\xc6\xc7\x8d\x5c\xc0\x26\xa5\x5e\xc1\xdf\xa8\xee\x2b\xae\x60\xc3\x49\x70\xc3\x05\xb4\xd2\x0d\x4b\x30\xc7\xf8\x30\xdb\x35\x05\x9b\xf3\x5c\xb1\x0a\xee\xb0\xf0\xee\xb3\xdc\xee\xb5\xc8\xee\xb5\xb4\x8e\xa0\xc8\x7b\x77\x2d\x48\x91\xf0\x1c\x39\x98\x35\x51\x38\x12\x59\x64\x57\x3f\x2b\x2e\x47\x83\x89\xba\xa8\xc2\xb1\xc2\x99\xd3\x75\xd6\x8b\xa0\xb1\xc4\x95\x44\x79\x9e\x83\xa0\x0c\xbb\xb7\x7d\x67\x19\x22\x9b\xdb\xce\x11\xae\xab\x46\xfc\x0c\xc8\xbd\xd0\x3b\xce\x10\xd9\xcd\x8d\x11\xb0\xeb\x9d\x17\x60\x23\x81\x6b\x16\x21\x61\x8a\x8b\x25\xcc\x58\xe1\xca\x51\xc8\xa3\x4a\x9d\xa2\xdc\x1e\x5a\x0e\x8c\xfe\x93\x71\x5c\x21\x77\xae\x5b\x6c\x98\xd7\xc1\xf8\x6e\xb2\xc5\xb6\xb9\xdc\x04\x0e\x93\xf1\x23\xcd\x5d\xb7\x5e\xfc\x11\xb8\xee\xbc\xae\x20\x1f\x73\xc9\xa5\x9a\xed\x1e\x2e\x51\xf7\x74\xab\x08\x72\xae\x18\x45\x27\x6b\x13\x0f\x2f\xf1\xd8\x3d\x37\x03\x24\x66\x39\x49\x67\x36\x68\x1d\xa5\xab\x6c\x59\xed\xce\x72\xe3\xa0\xd6\x30\x8e\x24\x99\x1f\xca\x28\xe8\xe0\x3e\x63\xeb\x56\x67\x09\x44\xd0\xd3\xc2\x7d\x71\x27\x08\x27\x02\x7b\x42\xfb\x80\x6b\xd6\x5e\x8f\xda\x7b\xe3\x6f\x9c\x06\x77\xe7\x77\x4f\xbd\x7f\xdb\x35\xcf\xba\xeb\x51\x7b\xef\x9a\x27\xf3\xd6\x5a\xd0\xda\x79\xd6\xd4\x71\xb1\xce\x9c\x94\xed\xd7\xab\x3c\xf1\x39\xdd\xf9\xba\x4d\xea\x92\x9c\xf3\xf6\x6d\x13\xbc\x34\x5f\x93\x2c\x12\x40\x2b\x91\x21\x2d\x92\x21\x0d\xc7\x52\x9b\xbe\xcc\xc4\x96\xe4\x5c\x62\x7d\xa0\x49\x1d\x29\xd7\x41\x5f\x24\xcf\x32\x72\x0b\x74\xa4\x5c\x95\xdf\xce\xa9\xb9\x1d\xb9\x9d\xab\xa9\xad\xba\x5f\xf3\x45\x70\xdb\x71\xc6\x52\x11\x55\x61\x9b\x6e\xff\x5a\x11\x51\x59\x8c\xf9\xa7\x92\x28\x64\x4d\xd5\xbb\x90\x72\x21\xe3\x52\xc0\x53\xc6\xd2\x93\xf9\x6e\xf9\xe1\xeb\xe3\x6f\x0f\x7f\x7c\x73\x75\x17\xbc\x52\xac\x48\x63\x10\x82\x0b\xc3\xbc\x75\xf5\xbd\xbf\xfd\x37\xff\xff\x00\x00\x00\xff\xff\x37\x8f\x2d\xaf\x7e\x20\x00\x00")

func dataVisageV1JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV1Json,
		"data/visage-v1.json",
	)
}

func dataVisageV1Json() (*asset, error) {
	bytes, err := dataVisageV1JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v1.json", size: 8318, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV2Json = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x99\x4d\x8f\xab\x36\x14\x86\xd7\xf0\x2b\xae\x60\x57\x5d\x5d\xa4\x2c\xb3\x6e\x54\x55\xaa\x3a\x57\xba\xd3\x55\x55\x21\xc7\x9c\x21\xee\x00\xa6\xb6\x61\x26\x1d\xcd\x7f\xaf\xf8\xc8\x60\xf0\x81\xc4\x86\x69\x36\x33\x51\xce\x9b\xf7\xc1\xe7\xf8\xe3\x00\x6f\xbe\x17\xc8\x9a\x06\xfb\x2f\x01\xe5\x09\x7c\xfb\xbb\x92\x8a\x15\xdf\x54\x1d\x41\x92\x42\x54\x33\x49\x52\x88\x68\x9e\xf4\x1f\x83\xaf\xbe\x17\x08\x5e\x29\x90\xc1\xfe\xcb\x9f\xbe\xe7\xbd\xf9\x9e\xe7\x05\x25\x51\x0a\x44\xd1\xf8\x44\xf5\x2e\x92\x4a\x00\xc9\x65\xf4\xc4\xb3\x8c\xbf\x40\xd2\xfc\xcc\xf3\x82\x82\xe4\xd0\x48\x26\x5f\xe7\xa0\x4e\x3c\x69\x02\xbf\x1c\x1e\x03\xdf\xf3\xde\xbf\x5e\x33\xde\xd3\x13\x29\x0a\xc8\x26\xc6\x5d\xd8\xd9\x16\x75\x93\xf6\x76\x9c\x54\xea\xb4\x8b\x68\xc6\xa0\x50\xcd\xc5\xb6\x1f\x62\x96\x44\x02\x24\xa8\x58\x02\x15\xa0\x26\x34\xe3\x77\x21\x22\x1e\x2e\xe2\xfb\xc3\x0f\xab\xab\xb8\x4a\xa3\x02\x88\x82\xd5\x9c\xa8\x80\x97\xab\xac\x41\xb3\x22\xab\x6c\x3a\xad\x4c\x8e\x3c\xf1\xff\x07\x54\x95\x09\x9a\xbc\x3f\x6e\x43\x35\x7f\xa1\x50\x8c\x0e\x26\x26\x4b\xc0\x3f\x15\x48\x15\x22\x62\xfb\xc1\x65\x3c\x65\xc5\x55\x94\xae\x72\x98\x12\xcd\x5f\x2e\xd8\xbf\xb7\x8d\x49\x57\xda\x0f\x88\x34\x5b\xca\x75\x8e\xa6\x72\x18\x50\x06\x29\x99\xee\x39\x48\xd6\x34\x95\xfd\x40\x14\x7f\x86\xeb\x95\xd1\x55\x2b\x2a\x43\x14\xe3\xc5\xe2\x0c\xbf\x00\x13\x90\x4a\xf0\xb3\x81\xfc\xf9\xf0\xdb\xe1\xf1\xb0\x08\x35\xbd\xeb\x5d\xc8\x8a\x04\x5e\xed\x93\x74\x24\x12\x99\x4d\xf5\x2e\xd4\x02\x0e\xe7\xc9\x13\x10\x55\x09\xe3\xa0\x1a\x14\xe1\x44\xe1\xc0\x90\x55\x9e\x13\x71\x9e\x47\x8c\x05\x16\x84\x94\xe4\x20\x23\xc5\x4b\xd3\xbb\x0d\x85\x43\xc8\xda\x75\x3e\x33\x9d\xb5\x7b\x5e\x58\x91\x82\xc4\x0e\xa6\x3e\xe0\x3a\x45\x6a\x96\x00\x9f\x49\x47\x17\x73\xcb\x47\xef\x3b\xd3\xd3\x0c\xe6\xee\xdd\x4d\x4f\x40\x97\x63\x6f\xee\x76\xa2\x55\x12\x84\x8c\xf6\xcd\xbf\xa6\x0b\x39\x66\x9c\x3e\x23\x89\xef\xbe\x77\xcd\x3b\x0a\xc1\x07\xd3\x83\x36\x1c\xcc\x22\xc7\xf5\x74\xb6\x27\xad\xd8\x25\xa7\xb4\x6e\x1a\xc9\xa8\xef\x74\x91\x72\xf5\x8a\x8d\xea\x35\xe5\xe1\xe3\xbc\x30\x37\x29\x9d\x1d\x72\xa3\x2a\xda\x41\x37\x2c\x68\x59\xc9\x53\x2c\xab\xa3\xa4\x82\x95\xcd\xb9\x8b\x94\xd4\xd4\x6c\x54\x5d\xd3\x18\x1f\x37\x72\x01\x9b\x94\x7a\x05\x7f\xa3\xba\xaf\xb8\x82\x0d\x27\xc1\x0d\x17\xd0\x4a\x37\x2c\xc1\x1c\xe3\xd3\x6c\xd7\x14\x6c\xce\x73\xc5\x2a\xb8\xc3\xc2\xbb\xcf\x72\xbb\xd7\x22\xbb\xd7\xd2\x3a\x82\x22\x1f\xdd\xb5\x20\x45\xc2\x73\xe4\x60\xd6\x44\xe1\x48\x64\x91\x5d\xfd\xac\xb8\x1c\x0d\x26\xea\xa2\x0a\xc7\x0a\x67\x4e\xd7\x59\x2f\x82\xc6\x12\x57\x12\xe5\x79\x0e\x82\x32\xec\xde\xf6\x83\x65\x88\x6c\x6e\x3b\x47\xb8\xae\x1a\xf1\x33\x20\xf7\x42\x1f\x38\x43\x64\x37\x37\x46\xc0\xae\x77\x5e\x80\x8d\x04\xae\x59\x84\x84\x29\x2e\x96\x30\x63\x85\x2b\x47\x21\x8f\x2a\x75\x8a\x72\x7b\x68\x39\x30\xfa\x4f\xc6\x71\x85\xdc\xb9\x6e\xb1\x61\x5e\x07\xe3\xbb\xc9\x16\xdb\xe6\x72\x13\x38\x4c\xc6\xcf\x34\x77\xdd\x7a\xf1\x47\xe0\xba\xf3\xba\x82\x7c\xce\x25\x97\x6a\xb6\x7b\xb8\x44\xdd\xd3\xad\x22\xc8\xb9\x62\x14\x9d\xac\x4d\x3c\xbc\xc4\x63\xf7\xdc\x0c\x90\x98\xe5\x24\x9d\xd9\xa0\x75\x94\xae\xb2\x65\xb5\x3b\xcb\x8d\x83\x5a\xc3\x38\x92\x64\x7e\x28\xa3\xa0\x83\xfb\x8c\xad\x5b\x9d\x25\x10\x41\x4f\x0b\xf7\xc5\x9d\x20\x9c\x08\xec\x09\xed\x03\xae\x59\x7b\x3d\x6a\xef\x8d\xbf\x71\x1a\xdc\x9d\xdf\x3d\xf5\xfe\x6d\xd7\x3c\xeb\xae\x47\xed\xbd\x6b\x9e\xcc\x5b\x6b\x41\x6b\xe7\x59\x53\xc7\xc5\x3a\x73\x52\xb6\x5f\xaf\xf2\xc4\xe7\x74\xe7\xeb\x36\xa9\x4b\x72\xce\xdb\xb7\x4d\xf0\xda\x7c\x4d\xb2\x48\x00\xad\x44\x86\xb4\x48\x86\x34\x1c\x4b\x6d\xfa\x32\x13\x5b\x92\x73\x89\xf5\x81\x26\x75\xa4\x5c\x07\x7d\x95\x3c\xcb\xc8\x2d\xd0\x91\x72\x55\x7e\x3b\xa7\xe6\x76\xe4\x76\xae\xa6\xb6\xea\x7e\xcd\x17\xc1\x6d\xc7\x19\x4b\x45\x54\x85\x6d\xba\xfd\x6b\x45\x44\x65\x31\xe6\x9f\x4a\xa2\x90\x35\x55\xef\x42\xca\x85\x8c\x4b\x01\x4f\x19\x4b\x4f\xe6\xbb\xe5\x87\xef\x8f\xbf\x3e\xfc\xfe\xc3\xd5\x5d\xf0\x4a\xb1\x22\x8d\x41\x08\x2e\x0c\xf3\xd6\xd5\xf7\xfe\xf2\xdf\xfd\xff\x02\x00\x00\xff\xff\x5b\xa6\x95\x6d\x7e\x20\x00\x00")

func dataVisageV2JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV2Json,
		"data/visage-v2.json",
	)
}

func dataVisageV2Json() (*asset, error) {
	bytes, err := dataVisageV2JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v2.json", size: 8318, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV3Json = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x99\x5d\x8f\xa3\x36\x14\x86\xaf\xe1\x57\xac\xe0\xae\x5a\x2d\x52\x73\x97\xeb\x46\x55\xa5\xaa\xb3\xd2\x4e\xaf\xaa\x0a\x39\xe6\x0c\x71\x07\x30\xb5\x0d\x3b\xe9\x68\xfe\x7b\xc5\x47\x06\x83\x0f\x24\x36\xcc\xe6\x66\x26\xca\x79\xf3\x3e\xf8\x1c\x7f\x1c\xe0\xd5\xf7\x02\x59\xd3\x60\xff\x29\xa0\x3c\x81\x2f\xff\x54\x52\xb1\xe2\x8b\xaa\x23\x48\x52\x88\x6a\x26\x49\x0a\x11\xcd\x93\xfe\x63\xf0\xd9\xf7\x02\xc1\x2b\x05\x32\xd8\x7f\xfa\xcb\xf7\xbc\x57\xdf\xf3\xbc\xa0\x24\x4a\x81\x28\x1a\x9f\xa8\xde\x45\x52\x09\x20\xb9\x8c\x9e\x78\x96\xf1\xef\x90\x34\x3f\xf3\xbc\xa0\x20\x39\x34\x92\xc9\xd7\x39\xa8\x13\x4f\x9a\xc0\xaf\x87\xc7\xc0\xf7\xbc\xb7\xcf\xd7\x8c\xf7\xf4\x44\x8a\x02\xb2\x89\x71\x17\x76\xb6\x45\xdd\xa4\xbd\x1d\x27\x95\x3a\xfd\x1c\xd1\x8c\x41\xa1\x9a\x8b\x6d\x3f\xc4\x2c\x89\x04\x48\x50\xb1\x04\x2a\x40\x4d\x68\xc6\xef\x42\x44\x3c\x5c\xc4\xd7\x87\x6f\x56\x57\x71\x95\x46\x05\x10\x05\xab\x39\x51\x01\xdf\xaf\xb2\x06\xcd\x8a\xac\xb2\xe9\xb4\x32\x39\xf2\xc4\x7f\x0c\xa8\x2a\x13\x34\x79\x7f\xde\x86\x6a\xfe\x42\xa1\x18\x1d\x4c\x4c\x96\x80\x7f\x2b\x90\x2a\x44\xc4\xf6\x83\xcb\x78\xca\x8a\xab\x28\x5d\xe5\x30\x25\x9a\xbf\x5c\xb0\xff\x6e\x1b\x93\xae\xb4\x1f\x10\x69\xb6\x94\xeb\x1c\x4d\xe5\x30\xa0\x0c\x52\x32\xdd\x73\x90\xac\x69\x2a\xfb\x81\x28\xfe\x0c\xd7\x2b\xa3\xab\x56\x54\x86\x28\xc6\x8b\xc5\x19\x7e\x01\x26\x20\x95\xe0\x67\x03\xf9\xcb\xe1\xf7\xc3\xe3\x61\x11\x6a\x7a\xd7\xbb\x90\x15\x09\xbc\xd8\x27\xe9\x48\x24\x32\x9b\xea\x5d\xa8\x05\x1c\xce\x93\x27\x20\xaa\x12\xc6\x41\x35\x28\xc2\x89\xc2\x81\x21\xab\x3c\x27\xe2\x3c\x8f\x18\x0b\x2c\x08\x29\xc9\x41\x46\x8a\x97\xa6\x77\x1b\x0a\x87\x90\xb5\xeb\x7c\x66\x3a\x6b\xf7\xbc\xb0\x22\x05\x89\x1d\x4c\x7d\xc0\x75\x8a\xd4\x2c\x01\x3e\x93\x8e\x2e\xe6\x96\x8f\xde\x77\xa6\xa7\x19\xcc\xdd\xbb\x9b\x9e\x80\x2e\xc7\xde\xdc\xed\x44\xab\x24\x08\x19\xed\x9b\x7f\x4d\x17\x72\xcc\x38\x7d\x46\x12\xdf\x7d\xef\x9a\x77\x14\x82\x0f\xa6\x07\x6d\x38\x98\x45\x8e\xeb\xe9\x6c\x4f\x5a\xb1\x4b\x4e\x69\xdd\x34\x92\x51\xdf\xe9\x22\xe5\xea\x15\x1b\xd5\x6b\xca\xc3\xc7\x79\x61\x6e\x52\x3a\x3b\xe4\x46\x55\xb4\x83\x6e\x58\xd0\xb2\x92\xa7\x58\x56\x47\x49\x05\x2b\x9b\x73\x17\x29\xa9\xa9\xd9\xa8\xba\xa6\x31\x3e\x6e\xe4\x02\x36\x29\xf5\x0a\xfe\x46\x75\x5f\x71\x05\x1b\x4e\x82\x1b\x2e\xa0\x95\x6e\x58\x82\x39\xc6\x87\xd9\xae\x29\xd8\x9c\xe7\x8a\x55\x70\x87\x85\x77\x9f\xe5\x76\xaf\x45\x76\xaf\xa5\x75\x04\x45\xde\xbb\x6b\x41\x8a\x84\xe7\xc8\xc1\xac\x89\xc2\x91\xc8\x22\xbb\xfa\x59\x71\x39\x1a\x4c\xd4\x45\x15\x8e\x15\xce\x9c\xae\xb3\x5e\x04\x8d\x25\xae\x24\xca\xf3\x1c\x04\x65\xd8\xbd\xed\x3b\xcb\x10\xd9\xdc\x76\x8e\x70\x5d\x35\xe2\x67\x40\xee\x85\xde\x71\x86\xc8\x6e\x6e\x8c\x80\x5d\xef\xbc\x00\x1b\x09\x5c\xb3\x08\x09\x53\x5c\x2c\x61\xc6\x0a\x57\x8e\x42\x1e\x55\xea\x14\xe5\xf6\xd0\x72\x60\xf4\x9f\x8c\xe3\x0a\xb9\x73\xdd\x62\xc3\xbc\x0e\xc6\x77\x93\x2d\xb6\xcd\xe5\x26\x70\x98\x8c\x1f\x69\xee\xba\xf5\xe2\x8f\xc0\x75\xe7\x75\x05\xf9\x98\x4b\x2e\xd5\x6c\xf7\x70\x89\xba\xa7\x5b\x45\x90\x73\xc5\x28\x3a\x59\x9b\x78\x78\x89\xc7\xee\xb9\x19\x20\x31\xcb\x49\x3a\xb3\x41\xeb\x28\x5d\x65\xcb\x6a\x77\x96\x1b\x07\xb5\x86\x71\x24\xc9\xfc\x50\x46\x41\x07\xf7\x19\x5b\xb7\x3a\x4b\x20\x82\x9e\x16\xee\x8b\x3b\x41\x38\x11\xd8\x13\xda\x07\x5c\xb3\xf6\x7a\xd4\xde\x1b\x7f\xe3\x34\xb8\x3b\xbf\x7b\xea\xfd\xdb\xae\x79\xd6\x5d\x8f\xda\x7b\xd7\x3c\x99\xb7\xd6\x82\xd6\xce\xb3\xa6\x8e\x8b\x75\xe6\xa4\x6c\xbf\x5e\xe5\x89\xcf\xe9\xce\xd7\x6d\x52\x97\xe4\x9c\xb7\x6f\x9b\xe0\xa5\xf9\x9a\x64\x91\x00\x5a\x89\x0c\x69\x91\x0c\x69\x38\x96\xda\xf4\x65\x26\xb6\x24\xe7\x12\xeb\x03\x4d\xea\x48\xb9\x0e\xfa\x22\x79\x96\x91\x5b\xa0\x23\xe5\xaa\xfc\x76\x4e\xcd\xed\xc8\xed\x5c\x4d\x6d\xd5\xfd\x9a\x2f\x82\xdb\x8e\x33\x96\x8a\xa8\x0a\xdb\x74\xfb\xd7\x8a\x88\xca\x62\xcc\x3f\x95\x44\x21\x6b\xaa\xde\x85\x94\x0b\x19\x97\x02\x9e\x32\x96\x9e\xcc\x77\xcb\x0f\x5f\x1f\x7f\x7b\xf8\xe3\x9b\xab\xbb\xe0\x95\x62\x45\x1a\x83\x10\x5c\x18\xe6\xad\xab\xef\xfd\xed\xbf\xf9\xff\x07\x00\x00\xff\xff\x7f\x41\x02\x2c\x7e\x20\x00\x00")

func dataVisageV3JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV3Json,
		"data/visage-v3.json",
	)
}

func dataVisageV3Json() (*asset, error) {
	bytes, err := dataVisageV3JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v3.json", size: 8318, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV4Json = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x5b\x4b\x8f\xdb\x36\x10\x3e\xdb\xbf\x22\xb0\x6e\x45\x10\x02\xc5\x9e\x7c\xee\xa2\x28\x50\x34\x01\x92\x9e\x8a\x42\xa0\xc5\xb1\xcd\xae\x24\xaa\x24\xa5\xcd\x36\xc8\x7f\x2f\x44\xc9\xab\x07\x87\x92\x48\xc9\xdd\x5e\x76\x37\x9e\xcf\xdf\xc7\x99\xe1\x63\xf8\xc8\xb7\xfd\xee\xa0\xaa\xe4\x70\x7c\x77\x48\x04\x83\x0f\x7f\x95\x4a\xf3\xfc\x83\xae\x08\xb0\x0b\x90\x8a\x2b\x7a\x01\x92\x64\xac\xfd\xf3\xf0\x7e\xbf\x3b\x48\x51\x6a\x50\x87\xe3\xbb\x3f\xf6\xbb\xdd\xb7\xfd\x6e\xb7\x3b\x14\x54\x6b\x90\x79\xcd\x43\xaa\x07\xa2\xb4\x04\x9a\x29\x72\x16\x69\x2a\x9e\x81\xd5\x5f\xdb\xed\x0e\x39\xcd\xa0\x86\x8c\x3e\xce\x40\x5f\x05\xab\x0d\x3f\x3f\x7e\x39\xec\x77\xbb\xef\xef\xe7\x88\x8f\xc9\x95\xe6\x39\xa4\x23\xe2\xc6\x1c\x4c\x8b\xb2\x29\x7f\xba\x52\x81\x54\xe4\x98\x8a\x0b\xcf\x49\x72\xa5\x7a\x44\x5c\x3d\xf4\x3f\x5d\x43\x4c\x4e\x94\x5d\x60\xdc\xf0\x96\x7f\x68\xbc\xb7\x4c\x54\x94\xb6\x47\x9f\x7e\xf7\x96\x6a\x33\xeb\xcc\x71\xf5\x10\x5f\x40\xc7\xf5\x17\xe3\x16\x11\x6f\x15\x4d\x4b\xdb\xe5\xb8\xdd\x84\xed\x62\xbd\xbc\x11\x45\xb9\xac\x11\xb3\x59\xb8\x0d\x2b\x09\x89\xc8\x32\xc8\x19\x30\x42\x2b\xca\x53\x7a\x4a\xc1\xce\xfa\x12\x78\xc0\xa0\xee\xd1\x8d\x34\xa7\x51\x1e\x52\x82\x96\xfa\xfa\x23\x49\x52\x0e\xb9\xae\x23\x6c\xfe\x88\x39\x23\x12\x14\xe8\x58\x41\x22\x01\x19\xae\xc3\xef\x45\x08\xb8\x17\xed\x8f\x9f\xbd\x5a\x31\xab\x96\x48\xa0\xda\x8e\xab\xaf\x0e\xc9\xe1\x79\x56\xab\xc3\xac\x88\x2a\x1f\xe7\xcf\xd6\x51\x57\xf1\xdf\x08\x95\x05\x43\x83\x37\x37\x24\x5a\x9a\xfa\x27\xe4\x9a\x27\x1d\x89\xad\x25\xe1\xef\x12\x94\x8e\x10\xb0\xbf\x73\x66\x26\x98\x95\xea\xa3\x02\xba\x44\xfd\x53\x48\xfe\xcf\x32\x9f\xfa\x48\x7f\x87\x68\xbd\xd8\xcf\xeb\xf4\x50\x01\x0e\xa5\x70\xa1\xf6\x4a\x61\x45\xad\x87\xf2\x77\x44\x8b\x27\x98\xcf\x4c\x1f\xb5\x22\x33\x54\x73\x91\x4f\xf6\xf0\x9b\x20\x03\xa5\xa5\x78\xb1\x24\x7f\x7a\xfc\xf5\xf1\xcb\xe3\xa4\xa8\xcd\x5d\x3d\x44\x3c\x67\xf0\xd5\x3f\x48\x27\xaa\x90\xde\x54\x3d\x44\x3d\x43\xc0\xa2\x70\x06\xaa\x4b\x69\xad\x08\x1d\x22\x1a\x21\x02\x34\x54\x99\x65\x54\xbe\xb8\x25\x86\x00\x0f\x85\x0b\xcd\x40\x11\x2d\x0a\x9b\xdb\x98\xa2\xce\xe4\xcd\xea\x8e\x4c\x43\x1d\x1e\x17\x9e\x5f\x40\x61\x0b\x53\x6b\x08\xed\x22\x15\x67\x20\x1c\xe1\x68\x6c\x61\xf1\x68\x79\x1d\xbb\x8d\x8e\x3c\x7c\xdf\xd1\x2a\xa0\xc3\xb1\x25\x0f\x5b\xd1\xda\xf2\xcf\x54\x71\x9c\x91\x53\x2a\x92\x27\x24\xf0\xcd\xe7\xa1\x71\x47\x45\x70\x67\x5a\xa1\x0d\x9d\x99\xd4\x09\x5d\x9d\xfd\x95\x56\xcc\x92\x63\xb5\xa6\x1b\xa9\xd7\x42\xdd\xd6\x6c\x11\x1b\xe5\x6b\xac\x87\xfb\x79\xd3\xdc\x24\x75\x7e\x92\x1b\x65\xd1\x4f\x74\xc3\x84\x16\xa5\xba\xc6\xaa\x3c\xa9\x44\xf2\xa2\x5e\x77\x91\x94\xda\x98\x8d\xb2\x6b\x13\xe3\x7e\x23\x0d\xd8\x24\xd5\x2b\xf4\x37\xca\xfb\x8a\x16\x6c\xd8\x09\x16\x34\xc0\x40\x37\x4c\x81\x4b\xe3\x6e\xb4\x6b\x12\xe6\xe2\x5c\x31\x0a\xde\x60\xe0\xbd\xcd\x70\x7b\xab\x41\xf6\x56\x43\xeb\x04\x9a\x76\x07\x36\x34\x67\x22\x43\x16\xe6\x1e\x28\x1a\x80\x3c\xa2\xdb\x5f\x2b\x6e\x4b\x03\x7a\x4c\x69\x50\xd1\x10\x11\xac\xd3\x54\xd6\x93\x42\x43\x48\xa8\x92\x39\xea\x92\x09\xc7\xf6\xb6\xaf\x5a\x16\xc8\x67\xdb\x39\x90\x6b\xb2\x11\x3f\x01\xb2\x17\x7a\x95\xb3\x40\x7e\x7d\x63\x20\xd8\xd4\xce\x13\x62\x03\x40\x68\x14\x81\x71\x2d\xe4\x94\xcc\x10\x11\xaa\xa3\x91\x4b\x84\xbe\x8a\x0e\xbb\x4e\xb0\x0e\x84\xad\xe5\x0a\xd9\xb9\x6e\x31\x61\xce\x0b\xe3\xb3\xc9\x16\xd3\xe6\x74\x11\xd8\x75\xc6\x7b\x92\x87\x4e\xbd\xae\x8b\x8b\x8e\x79\x5d\x42\xee\xd3\xe4\x42\x3b\xab\x87\x9b\x35\x3c\xdc\x9a\x40\x26\x34\x4f\xd0\xce\x5a\xdb\xa3\x9b\x3d\x0e\x8f\x4d\x27\x12\xf3\x8c\x3a\x2f\xac\x22\x1c\xe5\xab\x65\x66\x96\x85\x4e\xad\xd1\x98\xba\x7b\x8b\x42\xaf\x9d\x6e\xec\x0e\xda\xb0\x3c\x2b\xa0\x32\xb9\x4e\xec\x8b\x1b\x40\x34\x02\xf8\x2b\x98\x03\x2e\x27\x7d\xdf\xea\xcf\x8d\xdf\x05\x77\xec\xc1\xb7\xc2\x2d\xbf\xa9\x9a\x9d\xec\x7d\xab\x3f\x77\x25\x98\x9b\xba\x67\xf4\x66\x76\x92\x06\x0e\x56\xc7\x4a\x69\x3e\x5e\xc5\x89\xf7\xe9\x86\x37\xac\x53\x17\xf4\x25\x33\xb7\x4d\xf0\xb5\xfe\x98\xa6\x44\x42\x52\xca\x14\x29\x91\x2c\x68\x34\x84\xfa\xd4\x65\xb6\x6c\x41\x5f\x0a\xac\x0e\xb4\x55\x07\xc8\x75\xa2\x5f\x95\x48\x53\xba\x44\x74\x80\x5c\x15\xdf\x86\xa9\xde\x8e\x2c\xd7\xed\xa1\xbd\xaa\x5f\xfb\x22\xd8\x54\x9c\xb1\xd2\x54\x97\xd8\xa4\xdb\x5e\x2b\x22\x28\x0f\x9f\x7f\x28\xa8\x46\xc6\x54\xf5\x10\x25\x42\xaa\xb8\x90\x70\x4e\xf9\xe5\x6a\xdf\x2d\x7f\xfc\xf4\xe5\x97\x8f\xbf\x7d\x0e\x65\x97\xa2\xd4\x3c\xbf\xc4\x20\xa5\x90\x16\xf9\x34\x2b\x2d\xb5\xb8\x0a\xa5\x89\x02\x5d\x93\x20\xc1\x71\x41\x3c\x22\x13\xa2\x12\xf6\xf2\xe4\x95\x26\xe5\x0a\xb9\xf1\x1f\x98\xef\xaf\xb0\x22\x52\x4b\xda\xcf\x20\x05\xa4\x2c\x5c\xb2\x5f\xeb\xc2\xed\x18\x12\x38\x20\xa4\x1a\x57\x3c\xe3\x29\x45\x4e\x9a\x1c\x88\x75\x6f\x4c\xfe\x57\x2f\x5c\xb6\x7a\xe0\xd2\x5e\x54\xb5\x71\x22\xc7\x4a\xb0\x18\x59\x11\xcd\xfb\xa5\x16\x14\x57\x22\x40\xe8\x0c\xc0\xc8\x59\x08\xe4\x80\x7e\x68\xf1\xe5\x94\x90\x40\x8e\x74\x68\xdb\xe8\xcb\x7c\xac\x7f\x9a\x03\x67\x81\xdd\x6e\x9a\x98\xf4\x4d\xeb\xf8\x49\x01\x32\xe3\x4a\xa1\xfb\xf3\x46\x27\xb6\x21\x2b\x35\x8f\xf5\x2f\x67\xc2\x8d\xf1\xf4\xd2\xd9\xef\xa6\xd6\xcc\x37\x53\x82\x4b\xa6\x9e\x29\x4d\x22\x81\x26\xf8\xe1\x47\x23\x3b\xb6\xfb\x94\x05\xa1\xc2\xad\xdb\x6e\xe9\xd5\x5e\x37\x53\x83\xab\xf7\x8e\xac\x1b\xa5\x77\x42\xd4\x20\x5a\xf3\xd6\x71\x76\xab\xb6\x61\x76\x7a\xbb\x59\x94\xc9\xb1\xfd\x6b\xaa\x93\xdf\x20\x77\xea\xe7\x58\x5b\xde\xae\xf3\xfb\xb6\x66\x14\xa3\x75\x23\xa3\x79\xf7\x72\xac\x7f\xd5\xb2\x0c\x34\xe5\xc8\x31\x83\x19\x0a\x06\x1b\x0f\x21\xde\x4f\x6c\xc6\x52\xf8\x45\x58\xf7\x18\x78\x5b\x51\x67\x09\xdc\x73\x30\xbc\xd2\xd6\xcf\xbc\xfe\xb7\x39\x62\xa2\x25\xb2\x61\x30\x2a\x2d\x2a\xee\x21\x02\x34\x12\x9a\xa6\x27\x9a\x3c\x4d\x6b\x8c\x50\x61\xbe\x4c\x4a\x04\xf5\xba\xc1\x0b\x6d\x47\x11\xdc\x8c\x3a\x47\x01\x3c\x3f\xe4\x10\x09\x72\x96\x1c\x72\xe4\x38\xc7\xf8\xd3\x1a\x83\x37\xa0\x98\xe0\x74\x77\x6b\xee\xbe\x1b\xc8\xbd\xf5\x4c\x30\x27\x05\x97\x85\x74\x74\x57\x91\x48\x60\x1c\xa9\x2c\xe7\xa0\xde\x2f\xe7\xc8\x89\x6b\x89\x3e\x18\x46\xed\x3e\xe5\xbd\x60\xea\x56\xd4\x13\x9a\xd3\xf4\x45\xf3\xc4\x91\xb1\x1a\x65\x20\x8a\x07\xf4\x10\x5c\x89\xa4\xfc\x0c\x9a\x67\xb6\x6b\xaf\x92\x37\xc4\x0a\x6d\xfb\x7f\x40\xcc\xb8\x7a\xbb\x9e\xba\x8b\xe4\x8c\xcf\x37\xed\x0d\xfc\x1e\xc4\x9c\x89\xe7\x3c\x15\xd4\x31\xa1\xd5\xa0\x11\xc2\xe7\x41\x33\x64\x27\x6c\x0b\x3a\xf8\x3c\xb4\xe1\x99\x60\x20\xcd\xf3\x65\x77\xd3\x2d\x8c\x2d\xb6\xdf\xfd\xb9\xff\xbe\xff\x37\x00\x00\xff\xff\x1b\x29\xfe\x20\xa1\x36\x00\x00")

func dataVisageV4JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV4Json,
		"data/visage-v4.json",
	)
}

func dataVisageV4Json() (*asset, error) {
	bytes, err := dataVisageV4JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v4.json", size: 13985, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"data/almanac.json":                   dataAlmanacJson,
	"data/audrey.json":                    dataAudreyJson,
	"data/autohost.json":                  dataAutohostJson,
	"data/channels.json":                  dataChannelsJson,
	"data/cohesion.json":                  dataCohesionJson,
	"data/digestion.json":                 dataDigestionJson,
	"data/discovery.json":                 dataDiscoveryJson,
	"data/flowsdproxy.json":               dataFlowsdproxyJson,
	"data/friendship.json":                dataFriendshipJson,
	"data/im-store.json":                  dataImStoreJson,
	"data/partnerships.json":              dataPartnershipsJson,
	"data/presence.json":                  dataPresenceJson,
	"data/pubsub-broker.json":             dataPubsubBrokerJson,
	"data/rails.json":                     dataRailsJson,
	"data/recommendations.json":           dataRecommendationsJson,
	"data/similar-channels.json":          dataSimilarChannelsJson,
	"data/skadi.json":                     dataSkadiJson,
	"data/streams-api.json":               dataStreamsApiJson,
	"data/tmi-api.json":                   dataTmiApiJson,
	"data/tmi-clue.json":                  dataTmiClueJson,
	"data/tmi-pubsub.json":                dataTmiPubsubJson,
	"data/tmi-room.json":                  dataTmiRoomJson,
	"data/users-service.json":             dataUsersServiceJson,
	"data/video-origin-origin.json":       dataVideoOriginOriginJson,
	"data/video-origin-origindb.json":     dataVideoOriginOrigindbJson,
	"data/video-usher-api-find.json":      dataVideoUsherApiFindJson,
	"data/video-usher-api-usher.json":     dataVideoUsherApiUsherJson,
	"data/video-usher-api-video.json":     dataVideoUsherApiVideoJson,
	"data/video-usher-api-videoapi.json":  dataVideoUsherApiVideoapiJson,
	"data/video-usher-api-viewcount.json": dataVideoUsherApiViewcountJson,
	"data/videoshim.json":                 dataVideoshimJson,
	"data/visage-api.json":                dataVisageApiJson,
	"data/visage-kraken.json":             dataVisageKrakenJson,
	"data/visage-v1.json":                 dataVisageV1Json,
	"data/visage-v2.json":                 dataVisageV2Json,
	"data/visage-v3.json":                 dataVisageV3Json,
	"data/visage-v4.json":                 dataVisageV4Json,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"data": &bintree{nil, map[string]*bintree{
		"almanac.json":                   &bintree{dataAlmanacJson, map[string]*bintree{}},
		"audrey.json":                    &bintree{dataAudreyJson, map[string]*bintree{}},
		"autohost.json":                  &bintree{dataAutohostJson, map[string]*bintree{}},
		"channels.json":                  &bintree{dataChannelsJson, map[string]*bintree{}},
		"cohesion.json":                  &bintree{dataCohesionJson, map[string]*bintree{}},
		"digestion.json":                 &bintree{dataDigestionJson, map[string]*bintree{}},
		"discovery.json":                 &bintree{dataDiscoveryJson, map[string]*bintree{}},
		"flowsdproxy.json":               &bintree{dataFlowsdproxyJson, map[string]*bintree{}},
		"friendship.json":                &bintree{dataFriendshipJson, map[string]*bintree{}},
		"im-store.json":                  &bintree{dataImStoreJson, map[string]*bintree{}},
		"partnerships.json":              &bintree{dataPartnershipsJson, map[string]*bintree{}},
		"presence.json":                  &bintree{dataPresenceJson, map[string]*bintree{}},
		"pubsub-broker.json":             &bintree{dataPubsubBrokerJson, map[string]*bintree{}},
		"rails.json":                     &bintree{dataRailsJson, map[string]*bintree{}},
		"recommendations.json":           &bintree{dataRecommendationsJson, map[string]*bintree{}},
		"similar-channels.json":          &bintree{dataSimilarChannelsJson, map[string]*bintree{}},
		"skadi.json":                     &bintree{dataSkadiJson, map[string]*bintree{}},
		"streams-api.json":               &bintree{dataStreamsApiJson, map[string]*bintree{}},
		"tmi-api.json":                   &bintree{dataTmiApiJson, map[string]*bintree{}},
		"tmi-clue.json":                  &bintree{dataTmiClueJson, map[string]*bintree{}},
		"tmi-pubsub.json":                &bintree{dataTmiPubsubJson, map[string]*bintree{}},
		"tmi-room.json":                  &bintree{dataTmiRoomJson, map[string]*bintree{}},
		"users-service.json":             &bintree{dataUsersServiceJson, map[string]*bintree{}},
		"video-origin-origin.json":       &bintree{dataVideoOriginOriginJson, map[string]*bintree{}},
		"video-origin-origindb.json":     &bintree{dataVideoOriginOrigindbJson, map[string]*bintree{}},
		"video-usher-api-find.json":      &bintree{dataVideoUsherApiFindJson, map[string]*bintree{}},
		"video-usher-api-usher.json":     &bintree{dataVideoUsherApiUsherJson, map[string]*bintree{}},
		"video-usher-api-video.json":     &bintree{dataVideoUsherApiVideoJson, map[string]*bintree{}},
		"video-usher-api-videoapi.json":  &bintree{dataVideoUsherApiVideoapiJson, map[string]*bintree{}},
		"video-usher-api-viewcount.json": &bintree{dataVideoUsherApiViewcountJson, map[string]*bintree{}},
		"videoshim.json":                 &bintree{dataVideoshimJson, map[string]*bintree{}},
		"visage-api.json":                &bintree{dataVisageApiJson, map[string]*bintree{}},
		"visage-kraken.json":             &bintree{dataVisageKrakenJson, map[string]*bintree{}},
		"visage-v1.json":                 &bintree{dataVisageV1Json, map[string]*bintree{}},
		"visage-v2.json":                 &bintree{dataVisageV2Json, map[string]*bintree{}},
		"visage-v3.json":                 &bintree{dataVisageV3Json, map[string]*bintree{}},
		"visage-v4.json":                 &bintree{dataVisageV4Json, map[string]*bintree{}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
