// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/release/trace/api/transaction.proto

package api

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import code_justin_tv_release_trace_common "code.justin.tv/release/trace/common"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A TransactionSet is a list of Transactions.  It may be used when sending multiple
// transactions in a datagram, or when saving them to disk.  There is no codified or
// implied relation between Transactions grouped into an TransactionSet.
type TransactionSet struct {
	// List of Transactions
	Transaction []*Transaction `protobuf:"bytes,1,rep,name=transaction" json:"transaction,omitempty"`
}

func (m *TransactionSet) Reset()                    { *m = TransactionSet{} }
func (m *TransactionSet) String() string            { return proto.CompactTextString(m) }
func (*TransactionSet) ProtoMessage()               {}
func (*TransactionSet) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *TransactionSet) GetTransaction() []*Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// A Transaction groups together a collection of Calls into one
// tree. It provides access to the transaction_id which is shared by
// all of its constituent Calls.
type Transaction struct {
	// 128-bit identifier for the transaction, as set in
	// code.justin.tv.release.trace.pbmsg.Event messages: two 64-bit
	// integers, least significant word first.
	TransactionId []uint64 `protobuf:"fixed64,1,rep,packed,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	// root stores the data on the root call of the transaction.
	Root *Call `protobuf:"bytes,2,opt,name=root" json:"root,omitempty"`
	// In some rare cases, the root client of a transaction may be
	// known. If that's the case, such data can be stored in the
	// optional client field.
	Client *Service `protobuf:"bytes,3,opt,name=client" json:"client,omitempty"`
}

func (m *Transaction) Reset()                    { *m = Transaction{} }
func (m *Transaction) String() string            { return proto.CompactTextString(m) }
func (*Transaction) ProtoMessage()               {}
func (*Transaction) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Transaction) GetTransactionId() []uint64 {
	if m != nil {
		return m.TransactionId
	}
	return nil
}

func (m *Transaction) GetRoot() *Call {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *Transaction) GetClient() *Service {
	if m != nil {
		return m.Client
	}
	return nil
}

// A Call represents a single RPC call out to a service in the
// distributed stack trace.
//
// The client of the call is not explicitly listed here. The client
// can instead be inferred from the entire Transaction's tree:
//
//   - If this is the root call in the RPC tree, then the Transaction
//     has an optional client field which lists the client if it sends
//     data to trace. If not, then the client can't be known.
//   - If this is non-root node, then it has a parent. The svc of the
//     parent call is the client of this call.
type Call struct {
	// subcalls are the subcalls that this call depended on, in path order.
	Subcalls []*Call `protobuf:"bytes,1,rep,name=subcalls" json:"subcalls,omitempty"`
	// path is the same path identifier as used in event.proto.
	Path []uint32 `protobuf:"varint,2,rep,packed,name=path" json:"path,omitempty"`
	// svc holds the identity of the service which served the RPC
	// call. This might be left unset if the service does not send data
	// to Trace.
	Svc *Service `protobuf:"bytes,3,opt,name=svc" json:"svc,omitempty"`
	// params are the parameters of the Call, like the HTTP URI or SQL
	// query. They may be filled by either client or server; the
	// server's log of its outbound request should be preferred if they
	// conflict, since server owners are responsible for maintaining
	// metadata about what RPCs they provide.
	Params *RPCParams `protobuf:"bytes,4,opt,name=params" json:"params,omitempty"`
	// client_timestamps and service_timestamps provide lists of timing
	// information accordiong to each side of the call. They will only
	// be available if the respective side is sending Trace data. They
	// will be sorted by increasing time values (earliest first, in
	// other words). It's guaranteed that at least one set of timestamps
	// will have at least one value.
	ClientTimestamps  []*Timestamp `protobuf:"bytes,5,rep,name=client_timestamps,json=clientTimestamps" json:"client_timestamps,omitempty"`
	ServiceTimestamps []*Timestamp `protobuf:"bytes,6,rep,name=service_timestamps,json=serviceTimestamps" json:"service_timestamps,omitempty"`
	// request_sent_to is the host:port that the client established its
	// connection to to make the RPC. This is the client's perception,
	// and doesn't necessarily reflect where the server is actually
	// listening; proxies might be in between.
	RequestSentTo string `protobuf:"bytes,7,opt,name=request_sent_to,json=requestSentTo" json:"request_sent_to,omitempty"`
}

func (m *Call) Reset()                    { *m = Call{} }
func (m *Call) String() string            { return proto.CompactTextString(m) }
func (*Call) ProtoMessage()               {}
func (*Call) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *Call) GetSubcalls() []*Call {
	if m != nil {
		return m.Subcalls
	}
	return nil
}

func (m *Call) GetPath() []uint32 {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Call) GetSvc() *Service {
	if m != nil {
		return m.Svc
	}
	return nil
}

func (m *Call) GetParams() *RPCParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Call) GetClientTimestamps() []*Timestamp {
	if m != nil {
		return m.ClientTimestamps
	}
	return nil
}

func (m *Call) GetServiceTimestamps() []*Timestamp {
	if m != nil {
		return m.ServiceTimestamps
	}
	return nil
}

func (m *Call) GetRequestSentTo() string {
	if m != nil {
		return m.RequestSentTo
	}
	return ""
}

// Service represents an application which is capable of handling RPC
// calls.
type Service struct {
	// The name of the service
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The FQDN of the host that the service is running on
	Host string `protobuf:"bytes,2,opt,name=host" json:"host,omitempty"`
	// PID of the process
	Pid int32 `protobuf:"zigzag32,3,opt,name=pid" json:"pid,omitempty"`
	// The ip:port sending the request to this service.
	Peer string `protobuf:"bytes,4,opt,name=peer" json:"peer,omitempty"`
}

func (m *Service) Reset()                    { *m = Service{} }
func (m *Service) String() string            { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()               {}
func (*Service) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *Service) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Service) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Service) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *Service) GetPeer() string {
	if m != nil {
		return m.Peer
	}
	return ""
}

// Timestamp provides a marker for when something happened in a call.
type Timestamp struct {
	// time is when a call started, recorded as unix epoch
	// time in nanoseconds
	Time int64 `protobuf:"fixed64,1,opt,name=time" json:"time,omitempty"`
	// kind describes what happened at the specified time
	Kind code_justin_tv_release_trace_common.Kind `protobuf:"varint,2,opt,name=kind,enum=code.justin.tv.release.trace.common.event.Kind" json:"kind,omitempty"`
}

func (m *Timestamp) Reset()                    { *m = Timestamp{} }
func (m *Timestamp) String() string            { return proto.CompactTextString(m) }
func (*Timestamp) ProtoMessage()               {}
func (*Timestamp) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *Timestamp) GetTime() int64 {
	if m != nil {
		return m.Time
	}
	return 0
}

func (m *Timestamp) GetKind() code_justin_tv_release_trace_common.Kind {
	if m != nil {
		return m.Kind
	}
	return code_justin_tv_release_trace_common.Kind_UNKNOWN
}

// RPCParams contains data on the details of the request that the
// client made.
type RPCParams struct {
	Http      *HTTPParams      `protobuf:"bytes,1,opt,name=http" json:"http,omitempty"`
	Sql       *SQLParams       `protobuf:"bytes,2,opt,name=sql" json:"sql,omitempty"`
	Memcached *MemcachedParams `protobuf:"bytes,3,opt,name=memcached" json:"memcached,omitempty"`
	Grpc      *GRPCParams      `protobuf:"bytes,4,opt,name=grpc" json:"grpc,omitempty"`
}

func (m *RPCParams) Reset()                    { *m = RPCParams{} }
func (m *RPCParams) String() string            { return proto.CompactTextString(m) }
func (*RPCParams) ProtoMessage()               {}
func (*RPCParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *RPCParams) GetHttp() *HTTPParams {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *RPCParams) GetSql() *SQLParams {
	if m != nil {
		return m.Sql
	}
	return nil
}

func (m *RPCParams) GetMemcached() *MemcachedParams {
	if m != nil {
		return m.Memcached
	}
	return nil
}

func (m *RPCParams) GetGrpc() *GRPCParams {
	if m != nil {
		return m.Grpc
	}
	return nil
}

type HTTPParams struct {
	// The path part of the URI of the request.
	UriPath string `protobuf:"bytes,1,opt,name=uri_path,json=uriPath" json:"uri_path,omitempty"`
	// HTTP Status code. Values less than zero indicate an error
	// observed by the client which caused it to give up on the request
	// before getting a status code from the server.
	Status int32 `protobuf:"zigzag32,2,opt,name=status" json:"status,omitempty"`
	// Method of HTTP request.
	Method code_justin_tv_release_trace_common.Method `protobuf:"varint,3,opt,name=method,enum=code.justin.tv.release.trace.common.http.Method" json:"method,omitempty"`
	// If we have sufficient data to give a name to the route, then that
	// human-readable name will be stored here.
	Route string `protobuf:"bytes,4,opt,name=route" json:"route,omitempty"`
}

func (m *HTTPParams) Reset()                    { *m = HTTPParams{} }
func (m *HTTPParams) String() string            { return proto.CompactTextString(m) }
func (*HTTPParams) ProtoMessage()               {}
func (*HTTPParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *HTTPParams) GetUriPath() string {
	if m != nil {
		return m.UriPath
	}
	return ""
}

func (m *HTTPParams) GetStatus() int32 {
	if m != nil {
		return m.Status
	}
	return 0
}

func (m *HTTPParams) GetMethod() code_justin_tv_release_trace_common.Method {
	if m != nil {
		return m.Method
	}
	return code_justin_tv_release_trace_common.Method_UNKNOWN
}

func (m *HTTPParams) GetRoute() string {
	if m != nil {
		return m.Route
	}
	return ""
}

type SQLParams struct {
	// Name of the database where the query runs.
	Dbname string `protobuf:"bytes,1,opt,name=dbname" json:"dbname,omitempty"`
	// Username used to connect to the database.
	Dbuser string `protobuf:"bytes,2,opt,name=dbuser" json:"dbuser,omitempty"`
	// Query string with all user data removed.
	StrippedQuery string `protobuf:"bytes,3,opt,name=stripped_query,json=strippedQuery" json:"stripped_query,omitempty"`
	// List of tables directly referenced in the query.
	Tables []string `protobuf:"bytes,4,rep,name=tables" json:"tables,omitempty"`
}

func (m *SQLParams) Reset()                    { *m = SQLParams{} }
func (m *SQLParams) String() string            { return proto.CompactTextString(m) }
func (*SQLParams) ProtoMessage()               {}
func (*SQLParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *SQLParams) GetDbname() string {
	if m != nil {
		return m.Dbname
	}
	return ""
}

func (m *SQLParams) GetDbuser() string {
	if m != nil {
		return m.Dbuser
	}
	return ""
}

func (m *SQLParams) GetStrippedQuery() string {
	if m != nil {
		return m.StrippedQuery
	}
	return ""
}

func (m *SQLParams) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

type MemcachedParams struct {
	// The command sent to memcached by a client
	Command code_justin_tv_release_trace_common.Command `protobuf:"varint,1,opt,name=command,enum=code.justin.tv.release.trace.common.memcached.Command" json:"command,omitempty"`
	// The number of keys in the client's request
	NKeysRequest uint32 `protobuf:"varint,2,opt,name=n_keys_request,json=nKeysRequest" json:"n_keys_request,omitempty"`
	// The number of keys in the server's response
	NKeysResponse uint32 `protobuf:"varint,3,opt,name=n_keys_response,json=nKeysResponse" json:"n_keys_response,omitempty"`
}

func (m *MemcachedParams) Reset()                    { *m = MemcachedParams{} }
func (m *MemcachedParams) String() string            { return proto.CompactTextString(m) }
func (*MemcachedParams) ProtoMessage()               {}
func (*MemcachedParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *MemcachedParams) GetCommand() code_justin_tv_release_trace_common.Command {
	if m != nil {
		return m.Command
	}
	return code_justin_tv_release_trace_common.Command_UNKNOWN_COMMAND
}

func (m *MemcachedParams) GetNKeysRequest() uint32 {
	if m != nil {
		return m.NKeysRequest
	}
	return 0
}

func (m *MemcachedParams) GetNKeysResponse() uint32 {
	if m != nil {
		return m.NKeysResponse
	}
	return 0
}

type GRPCParams struct {
	// Fully-qualified method name, including proto package name,
	// service name, and method name.
	Method string `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
}

func (m *GRPCParams) Reset()                    { *m = GRPCParams{} }
func (m *GRPCParams) String() string            { return proto.CompactTextString(m) }
func (*GRPCParams) ProtoMessage()               {}
func (*GRPCParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *GRPCParams) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

func init() {
	proto.RegisterType((*TransactionSet)(nil), "code.justin.tv.release.trace.api.TransactionSet")
	proto.RegisterType((*Transaction)(nil), "code.justin.tv.release.trace.api.Transaction")
	proto.RegisterType((*Call)(nil), "code.justin.tv.release.trace.api.Call")
	proto.RegisterType((*Service)(nil), "code.justin.tv.release.trace.api.Service")
	proto.RegisterType((*Timestamp)(nil), "code.justin.tv.release.trace.api.Timestamp")
	proto.RegisterType((*RPCParams)(nil), "code.justin.tv.release.trace.api.RPCParams")
	proto.RegisterType((*HTTPParams)(nil), "code.justin.tv.release.trace.api.HTTPParams")
	proto.RegisterType((*SQLParams)(nil), "code.justin.tv.release.trace.api.SQLParams")
	proto.RegisterType((*MemcachedParams)(nil), "code.justin.tv.release.trace.api.MemcachedParams")
	proto.RegisterType((*GRPCParams)(nil), "code.justin.tv.release.trace.api.GRPCParams")
}

func init() { proto.RegisterFile("code.justin.tv/release/trace/api/transaction.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 742 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x95, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xe5, 0x38, 0x4d, 0xea, 0x09, 0x49, 0x93, 0x15, 0xaa, 0x0c, 0xa7, 0xc8, 0x2a, 0x55,
	0x2a, 0xc0, 0x29, 0x41, 0xe2, 0x00, 0x42, 0x82, 0xe6, 0x40, 0x51, 0xa9, 0x9a, 0x6e, 0x22, 0x81,
	0x7a, 0x89, 0x36, 0xf6, 0x8a, 0x98, 0xfa, 0x5f, 0xbd, 0xeb, 0x48, 0xe5, 0x65, 0xfa, 0x0c, 0x9c,
	0xb8, 0xf3, 0x64, 0x68, 0xc7, 0x9b, 0xc4, 0x70, 0x68, 0xd2, 0x53, 0x77, 0xc7, 0xfb, 0xfb, 0x76,
	0xbe, 0x99, 0xd9, 0x06, 0x06, 0x5e, 0xe2, 0x73, 0xf7, 0x47, 0x2e, 0x64, 0x10, 0xbb, 0x72, 0xd1,
	0xcf, 0x78, 0xc8, 0x99, 0xe0, 0x7d, 0x99, 0x31, 0x8f, 0xf7, 0x59, 0x1a, 0xa8, 0x55, 0x2c, 0x98,
	0x27, 0x83, 0x24, 0x76, 0xd3, 0x2c, 0x91, 0x09, 0xe9, 0xfe, 0xcb, 0xb8, 0x9a, 0x71, 0x91, 0x71,
	0x59, 0x1a, 0x3c, 0x3d, 0xbe, 0x57, 0xd5, 0x4b, 0xa2, 0x28, 0x89, 0xf5, 0x9f, 0x42, 0xd3, 0x61,
	0xd0, 0x9a, 0xac, 0x2f, 0x1a, 0x73, 0x49, 0x2e, 0xa0, 0x51, 0xba, 0xda, 0x36, 0xba, 0x66, 0xaf,
	0x31, 0x78, 0xe9, 0x6e, 0xba, 0xdb, 0x2d, 0xc9, 0xd0, 0xb2, 0x82, 0xf3, 0xdb, 0x80, 0x46, 0xe9,
	0x23, 0x39, 0x82, 0x56, 0xe9, 0xf3, 0x34, 0xf0, 0xf1, 0x8e, 0xda, 0x49, 0xa5, 0x6d, 0xd0, 0x66,
	0xe9, 0xcb, 0x67, 0x9f, 0xbc, 0x85, 0x6a, 0x96, 0x24, 0xd2, 0xae, 0x74, 0x8d, 0x5e, 0x63, 0x70,
	0xb8, 0x39, 0x89, 0x21, 0x0b, 0x43, 0x8a, 0x0c, 0xf9, 0x08, 0x35, 0x2f, 0x0c, 0x78, 0x2c, 0x6d,
	0x13, 0xe9, 0xa3, 0xcd, 0xf4, 0x98, 0x67, 0x8b, 0xc0, 0xe3, 0x54, 0x83, 0xce, 0x1f, 0x13, 0xaa,
	0x4a, 0x91, 0x9c, 0xc0, 0xae, 0xc8, 0x67, 0x1e, 0x0b, 0x43, 0xa1, 0x0b, 0xb2, 0x6d, 0x2e, 0x2b,
	0x8e, 0xec, 0x43, 0x35, 0x65, 0x72, 0x6e, 0x57, 0xba, 0x66, 0xaf, 0x89, 0x66, 0x71, 0x4f, 0xde,
	0x81, 0x29, 0x16, 0xde, 0xc3, 0x93, 0x54, 0x14, 0x19, 0x42, 0x2d, 0x65, 0x19, 0x8b, 0x84, 0x5d,
	0x45, 0xfe, 0xf9, 0x66, 0x9e, 0x8e, 0x86, 0x23, 0x44, 0xa8, 0x46, 0xc9, 0x37, 0xe8, 0x14, 0x86,
	0xa7, 0x32, 0x88, 0xb8, 0x90, 0x2c, 0x4a, 0x85, 0xbd, 0x83, 0x36, 0xb7, 0xd0, 0x9b, 0x2c, 0x19,
	0xda, 0x2e, 0x54, 0x56, 0x01, 0x41, 0xae, 0x80, 0x88, 0x22, 0xdd, 0xb2, 0x74, 0xed, 0xe1, 0xd2,
	0x1d, 0x2d, 0x53, 0xd2, 0x3e, 0x84, 0xbd, 0x8c, 0xdf, 0xe4, 0x5c, 0xc8, 0xa9, 0xc0, 0xdc, 0x13,
	0xbb, 0xde, 0x35, 0x7a, 0x16, 0x6d, 0xea, 0xf0, 0x58, 0xe5, 0x92, 0x38, 0x5f, 0xa1, 0xae, 0x4b,
	0x46, 0x08, 0x54, 0x63, 0x16, 0x71, 0xdb, 0xc0, 0x73, 0xb8, 0x56, 0xb1, 0x79, 0x22, 0x8a, 0x11,
	0xb3, 0x28, 0xae, 0x49, 0x1b, 0xcc, 0x34, 0xf0, 0xb1, 0x25, 0x1d, 0xaa, 0x96, 0xea, 0x54, 0xca,
	0x79, 0x86, 0x55, 0xb6, 0x28, 0xae, 0x1d, 0x1f, 0xac, 0x55, 0x3a, 0xea, 0x80, 0x72, 0x88, 0xd2,
	0x6d, 0x8a, 0x6b, 0x32, 0x84, 0xea, 0x75, 0x10, 0xfb, 0x28, 0xdd, 0x1a, 0xf4, 0xef, 0xf7, 0xab,
	0x5f, 0x25, 0x5f, 0xf0, 0x58, 0xba, 0x67, 0x41, 0xec, 0x53, 0x84, 0x9d, 0xbb, 0x0a, 0x58, 0xab,
	0x96, 0x91, 0x0f, 0x50, 0x9d, 0x4b, 0x99, 0xe2, 0x35, 0x8d, 0xc1, 0x8b, 0xcd, 0x25, 0x3c, 0x9d,
	0x4c, 0x46, 0xba, 0xdd, 0x48, 0x92, 0xf7, 0x60, 0x8a, 0x9b, 0x50, 0xbf, 0xa8, 0x2d, 0x7a, 0x30,
	0xbe, 0xfc, 0xa2, 0x79, 0xc5, 0x91, 0x0b, 0xb0, 0x22, 0x1e, 0x79, 0xcc, 0x9b, 0x73, 0x5f, 0xcf,
	0xec, 0xab, 0xcd, 0x22, 0xe7, 0x4b, 0x44, 0x4b, 0xad, 0x35, 0x94, 0xa3, 0xef, 0x59, 0xea, 0xe9,
	0xf9, 0xdd, 0xc2, 0xd1, 0xa7, 0xf5, 0x00, 0x23, 0xe9, 0xdc, 0x19, 0x00, 0x6b, 0x9b, 0xe4, 0x09,
	0xec, 0xe6, 0x59, 0x30, 0xc5, 0xb7, 0x56, 0x34, 0xba, 0x9e, 0x67, 0xc1, 0x48, 0x3d, 0xb5, 0x7d,
	0xa8, 0x09, 0xc9, 0x64, 0x2e, 0xd0, 0x7e, 0x87, 0xea, 0x1d, 0x39, 0x85, 0x5a, 0xc4, 0xe5, 0x3c,
	0x29, 0x1c, 0xb5, 0x06, 0xc7, 0x5b, 0xb5, 0x4a, 0x95, 0xd3, 0x3d, 0x47, 0x8e, 0x6a, 0x9e, 0x3c,
	0x86, 0x9d, 0x2c, 0xc9, 0x25, 0xd7, 0x83, 0x52, 0x6c, 0x9c, 0x9f, 0x60, 0xad, 0xca, 0xa8, 0x92,
	0xf0, 0x67, 0xa5, 0x31, 0xd4, 0xbb, 0x22, 0x9e, 0x0b, 0x9e, 0xe9, 0x51, 0xd4, 0x3b, 0xf2, 0x0c,
	0x5a, 0x42, 0x66, 0x41, 0x9a, 0x72, 0x7f, 0x7a, 0x93, 0xf3, 0xec, 0x16, 0x93, 0xb4, 0x68, 0x73,
	0x19, 0xbd, 0x54, 0x41, 0x85, 0x4b, 0x36, 0x0b, 0xb9, 0xfa, 0x4f, 0x60, 0x2a, 0xbc, 0xd8, 0x39,
	0xbf, 0x0c, 0xd8, 0xfb, 0xaf, 0xfc, 0x64, 0x04, 0x75, 0xe5, 0x81, 0xc5, 0x3e, 0xe6, 0xd0, 0x1a,
	0xbc, 0xd9, 0xca, 0xf0, 0xaa, 0x69, 0xee, 0xb0, 0xa0, 0xe9, 0x52, 0x86, 0x1c, 0x40, 0x2b, 0x9e,
	0x5e, 0xf3, 0x5b, 0x31, 0xd5, 0x8f, 0x0f, 0x4d, 0x34, 0xe9, 0xa3, 0xf8, 0x8c, 0xdf, 0x0a, 0x5a,
	0xc4, 0xd4, 0x93, 0x5d, 0x9d, 0x12, 0x69, 0x12, 0x0b, 0x8e, 0x5e, 0x9a, 0xb4, 0xa9, 0x8f, 0x15,
	0x41, 0xe7, 0x00, 0x60, 0xdd, 0x65, 0xe5, 0x4c, 0x77, 0x47, 0x17, 0xac, 0xd8, 0x9d, 0xec, 0x5c,
	0x99, 0x2c, 0x0d, 0x66, 0x35, 0xfc, 0x21, 0x7b, 0xfd, 0x37, 0x00, 0x00, 0xff, 0xff, 0x59, 0x2c,
	0x24, 0xbb, 0x52, 0x07, 0x00, 0x00,
}
