package stats

import (
	"math"
	"testing"
)

func TestBucketIndex(t *testing.T) {
	tests := []struct {
		value int64
		idx   int
	}{
		{0, 0},
		{1, 1},
		{-1, 2},
		{10, 101},
		{-10, 102},
		{100, 201},
		{-100, 202},
		{1000, 301},
		{-1000, 302},
		{2, 31},
		{3, 49},
		{4, 61},
		{5, 71},
		{6, 79},
		{7, 85},
		{8, 91},
		{9, 97},
		{10, 101},
		{11, 105},
		{12, 109},
		{13, 113},
		{14, 115},
		{15, 119},
		{16, 121},
		{17, 125},
		{18, 127},
		{19, 129},
		{20, 131},
		{21, 133},
		{22, 135},
		{23, 137},
		{100, 201},
		{101, 201},
		{102, 201},
		{103, 203},
		{104, 203},
		{105, 203},
		{106, 203},
		{107, 203},
		{108, 205},
		{math.MaxInt64, 1897},
		{math.MinInt64, 1898},
	}

	for _, tt := range tests {
		h := NewHistogram(50)
		if have, want := h.BucketIndex(tt.value), tt.idx; have != want {
			t.Errorf("h.BucketIndex(%d); %d != %d", tt.value, have, want)
		}
	}
}

func TestBucketBounds(t *testing.T) {
	tests := []struct {
		idx   int
		lower int64
		upper int64
	}{
		{0, 0, 1},
		{1, 1, 2},
		{2, -1, 0},
		{101, 10, 11},
		{103, 11, 11},
		{105, 11, 12},
		{125, 17, 18},
		{129, 19, 20},
		{203, 103, 108},
	}

	for _, tt := range tests {
		h := NewHistogram(50)
		hl, hu := h.BucketBounds(tt.idx)
		wl, wu := tt.lower, tt.upper
		if hl != wl || hu != wu {
			t.Errorf("h.BucketBounds(%d); %d, %d != %d, %d", tt.idx, hl, hu, wl, wu)
		} else {
			t.Logf("h.BucketBounds(%d); ok", tt.idx)
		}
	}
}
