package main

import (
	"io"

	"github.com/golang/protobuf/proto"
)

// Proto writer marshals proto messages and writes their marshaled
// form to an io.Writer.
type protoWriter struct {
	w   io.Writer
	buf *proto.Buffer
}

func newProtoWriter(w io.Writer) *protoWriter {
	return &protoWriter{
		w:   w,
		buf: proto.NewBuffer(nil),
	}
}

func (pw *protoWriter) marshal(msg proto.Message) (n int, err error) {
	pw.buf.Reset()
	if err := pw.buf.Marshal(msg); err != nil {
		return 0, err
	}
	return pw.w.Write(pw.buf.Bytes())
}
