#!/bin/bash
set -e -o pipefail -u

# TODO: find a way to auto-select an ephemeral port here
localaddr="localhost:9323"

SSH_ARGS_APPEND="-q -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o PreferredAuthentications=publickey"

if [ "$#" -lt "2" ]; then
	cmd="$0"

	exec >&2
	echo "Usage of ${cmd}:"
	echo "  ${cmd} hostclass command"
	echo ""
	echo "where 'hostclass' might be 'trace-statsdsink-kinesis-canary' or"
	echo "'trace-aggregator-kinesis', and 'command' is a command to be run with the ADDR"
	echo "environment variable set to a forwarded address."
	echo ""
	echo "\$ ${cmd} trace-aggregator-kinesis \\"
	echo "    bash -c 'go tool pprof -web -alloc_space http://\$ADDR/debug/pprof/heap'"
	echo ""
	echo "\$ ${cmd} trace-aggregator-kinesis \\"
	echo "    bash -c 'curl -s -o - http://\$ADDR/debug/vars'"
	echo ""
	echo "\$ ${cmd} trace-aggregator-kinesis \\"
	echo "    bash -c 'chrome http://\$ADDR/debug/requests ; tail -f /dev/null'"
	echo ""
	exit 1
fi

hostclass="$1"
shift

ips=$(aws ec2 describe-instances \
	--output text\
	--query "Reservations[*].Instances[*].PrivateIpAddress"\
	--filter "Name=tag-value,Values=${hostclass}")

one="$(echo "${ips}" | head -n 1)"

if [ -z "${one}" ]; then
	echo "no hosts found of class ${hostclass}"
	exit 1
fi

addr=$(ssh $SSH_ARGS_APPEND \
	-- "${one}" \
	"sudo netstat -tnlp | awk '{print \$4,\$7}' | sed -n -e 's,^\([^ /]*\) [0-9]*/\(aggregate\|statsdsink\)\$,\1,p' | head -n 1")

if [ -z "${addr}" ]; then
	echo "no process found on ${one}"
	exit 1
fi

ssh $SSH_ARGS_APPEND \
	-N -L "${localaddr}:${addr}" -- "${one}" &
sshfwdpid="$!"

export ADDR="${localaddr}"
"$@"

kill -TERM -- "${sshfwdpid}"
wait
