// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAllocateConnectionOnInterconnect = "AllocateConnectionOnInterconnect"

// AllocateConnectionOnInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the AllocateConnectionOnInterconnect operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateConnectionOnInterconnect for more information on using the AllocateConnectionOnInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateConnectionOnInterconnectRequest method.
//    req, resp := client.AllocateConnectionOnInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnect
func (c *DirectConnect) AllocateConnectionOnInterconnectRequest(input *AllocateConnectionOnInterconnectInput) (req *request.Request, output *Connection) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AllocateConnectionOnInterconnect, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAllocateConnectionOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateConnectionOnInterconnectInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateConnectionOnInterconnect API operation for AWS Direct Connect.
//
// Deprecated in favor of AllocateHostedConnection.
//
// Creates a hosted connection on an interconnect.
//
// Allocates a VLAN number and a specified amount of bandwidth for use by a
// hosted connection on the given interconnect.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocateConnectionOnInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnect
func (c *DirectConnect) AllocateConnectionOnInterconnect(input *AllocateConnectionOnInterconnectInput) (*Connection, error) {
	req, out := c.AllocateConnectionOnInterconnectRequest(input)
	return out, req.Send()
}

// AllocateConnectionOnInterconnectWithContext is the same as AllocateConnectionOnInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateConnectionOnInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocateConnectionOnInterconnectWithContext(ctx aws.Context, input *AllocateConnectionOnInterconnectInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AllocateConnectionOnInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateHostedConnection = "AllocateHostedConnection"

// AllocateHostedConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AllocateHostedConnection operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateHostedConnection for more information on using the AllocateHostedConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateHostedConnectionRequest method.
//    req, resp := client.AllocateHostedConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection
func (c *DirectConnect) AllocateHostedConnectionRequest(input *AllocateHostedConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAllocateHostedConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateHostedConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateHostedConnection API operation for AWS Direct Connect.
//
// Creates a hosted connection on an interconnect or a link aggregation group
// (LAG).
//
// Allocates a VLAN number and a specified amount of bandwidth for use by a
// hosted connection on the given interconnect or LAG.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocateHostedConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection
func (c *DirectConnect) AllocateHostedConnection(input *AllocateHostedConnectionInput) (*Connection, error) {
	req, out := c.AllocateHostedConnectionRequest(input)
	return out, req.Send()
}

// AllocateHostedConnectionWithContext is the same as AllocateHostedConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateHostedConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocateHostedConnectionWithContext(ctx aws.Context, input *AllocateHostedConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AllocateHostedConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocatePrivateVirtualInterface = "AllocatePrivateVirtualInterface"

// AllocatePrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AllocatePrivateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocatePrivateVirtualInterface for more information on using the AllocatePrivateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocatePrivateVirtualInterfaceRequest method.
//    req, resp := client.AllocatePrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface
func (c *DirectConnect) AllocatePrivateVirtualInterfaceRequest(input *AllocatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePrivateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AllocatePrivateVirtualInterface API operation for AWS Direct Connect.
//
// Provisions a private virtual interface to be owned by another AWS customer.
//
// Virtual interfaces created using this action must be confirmed by the virtual
// interface owner by using the ConfirmPrivateVirtualInterface action. Until
// then, the virtual interface will be in 'Confirming' state, and will not be
// available for handling traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocatePrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface
func (c *DirectConnect) AllocatePrivateVirtualInterface(input *AllocatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePrivateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// AllocatePrivateVirtualInterfaceWithContext is the same as AllocatePrivateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AllocatePrivateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocatePrivateVirtualInterfaceWithContext(ctx aws.Context, input *AllocatePrivateVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.AllocatePrivateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocatePublicVirtualInterface = "AllocatePublicVirtualInterface"

// AllocatePublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AllocatePublicVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocatePublicVirtualInterface for more information on using the AllocatePublicVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocatePublicVirtualInterfaceRequest method.
//    req, resp := client.AllocatePublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface
func (c *DirectConnect) AllocatePublicVirtualInterfaceRequest(input *AllocatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePublicVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AllocatePublicVirtualInterface API operation for AWS Direct Connect.
//
// Provisions a public virtual interface to be owned by a different customer.
//
// The owner of a connection calls this function to provision a public virtual
// interface which will be owned by another AWS customer.
//
// Virtual interfaces created using this function must be confirmed by the virtual
// interface owner by calling ConfirmPublicVirtualInterface. Until this step
// has been completed, the virtual interface will be in 'Confirming' state,
// and will not be available for handling traffic.
//
// When creating an IPv6 public virtual interface (addressFamily is 'ipv6'),
// the customer and amazon address fields should be left blank to use auto-assigned
// IPv6 space. Custom IPv6 Addresses are currently not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocatePublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface
func (c *DirectConnect) AllocatePublicVirtualInterface(input *AllocatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePublicVirtualInterfaceRequest(input)
	return out, req.Send()
}

// AllocatePublicVirtualInterfaceWithContext is the same as AllocatePublicVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AllocatePublicVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocatePublicVirtualInterfaceWithContext(ctx aws.Context, input *AllocatePublicVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.AllocatePublicVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateConnectionWithLag = "AssociateConnectionWithLag"

// AssociateConnectionWithLagRequest generates a "aws/request.Request" representing the
// client's request for the AssociateConnectionWithLag operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateConnectionWithLag for more information on using the AssociateConnectionWithLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateConnectionWithLagRequest method.
//    req, resp := client.AssociateConnectionWithLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag
func (c *DirectConnect) AssociateConnectionWithLagRequest(input *AssociateConnectionWithLagInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAssociateConnectionWithLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateConnectionWithLagInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateConnectionWithLag API operation for AWS Direct Connect.
//
// Associates an existing connection with a link aggregation group (LAG). The
// connection is interrupted and re-established as a member of the LAG (connectivity
// to AWS will be interrupted). The connection must be hosted on the same AWS
// Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth
// for the LAG. You can reassociate a connection that's currently associated
// with a different LAG; however, if removing the connection will cause the
// original LAG to fall below its setting for minimum number of operational
// connections, the request fails.
//
// Any virtual interfaces that are directly associated with the connection are
// automatically re-associated with the LAG. If the connection was originally
// associated with a different LAG, the virtual interfaces remain associated
// with the original LAG.
//
// For interconnects, any hosted connections are automatically re-associated
// with the LAG. If the interconnect was originally associated with a different
// LAG, the hosted connections remain associated with the original LAG.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AssociateConnectionWithLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag
func (c *DirectConnect) AssociateConnectionWithLag(input *AssociateConnectionWithLagInput) (*Connection, error) {
	req, out := c.AssociateConnectionWithLagRequest(input)
	return out, req.Send()
}

// AssociateConnectionWithLagWithContext is the same as AssociateConnectionWithLag with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateConnectionWithLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AssociateConnectionWithLagWithContext(ctx aws.Context, input *AssociateConnectionWithLagInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AssociateConnectionWithLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateHostedConnection = "AssociateHostedConnection"

// AssociateHostedConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AssociateHostedConnection operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateHostedConnection for more information on using the AssociateHostedConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateHostedConnectionRequest method.
//    req, resp := client.AssociateHostedConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection
func (c *DirectConnect) AssociateHostedConnectionRequest(input *AssociateHostedConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAssociateHostedConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateHostedConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateHostedConnection API operation for AWS Direct Connect.
//
// Associates a hosted connection and its virtual interfaces with a link aggregation
// group (LAG) or interconnect. If the target interconnect or LAG has an existing
// hosted connection with a conflicting VLAN number or IP address, the operation
// fails. This action temporarily interrupts the hosted connection's connectivity
// to AWS as it is being migrated.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AssociateHostedConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection
func (c *DirectConnect) AssociateHostedConnection(input *AssociateHostedConnectionInput) (*Connection, error) {
	req, out := c.AssociateHostedConnectionRequest(input)
	return out, req.Send()
}

// AssociateHostedConnectionWithContext is the same as AssociateHostedConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateHostedConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AssociateHostedConnectionWithContext(ctx aws.Context, input *AssociateHostedConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AssociateHostedConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateVirtualInterface = "AssociateVirtualInterface"

// AssociateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateVirtualInterface for more information on using the AssociateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateVirtualInterfaceRequest method.
//    req, resp := client.AssociateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface
func (c *DirectConnect) AssociateVirtualInterfaceRequest(input *AssociateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAssociateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateVirtualInterface API operation for AWS Direct Connect.
//
// Associates a virtual interface with a specified link aggregation group (LAG)
// or connection. Connectivity to AWS is temporarily interrupted as the virtual
// interface is being migrated. If the target connection or LAG has an associated
// virtual interface with a conflicting VLAN number or a conflicting IP address,
// the operation fails.
//
// Virtual interfaces associated with a hosted connection cannot be associated
// with a LAG; hosted connections must be migrated along with their virtual
// interfaces using AssociateHostedConnection.
//
// In order to reassociate a virtual interface to a new connection or LAG, the
// requester must own either the virtual interface itself or the connection
// to which the virtual interface is currently associated. Additionally, the
// requester must own the connection or LAG to which the virtual interface will
// be newly associated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AssociateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface
func (c *DirectConnect) AssociateVirtualInterface(input *AssociateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AssociateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// AssociateVirtualInterfaceWithContext is the same as AssociateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AssociateVirtualInterfaceWithContext(ctx aws.Context, input *AssociateVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.AssociateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmConnection = "ConfirmConnection"

// ConfirmConnectionRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmConnection operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmConnection for more information on using the ConfirmConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmConnectionRequest method.
//    req, resp := client.ConfirmConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection
func (c *DirectConnect) ConfirmConnectionRequest(input *ConfirmConnectionInput) (req *request.Request, output *ConfirmConnectionOutput) {
	op := &request.Operation{
		Name:       opConfirmConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmConnectionInput{}
	}

	output = &ConfirmConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmConnection API operation for AWS Direct Connect.
//
// Confirm the creation of a hosted connection on an interconnect.
//
// Upon creation, the hosted connection is initially in the 'Ordering' state,
// and will remain in this state until the owner calls ConfirmConnection to
// confirm creation of the hosted connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection
func (c *DirectConnect) ConfirmConnection(input *ConfirmConnectionInput) (*ConfirmConnectionOutput, error) {
	req, out := c.ConfirmConnectionRequest(input)
	return out, req.Send()
}

// ConfirmConnectionWithContext is the same as ConfirmConnection with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) ConfirmConnectionWithContext(ctx aws.Context, input *ConfirmConnectionInput, opts ...request.Option) (*ConfirmConnectionOutput, error) {
	req, out := c.ConfirmConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmPrivateVirtualInterface = "ConfirmPrivateVirtualInterface"

// ConfirmPrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmPrivateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmPrivateVirtualInterface for more information on using the ConfirmPrivateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmPrivateVirtualInterfaceRequest method.
//    req, resp := client.ConfirmPrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface
func (c *DirectConnect) ConfirmPrivateVirtualInterfaceRequest(input *ConfirmPrivateVirtualInterfaceInput) (req *request.Request, output *ConfirmPrivateVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPrivateVirtualInterfaceInput{}
	}

	output = &ConfirmPrivateVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmPrivateVirtualInterface API operation for AWS Direct Connect.
//
// Accept ownership of a private virtual interface created by another customer.
//
// After the virtual interface owner calls this function, the virtual interface
// will be created and attached to the given virtual private gateway or direct
// connect gateway, and will be available for handling traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmPrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface
func (c *DirectConnect) ConfirmPrivateVirtualInterface(input *ConfirmPrivateVirtualInterfaceInput) (*ConfirmPrivateVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPrivateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// ConfirmPrivateVirtualInterfaceWithContext is the same as ConfirmPrivateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmPrivateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) ConfirmPrivateVirtualInterfaceWithContext(ctx aws.Context, input *ConfirmPrivateVirtualInterfaceInput, opts ...request.Option) (*ConfirmPrivateVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPrivateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmPublicVirtualInterface = "ConfirmPublicVirtualInterface"

// ConfirmPublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmPublicVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmPublicVirtualInterface for more information on using the ConfirmPublicVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmPublicVirtualInterfaceRequest method.
//    req, resp := client.ConfirmPublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface
func (c *DirectConnect) ConfirmPublicVirtualInterfaceRequest(input *ConfirmPublicVirtualInterfaceInput) (req *request.Request, output *ConfirmPublicVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPublicVirtualInterfaceInput{}
	}

	output = &ConfirmPublicVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmPublicVirtualInterface API operation for AWS Direct Connect.
//
// Accept ownership of a public virtual interface created by another customer.
//
// After the virtual interface owner calls this function, the specified virtual
// interface will be created and made available for handling traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmPublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface
func (c *DirectConnect) ConfirmPublicVirtualInterface(input *ConfirmPublicVirtualInterfaceInput) (*ConfirmPublicVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPublicVirtualInterfaceRequest(input)
	return out, req.Send()
}

// ConfirmPublicVirtualInterfaceWithContext is the same as ConfirmPublicVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmPublicVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) ConfirmPublicVirtualInterfaceWithContext(ctx aws.Context, input *ConfirmPublicVirtualInterfaceInput, opts ...request.Option) (*ConfirmPublicVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPublicVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBGPPeer = "CreateBGPPeer"

// CreateBGPPeerRequest generates a "aws/request.Request" representing the
// client's request for the CreateBGPPeer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBGPPeer for more information on using the CreateBGPPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBGPPeerRequest method.
//    req, resp := client.CreateBGPPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer
func (c *DirectConnect) CreateBGPPeerRequest(input *CreateBGPPeerInput) (req *request.Request, output *CreateBGPPeerOutput) {
	op := &request.Operation{
		Name:       opCreateBGPPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBGPPeerInput{}
	}

	output = &CreateBGPPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBGPPeer API operation for AWS Direct Connect.
//
// Creates a new BGP peer on a specified virtual interface. The BGP peer cannot
// be in the same address family (IPv4/IPv6) of an existing BGP peer on the
// virtual interface.
//
// You must create a BGP peer for the corresponding address family in order
// to access AWS resources that also use that address family.
//
// When creating a IPv6 BGP peer, the Amazon address and customer address fields
// must be left blank. IPv6 addresses are automatically assigned from Amazon's
// pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
//
// For a public virtual interface, the Autonomous System Number (ASN) must be
// private or already whitelisted for the virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateBGPPeer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer
func (c *DirectConnect) CreateBGPPeer(input *CreateBGPPeerInput) (*CreateBGPPeerOutput, error) {
	req, out := c.CreateBGPPeerRequest(input)
	return out, req.Send()
}

// CreateBGPPeerWithContext is the same as CreateBGPPeer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBGPPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateBGPPeerWithContext(ctx aws.Context, input *CreateBGPPeerInput, opts ...request.Option) (*CreateBGPPeerOutput, error) {
	req, out := c.CreateBGPPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnection for more information on using the CreateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectionRequest method.
//    req, resp := client.CreateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection
func (c *DirectConnect) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnection API operation for AWS Direct Connect.
//
// Creates a new connection between the customer network and a specific AWS
// Direct Connect location.
//
// A connection links your internal network to an AWS Direct Connect location
// over a standard 1 gigabit or 10 gigabit Ethernet fiber-optic cable. One end
// of the cable is connected to your router, the other to an AWS Direct Connect
// router. An AWS Direct Connect location provides access to Amazon Web Services
// in the region it is associated with. You can establish connections with AWS
// Direct Connect locations in multiple regions, but a connection in one region
// does not provide connectivity to other regions.
//
// To find the locations for your region, use DescribeLocations.
//
// You can automatically add the new connection to a link aggregation group
// (LAG) by specifying a LAG ID in the request. This ensures that the new connection
// is allocated on the same AWS Direct Connect endpoint that hosts the specified
// LAG. If there are no available ports on the endpoint, the request fails and
// no connection will be created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection
func (c *DirectConnect) CreateConnection(input *CreateConnectionInput) (*Connection, error) {
	req, out := c.CreateConnectionRequest(input)
	return out, req.Send()
}

// CreateConnectionWithContext is the same as CreateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateConnectionWithContext(ctx aws.Context, input *CreateConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.CreateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectConnectGateway = "CreateDirectConnectGateway"

// CreateDirectConnectGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectConnectGateway operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectConnectGateway for more information on using the CreateDirectConnectGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectConnectGatewayRequest method.
//    req, resp := client.CreateDirectConnectGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway
func (c *DirectConnect) CreateDirectConnectGatewayRequest(input *CreateDirectConnectGatewayInput) (req *request.Request, output *CreateDirectConnectGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateDirectConnectGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectConnectGatewayInput{}
	}

	output = &CreateDirectConnectGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectConnectGateway API operation for AWS Direct Connect.
//
// Creates a new direct connect gateway. A direct connect gateway is an intermediate
// object that enables you to connect a set of virtual interfaces and virtual
// private gateways. direct connect gateways are global and visible in any AWS
// region after they are created. The virtual interfaces and virtual private
// gateways that are connected through a direct connect gateway can be in different
// regions. This enables you to connect to a VPC in any region, regardless of
// the region in which the virtual interfaces are located, and pass traffic
// between them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateDirectConnectGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway
func (c *DirectConnect) CreateDirectConnectGateway(input *CreateDirectConnectGatewayInput) (*CreateDirectConnectGatewayOutput, error) {
	req, out := c.CreateDirectConnectGatewayRequest(input)
	return out, req.Send()
}

// CreateDirectConnectGatewayWithContext is the same as CreateDirectConnectGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectConnectGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateDirectConnectGatewayWithContext(ctx aws.Context, input *CreateDirectConnectGatewayInput, opts ...request.Option) (*CreateDirectConnectGatewayOutput, error) {
	req, out := c.CreateDirectConnectGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectConnectGatewayAssociation = "CreateDirectConnectGatewayAssociation"

// CreateDirectConnectGatewayAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectConnectGatewayAssociation operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectConnectGatewayAssociation for more information on using the CreateDirectConnectGatewayAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectConnectGatewayAssociationRequest method.
//    req, resp := client.CreateDirectConnectGatewayAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation
func (c *DirectConnect) CreateDirectConnectGatewayAssociationRequest(input *CreateDirectConnectGatewayAssociationInput) (req *request.Request, output *CreateDirectConnectGatewayAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateDirectConnectGatewayAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectConnectGatewayAssociationInput{}
	}

	output = &CreateDirectConnectGatewayAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectConnectGatewayAssociation API operation for AWS Direct Connect.
//
// Creates an association between a direct connect gateway and a virtual private
// gateway (VGW). The VGW must be attached to a VPC and must not be associated
// with another direct connect gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateDirectConnectGatewayAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation
func (c *DirectConnect) CreateDirectConnectGatewayAssociation(input *CreateDirectConnectGatewayAssociationInput) (*CreateDirectConnectGatewayAssociationOutput, error) {
	req, out := c.CreateDirectConnectGatewayAssociationRequest(input)
	return out, req.Send()
}

// CreateDirectConnectGatewayAssociationWithContext is the same as CreateDirectConnectGatewayAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectConnectGatewayAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateDirectConnectGatewayAssociationWithContext(ctx aws.Context, input *CreateDirectConnectGatewayAssociationInput, opts ...request.Option) (*CreateDirectConnectGatewayAssociationOutput, error) {
	req, out := c.CreateDirectConnectGatewayAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInterconnect = "CreateInterconnect"

// CreateInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the CreateInterconnect operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInterconnect for more information on using the CreateInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInterconnectRequest method.
//    req, resp := client.CreateInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect
func (c *DirectConnect) CreateInterconnectRequest(input *CreateInterconnectInput) (req *request.Request, output *Interconnect) {
	op := &request.Operation{
		Name:       opCreateInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInterconnectInput{}
	}

	output = &Interconnect{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInterconnect API operation for AWS Direct Connect.
//
// Creates a new interconnect between a AWS Direct Connect partner's network
// and a specific AWS Direct Connect location.
//
// An interconnect is a connection which is capable of hosting other connections.
// The AWS Direct Connect partner can use an interconnect to provide sub-1Gbps
// AWS Direct Connect service to tier 2 customers who do not have their own
// connections. Like a standard connection, an interconnect links the AWS Direct
// Connect partner's network to an AWS Direct Connect location over a standard
// 1 Gbps or 10 Gbps Ethernet fiber-optic cable. One end is connected to the
// partner's router, the other to an AWS Direct Connect router.
//
// You can automatically add the new interconnect to a link aggregation group
// (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect
// is allocated on the same AWS Direct Connect endpoint that hosts the specified
// LAG. If there are no available ports on the endpoint, the request fails and
// no interconnect will be created.
//
// For each end customer, the AWS Direct Connect partner provisions a connection
// on their interconnect by calling AllocateConnectionOnInterconnect. The end
// customer can then connect to AWS resources by creating a virtual interface
// on their connection, using the VLAN assigned to them by the AWS Direct Connect
// partner.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect
func (c *DirectConnect) CreateInterconnect(input *CreateInterconnectInput) (*Interconnect, error) {
	req, out := c.CreateInterconnectRequest(input)
	return out, req.Send()
}

// CreateInterconnectWithContext is the same as CreateInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateInterconnectWithContext(ctx aws.Context, input *CreateInterconnectInput, opts ...request.Option) (*Interconnect, error) {
	req, out := c.CreateInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLag = "CreateLag"

// CreateLagRequest generates a "aws/request.Request" representing the
// client's request for the CreateLag operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLag for more information on using the CreateLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLagRequest method.
//    req, resp := client.CreateLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag
func (c *DirectConnect) CreateLagRequest(input *CreateLagInput) (req *request.Request, output *Lag) {
	op := &request.Operation{
		Name:       opCreateLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLagInput{}
	}

	output = &Lag{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLag API operation for AWS Direct Connect.
//
// Creates a new link aggregation group (LAG) with the specified number of bundled
// physical connections between the customer network and a specific AWS Direct
// Connect location. A LAG is a logical interface that uses the Link Aggregation
// Control Protocol (LACP) to aggregate multiple 1 gigabit or 10 gigabit interfaces,
// allowing you to treat them as a single interface.
//
// All connections in a LAG must use the same bandwidth (for example, 10 Gbps),
// and must terminate at the same AWS Direct Connect endpoint.
//
// You can have up to 10 connections per LAG. Regardless of this limit, if you
// request more connections for the LAG than AWS Direct Connect can allocate
// on a single endpoint, no LAG is created.
//
// You can specify an existing physical connection or interconnect to include
// in the LAG (which counts towards the total number of connections). Doing
// so interrupts the current physical connection or hosted connections, and
// re-establishes them as a member of the LAG. The LAG will be created on the
// same AWS Direct Connect endpoint to which the connection terminates. Any
// virtual interfaces associated with the connection are automatically disassociated
// and re-associated with the LAG. The connection ID does not change.
//
// If the AWS account used to create a LAG is a registered AWS Direct Connect
// partner, the LAG is automatically enabled to host sub-connections. For a
// LAG owned by a partner, any associated virtual interfaces cannot be directly
// configured.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag
func (c *DirectConnect) CreateLag(input *CreateLagInput) (*Lag, error) {
	req, out := c.CreateLagRequest(input)
	return out, req.Send()
}

// CreateLagWithContext is the same as CreateLag with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateLagWithContext(ctx aws.Context, input *CreateLagInput, opts ...request.Option) (*Lag, error) {
	req, out := c.CreateLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePrivateVirtualInterface = "CreatePrivateVirtualInterface"

// CreatePrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrivateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePrivateVirtualInterface for more information on using the CreatePrivateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePrivateVirtualInterfaceRequest method.
//    req, resp := client.CreatePrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface
func (c *DirectConnect) CreatePrivateVirtualInterfaceRequest(input *CreatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrivateVirtualInterface API operation for AWS Direct Connect.
//
// Creates a new private virtual interface. A virtual interface is the VLAN
// that transports AWS Direct Connect traffic. A private virtual interface supports
// sending traffic to a single virtual private cloud (VPC).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreatePrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface
func (c *DirectConnect) CreatePrivateVirtualInterface(input *CreatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePrivateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// CreatePrivateVirtualInterfaceWithContext is the same as CreatePrivateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrivateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreatePrivateVirtualInterfaceWithContext(ctx aws.Context, input *CreatePrivateVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.CreatePrivateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublicVirtualInterface = "CreatePublicVirtualInterface"

// CreatePublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublicVirtualInterface for more information on using the CreatePublicVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePublicVirtualInterfaceRequest method.
//    req, resp := client.CreatePublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface
func (c *DirectConnect) CreatePublicVirtualInterfaceRequest(input *CreatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicVirtualInterface API operation for AWS Direct Connect.
//
// Creates a new public virtual interface. A virtual interface is the VLAN that
// transports AWS Direct Connect traffic. A public virtual interface supports
// sending traffic to public services of AWS such as Amazon Simple Storage Service
// (Amazon S3).
//
// When creating an IPv6 public virtual interface (addressFamily is 'ipv6'),
// the customer and amazon address fields should be left blank to use auto-assigned
// IPv6 space. Custom IPv6 Addresses are currently not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreatePublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface
func (c *DirectConnect) CreatePublicVirtualInterface(input *CreatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePublicVirtualInterfaceRequest(input)
	return out, req.Send()
}

// CreatePublicVirtualInterfaceWithContext is the same as CreatePublicVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublicVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreatePublicVirtualInterfaceWithContext(ctx aws.Context, input *CreatePublicVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.CreatePublicVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBGPPeer = "DeleteBGPPeer"

// DeleteBGPPeerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBGPPeer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBGPPeer for more information on using the DeleteBGPPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBGPPeerRequest method.
//    req, resp := client.DeleteBGPPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer
func (c *DirectConnect) DeleteBGPPeerRequest(input *DeleteBGPPeerInput) (req *request.Request, output *DeleteBGPPeerOutput) {
	op := &request.Operation{
		Name:       opDeleteBGPPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBGPPeerInput{}
	}

	output = &DeleteBGPPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBGPPeer API operation for AWS Direct Connect.
//
// Deletes a BGP peer on the specified virtual interface that matches the specified
// customer address and ASN. You cannot delete the last BGP peer from a virtual
// interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteBGPPeer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer
func (c *DirectConnect) DeleteBGPPeer(input *DeleteBGPPeerInput) (*DeleteBGPPeerOutput, error) {
	req, out := c.DeleteBGPPeerRequest(input)
	return out, req.Send()
}

// DeleteBGPPeerWithContext is the same as DeleteBGPPeer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBGPPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteBGPPeerWithContext(ctx aws.Context, input *DeleteBGPPeerInput, opts ...request.Option) (*DeleteBGPPeerOutput, error) {
	req, out := c.DeleteBGPPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectionRequest method.
//    req, resp := client.DeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection
func (c *DirectConnect) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for AWS Direct Connect.
//
// Deletes the connection.
//
// Deleting a connection only stops the AWS Direct Connect port hour and data
// transfer charges. You need to cancel separately with the providers any services
// or charges for cross-connects or network circuits that connect you to the
// AWS Direct Connect location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection
func (c *DirectConnect) DeleteConnection(input *DeleteConnectionInput) (*Connection, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectConnectGateway = "DeleteDirectConnectGateway"

// DeleteDirectConnectGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectConnectGateway operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectConnectGateway for more information on using the DeleteDirectConnectGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectConnectGatewayRequest method.
//    req, resp := client.DeleteDirectConnectGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway
func (c *DirectConnect) DeleteDirectConnectGatewayRequest(input *DeleteDirectConnectGatewayInput) (req *request.Request, output *DeleteDirectConnectGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectConnectGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectConnectGatewayInput{}
	}

	output = &DeleteDirectConnectGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectConnectGateway API operation for AWS Direct Connect.
//
// Deletes a direct connect gateway. You must first delete all virtual interfaces
// that are attached to the direct connect gateway and disassociate all virtual
// private gateways that are associated with the direct connect gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteDirectConnectGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway
func (c *DirectConnect) DeleteDirectConnectGateway(input *DeleteDirectConnectGatewayInput) (*DeleteDirectConnectGatewayOutput, error) {
	req, out := c.DeleteDirectConnectGatewayRequest(input)
	return out, req.Send()
}

// DeleteDirectConnectGatewayWithContext is the same as DeleteDirectConnectGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectConnectGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteDirectConnectGatewayWithContext(ctx aws.Context, input *DeleteDirectConnectGatewayInput, opts ...request.Option) (*DeleteDirectConnectGatewayOutput, error) {
	req, out := c.DeleteDirectConnectGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectConnectGatewayAssociation = "DeleteDirectConnectGatewayAssociation"

// DeleteDirectConnectGatewayAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectConnectGatewayAssociation operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectConnectGatewayAssociation for more information on using the DeleteDirectConnectGatewayAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectConnectGatewayAssociationRequest method.
//    req, resp := client.DeleteDirectConnectGatewayAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation
func (c *DirectConnect) DeleteDirectConnectGatewayAssociationRequest(input *DeleteDirectConnectGatewayAssociationInput) (req *request.Request, output *DeleteDirectConnectGatewayAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectConnectGatewayAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectConnectGatewayAssociationInput{}
	}

	output = &DeleteDirectConnectGatewayAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectConnectGatewayAssociation API operation for AWS Direct Connect.
//
// Deletes the association between a direct connect gateway and a virtual private
// gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteDirectConnectGatewayAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation
func (c *DirectConnect) DeleteDirectConnectGatewayAssociation(input *DeleteDirectConnectGatewayAssociationInput) (*DeleteDirectConnectGatewayAssociationOutput, error) {
	req, out := c.DeleteDirectConnectGatewayAssociationRequest(input)
	return out, req.Send()
}

// DeleteDirectConnectGatewayAssociationWithContext is the same as DeleteDirectConnectGatewayAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectConnectGatewayAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteDirectConnectGatewayAssociationWithContext(ctx aws.Context, input *DeleteDirectConnectGatewayAssociationInput, opts ...request.Option) (*DeleteDirectConnectGatewayAssociationOutput, error) {
	req, out := c.DeleteDirectConnectGatewayAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInterconnect = "DeleteInterconnect"

// DeleteInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInterconnect operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInterconnect for more information on using the DeleteInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInterconnectRequest method.
//    req, resp := client.DeleteInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect
func (c *DirectConnect) DeleteInterconnectRequest(input *DeleteInterconnectInput) (req *request.Request, output *DeleteInterconnectOutput) {
	op := &request.Operation{
		Name:       opDeleteInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInterconnectInput{}
	}

	output = &DeleteInterconnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInterconnect API operation for AWS Direct Connect.
//
// Deletes the specified interconnect.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect
func (c *DirectConnect) DeleteInterconnect(input *DeleteInterconnectInput) (*DeleteInterconnectOutput, error) {
	req, out := c.DeleteInterconnectRequest(input)
	return out, req.Send()
}

// DeleteInterconnectWithContext is the same as DeleteInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteInterconnectWithContext(ctx aws.Context, input *DeleteInterconnectInput, opts ...request.Option) (*DeleteInterconnectOutput, error) {
	req, out := c.DeleteInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLag = "DeleteLag"

// DeleteLagRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLag operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLag for more information on using the DeleteLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLagRequest method.
//    req, resp := client.DeleteLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag
func (c *DirectConnect) DeleteLagRequest(input *DeleteLagInput) (req *request.Request, output *Lag) {
	op := &request.Operation{
		Name:       opDeleteLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLagInput{}
	}

	output = &Lag{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLag API operation for AWS Direct Connect.
//
// Deletes a link aggregation group (LAG). You cannot delete a LAG if it has
// active virtual interfaces or hosted connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag
func (c *DirectConnect) DeleteLag(input *DeleteLagInput) (*Lag, error) {
	req, out := c.DeleteLagRequest(input)
	return out, req.Send()
}

// DeleteLagWithContext is the same as DeleteLag with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteLagWithContext(ctx aws.Context, input *DeleteLagInput, opts ...request.Option) (*Lag, error) {
	req, out := c.DeleteLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualInterface = "DeleteVirtualInterface"

// DeleteVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualInterface for more information on using the DeleteVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVirtualInterfaceRequest method.
//    req, resp := client.DeleteVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface
func (c *DirectConnect) DeleteVirtualInterfaceRequest(input *DeleteVirtualInterfaceInput) (req *request.Request, output *DeleteVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVirtualInterfaceInput{}
	}

	output = &DeleteVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualInterface API operation for AWS Direct Connect.
//
// Deletes a virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface
func (c *DirectConnect) DeleteVirtualInterface(input *DeleteVirtualInterfaceInput) (*DeleteVirtualInterfaceOutput, error) {
	req, out := c.DeleteVirtualInterfaceRequest(input)
	return out, req.Send()
}

// DeleteVirtualInterfaceWithContext is the same as DeleteVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteVirtualInterfaceWithContext(ctx aws.Context, input *DeleteVirtualInterfaceInput, opts ...request.Option) (*DeleteVirtualInterfaceOutput, error) {
	req, out := c.DeleteVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionLoa = "DescribeConnectionLoa"

// DescribeConnectionLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionLoa operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionLoa for more information on using the DescribeConnectionLoa
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionLoaRequest method.
//    req, resp := client.DescribeConnectionLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoa
func (c *DirectConnect) DescribeConnectionLoaRequest(input *DescribeConnectionLoaInput) (req *request.Request, output *DescribeConnectionLoaOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeConnectionLoa, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeConnectionLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionLoaInput{}
	}

	output = &DescribeConnectionLoaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionLoa API operation for AWS Direct Connect.
//
// Deprecated in favor of DescribeLoa.
//
// Returns the LOA-CFA for a Connection.
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that your APN partner or service provider uses when establishing
// your cross connect to AWS at the colocation facility. For more information,
// see Requesting Cross Connects at AWS Direct Connect Locations (http://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect user guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnectionLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoa
func (c *DirectConnect) DescribeConnectionLoa(input *DescribeConnectionLoaInput) (*DescribeConnectionLoaOutput, error) {
	req, out := c.DescribeConnectionLoaRequest(input)
	return out, req.Send()
}

// DescribeConnectionLoaWithContext is the same as DescribeConnectionLoa with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionLoa for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeConnectionLoaWithContext(ctx aws.Context, input *DescribeConnectionLoaInput, opts ...request.Option) (*DescribeConnectionLoaOutput, error) {
	req, out := c.DescribeConnectionLoaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnections operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnections for more information on using the DescribeConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionsRequest method.
//    req, resp := client.DescribeConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections
func (c *DirectConnect) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnections API operation for AWS Direct Connect.
//
// Displays all connections in this region.
//
// If a connection ID is provided, the call returns only that particular connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections
func (c *DirectConnect) DescribeConnections(input *DescribeConnectionsInput) (*Connections, error) {
	req, out := c.DescribeConnectionsRequest(input)
	return out, req.Send()
}

// DescribeConnectionsWithContext is the same as DescribeConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeConnectionsWithContext(ctx aws.Context, input *DescribeConnectionsInput, opts ...request.Option) (*Connections, error) {
	req, out := c.DescribeConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionsOnInterconnect = "DescribeConnectionsOnInterconnect"

// DescribeConnectionsOnInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionsOnInterconnect operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionsOnInterconnect for more information on using the DescribeConnectionsOnInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionsOnInterconnectRequest method.
//    req, resp := client.DescribeConnectionsOnInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnect
func (c *DirectConnect) DescribeConnectionsOnInterconnectRequest(input *DescribeConnectionsOnInterconnectInput) (req *request.Request, output *Connections) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeConnectionsOnInterconnect, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeConnectionsOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsOnInterconnectInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionsOnInterconnect API operation for AWS Direct Connect.
//
// Deprecated in favor of DescribeHostedConnections.
//
// Returns a list of connections that have been provisioned on the given interconnect.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnectionsOnInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnect
func (c *DirectConnect) DescribeConnectionsOnInterconnect(input *DescribeConnectionsOnInterconnectInput) (*Connections, error) {
	req, out := c.DescribeConnectionsOnInterconnectRequest(input)
	return out, req.Send()
}

// DescribeConnectionsOnInterconnectWithContext is the same as DescribeConnectionsOnInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionsOnInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeConnectionsOnInterconnectWithContext(ctx aws.Context, input *DescribeConnectionsOnInterconnectInput, opts ...request.Option) (*Connections, error) {
	req, out := c.DescribeConnectionsOnInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectConnectGatewayAssociations = "DescribeDirectConnectGatewayAssociations"

// DescribeDirectConnectGatewayAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectConnectGatewayAssociations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectConnectGatewayAssociations for more information on using the DescribeDirectConnectGatewayAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectConnectGatewayAssociationsRequest method.
//    req, resp := client.DescribeDirectConnectGatewayAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations
func (c *DirectConnect) DescribeDirectConnectGatewayAssociationsRequest(input *DescribeDirectConnectGatewayAssociationsInput) (req *request.Request, output *DescribeDirectConnectGatewayAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectConnectGatewayAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewayAssociationsInput{}
	}

	output = &DescribeDirectConnectGatewayAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectConnectGatewayAssociations API operation for AWS Direct Connect.
//
// Returns a list of all direct connect gateway and virtual private gateway
// (VGW) associations. Either a direct connect gateway ID or a VGW ID must be
// provided in the request. If a direct connect gateway ID is provided, the
// response returns all VGWs associated with the direct connect gateway. If
// a VGW ID is provided, the response returns all direct connect gateways associated
// with the VGW. If both are provided, the response only returns the association
// that matches both the direct connect gateway and the VGW.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeDirectConnectGatewayAssociations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations
func (c *DirectConnect) DescribeDirectConnectGatewayAssociations(input *DescribeDirectConnectGatewayAssociationsInput) (*DescribeDirectConnectGatewayAssociationsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAssociationsRequest(input)
	return out, req.Send()
}

// DescribeDirectConnectGatewayAssociationsWithContext is the same as DescribeDirectConnectGatewayAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectConnectGatewayAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeDirectConnectGatewayAssociationsWithContext(ctx aws.Context, input *DescribeDirectConnectGatewayAssociationsInput, opts ...request.Option) (*DescribeDirectConnectGatewayAssociationsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectConnectGatewayAttachments = "DescribeDirectConnectGatewayAttachments"

// DescribeDirectConnectGatewayAttachmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectConnectGatewayAttachments operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectConnectGatewayAttachments for more information on using the DescribeDirectConnectGatewayAttachments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectConnectGatewayAttachmentsRequest method.
//    req, resp := client.DescribeDirectConnectGatewayAttachmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments
func (c *DirectConnect) DescribeDirectConnectGatewayAttachmentsRequest(input *DescribeDirectConnectGatewayAttachmentsInput) (req *request.Request, output *DescribeDirectConnectGatewayAttachmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectConnectGatewayAttachments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewayAttachmentsInput{}
	}

	output = &DescribeDirectConnectGatewayAttachmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectConnectGatewayAttachments API operation for AWS Direct Connect.
//
// Returns a list of all direct connect gateway and virtual interface (VIF)
// attachments. Either a direct connect gateway ID or a VIF ID must be provided
// in the request. If a direct connect gateway ID is provided, the response
// returns all VIFs attached to the direct connect gateway. If a VIF ID is provided,
// the response returns all direct connect gateways attached to the VIF. If
// both are provided, the response only returns the attachment that matches
// both the direct connect gateway and the VIF.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeDirectConnectGatewayAttachments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments
func (c *DirectConnect) DescribeDirectConnectGatewayAttachments(input *DescribeDirectConnectGatewayAttachmentsInput) (*DescribeDirectConnectGatewayAttachmentsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAttachmentsRequest(input)
	return out, req.Send()
}

// DescribeDirectConnectGatewayAttachmentsWithContext is the same as DescribeDirectConnectGatewayAttachments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectConnectGatewayAttachments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeDirectConnectGatewayAttachmentsWithContext(ctx aws.Context, input *DescribeDirectConnectGatewayAttachmentsInput, opts ...request.Option) (*DescribeDirectConnectGatewayAttachmentsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAttachmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectConnectGateways = "DescribeDirectConnectGateways"

// DescribeDirectConnectGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectConnectGateways operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectConnectGateways for more information on using the DescribeDirectConnectGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectConnectGatewaysRequest method.
//    req, resp := client.DescribeDirectConnectGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways
func (c *DirectConnect) DescribeDirectConnectGatewaysRequest(input *DescribeDirectConnectGatewaysInput) (req *request.Request, output *DescribeDirectConnectGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectConnectGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewaysInput{}
	}

	output = &DescribeDirectConnectGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectConnectGateways API operation for AWS Direct Connect.
//
// Returns a list of direct connect gateways in your account. Deleted direct
// connect gateways are not returned. You can provide a direct connect gateway
// ID in the request to return information about the specific direct connect
// gateway only. Otherwise, if a direct connect gateway ID is not provided,
// information about all of your direct connect gateways is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeDirectConnectGateways for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways
func (c *DirectConnect) DescribeDirectConnectGateways(input *DescribeDirectConnectGatewaysInput) (*DescribeDirectConnectGatewaysOutput, error) {
	req, out := c.DescribeDirectConnectGatewaysRequest(input)
	return out, req.Send()
}

// DescribeDirectConnectGatewaysWithContext is the same as DescribeDirectConnectGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectConnectGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeDirectConnectGatewaysWithContext(ctx aws.Context, input *DescribeDirectConnectGatewaysInput, opts ...request.Option) (*DescribeDirectConnectGatewaysOutput, error) {
	req, out := c.DescribeDirectConnectGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHostedConnections = "DescribeHostedConnections"

// DescribeHostedConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostedConnections operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHostedConnections for more information on using the DescribeHostedConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHostedConnectionsRequest method.
//    req, resp := client.DescribeHostedConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections
func (c *DirectConnect) DescribeHostedConnectionsRequest(input *DescribeHostedConnectionsInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeHostedConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHostedConnectionsInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostedConnections API operation for AWS Direct Connect.
//
// Returns a list of hosted connections that have been provisioned on the given
// interconnect or link aggregation group (LAG).
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeHostedConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections
func (c *DirectConnect) DescribeHostedConnections(input *DescribeHostedConnectionsInput) (*Connections, error) {
	req, out := c.DescribeHostedConnectionsRequest(input)
	return out, req.Send()
}

// DescribeHostedConnectionsWithContext is the same as DescribeHostedConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHostedConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeHostedConnectionsWithContext(ctx aws.Context, input *DescribeHostedConnectionsInput, opts ...request.Option) (*Connections, error) {
	req, out := c.DescribeHostedConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInterconnectLoa = "DescribeInterconnectLoa"

// DescribeInterconnectLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInterconnectLoa operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInterconnectLoa for more information on using the DescribeInterconnectLoa
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInterconnectLoaRequest method.
//    req, resp := client.DescribeInterconnectLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoa
func (c *DirectConnect) DescribeInterconnectLoaRequest(input *DescribeInterconnectLoaInput) (req *request.Request, output *DescribeInterconnectLoaOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeInterconnectLoa, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeInterconnectLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectLoaInput{}
	}

	output = &DescribeInterconnectLoaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInterconnectLoa API operation for AWS Direct Connect.
//
// Deprecated in favor of DescribeLoa.
//
// Returns the LOA-CFA for an Interconnect.
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that is used when establishing your cross connect to AWS at the
// colocation facility. For more information, see Requesting Cross Connects
// at AWS Direct Connect Locations (http://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect user guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeInterconnectLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoa
func (c *DirectConnect) DescribeInterconnectLoa(input *DescribeInterconnectLoaInput) (*DescribeInterconnectLoaOutput, error) {
	req, out := c.DescribeInterconnectLoaRequest(input)
	return out, req.Send()
}

// DescribeInterconnectLoaWithContext is the same as DescribeInterconnectLoa with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInterconnectLoa for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeInterconnectLoaWithContext(ctx aws.Context, input *DescribeInterconnectLoaInput, opts ...request.Option) (*DescribeInterconnectLoaOutput, error) {
	req, out := c.DescribeInterconnectLoaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInterconnects = "DescribeInterconnects"

// DescribeInterconnectsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInterconnects operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInterconnects for more information on using the DescribeInterconnects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInterconnectsRequest method.
//    req, resp := client.DescribeInterconnectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects
func (c *DirectConnect) DescribeInterconnectsRequest(input *DescribeInterconnectsInput) (req *request.Request, output *DescribeInterconnectsOutput) {
	op := &request.Operation{
		Name:       opDescribeInterconnects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectsInput{}
	}

	output = &DescribeInterconnectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInterconnects API operation for AWS Direct Connect.
//
// Returns a list of interconnects owned by the AWS account.
//
// If an interconnect ID is provided, it will only return this particular interconnect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeInterconnects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects
func (c *DirectConnect) DescribeInterconnects(input *DescribeInterconnectsInput) (*DescribeInterconnectsOutput, error) {
	req, out := c.DescribeInterconnectsRequest(input)
	return out, req.Send()
}

// DescribeInterconnectsWithContext is the same as DescribeInterconnects with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInterconnects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeInterconnectsWithContext(ctx aws.Context, input *DescribeInterconnectsInput, opts ...request.Option) (*DescribeInterconnectsOutput, error) {
	req, out := c.DescribeInterconnectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLags = "DescribeLags"

// DescribeLagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLags for more information on using the DescribeLags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLagsRequest method.
//    req, resp := client.DescribeLagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags
func (c *DirectConnect) DescribeLagsRequest(input *DescribeLagsInput) (req *request.Request, output *DescribeLagsOutput) {
	op := &request.Operation{
		Name:       opDescribeLags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLagsInput{}
	}

	output = &DescribeLagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLags API operation for AWS Direct Connect.
//
// Describes the link aggregation groups (LAGs) in your account.
//
// If a LAG ID is provided, only information about the specified LAG is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeLags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags
func (c *DirectConnect) DescribeLags(input *DescribeLagsInput) (*DescribeLagsOutput, error) {
	req, out := c.DescribeLagsRequest(input)
	return out, req.Send()
}

// DescribeLagsWithContext is the same as DescribeLags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeLagsWithContext(ctx aws.Context, input *DescribeLagsInput, opts ...request.Option) (*DescribeLagsOutput, error) {
	req, out := c.DescribeLagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoa = "DescribeLoa"

// DescribeLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoa operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoa for more information on using the DescribeLoa
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoaRequest method.
//    req, resp := client.DescribeLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa
func (c *DirectConnect) DescribeLoaRequest(input *DescribeLoaInput) (req *request.Request, output *Loa) {
	op := &request.Operation{
		Name:       opDescribeLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoaInput{}
	}

	output = &Loa{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoa API operation for AWS Direct Connect.
//
// Returns the LOA-CFA for a connection, interconnect, or link aggregation group
// (LAG).
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that is used when establishing your cross connect to AWS at the
// colocation facility. For more information, see Requesting Cross Connects
// at AWS Direct Connect Locations (http://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect user guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa
func (c *DirectConnect) DescribeLoa(input *DescribeLoaInput) (*Loa, error) {
	req, out := c.DescribeLoaRequest(input)
	return out, req.Send()
}

// DescribeLoaWithContext is the same as DescribeLoa with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoa for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeLoaWithContext(ctx aws.Context, input *DescribeLoaInput, opts ...request.Option) (*Loa, error) {
	req, out := c.DescribeLoaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocations = "DescribeLocations"

// DescribeLocationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocations for more information on using the DescribeLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationsRequest method.
//    req, resp := client.DescribeLocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations
func (c *DirectConnect) DescribeLocationsRequest(input *DescribeLocationsInput) (req *request.Request, output *DescribeLocationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationsInput{}
	}

	output = &DescribeLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocations API operation for AWS Direct Connect.
//
// Returns the list of AWS Direct Connect locations in the current AWS region.
// These are the locations that may be selected when calling CreateConnection
// or CreateInterconnect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeLocations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations
func (c *DirectConnect) DescribeLocations(input *DescribeLocationsInput) (*DescribeLocationsOutput, error) {
	req, out := c.DescribeLocationsRequest(input)
	return out, req.Send()
}

// DescribeLocationsWithContext is the same as DescribeLocations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeLocationsWithContext(ctx aws.Context, input *DescribeLocationsInput, opts ...request.Option) (*DescribeLocationsOutput, error) {
	req, out := c.DescribeLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags
func (c *DirectConnect) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for AWS Direct Connect.
//
// Describes the tags associated with the specified Direct Connect resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags
func (c *DirectConnect) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualGateways = "DescribeVirtualGateways"

// DescribeVirtualGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualGateways operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualGateways for more information on using the DescribeVirtualGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualGatewaysRequest method.
//    req, resp := client.DescribeVirtualGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways
func (c *DirectConnect) DescribeVirtualGatewaysRequest(input *DescribeVirtualGatewaysInput) (req *request.Request, output *DescribeVirtualGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualGatewaysInput{}
	}

	output = &DescribeVirtualGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualGateways API operation for AWS Direct Connect.
//
// Returns a list of virtual private gateways owned by the AWS account.
//
// You can create one or more AWS Direct Connect private virtual interfaces
// linking to a virtual private gateway. A virtual private gateway can be managed
// via Amazon Virtual Private Cloud (VPC) console or the EC2 CreateVpnGateway
// (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeVirtualGateways for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways
func (c *DirectConnect) DescribeVirtualGateways(input *DescribeVirtualGatewaysInput) (*DescribeVirtualGatewaysOutput, error) {
	req, out := c.DescribeVirtualGatewaysRequest(input)
	return out, req.Send()
}

// DescribeVirtualGatewaysWithContext is the same as DescribeVirtualGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeVirtualGatewaysWithContext(ctx aws.Context, input *DescribeVirtualGatewaysInput, opts ...request.Option) (*DescribeVirtualGatewaysOutput, error) {
	req, out := c.DescribeVirtualGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualInterfaces = "DescribeVirtualInterfaces"

// DescribeVirtualInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualInterfaces operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualInterfaces for more information on using the DescribeVirtualInterfaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualInterfacesRequest method.
//    req, resp := client.DescribeVirtualInterfacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces
func (c *DirectConnect) DescribeVirtualInterfacesRequest(input *DescribeVirtualInterfacesInput) (req *request.Request, output *DescribeVirtualInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualInterfacesInput{}
	}

	output = &DescribeVirtualInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualInterfaces API operation for AWS Direct Connect.
//
// Displays all virtual interfaces for an AWS account. Virtual interfaces deleted
// fewer than 15 minutes before you make the request are also returned. If you
// specify a connection ID, only the virtual interfaces associated with the
// connection are returned. If you specify a virtual interface ID, then only
// a single virtual interface is returned.
//
// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
// location and the customer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeVirtualInterfaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces
func (c *DirectConnect) DescribeVirtualInterfaces(input *DescribeVirtualInterfacesInput) (*DescribeVirtualInterfacesOutput, error) {
	req, out := c.DescribeVirtualInterfacesRequest(input)
	return out, req.Send()
}

// DescribeVirtualInterfacesWithContext is the same as DescribeVirtualInterfaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualInterfaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeVirtualInterfacesWithContext(ctx aws.Context, input *DescribeVirtualInterfacesInput, opts ...request.Option) (*DescribeVirtualInterfacesOutput, error) {
	req, out := c.DescribeVirtualInterfacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConnectionFromLag = "DisassociateConnectionFromLag"

// DisassociateConnectionFromLagRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConnectionFromLag operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateConnectionFromLag for more information on using the DisassociateConnectionFromLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateConnectionFromLagRequest method.
//    req, resp := client.DisassociateConnectionFromLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag
func (c *DirectConnect) DisassociateConnectionFromLagRequest(input *DisassociateConnectionFromLagInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opDisassociateConnectionFromLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectionFromLagInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateConnectionFromLag API operation for AWS Direct Connect.
//
// Disassociates a connection from a link aggregation group (LAG). The connection
// is interrupted and re-established as a standalone connection (the connection
// is not deleted; to delete the connection, use the DeleteConnection request).
// If the LAG has associated virtual interfaces or hosted connections, they
// remain associated with the LAG. A disassociated connection owned by an AWS
// Direct Connect partner is automatically converted to an interconnect.
//
// If disassociating the connection will cause the LAG to fall below its setting
// for minimum number of operational connections, the request fails, except
// when it's the last member of the LAG. If all connections are disassociated,
// the LAG continues to exist as an empty LAG with no physical connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DisassociateConnectionFromLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag
func (c *DirectConnect) DisassociateConnectionFromLag(input *DisassociateConnectionFromLagInput) (*Connection, error) {
	req, out := c.DisassociateConnectionFromLagRequest(input)
	return out, req.Send()
}

// DisassociateConnectionFromLagWithContext is the same as DisassociateConnectionFromLag with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConnectionFromLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DisassociateConnectionFromLagWithContext(ctx aws.Context, input *DisassociateConnectionFromLagInput, opts ...request.Option) (*Connection, error) {
	req, out := c.DisassociateConnectionFromLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource
func (c *DirectConnect) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for AWS Direct Connect.
//
// Adds the specified tags to the specified Direct Connect resource. Each Direct
// Connect resource can have a maximum of 50 tags.
//
// Each tag consists of a key and an optional value. If a tag with the same
// key is already associated with the Direct Connect resource, this action updates
// its value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned to
//   a Direct Connect resource.
//
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource
func (c *DirectConnect) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource
func (c *DirectConnect) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for AWS Direct Connect.
//
// Removes one or more tags from the specified Direct Connect resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource
func (c *DirectConnect) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLag = "UpdateLag"

// UpdateLagRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLag operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLag for more information on using the UpdateLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLagRequest method.
//    req, resp := client.UpdateLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag
func (c *DirectConnect) UpdateLagRequest(input *UpdateLagInput) (req *request.Request, output *Lag) {
	op := &request.Operation{
		Name:       opUpdateLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLagInput{}
	}

	output = &Lag{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLag API operation for AWS Direct Connect.
//
// Updates the attributes of a link aggregation group (LAG).
//
// You can update the following attributes:
//
//    * The name of the LAG.
//
//    * The value for the minimum number of connections that must be operational
//    for the LAG itself to be operational.
//
// When you create a LAG, the default value for the minimum number of operational
// connections is zero (0). If you update this value, and the number of operational
// connections falls below the specified value, the LAG will automatically go
// down to avoid overutilization of the remaining connections. Adjusting this
// value should be done with care as it could force the LAG down if the value
// is set higher than the current number of operational connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation UpdateLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag
func (c *DirectConnect) UpdateLag(input *UpdateLagInput) (*Lag, error) {
	req, out := c.UpdateLagRequest(input)
	return out, req.Send()
}

// UpdateLagWithContext is the same as UpdateLag with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) UpdateLagWithContext(ctx aws.Context, input *UpdateLagInput, opts ...request.Option) (*Lag, error) {
	req, out := c.UpdateLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Container for the parameters to the AllocateConnectionOnInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnectRequest
type AllocateConnectionOnInterconnectInput struct {
	_ struct{} `type:"structure"`

	// Bandwidth of the connection.
	//
	// Example: "500Mbps"
	//
	// Default: None
	//
	// Values: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// Name of the provisioned connection.
	//
	// Example: "500M Connection to AWS"
	//
	// Default: None
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// ID of the interconnect on which the connection will be provisioned.
	//
	// Example: dxcon-456abc78
	//
	// Default: None
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// Numeric account Id of the customer for whom the connection will be provisioned.
	//
	// Example: 123443215678
	//
	// Default: None
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	// The dedicated VLAN provisioned to the connection.
	//
	// Example: 101
	//
	// Default: None
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateConnectionOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateConnectionOnInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateConnectionOnInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateConnectionOnInterconnectInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *AllocateConnectionOnInterconnectInput) SetBandwidth(v string) *AllocateConnectionOnInterconnectInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *AllocateConnectionOnInterconnectInput) SetConnectionName(v string) *AllocateConnectionOnInterconnectInput {
	s.ConnectionName = &v
	return s
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *AllocateConnectionOnInterconnectInput) SetInterconnectId(v string) *AllocateConnectionOnInterconnectInput {
	s.InterconnectId = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocateConnectionOnInterconnectInput) SetOwnerAccount(v string) *AllocateConnectionOnInterconnectInput {
	s.OwnerAccount = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *AllocateConnectionOnInterconnectInput) SetVlan(v int64) *AllocateConnectionOnInterconnectInput {
	s.Vlan = &v
	return s
}

// Container for the parameters to theHostedConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnectionRequest
type AllocateHostedConnectionInput struct {
	_ struct{} `type:"structure"`

	// The bandwidth of the connection.
	//
	// Example: 500Mbps
	//
	// Default: None
	//
	// Values: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The ID of the interconnect or LAG on which the connection will be provisioned.
	//
	// Example: dxcon-456abc78 or dxlag-abc123
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The name of the provisioned connection.
	//
	// Example: "500M Connection to AWS"
	//
	// Default: None
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// The numeric account ID of the customer for whom the connection will be provisioned.
	//
	// Example: 123443215678
	//
	// Default: None
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	// The dedicated VLAN provisioned to the hosted connection.
	//
	// Example: 101
	//
	// Default: None
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateHostedConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateHostedConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateHostedConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateHostedConnectionInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *AllocateHostedConnectionInput) SetBandwidth(v string) *AllocateHostedConnectionInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocateHostedConnectionInput) SetConnectionId(v string) *AllocateHostedConnectionInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *AllocateHostedConnectionInput) SetConnectionName(v string) *AllocateHostedConnectionInput {
	s.ConnectionName = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocateHostedConnectionInput) SetOwnerAccount(v string) *AllocateHostedConnectionInput {
	s.OwnerAccount = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *AllocateHostedConnectionInput) SetVlan(v int64) *AllocateHostedConnectionInput {
	s.Vlan = &v
	return s
}

// Container for the parameters to the AllocatePrivateVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterfaceRequest
type AllocatePrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The connection ID on which the private virtual interface is provisioned.
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the private virtual interface to be provisioned.
	//
	// Default: None
	//
	// NewPrivateVirtualInterfaceAllocation is a required field
	NewPrivateVirtualInterfaceAllocation *NewPrivateVirtualInterfaceAllocation `locationName:"newPrivateVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The AWS account that will own the new private virtual interface.
	//
	// Default: None
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocatePrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocatePrivateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPrivateVirtualInterfaceAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPrivateVirtualInterfaceAllocation"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.NewPrivateVirtualInterfaceAllocation != nil {
		if err := s.NewPrivateVirtualInterfaceAllocation.Validate(); err != nil {
			invalidParams.AddNested("NewPrivateVirtualInterfaceAllocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetConnectionId(v string) *AllocatePrivateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPrivateVirtualInterfaceAllocation sets the NewPrivateVirtualInterfaceAllocation field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetNewPrivateVirtualInterfaceAllocation(v *NewPrivateVirtualInterfaceAllocation) *AllocatePrivateVirtualInterfaceInput {
	s.NewPrivateVirtualInterfaceAllocation = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetOwnerAccount(v string) *AllocatePrivateVirtualInterfaceInput {
	s.OwnerAccount = &v
	return s
}

// Container for the parameters to the AllocatePublicVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterfaceRequest
type AllocatePublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The connection ID on which the public virtual interface is provisioned.
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the public virtual interface to be provisioned.
	//
	// Default: None
	//
	// NewPublicVirtualInterfaceAllocation is a required field
	NewPublicVirtualInterfaceAllocation *NewPublicVirtualInterfaceAllocation `locationName:"newPublicVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The AWS account that will own the new public virtual interface.
	//
	// Default: None
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocatePublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocatePublicVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPublicVirtualInterfaceAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPublicVirtualInterfaceAllocation"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.NewPublicVirtualInterfaceAllocation != nil {
		if err := s.NewPublicVirtualInterfaceAllocation.Validate(); err != nil {
			invalidParams.AddNested("NewPublicVirtualInterfaceAllocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetConnectionId(v string) *AllocatePublicVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPublicVirtualInterfaceAllocation sets the NewPublicVirtualInterfaceAllocation field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetNewPublicVirtualInterfaceAllocation(v *NewPublicVirtualInterfaceAllocation) *AllocatePublicVirtualInterfaceInput {
	s.NewPublicVirtualInterfaceAllocation = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetOwnerAccount(v string) *AllocatePublicVirtualInterfaceInput {
	s.OwnerAccount = &v
	return s
}

// Container for the parameters to the AssociateConnectionWithLag operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLagRequest
type AssociateConnectionWithLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// Example: dxcon-abc123
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the LAG with which to associate the connection.
	//
	// Example: dxlag-abc123
	//
	// Default: None
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateConnectionWithLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateConnectionWithLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateConnectionWithLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateConnectionWithLagInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AssociateConnectionWithLagInput) SetConnectionId(v string) *AssociateConnectionWithLagInput {
	s.ConnectionId = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *AssociateConnectionWithLagInput) SetLagId(v string) *AssociateConnectionWithLagInput {
	s.LagId = &v
	return s
}

// Container for the parameters to the AssociateHostedConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnectionRequest
type AssociateHostedConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted connection.
	//
	// Example: dxcon-abc123
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the interconnect or the LAG.
	//
	// Example: dxcon-abc123 or dxlag-abc123
	//
	// Default: None
	//
	// ParentConnectionId is a required field
	ParentConnectionId *string `locationName:"parentConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateHostedConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateHostedConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateHostedConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateHostedConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ParentConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AssociateHostedConnectionInput) SetConnectionId(v string) *AssociateHostedConnectionInput {
	s.ConnectionId = &v
	return s
}

// SetParentConnectionId sets the ParentConnectionId field's value.
func (s *AssociateHostedConnectionInput) SetParentConnectionId(v string) *AssociateHostedConnectionInput {
	s.ParentConnectionId = &v
	return s
}

// Container for the parameters to the AssociateVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterfaceRequest
type AssociateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG or connection with which to associate the virtual interface.
	//
	// Example: dxlag-abc123 or dxcon-abc123
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AssociateVirtualInterfaceInput) SetConnectionId(v string) *AssociateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *AssociateVirtualInterfaceInput) SetVirtualInterfaceId(v string) *AssociateVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// A structure containing information about a BGP peer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/BGPPeer
type BGPPeer struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// The state of the BGP peer.
	//
	//    * Verifying: The BGP peering addresses or ASN require validation before
	//    the BGP peer can be created. This state only applies to BGP peers on a
	//    public virtual interface.
	//
	//    * Pending: The BGP peer has been created, and is in this state until it
	//    is ready to be established.
	//
	//    * Available: The BGP peer can be established.
	//
	//    * Deleting: The BGP peer is in the process of being deleted.
	//
	//    * Deleted: The BGP peer has been deleted and cannot be established.
	BgpPeerState *string `locationName:"bgpPeerState" type:"string" enum:"BGPPeerState"`

	// The Up/Down state of the BGP peer.
	//
	//    * Up: The BGP peer is established.
	//
	//    * Down: The BGP peer is down.
	BgpStatus *string `locationName:"bgpStatus" type:"string" enum:"BGPStatus"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s BGPPeer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BGPPeer) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *BGPPeer) SetAddressFamily(v string) *BGPPeer {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *BGPPeer) SetAmazonAddress(v string) *BGPPeer {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *BGPPeer) SetAsn(v int64) *BGPPeer {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *BGPPeer) SetAuthKey(v string) *BGPPeer {
	s.AuthKey = &v
	return s
}

// SetBgpPeerState sets the BgpPeerState field's value.
func (s *BGPPeer) SetBgpPeerState(v string) *BGPPeer {
	s.BgpPeerState = &v
	return s
}

// SetBgpStatus sets the BgpStatus field's value.
func (s *BGPPeer) SetBgpStatus(v string) *BGPPeer {
	s.BgpStatus = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *BGPPeer) SetCustomerAddress(v string) *BGPPeer {
	s.CustomerAddress = &v
	return s
}

// Container for the parameters to the ConfirmConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnectionRequest
type ConfirmConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *ConfirmConnectionInput) SetConnectionId(v string) *ConfirmConnectionInput {
	s.ConnectionId = &v
	return s
}

// The response received when ConfirmConnection is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnectionResponse
type ConfirmConnectionOutput struct {
	_ struct{} `type:"structure"`

	// State of the connection.
	//
	//    * Ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * Requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * Pending: The connection has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the connection is ready for use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The connection is in the process of being deleted.
	//
	//    * Deleted: The connection has been deleted.
	//
	//    * Rejected: A hosted connection in the 'Ordering' state will enter the
	//    'Rejected' state if it is deleted by the end customer.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`
}

// String returns the string representation
func (s ConfirmConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *ConfirmConnectionOutput) SetConnectionState(v string) *ConfirmConnectionOutput {
	s.ConnectionState = &v
	return s
}

// Container for the parameters to the ConfirmPrivateVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterfaceRequest
type ConfirmPrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// ID of the direct connect gateway that will be attached to the virtual interface.
	//
	// A direct connect gateway can be managed via the AWS Direct Connect console
	// or the CreateDirectConnectGateway action.
	//
	// Default: None
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// ID of the virtual private gateway that will be attached to the virtual interface.
	//
	// A virtual private gateway can be managed via the Amazon Virtual Private Cloud
	// (VPC) console or the EC2 CreateVpnGateway (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html)
	// action.
	//
	// Default: None
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmPrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmPrivateVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetDirectConnectGatewayId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetVirtualGatewayId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetVirtualInterfaceId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when ConfirmPrivateVirtualInterface is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterfaceResponse
type ConfirmPrivateVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *ConfirmPrivateVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *ConfirmPrivateVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

// Container for the parameters to the ConfirmPublicVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterfaceRequest
type ConfirmPublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmPublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmPublicVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *ConfirmPublicVirtualInterfaceInput) SetVirtualInterfaceId(v string) *ConfirmPublicVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when ConfirmPublicVirtualInterface is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterfaceResponse
type ConfirmPublicVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *ConfirmPublicVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *ConfirmPublicVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

// A connection represents the physical network connection between the AWS Direct
// Connect location and the customer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Connection
type Connection struct {
	_ struct{} `type:"structure"`

	// The Direct Connection endpoint which the physical connection terminates on.
	AwsDevice *string `locationName:"awsDevice" type:"string"`

	// Bandwidth of the connection.
	//
	// Example: 1Gbps (for regular connections), or 500Mbps (for hosted connections)
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The name of the connection.
	//
	// Example: "My Connection to AWS"
	//
	// Default: None
	ConnectionName *string `locationName:"connectionName" type:"string"`

	// State of the connection.
	//
	//    * Ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * Requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * Pending: The connection has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the connection is ready for use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The connection is in the process of being deleted.
	//
	//    * Deleted: The connection has been deleted.
	//
	//    * Rejected: A hosted connection in the 'Ordering' state will enter the
	//    'Rejected' state if it is deleted by the end customer.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`

	// The ID of the LAG.
	//
	// Example: dxlag-fg5678gh
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeLoa for this connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp" timestampFormat:"unix"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The AWS account that will own the new connection.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the AWS Direct Connect service provider associated with the connection.
	PartnerName *string `locationName:"partnerName" type:"string"`

	// The AWS region where the connection is located.
	//
	// Example: us-east-1
	//
	// Default: None
	Region *string `locationName:"region" type:"string"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

// SetAwsDevice sets the AwsDevice field's value.
func (s *Connection) SetAwsDevice(v string) *Connection {
	s.AwsDevice = &v
	return s
}

// SetBandwidth sets the Bandwidth field's value.
func (s *Connection) SetBandwidth(v string) *Connection {
	s.Bandwidth = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *Connection) SetConnectionId(v string) *Connection {
	s.ConnectionId = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *Connection) SetConnectionName(v string) *Connection {
	s.ConnectionName = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *Connection) SetConnectionState(v string) *Connection {
	s.ConnectionState = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *Connection) SetLagId(v string) *Connection {
	s.LagId = &v
	return s
}

// SetLoaIssueTime sets the LoaIssueTime field's value.
func (s *Connection) SetLoaIssueTime(v time.Time) *Connection {
	s.LoaIssueTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Connection) SetLocation(v string) *Connection {
	s.Location = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Connection) SetOwnerAccount(v string) *Connection {
	s.OwnerAccount = &v
	return s
}

// SetPartnerName sets the PartnerName field's value.
func (s *Connection) SetPartnerName(v string) *Connection {
	s.PartnerName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Connection) SetRegion(v string) *Connection {
	s.Region = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *Connection) SetVlan(v int64) *Connection {
	s.Vlan = &v
	return s
}

// A structure containing a list of connections.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Connections
type Connections struct {
	_ struct{} `type:"structure"`

	// A list of connections.
	Connections []*Connection `locationName:"connections" type:"list"`
}

// String returns the string representation
func (s Connections) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connections) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *Connections) SetConnections(v []*Connection) *Connections {
	s.Connections = v
	return s
}

// Container for the parameters to the CreateBGPPeer operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeerRequest
type CreateBGPPeerInput struct {
	_ struct{} `type:"structure"`

	// Detailed information for the BGP peer to be created.
	//
	// Default: None
	NewBGPPeer *NewBGPPeer `locationName:"newBGPPeer" type:"structure"`

	// The ID of the virtual interface on which the BGP peer will be provisioned.
	//
	// Example: dxvif-456abc78
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s CreateBGPPeerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBGPPeerInput) GoString() string {
	return s.String()
}

// SetNewBGPPeer sets the NewBGPPeer field's value.
func (s *CreateBGPPeerInput) SetNewBGPPeer(v *NewBGPPeer) *CreateBGPPeerInput {
	s.NewBGPPeer = v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *CreateBGPPeerInput) SetVirtualInterfaceId(v string) *CreateBGPPeerInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when CreateBGPPeer is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeerResponse
type CreateBGPPeerOutput struct {
	_ struct{} `type:"structure"`

	// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
	// location and the customer.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s CreateBGPPeerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBGPPeerOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *CreateBGPPeerOutput) SetVirtualInterface(v *VirtualInterface) *CreateBGPPeerOutput {
	s.VirtualInterface = v
	return s
}

// Container for the parameters to the CreateConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnectionRequest
type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// Bandwidth of the connection.
	//
	// Example: 1Gbps
	//
	// Default: None
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the connection.
	//
	// Example: "My Connection to AWS"
	//
	// Default: None
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// The ID of the LAG.
	//
	// Example: dxlag-fg5678gh
	LagId *string `locationName:"lagId" type:"string"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateConnectionInput) SetBandwidth(v string) *CreateConnectionInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *CreateConnectionInput) SetConnectionName(v string) *CreateConnectionInput {
	s.ConnectionName = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *CreateConnectionInput) SetLagId(v string) *CreateConnectionInput {
	s.LagId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateConnectionInput) SetLocation(v string) *CreateConnectionInput {
	s.Location = &v
	return s
}

// Container for the parameters to the CreateDirectConnectGatewayAssociation
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationRequest
type CreateDirectConnectGatewayAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	//
	// Default: None
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`

	// The ID of the virtual private gateway.
	//
	// Example: "vgw-abc123ef"
	//
	// Default: None
	//
	// VirtualGatewayId is a required field
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectConnectGatewayAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectConnectGatewayAssociationInput"}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}
	if s.VirtualGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *CreateDirectConnectGatewayAssociationInput) SetDirectConnectGatewayId(v string) *CreateDirectConnectGatewayAssociationInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *CreateDirectConnectGatewayAssociationInput) SetVirtualGatewayId(v string) *CreateDirectConnectGatewayAssociationInput {
	s.VirtualGatewayId = &v
	return s
}

// Container for the response from the CreateDirectConnectGatewayAssociation
// API call
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationResult
type CreateDirectConnectGatewayAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The direct connect gateway association to be created.
	DirectConnectGatewayAssociation *GatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayAssociationOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociation sets the DirectConnectGatewayAssociation field's value.
func (s *CreateDirectConnectGatewayAssociationOutput) SetDirectConnectGatewayAssociation(v *GatewayAssociation) *CreateDirectConnectGatewayAssociationOutput {
	s.DirectConnectGatewayAssociation = v
	return s
}

// Container for the parameters to the CreateDirectConnectGateway operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayRequest
type CreateDirectConnectGatewayInput struct {
	_ struct{} `type:"structure"`

	// The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be
	// configured on the Amazon side of the connection. The ASN must be in the private
	// range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294
	//
	// Example: 65200
	//
	// Default: 64512
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The name of the direct connect gateway.
	//
	// Example: "My direct connect gateway"
	//
	// Default: None
	//
	// DirectConnectGatewayName is a required field
	DirectConnectGatewayName *string `locationName:"directConnectGatewayName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectConnectGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectConnectGatewayInput"}
	if s.DirectConnectGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *CreateDirectConnectGatewayInput) SetAmazonSideAsn(v int64) *CreateDirectConnectGatewayInput {
	s.AmazonSideAsn = &v
	return s
}

// SetDirectConnectGatewayName sets the DirectConnectGatewayName field's value.
func (s *CreateDirectConnectGatewayInput) SetDirectConnectGatewayName(v string) *CreateDirectConnectGatewayInput {
	s.DirectConnectGatewayName = &v
	return s
}

// Container for the response from the CreateDirectConnectGateway API call
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayResult
type CreateDirectConnectGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The direct connect gateway to be created.
	DirectConnectGateway *Gateway `locationName:"directConnectGateway" type:"structure"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGateway sets the DirectConnectGateway field's value.
func (s *CreateDirectConnectGatewayOutput) SetDirectConnectGateway(v *Gateway) *CreateDirectConnectGatewayOutput {
	s.DirectConnectGateway = v
	return s
}

// Container for the parameters to the CreateInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnectRequest
type CreateInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The port bandwidth
	//
	// Example: 1Gbps
	//
	// Default: None
	//
	// Available values: 1Gbps,10Gbps
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the interconnect.
	//
	// Example: "1G Interconnect to AWS"
	//
	// Default: None
	//
	// InterconnectName is a required field
	InterconnectName *string `locationName:"interconnectName" type:"string" required:"true"`

	// The ID of the LAG.
	//
	// Example: dxlag-fg5678gh
	LagId *string `locationName:"lagId" type:"string"`

	// Where the interconnect is located
	//
	// Example: EqSV5
	//
	// Default: None
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInterconnectInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.InterconnectName == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateInterconnectInput) SetBandwidth(v string) *CreateInterconnectInput {
	s.Bandwidth = &v
	return s
}

// SetInterconnectName sets the InterconnectName field's value.
func (s *CreateInterconnectInput) SetInterconnectName(v string) *CreateInterconnectInput {
	s.InterconnectName = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *CreateInterconnectInput) SetLagId(v string) *CreateInterconnectInput {
	s.LagId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateInterconnectInput) SetLocation(v string) *CreateInterconnectInput {
	s.Location = &v
	return s
}

// Container for the parameters to the CreateLag operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLagRequest
type CreateLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of an existing connection to migrate to the LAG.
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The bandwidth of the individual physical connections bundled by the LAG.
	//
	// Default: None
	//
	// Available values: 1Gbps, 10Gbps
	//
	// ConnectionsBandwidth is a required field
	ConnectionsBandwidth *string `locationName:"connectionsBandwidth" type:"string" required:"true"`

	// The name of the LAG.
	//
	// Example: "3x10G LAG to AWS"
	//
	// Default: None
	//
	// LagName is a required field
	LagName *string `locationName:"lagName" type:"string" required:"true"`

	// The AWS Direct Connect location in which the LAG should be allocated.
	//
	// Example: EqSV5
	//
	// Default: None
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`

	// The number of physical connections initially provisioned and bundled by the
	// LAG.
	//
	// Default: None
	//
	// NumberOfConnections is a required field
	NumberOfConnections *int64 `locationName:"numberOfConnections" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLagInput"}
	if s.ConnectionsBandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionsBandwidth"))
	}
	if s.LagName == nil {
		invalidParams.Add(request.NewErrParamRequired("LagName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.NumberOfConnections == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfConnections"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreateLagInput) SetConnectionId(v string) *CreateLagInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionsBandwidth sets the ConnectionsBandwidth field's value.
func (s *CreateLagInput) SetConnectionsBandwidth(v string) *CreateLagInput {
	s.ConnectionsBandwidth = &v
	return s
}

// SetLagName sets the LagName field's value.
func (s *CreateLagInput) SetLagName(v string) *CreateLagInput {
	s.LagName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateLagInput) SetLocation(v string) *CreateLagInput {
	s.Location = &v
	return s
}

// SetNumberOfConnections sets the NumberOfConnections field's value.
func (s *CreateLagInput) SetNumberOfConnections(v int64) *CreateLagInput {
	s.NumberOfConnections = &v
	return s
}

// Container for the parameters to the CreatePrivateVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterfaceRequest
type CreatePrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the private virtual interface to be created.
	//
	// Default: None
	//
	// NewPrivateVirtualInterface is a required field
	NewPrivateVirtualInterface *NewPrivateVirtualInterface `locationName:"newPrivateVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrivateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPrivateVirtualInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPrivateVirtualInterface"))
	}
	if s.NewPrivateVirtualInterface != nil {
		if err := s.NewPrivateVirtualInterface.Validate(); err != nil {
			invalidParams.AddNested("NewPrivateVirtualInterface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreatePrivateVirtualInterfaceInput) SetConnectionId(v string) *CreatePrivateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPrivateVirtualInterface sets the NewPrivateVirtualInterface field's value.
func (s *CreatePrivateVirtualInterfaceInput) SetNewPrivateVirtualInterface(v *NewPrivateVirtualInterface) *CreatePrivateVirtualInterfaceInput {
	s.NewPrivateVirtualInterface = v
	return s
}

// Container for the parameters to the CreatePublicVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterfaceRequest
type CreatePublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the public virtual interface to be created.
	//
	// Default: None
	//
	// NewPublicVirtualInterface is a required field
	NewPublicVirtualInterface *NewPublicVirtualInterface `locationName:"newPublicVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublicVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPublicVirtualInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPublicVirtualInterface"))
	}
	if s.NewPublicVirtualInterface != nil {
		if err := s.NewPublicVirtualInterface.Validate(); err != nil {
			invalidParams.AddNested("NewPublicVirtualInterface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreatePublicVirtualInterfaceInput) SetConnectionId(v string) *CreatePublicVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPublicVirtualInterface sets the NewPublicVirtualInterface field's value.
func (s *CreatePublicVirtualInterfaceInput) SetNewPublicVirtualInterface(v *NewPublicVirtualInterface) *CreatePublicVirtualInterfaceInput {
	s.NewPublicVirtualInterface = v
	return s
}

// Container for the parameters to the DeleteBGPPeer operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeerRequest
type DeleteBGPPeerInput struct {
	_ struct{} `type:"structure"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the virtual interface from which the BGP peer will be deleted.
	//
	// Example: dxvif-456abc78
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DeleteBGPPeerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBGPPeerInput) GoString() string {
	return s.String()
}

// SetAsn sets the Asn field's value.
func (s *DeleteBGPPeerInput) SetAsn(v int64) *DeleteBGPPeerInput {
	s.Asn = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *DeleteBGPPeerInput) SetCustomerAddress(v string) *DeleteBGPPeerInput {
	s.CustomerAddress = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DeleteBGPPeerInput) SetVirtualInterfaceId(v string) *DeleteBGPPeerInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when DeleteBGPPeer is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeerResponse
type DeleteBGPPeerOutput struct {
	_ struct{} `type:"structure"`

	// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
	// location and the customer.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s DeleteBGPPeerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBGPPeerOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *DeleteBGPPeerOutput) SetVirtualInterface(v *VirtualInterface) *DeleteBGPPeerOutput {
	s.VirtualInterface = v
	return s
}

// Container for the parameters to the DeleteConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnectionRequest
type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DeleteConnectionInput) SetConnectionId(v string) *DeleteConnectionInput {
	s.ConnectionId = &v
	return s
}

// Container for the parameters to the DeleteDirectConnectGatewayAssociation
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationRequest
type DeleteDirectConnectGatewayAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	//
	// Default: None
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`

	// The ID of the virtual private gateway.
	//
	// Example: "vgw-abc123ef"
	//
	// Default: None
	//
	// VirtualGatewayId is a required field
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectConnectGatewayAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectConnectGatewayAssociationInput"}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}
	if s.VirtualGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DeleteDirectConnectGatewayAssociationInput) SetDirectConnectGatewayId(v string) *DeleteDirectConnectGatewayAssociationInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *DeleteDirectConnectGatewayAssociationInput) SetVirtualGatewayId(v string) *DeleteDirectConnectGatewayAssociationInput {
	s.VirtualGatewayId = &v
	return s
}

// Container for the response from the DeleteDirectConnectGatewayAssociation
// API call
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationResult
type DeleteDirectConnectGatewayAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The direct connect gateway association to be deleted.
	DirectConnectGatewayAssociation *GatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayAssociationOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociation sets the DirectConnectGatewayAssociation field's value.
func (s *DeleteDirectConnectGatewayAssociationOutput) SetDirectConnectGatewayAssociation(v *GatewayAssociation) *DeleteDirectConnectGatewayAssociationOutput {
	s.DirectConnectGatewayAssociation = v
	return s
}

// Container for the parameters to the DeleteDirectConnectGateway operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayRequest
type DeleteDirectConnectGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	//
	// Default: None
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectConnectGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectConnectGatewayInput"}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DeleteDirectConnectGatewayInput) SetDirectConnectGatewayId(v string) *DeleteDirectConnectGatewayInput {
	s.DirectConnectGatewayId = &v
	return s
}

// Container for the response from the DeleteDirectConnectGateway API call
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayResult
type DeleteDirectConnectGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The direct connect gateway to be deleted.
	DirectConnectGateway *Gateway `locationName:"directConnectGateway" type:"structure"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGateway sets the DirectConnectGateway field's value.
func (s *DeleteDirectConnectGatewayOutput) SetDirectConnectGateway(v *Gateway) *DeleteDirectConnectGatewayOutput {
	s.DirectConnectGateway = v
	return s
}

// Container for the parameters to the DeleteInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnectRequest
type DeleteInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInterconnectInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DeleteInterconnectInput) SetInterconnectId(v string) *DeleteInterconnectInput {
	s.InterconnectId = &v
	return s
}

// The response received when DeleteInterconnect is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnectResponse
type DeleteInterconnectOutput struct {
	_ struct{} `type:"structure"`

	// State of the interconnect.
	//
	//    * Requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * Pending: The interconnect has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The interconnect is in the process of being deleted.
	//
	//    * Deleted: The interconnect has been deleted.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`
}

// String returns the string representation
func (s DeleteInterconnectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectOutput) GoString() string {
	return s.String()
}

// SetInterconnectState sets the InterconnectState field's value.
func (s *DeleteInterconnectOutput) SetInterconnectState(v string) *DeleteInterconnectOutput {
	s.InterconnectState = &v
	return s
}

// Container for the parameters to the DeleteLag operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLagRequest
type DeleteLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG to delete.
	//
	// Example: dxlag-abc123
	//
	// Default: None
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLagInput"}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLagId sets the LagId field's value.
func (s *DeleteLagInput) SetLagId(v string) *DeleteLagInput {
	s.LagId = &v
	return s
}

// Container for the parameters to the DeleteVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterfaceRequest
type DeleteVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DeleteVirtualInterfaceInput) SetVirtualInterfaceId(v string) *DeleteVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when DeleteVirtualInterface is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterfaceResponse
type DeleteVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *DeleteVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *DeleteVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

// Container for the parameters to the DescribeConnectionLoa operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoaRequest
type DescribeConnectionLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// A standard media type indicating the content type of the LOA-CFA document.
	// Currently, the only supported value is "application/pdf".
	//
	// Default: application/pdf
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the APN partner or service provider who establishes connectivity
	// on your behalf. If you supply this parameter, the LOA-CFA lists the provider
	// name alongside your company name as the requester of the cross connect.
	//
	// Default: None
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionLoaInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeConnectionLoaInput) SetConnectionId(v string) *DescribeConnectionLoaInput {
	s.ConnectionId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeConnectionLoaInput) SetLoaContentType(v string) *DescribeConnectionLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeConnectionLoaInput) SetProviderName(v string) *DescribeConnectionLoaInput {
	s.ProviderName = &v
	return s
}

// The response received when DescribeConnectionLoa is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoaResponse
type DescribeConnectionLoaOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the Letter of Authorization - Connecting Facility
	// Assignment (LOA-CFA) for a connection.
	Loa *Loa `locationName:"loa" type:"structure"`
}

// String returns the string representation
func (s DescribeConnectionLoaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionLoaOutput) GoString() string {
	return s.String()
}

// SetLoa sets the Loa field's value.
func (s *DescribeConnectionLoaOutput) SetLoa(v *Loa) *DescribeConnectionLoaOutput {
	s.Loa = v
	return s
}

// Container for the parameters to the DescribeConnections operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsRequest
type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeConnectionsInput) SetConnectionId(v string) *DescribeConnectionsInput {
	s.ConnectionId = &v
	return s
}

// Container for the parameters to the DescribeConnectionsOnInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnectRequest
type DescribeConnectionsOnInterconnectInput struct {
	_ struct{} `type:"structure"`

	// ID of the interconnect on which a list of connection is provisioned.
	//
	// Example: dxcon-abc123
	//
	// Default: None
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConnectionsOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsOnInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionsOnInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionsOnInterconnectInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeConnectionsOnInterconnectInput) SetInterconnectId(v string) *DescribeConnectionsOnInterconnectInput {
	s.InterconnectId = &v
	return s
}

// Container for the parameters to the DescribeDirectConnectGatewayAssociations
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationsRequest
type DescribeDirectConnectGatewayAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	//
	// Default: None
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of direct connect gateway associations to return per page.
	//
	// Example: 15
	//
	// Default: None
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous describe result to retrieve the next page
	// of the result.
	//
	// Default: None
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the virtual private gateway.
	//
	// Example: "vgw-abc123ef"
	//
	// Default: None
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAssociationsInput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetDirectConnectGatewayId(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetMaxResults(v int64) *DescribeDirectConnectGatewayAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetNextToken(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.NextToken = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetVirtualGatewayId(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.VirtualGatewayId = &v
	return s
}

// Container for the response from the DescribeDirectConnectGatewayAssociations
// API call
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationsResult
type DescribeDirectConnectGatewayAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the direct connect gateway associations.
	DirectConnectGatewayAssociations []*GatewayAssociation `locationName:"directConnectGatewayAssociations" type:"list"`

	// Token to retrieve the next page of the result.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAssociationsOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociations sets the DirectConnectGatewayAssociations field's value.
func (s *DescribeDirectConnectGatewayAssociationsOutput) SetDirectConnectGatewayAssociations(v []*GatewayAssociation) *DescribeDirectConnectGatewayAssociationsOutput {
	s.DirectConnectGatewayAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAssociationsOutput) SetNextToken(v string) *DescribeDirectConnectGatewayAssociationsOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeDirectConnectGatewayAttachments
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachmentsRequest
type DescribeDirectConnectGatewayAttachmentsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	//
	// Default: None
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of direct connect gateway attachments to return per page.
	//
	// Example: 15
	//
	// Default: None
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous describe result to retrieve the next page
	// of the result.
	//
	// Default: None
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the virtual interface.
	//
	// Example: "dxvif-abc123ef"
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsInput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetDirectConnectGatewayId(v string) *DescribeDirectConnectGatewayAttachmentsInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetMaxResults(v int64) *DescribeDirectConnectGatewayAttachmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetNextToken(v string) *DescribeDirectConnectGatewayAttachmentsInput {
	s.NextToken = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetVirtualInterfaceId(v string) *DescribeDirectConnectGatewayAttachmentsInput {
	s.VirtualInterfaceId = &v
	return s
}

// Container for the response from the DescribeDirectConnectGatewayAttachments
// API call
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachmentsResult
type DescribeDirectConnectGatewayAttachmentsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the direct connect gateway attachments.
	DirectConnectGatewayAttachments []*GatewayAttachment `locationName:"directConnectGatewayAttachments" type:"list"`

	// Token to retrieve the next page of the result.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAttachments sets the DirectConnectGatewayAttachments field's value.
func (s *DescribeDirectConnectGatewayAttachmentsOutput) SetDirectConnectGatewayAttachments(v []*GatewayAttachment) *DescribeDirectConnectGatewayAttachmentsOutput {
	s.DirectConnectGatewayAttachments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAttachmentsOutput) SetNextToken(v string) *DescribeDirectConnectGatewayAttachmentsOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeDirectConnectGateways operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewaysRequest
type DescribeDirectConnectGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	//
	// Default: None
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of direct connect gateways to return per page.
	//
	// Example: 15
	//
	// Default: None
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous describe result to retrieve the next page
	// of the result.
	//
	// Default: None
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewaysInput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DescribeDirectConnectGatewaysInput) SetDirectConnectGatewayId(v string) *DescribeDirectConnectGatewaysInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectConnectGatewaysInput) SetMaxResults(v int64) *DescribeDirectConnectGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewaysInput) SetNextToken(v string) *DescribeDirectConnectGatewaysInput {
	s.NextToken = &v
	return s
}

// Container for the response from the DescribeDirectConnectGateways API call
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewaysResult
type DescribeDirectConnectGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about the direct connect gateways.
	DirectConnectGateways []*Gateway `locationName:"directConnectGateways" type:"list"`

	// Token to retrieve the next page of the result.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewaysOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGateways sets the DirectConnectGateways field's value.
func (s *DescribeDirectConnectGatewaysOutput) SetDirectConnectGateways(v []*Gateway) *DescribeDirectConnectGatewaysOutput {
	s.DirectConnectGateways = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewaysOutput) SetNextToken(v string) *DescribeDirectConnectGatewaysOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeHostedConnections operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnectionsRequest
type DescribeHostedConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect or LAG on which the hosted connections are provisioned.
	//
	// Example: dxcon-abc123 or dxlag-abc123
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHostedConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostedConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHostedConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHostedConnectionsInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeHostedConnectionsInput) SetConnectionId(v string) *DescribeHostedConnectionsInput {
	s.ConnectionId = &v
	return s
}

// Container for the parameters to the DescribeInterconnectLoa operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoaRequest
type DescribeInterconnectLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// A standard media type indicating the content type of the LOA-CFA document.
	// Currently, the only supported value is "application/pdf".
	//
	// Default: application/pdf
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the service provider who establishes connectivity on your behalf.
	// If you supply this parameter, the LOA-CFA lists the provider name alongside
	// your company name as the requester of the cross connect.
	//
	// Default: None
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeInterconnectLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInterconnectLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInterconnectLoaInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeInterconnectLoaInput) SetInterconnectId(v string) *DescribeInterconnectLoaInput {
	s.InterconnectId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeInterconnectLoaInput) SetLoaContentType(v string) *DescribeInterconnectLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeInterconnectLoaInput) SetProviderName(v string) *DescribeInterconnectLoaInput {
	s.ProviderName = &v
	return s
}

// The response received when DescribeInterconnectLoa is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoaResponse
type DescribeInterconnectLoaOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the Letter of Authorization - Connecting Facility
	// Assignment (LOA-CFA) for a connection.
	Loa *Loa `locationName:"loa" type:"structure"`
}

// String returns the string representation
func (s DescribeInterconnectLoaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectLoaOutput) GoString() string {
	return s.String()
}

// SetLoa sets the Loa field's value.
func (s *DescribeInterconnectLoaOutput) SetLoa(v *Loa) *DescribeInterconnectLoaOutput {
	s.Loa = v
	return s
}

// Container for the parameters to the DescribeInterconnects operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectsRequest
type DescribeInterconnectsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	InterconnectId *string `locationName:"interconnectId" type:"string"`
}

// String returns the string representation
func (s DescribeInterconnectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsInput) GoString() string {
	return s.String()
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeInterconnectsInput) SetInterconnectId(v string) *DescribeInterconnectsInput {
	s.InterconnectId = &v
	return s
}

// A structure containing a list of interconnects.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Interconnects
type DescribeInterconnectsOutput struct {
	_ struct{} `type:"structure"`

	// A list of interconnects.
	Interconnects []*Interconnect `locationName:"interconnects" type:"list"`
}

// String returns the string representation
func (s DescribeInterconnectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsOutput) GoString() string {
	return s.String()
}

// SetInterconnects sets the Interconnects field's value.
func (s *DescribeInterconnectsOutput) SetInterconnects(v []*Interconnect) *DescribeInterconnectsOutput {
	s.Interconnects = v
	return s
}

// Container for the parameters to the DescribeLags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLagsRequest
type DescribeLagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG.
	//
	// Example: dxlag-abc123
	//
	// Default: None
	LagId *string `locationName:"lagId" type:"string"`
}

// String returns the string representation
func (s DescribeLagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLagsInput) GoString() string {
	return s.String()
}

// SetLagId sets the LagId field's value.
func (s *DescribeLagsInput) SetLagId(v string) *DescribeLagsInput {
	s.LagId = &v
	return s
}

// A structure containing a list of LAGs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Lags
type DescribeLagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of LAGs.
	Lags []*Lag `locationName:"lags" type:"list"`
}

// String returns the string representation
func (s DescribeLagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLagsOutput) GoString() string {
	return s.String()
}

// SetLags sets the Lags field's value.
func (s *DescribeLagsOutput) SetLags(v []*Lag) *DescribeLagsOutput {
	s.Lags = v
	return s
}

// Container for the parameters to the DescribeLoa operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoaRequest
type DescribeLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of a connection, LAG, or interconnect for which to get the LOA-CFA
	// information.
	//
	// Example: dxcon-abc123 or dxlag-abc123
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// A standard media type indicating the content type of the LOA-CFA document.
	// Currently, the only supported value is "application/pdf".
	//
	// Default: application/pdf
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the service provider who establishes connectivity on your behalf.
	// If you supply this parameter, the LOA-CFA lists the provider name alongside
	// your company name as the requester of the cross connect.
	//
	// Default: None
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoaInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeLoaInput) SetConnectionId(v string) *DescribeLoaInput {
	s.ConnectionId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeLoaInput) SetLoaContentType(v string) *DescribeLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeLoaInput) SetProviderName(v string) *DescribeLoaInput {
	s.ProviderName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocationsInput
type DescribeLocationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsInput) GoString() string {
	return s.String()
}

// A location is a network facility where AWS Direct Connect routers are available
// to be connected. Generally, these are colocation hubs where many network
// providers have equipment, and where cross connects can be delivered. Locations
// include a name and facility code, and must be provided when creating a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Locations
type DescribeLocationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of colocation hubs where network providers have equipment. Most regions
	// have multiple locations available.
	Locations []*Location `locationName:"locations" type:"list"`
}

// String returns the string representation
func (s DescribeLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsOutput) GoString() string {
	return s.String()
}

// SetLocations sets the Locations field's value.
func (s *DescribeLocationsOutput) SetLocations(v []*Location) *DescribeLocationsOutput {
	s.Locations = v
	return s
}

// Container for the parameters to the DescribeTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTagsRequest
type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the Direct Connect resources.
	//
	// ResourceArns is a required field
	ResourceArns []*string `locationName:"resourceArns" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArns sets the ResourceArns field's value.
func (s *DescribeTagsInput) SetResourceArns(v []*string) *DescribeTagsInput {
	s.ResourceArns = v
	return s
}

// The response received when DescribeTags is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTagsResponse
type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	ResourceTags []*ResourceTag `locationName:"resourceTags" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetResourceTags sets the ResourceTags field's value.
func (s *DescribeTagsOutput) SetResourceTags(v []*ResourceTag) *DescribeTagsOutput {
	s.ResourceTags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGatewaysInput
type DescribeVirtualGatewaysInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysInput) GoString() string {
	return s.String()
}

// A structure containing a list of virtual private gateways.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualGateways
type DescribeVirtualGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// A list of virtual private gateways.
	VirtualGateways []*VirtualGateway `locationName:"virtualGateways" type:"list"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysOutput) GoString() string {
	return s.String()
}

// SetVirtualGateways sets the VirtualGateways field's value.
func (s *DescribeVirtualGatewaysOutput) SetVirtualGateways(v []*VirtualGateway) *DescribeVirtualGatewaysOutput {
	s.VirtualGateways = v
	return s
}

// Container for the parameters to the DescribeVirtualInterfaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfacesRequest
type DescribeVirtualInterfacesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesInput) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeVirtualInterfacesInput) SetConnectionId(v string) *DescribeVirtualInterfacesInput {
	s.ConnectionId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DescribeVirtualInterfacesInput) SetVirtualInterfaceId(v string) *DescribeVirtualInterfacesInput {
	s.VirtualInterfaceId = &v
	return s
}

// A structure containing a list of virtual interfaces.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualInterfaces
type DescribeVirtualInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// A list of virtual interfaces.
	VirtualInterfaces []*VirtualInterface `locationName:"virtualInterfaces" type:"list"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaces sets the VirtualInterfaces field's value.
func (s *DescribeVirtualInterfacesOutput) SetVirtualInterfaces(v []*VirtualInterface) *DescribeVirtualInterfacesOutput {
	s.VirtualInterfaces = v
	return s
}

// Container for the parameters to the DisassociateConnectionFromLag operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLagRequest
type DisassociateConnectionFromLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection to disassociate from the LAG.
	//
	// Example: dxcon-abc123
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the LAG.
	//
	// Example: dxlag-abc123
	//
	// Default: None
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateConnectionFromLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConnectionFromLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectionFromLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConnectionFromLagInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DisassociateConnectionFromLagInput) SetConnectionId(v string) *DisassociateConnectionFromLagInput {
	s.ConnectionId = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *DisassociateConnectionFromLagInput) SetLagId(v string) *DisassociateConnectionFromLagInput {
	s.LagId = &v
	return s
}

// A direct connect gateway is an intermediate object that enables you to connect
// virtual interfaces and virtual private gateways.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DirectConnectGateway
type Gateway struct {
	_ struct{} `type:"structure"`

	// The autonomous system number (ASN) for the Amazon side of the connection.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The name of the direct connect gateway.
	//
	// Example: "My direct connect gateway"
	//
	// Default: None
	DirectConnectGatewayName *string `locationName:"directConnectGatewayName" type:"string"`

	// State of the direct connect gateway.
	//
	//    * Pending: The initial state after calling CreateDirectConnectGateway.
	//
	//    * Available: The direct connect gateway is ready for use.
	//
	//    * Deleting: The initial state after calling DeleteDirectConnectGateway.
	//
	//    * Deleted: The direct connect gateway is deleted and cannot pass traffic.
	DirectConnectGatewayState *string `locationName:"directConnectGatewayState" type:"string" enum:"GatewayState"`

	// The AWS account ID of the owner of the direct connect gateway.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// Error message when the state of an object fails to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`
}

// String returns the string representation
func (s Gateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Gateway) GoString() string {
	return s.String()
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *Gateway) SetAmazonSideAsn(v int64) *Gateway {
	s.AmazonSideAsn = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *Gateway) SetDirectConnectGatewayId(v string) *Gateway {
	s.DirectConnectGatewayId = &v
	return s
}

// SetDirectConnectGatewayName sets the DirectConnectGatewayName field's value.
func (s *Gateway) SetDirectConnectGatewayName(v string) *Gateway {
	s.DirectConnectGatewayName = &v
	return s
}

// SetDirectConnectGatewayState sets the DirectConnectGatewayState field's value.
func (s *Gateway) SetDirectConnectGatewayState(v string) *Gateway {
	s.DirectConnectGatewayState = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Gateway) SetOwnerAccount(v string) *Gateway {
	s.OwnerAccount = &v
	return s
}

// SetStateChangeError sets the StateChangeError field's value.
func (s *Gateway) SetStateChangeError(v string) *Gateway {
	s.StateChangeError = &v
	return s
}

// The association between a direct connect gateway and virtual private gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DirectConnectGatewayAssociation
type GatewayAssociation struct {
	_ struct{} `type:"structure"`

	// State of the direct connect gateway association.
	//
	//    * Associating: The initial state after calling CreateDirectConnectGatewayAssociation.
	//
	//    * Associated: The direct connect gateway and virtual private gateway are
	//    successfully associated and ready to pass traffic.
	//
	//    * Disassociating: The initial state after calling DeleteDirectConnectGatewayAssociation.
	//
	//    * Disassociated: The virtual private gateway is successfully disassociated
	//    from the direct connect gateway. Traffic flow between the direct connect
	//    gateway and virtual private gateway stops.
	AssociationState *string `locationName:"associationState" type:"string" enum:"GatewayAssociationState"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// Error message when the state of an object fails to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The AWS account ID of the owner of the virtual private gateway.
	VirtualGatewayOwnerAccount *string `locationName:"virtualGatewayOwnerAccount" type:"string"`

	// The region in which the virtual private gateway is located.
	//
	// Example: us-east-1
	VirtualGatewayRegion *string `locationName:"virtualGatewayRegion" type:"string"`
}

// String returns the string representation
func (s GatewayAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayAssociation) GoString() string {
	return s.String()
}

// SetAssociationState sets the AssociationState field's value.
func (s *GatewayAssociation) SetAssociationState(v string) *GatewayAssociation {
	s.AssociationState = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *GatewayAssociation) SetDirectConnectGatewayId(v string) *GatewayAssociation {
	s.DirectConnectGatewayId = &v
	return s
}

// SetStateChangeError sets the StateChangeError field's value.
func (s *GatewayAssociation) SetStateChangeError(v string) *GatewayAssociation {
	s.StateChangeError = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *GatewayAssociation) SetVirtualGatewayId(v string) *GatewayAssociation {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualGatewayOwnerAccount sets the VirtualGatewayOwnerAccount field's value.
func (s *GatewayAssociation) SetVirtualGatewayOwnerAccount(v string) *GatewayAssociation {
	s.VirtualGatewayOwnerAccount = &v
	return s
}

// SetVirtualGatewayRegion sets the VirtualGatewayRegion field's value.
func (s *GatewayAssociation) SetVirtualGatewayRegion(v string) *GatewayAssociation {
	s.VirtualGatewayRegion = &v
	return s
}

// The association between a direct connect gateway and virtual interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DirectConnectGatewayAttachment
type GatewayAttachment struct {
	_ struct{} `type:"structure"`

	// State of the direct connect gateway attachment.
	//
	//    * Attaching: The initial state after a virtual interface is created using
	//    the direct connect gateway.
	//
	//    * Attached: The direct connect gateway and virtual interface are successfully
	//    attached and ready to pass traffic.
	//
	//    * Detaching: The initial state after calling DeleteVirtualInterface on
	//    a virtual interface that is attached to a direct connect gateway.
	//
	//    * Detached: The virtual interface is successfully detached from the direct
	//    connect gateway. Traffic flow between the direct connect gateway and virtual
	//    interface stops.
	AttachmentState *string `locationName:"attachmentState" type:"string" enum:"GatewayAttachmentState"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// Error message when the state of an object fails to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`

	// The ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The AWS account ID of the owner of the virtual interface.
	VirtualInterfaceOwnerAccount *string `locationName:"virtualInterfaceOwnerAccount" type:"string"`

	// The region in which the virtual interface is located.
	//
	// Example: us-east-1
	VirtualInterfaceRegion *string `locationName:"virtualInterfaceRegion" type:"string"`
}

// String returns the string representation
func (s GatewayAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayAttachment) GoString() string {
	return s.String()
}

// SetAttachmentState sets the AttachmentState field's value.
func (s *GatewayAttachment) SetAttachmentState(v string) *GatewayAttachment {
	s.AttachmentState = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *GatewayAttachment) SetDirectConnectGatewayId(v string) *GatewayAttachment {
	s.DirectConnectGatewayId = &v
	return s
}

// SetStateChangeError sets the StateChangeError field's value.
func (s *GatewayAttachment) SetStateChangeError(v string) *GatewayAttachment {
	s.StateChangeError = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *GatewayAttachment) SetVirtualInterfaceId(v string) *GatewayAttachment {
	s.VirtualInterfaceId = &v
	return s
}

// SetVirtualInterfaceOwnerAccount sets the VirtualInterfaceOwnerAccount field's value.
func (s *GatewayAttachment) SetVirtualInterfaceOwnerAccount(v string) *GatewayAttachment {
	s.VirtualInterfaceOwnerAccount = &v
	return s
}

// SetVirtualInterfaceRegion sets the VirtualInterfaceRegion field's value.
func (s *GatewayAttachment) SetVirtualInterfaceRegion(v string) *GatewayAttachment {
	s.VirtualInterfaceRegion = &v
	return s
}

// An interconnect is a connection that can host other connections.
//
// Like a standard AWS Direct Connect connection, an interconnect represents
// the physical connection between an AWS Direct Connect partner's network and
// a specific Direct Connect location. An AWS Direct Connect partner who owns
// an interconnect can provision hosted connections on the interconnect for
// their end customers, thereby providing the end customers with connectivity
// to AWS services.
//
// The resources of the interconnect, including bandwidth and VLAN numbers,
// are shared by all of the hosted connections on the interconnect, and the
// owner of the interconnect determines how these resources are assigned.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Interconnect
type Interconnect struct {
	_ struct{} `type:"structure"`

	// The Direct Connection endpoint which the physical connection terminates on.
	AwsDevice *string `locationName:"awsDevice" type:"string"`

	// Bandwidth of the connection.
	//
	// Example: 1Gbps
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	InterconnectId *string `locationName:"interconnectId" type:"string"`

	// The name of the interconnect.
	//
	// Example: "1G Interconnect to AWS"
	InterconnectName *string `locationName:"interconnectName" type:"string"`

	// State of the interconnect.
	//
	//    * Requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * Pending: The interconnect has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The interconnect is in the process of being deleted.
	//
	//    * Deleted: The interconnect has been deleted.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`

	// The ID of the LAG.
	//
	// Example: dxlag-fg5678gh
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeInterconnectLoa for this Interconnect.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp" timestampFormat:"unix"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The AWS region where the connection is located.
	//
	// Example: us-east-1
	//
	// Default: None
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s Interconnect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Interconnect) GoString() string {
	return s.String()
}

// SetAwsDevice sets the AwsDevice field's value.
func (s *Interconnect) SetAwsDevice(v string) *Interconnect {
	s.AwsDevice = &v
	return s
}

// SetBandwidth sets the Bandwidth field's value.
func (s *Interconnect) SetBandwidth(v string) *Interconnect {
	s.Bandwidth = &v
	return s
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *Interconnect) SetInterconnectId(v string) *Interconnect {
	s.InterconnectId = &v
	return s
}

// SetInterconnectName sets the InterconnectName field's value.
func (s *Interconnect) SetInterconnectName(v string) *Interconnect {
	s.InterconnectName = &v
	return s
}

// SetInterconnectState sets the InterconnectState field's value.
func (s *Interconnect) SetInterconnectState(v string) *Interconnect {
	s.InterconnectState = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *Interconnect) SetLagId(v string) *Interconnect {
	s.LagId = &v
	return s
}

// SetLoaIssueTime sets the LoaIssueTime field's value.
func (s *Interconnect) SetLoaIssueTime(v time.Time) *Interconnect {
	s.LoaIssueTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Interconnect) SetLocation(v string) *Interconnect {
	s.Location = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Interconnect) SetRegion(v string) *Interconnect {
	s.Region = &v
	return s
}

// Describes a link aggregation group (LAG). A LAG is a connection that uses
// the Link Aggregation Control Protocol (LACP) to logically aggregate a bundle
// of physical connections. Like an interconnect, it can host other connections.
// All connections in a LAG must terminate on the same physical AWS Direct Connect
// endpoint, and must be the same bandwidth.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Lag
type Lag struct {
	_ struct{} `type:"structure"`

	// Indicates whether the LAG can host other connections.
	//
	// This is intended for use by AWS Direct Connect partners only.
	AllowsHostedConnections *bool `locationName:"allowsHostedConnections" type:"boolean"`

	// The AWS Direct Connection endpoint that hosts the LAG.
	AwsDevice *string `locationName:"awsDevice" type:"string"`

	// A list of connections bundled by this LAG.
	Connections []*Connection `locationName:"connections" type:"list"`

	// The individual bandwidth of the physical connections bundled by the LAG.
	//
	// Available values: 1Gbps, 10Gbps
	ConnectionsBandwidth *string `locationName:"connectionsBandwidth" type:"string"`

	// The ID of the LAG.
	//
	// Example: dxlag-fg5678gh
	LagId *string `locationName:"lagId" type:"string"`

	// The name of the LAG.
	LagName *string `locationName:"lagName" type:"string"`

	// The state of the LAG.
	//
	//    * Requested: The initial state of a LAG. The LAG stays in the requested
	//    state until the Letter of Authorization (LOA) is available.
	//
	//    * Pending: The LAG has been approved, and is being initialized.
	//
	//    * Available: The network link is established, and the LAG is ready for
	//    use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The LAG is in the process of being deleted.
	//
	//    * Deleted: The LAG has been deleted.
	LagState *string `locationName:"lagState" type:"string" enum:"LagState"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The minimum number of physical connections that must be operational for the
	// LAG itself to be operational. If the number of operational connections drops
	// below this setting, the LAG state changes to down. This value can help to
	// ensure that a LAG is not overutilized if a significant number of its bundled
	// connections go down.
	MinimumLinks *int64 `locationName:"minimumLinks" type:"integer"`

	// The number of physical connections bundled by the LAG, up to a maximum of
	// 10.
	NumberOfConnections *int64 `locationName:"numberOfConnections" type:"integer"`

	// The owner of the LAG.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The AWS region where the connection is located.
	//
	// Example: us-east-1
	//
	// Default: None
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s Lag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Lag) GoString() string {
	return s.String()
}

// SetAllowsHostedConnections sets the AllowsHostedConnections field's value.
func (s *Lag) SetAllowsHostedConnections(v bool) *Lag {
	s.AllowsHostedConnections = &v
	return s
}

// SetAwsDevice sets the AwsDevice field's value.
func (s *Lag) SetAwsDevice(v string) *Lag {
	s.AwsDevice = &v
	return s
}

// SetConnections sets the Connections field's value.
func (s *Lag) SetConnections(v []*Connection) *Lag {
	s.Connections = v
	return s
}

// SetConnectionsBandwidth sets the ConnectionsBandwidth field's value.
func (s *Lag) SetConnectionsBandwidth(v string) *Lag {
	s.ConnectionsBandwidth = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *Lag) SetLagId(v string) *Lag {
	s.LagId = &v
	return s
}

// SetLagName sets the LagName field's value.
func (s *Lag) SetLagName(v string) *Lag {
	s.LagName = &v
	return s
}

// SetLagState sets the LagState field's value.
func (s *Lag) SetLagState(v string) *Lag {
	s.LagState = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Lag) SetLocation(v string) *Lag {
	s.Location = &v
	return s
}

// SetMinimumLinks sets the MinimumLinks field's value.
func (s *Lag) SetMinimumLinks(v int64) *Lag {
	s.MinimumLinks = &v
	return s
}

// SetNumberOfConnections sets the NumberOfConnections field's value.
func (s *Lag) SetNumberOfConnections(v int64) *Lag {
	s.NumberOfConnections = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Lag) SetOwnerAccount(v string) *Lag {
	s.OwnerAccount = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Lag) SetRegion(v string) *Lag {
	s.Region = &v
	return s
}

// A structure containing the Letter of Authorization - Connecting Facility
// Assignment (LOA-CFA) for a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Loa
type Loa struct {
	_ struct{} `type:"structure"`

	// The binary contents of the LOA-CFA document.
	//
	// LoaContent is automatically base64 encoded/decoded by the SDK.
	LoaContent []byte `locationName:"loaContent" type:"blob"`

	// A standard media type indicating the content type of the LOA-CFA document.
	// Currently, the only supported value is "application/pdf".
	//
	// Default: application/pdf
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`
}

// String returns the string representation
func (s Loa) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Loa) GoString() string {
	return s.String()
}

// SetLoaContent sets the LoaContent field's value.
func (s *Loa) SetLoaContent(v []byte) *Loa {
	s.LoaContent = v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *Loa) SetLoaContentType(v string) *Loa {
	s.LoaContentType = &v
	return s
}

// An AWS Direct Connect location where connections and interconnects can be
// requested.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Location
type Location struct {
	_ struct{} `type:"structure"`

	// The code used to indicate the AWS Direct Connect location.
	LocationCode *string `locationName:"locationCode" type:"string"`

	// The name of the AWS Direct Connect location. The name includes the colocation
	// partner name and the physical site of the lit building.
	LocationName *string `locationName:"locationName" type:"string"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// SetLocationCode sets the LocationCode field's value.
func (s *Location) SetLocationCode(v string) *Location {
	s.LocationCode = &v
	return s
}

// SetLocationName sets the LocationName field's value.
func (s *Location) SetLocationName(v string) *Location {
	s.LocationName = &v
	return s
}

// A structure containing information about a new BGP peer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewBGPPeer
type NewBGPPeer struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s NewBGPPeer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewBGPPeer) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewBGPPeer) SetAddressFamily(v string) *NewBGPPeer {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewBGPPeer) SetAmazonAddress(v string) *NewBGPPeer {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewBGPPeer) SetAsn(v int64) *NewBGPPeer {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewBGPPeer) SetAuthKey(v string) *NewBGPPeer {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewBGPPeer) SetCustomerAddress(v string) *NewBGPPeer {
	s.CustomerAddress = &v
	return s
}

// A structure containing information about a new private virtual interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPrivateVirtualInterface
type NewPrivateVirtualInterface struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPrivateVirtualInterface"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPrivateVirtualInterface) SetAddressFamily(v string) *NewPrivateVirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPrivateVirtualInterface) SetAmazonAddress(v string) *NewPrivateVirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPrivateVirtualInterface) SetAsn(v int64) *NewPrivateVirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPrivateVirtualInterface) SetAuthKey(v string) *NewPrivateVirtualInterface {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPrivateVirtualInterface) SetCustomerAddress(v string) *NewPrivateVirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *NewPrivateVirtualInterface) SetDirectConnectGatewayId(v string) *NewPrivateVirtualInterface {
	s.DirectConnectGatewayId = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *NewPrivateVirtualInterface) SetVirtualGatewayId(v string) *NewPrivateVirtualInterface {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPrivateVirtualInterface) SetVirtualInterfaceName(v string) *NewPrivateVirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPrivateVirtualInterface) SetVlan(v int64) *NewPrivateVirtualInterface {
	s.Vlan = &v
	return s
}

// A structure containing information about a private virtual interface that
// will be provisioned on a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPrivateVirtualInterfaceAllocation
type NewPrivateVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterfaceAllocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPrivateVirtualInterfaceAllocation"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAddressFamily(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAmazonAddress(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAsn(v int64) *NewPrivateVirtualInterfaceAllocation {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAuthKey(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetCustomerAddress(v string) *NewPrivateVirtualInterfaceAllocation {
	s.CustomerAddress = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetVirtualInterfaceName(v string) *NewPrivateVirtualInterfaceAllocation {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetVlan(v int64) *NewPrivateVirtualInterfaceAllocation {
	s.Vlan = &v
	return s
}

// A structure containing information about a new public virtual interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPublicVirtualInterface
type NewPublicVirtualInterface struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPublicVirtualInterface"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPublicVirtualInterface) SetAddressFamily(v string) *NewPublicVirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPublicVirtualInterface) SetAmazonAddress(v string) *NewPublicVirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPublicVirtualInterface) SetAsn(v int64) *NewPublicVirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPublicVirtualInterface) SetAuthKey(v string) *NewPublicVirtualInterface {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPublicVirtualInterface) SetCustomerAddress(v string) *NewPublicVirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *NewPublicVirtualInterface) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *NewPublicVirtualInterface {
	s.RouteFilterPrefixes = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPublicVirtualInterface) SetVirtualInterfaceName(v string) *NewPublicVirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPublicVirtualInterface) SetVlan(v int64) *NewPublicVirtualInterface {
	s.Vlan = &v
	return s
}

// A structure containing information about a public virtual interface that
// will be provisioned on a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPublicVirtualInterfaceAllocation
type NewPublicVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterfaceAllocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPublicVirtualInterfaceAllocation"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAddressFamily(v string) *NewPublicVirtualInterfaceAllocation {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAmazonAddress(v string) *NewPublicVirtualInterfaceAllocation {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAsn(v int64) *NewPublicVirtualInterfaceAllocation {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAuthKey(v string) *NewPublicVirtualInterfaceAllocation {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetCustomerAddress(v string) *NewPublicVirtualInterfaceAllocation {
	s.CustomerAddress = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *NewPublicVirtualInterfaceAllocation {
	s.RouteFilterPrefixes = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetVirtualInterfaceName(v string) *NewPublicVirtualInterfaceAllocation {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetVlan(v int64) *NewPublicVirtualInterfaceAllocation {
	s.Vlan = &v
	return s
}

// The tags associated with a Direct Connect resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ResourceTag
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Direct Connect resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The tags.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTag) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceTag) SetResourceArn(v string) *ResourceTag {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceTag) SetTags(v []*Tag) *ResourceTag {
	s.Tags = v
	return s
}

// A route filter prefix that the customer can advertise through Border Gateway
// Protocol (BGP) over a public virtual interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/RouteFilterPrefix
type RouteFilterPrefix struct {
	_ struct{} `type:"structure"`

	// CIDR notation for the advertised route. Multiple routes are separated by
	// commas.
	//
	// IPv6 CIDRs must be at least a /64 or shorter
	//
	// Example: 10.10.10.0/24,10.10.11.0/24,2001:db8::/64
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s RouteFilterPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteFilterPrefix) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *RouteFilterPrefix) SetCidr(v string) *RouteFilterPrefix {
	s.Cidr = &v
	return s
}

// Information about a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the TagResource operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResourceRequest
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Direct Connect resource.
	//
	// Example: arn:aws:directconnect:us-east-1:123456789012:dxcon/dxcon-fg5678gh
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The list of tags to add.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

// The response received when TagResource is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResourceResponse
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the UntagResource operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResourceRequest
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Direct Connect resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The response received when UntagResource is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResourceResponse
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the UpdateLag operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLagRequest
type UpdateLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG to update.
	//
	// Example: dxlag-abc123
	//
	// Default: None
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`

	// The name for the LAG.
	//
	// Example: "3x10G LAG to AWS"
	//
	// Default: None
	LagName *string `locationName:"lagName" type:"string"`

	// The minimum number of physical connections that must be operational for the
	// LAG itself to be operational.
	//
	// Default: None
	MinimumLinks *int64 `locationName:"minimumLinks" type:"integer"`
}

// String returns the string representation
func (s UpdateLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLagInput"}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLagId sets the LagId field's value.
func (s *UpdateLagInput) SetLagId(v string) *UpdateLagInput {
	s.LagId = &v
	return s
}

// SetLagName sets the LagName field's value.
func (s *UpdateLagInput) SetLagName(v string) *UpdateLagInput {
	s.LagName = &v
	return s
}

// SetMinimumLinks sets the MinimumLinks field's value.
func (s *UpdateLagInput) SetMinimumLinks(v int64) *UpdateLagInput {
	s.MinimumLinks = &v
	return s
}

// You can create one or more AWS Direct Connect private virtual interfaces
// linking to your virtual private gateway.
//
// Virtual private gateways can be managed using the Amazon Virtual Private
// Cloud (Amazon VPC) console or the Amazon EC2 CreateVpnGateway action (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualGateway
type VirtualGateway struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// State of the virtual private gateway.
	//
	//    * Pending: This is the initial state after calling CreateVpnGateway.
	//
	//    * Available: Ready for use by a private virtual interface.
	//
	//    * Deleting: This is the initial state after calling DeleteVpnGateway.
	//
	//    * Deleted: In this state, a private virtual interface is unable to send
	//    traffic over this gateway.
	VirtualGatewayState *string `locationName:"virtualGatewayState" type:"string"`
}

// String returns the string representation
func (s VirtualGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualGateway) GoString() string {
	return s.String()
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *VirtualGateway) SetVirtualGatewayId(v string) *VirtualGateway {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualGatewayState sets the VirtualGatewayState field's value.
func (s *VirtualGateway) SetVirtualGatewayState(v string) *VirtualGateway {
	s.VirtualGatewayState = &v
	return s
}

// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
// location and the customer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualInterface
type VirtualInterface struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system number (ASN) for the Amazon side of the connection.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// A list of the BGP peers configured on this virtual interface.
	BgpPeers []*BGPPeer `locationName:"bgpPeers" type:"list"`

	// The ID of the connection. This field is also used as the ID type for operations
	// that use multiple connection types (LAG, interconnect, and/or connection).
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// Information for generating the customer router configuration.
	CustomerRouterConfig *string `locationName:"customerRouterConfig" type:"string"`

	// The ID of the direct connect gateway.
	//
	// Example: "abcd1234-dcba-5678-be23-cdef9876ab45"
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The AWS account that will own the new virtual interface.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	// The type of virtual interface.
	//
	// Example: private (Amazon VPC) or public (Amazon S3, Amazon DynamoDB, and
	// so on.)
	VirtualInterfaceType *string `locationName:"virtualInterfaceType" type:"string"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s VirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualInterface) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *VirtualInterface) SetAddressFamily(v string) *VirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *VirtualInterface) SetAmazonAddress(v string) *VirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *VirtualInterface) SetAmazonSideAsn(v int64) *VirtualInterface {
	s.AmazonSideAsn = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *VirtualInterface) SetAsn(v int64) *VirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *VirtualInterface) SetAuthKey(v string) *VirtualInterface {
	s.AuthKey = &v
	return s
}

// SetBgpPeers sets the BgpPeers field's value.
func (s *VirtualInterface) SetBgpPeers(v []*BGPPeer) *VirtualInterface {
	s.BgpPeers = v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *VirtualInterface) SetConnectionId(v string) *VirtualInterface {
	s.ConnectionId = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *VirtualInterface) SetCustomerAddress(v string) *VirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetCustomerRouterConfig sets the CustomerRouterConfig field's value.
func (s *VirtualInterface) SetCustomerRouterConfig(v string) *VirtualInterface {
	s.CustomerRouterConfig = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *VirtualInterface) SetDirectConnectGatewayId(v string) *VirtualInterface {
	s.DirectConnectGatewayId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *VirtualInterface) SetLocation(v string) *VirtualInterface {
	s.Location = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *VirtualInterface) SetOwnerAccount(v string) *VirtualInterface {
	s.OwnerAccount = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *VirtualInterface) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *VirtualInterface {
	s.RouteFilterPrefixes = v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *VirtualInterface) SetVirtualGatewayId(v string) *VirtualInterface {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *VirtualInterface) SetVirtualInterfaceId(v string) *VirtualInterface {
	s.VirtualInterfaceId = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *VirtualInterface) SetVirtualInterfaceName(v string) *VirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *VirtualInterface) SetVirtualInterfaceState(v string) *VirtualInterface {
	s.VirtualInterfaceState = &v
	return s
}

// SetVirtualInterfaceType sets the VirtualInterfaceType field's value.
func (s *VirtualInterface) SetVirtualInterfaceType(v string) *VirtualInterface {
	s.VirtualInterfaceType = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *VirtualInterface) SetVlan(v int64) *VirtualInterface {
	s.Vlan = &v
	return s
}

// Indicates the address family for the BGP peer.
//
//    * ipv4: IPv4 address family
//
//    * ipv6: IPv6 address family
const (
	// AddressFamilyIpv4 is a AddressFamily enum value
	AddressFamilyIpv4 = "ipv4"

	// AddressFamilyIpv6 is a AddressFamily enum value
	AddressFamilyIpv6 = "ipv6"
)

// The state of the BGP peer.
//
//    * Verifying: The BGP peering addresses or ASN require validation before
//    the BGP peer can be created. This state only applies to BGP peers on a
//    public virtual interface.
//
//    * Pending: The BGP peer has been created, and is in this state until it
//    is ready to be established.
//
//    * Available: The BGP peer can be established.
//
//    * Deleting: The BGP peer is in the process of being deleted.
//
//    * Deleted: The BGP peer has been deleted and cannot be established.
const (
	// BGPPeerStateVerifying is a BGPPeerState enum value
	BGPPeerStateVerifying = "verifying"

	// BGPPeerStatePending is a BGPPeerState enum value
	BGPPeerStatePending = "pending"

	// BGPPeerStateAvailable is a BGPPeerState enum value
	BGPPeerStateAvailable = "available"

	// BGPPeerStateDeleting is a BGPPeerState enum value
	BGPPeerStateDeleting = "deleting"

	// BGPPeerStateDeleted is a BGPPeerState enum value
	BGPPeerStateDeleted = "deleted"
)

// The Up/Down state of the BGP peer.
//
//    * Up: The BGP peer is established.
//
//    * Down: The BGP peer is down.
const (
	// BGPStatusUp is a BGPStatus enum value
	BGPStatusUp = "up"

	// BGPStatusDown is a BGPStatus enum value
	BGPStatusDown = "down"
)

// State of the connection.
//
//    * Ordering: The initial state of a hosted connection provisioned on an
//    interconnect. The connection stays in the ordering state until the owner
//    of the hosted connection confirms or declines the connection order.
//
//    * Requested: The initial state of a standard connection. The connection
//    stays in the requested state until the Letter of Authorization (LOA) is
//    sent to the customer.
//
//    * Pending: The connection has been approved, and is being initialized.
//
//    * Available: The network link is up, and the connection is ready for use.
//
//    * Down: The network link is down.
//
//    * Deleting: The connection is in the process of being deleted.
//
//    * Deleted: The connection has been deleted.
//
//    * Rejected: A hosted connection in the 'Ordering' state will enter the
//    'Rejected' state if it is deleted by the end customer.
const (
	// ConnectionStateOrdering is a ConnectionState enum value
	ConnectionStateOrdering = "ordering"

	// ConnectionStateRequested is a ConnectionState enum value
	ConnectionStateRequested = "requested"

	// ConnectionStatePending is a ConnectionState enum value
	ConnectionStatePending = "pending"

	// ConnectionStateAvailable is a ConnectionState enum value
	ConnectionStateAvailable = "available"

	// ConnectionStateDown is a ConnectionState enum value
	ConnectionStateDown = "down"

	// ConnectionStateDeleting is a ConnectionState enum value
	ConnectionStateDeleting = "deleting"

	// ConnectionStateDeleted is a ConnectionState enum value
	ConnectionStateDeleted = "deleted"

	// ConnectionStateRejected is a ConnectionState enum value
	ConnectionStateRejected = "rejected"
)

// State of the direct connect gateway association.
//
//    * Associating: The initial state after calling CreateDirectConnectGatewayAssociation.
//
//    * Associated: The direct connect gateway and virtual private gateway are
//    successfully associated and ready to pass traffic.
//
//    * Disassociating: The initial state after calling DeleteDirectConnectGatewayAssociation.
//
//    * Disassociated: The virtual private gateway is successfully disassociated
//    from the direct connect gateway. Traffic flow between the direct connect
//    gateway and virtual private gateway stops.
const (
	// GatewayAssociationStateAssociating is a GatewayAssociationState enum value
	GatewayAssociationStateAssociating = "associating"

	// GatewayAssociationStateAssociated is a GatewayAssociationState enum value
	GatewayAssociationStateAssociated = "associated"

	// GatewayAssociationStateDisassociating is a GatewayAssociationState enum value
	GatewayAssociationStateDisassociating = "disassociating"

	// GatewayAssociationStateDisassociated is a GatewayAssociationState enum value
	GatewayAssociationStateDisassociated = "disassociated"
)

// State of the direct connect gateway attachment.
//
//    * Attaching: The initial state after a virtual interface is created using
//    the direct connect gateway.
//
//    * Attached: The direct connect gateway and virtual interface are successfully
//    attached and ready to pass traffic.
//
//    * Detaching: The initial state after calling DeleteVirtualInterface on
//    a virtual interface that is attached to a direct connect gateway.
//
//    * Detached: The virtual interface is successfully detached from the direct
//    connect gateway. Traffic flow between the direct connect gateway and virtual
//    interface stops.
const (
	// GatewayAttachmentStateAttaching is a GatewayAttachmentState enum value
	GatewayAttachmentStateAttaching = "attaching"

	// GatewayAttachmentStateAttached is a GatewayAttachmentState enum value
	GatewayAttachmentStateAttached = "attached"

	// GatewayAttachmentStateDetaching is a GatewayAttachmentState enum value
	GatewayAttachmentStateDetaching = "detaching"

	// GatewayAttachmentStateDetached is a GatewayAttachmentState enum value
	GatewayAttachmentStateDetached = "detached"
)

// State of the direct connect gateway.
//
//    * Pending: The initial state after calling CreateDirectConnectGateway.
//
//    * Available: The direct connect gateway is ready for use.
//
//    * Deleting: The initial state after calling DeleteDirectConnectGateway.
//
//    * Deleted: The direct connect gateway is deleted and cannot pass traffic.
const (
	// GatewayStatePending is a GatewayState enum value
	GatewayStatePending = "pending"

	// GatewayStateAvailable is a GatewayState enum value
	GatewayStateAvailable = "available"

	// GatewayStateDeleting is a GatewayState enum value
	GatewayStateDeleting = "deleting"

	// GatewayStateDeleted is a GatewayState enum value
	GatewayStateDeleted = "deleted"
)

// State of the interconnect.
//
//    * Requested: The initial state of an interconnect. The interconnect stays
//    in the requested state until the Letter of Authorization (LOA) is sent
//    to the customer.
//
//    * Pending: The interconnect has been approved, and is being initialized.
//
//    * Available: The network link is up, and the interconnect is ready for
//    use.
//
//    * Down: The network link is down.
//
//    * Deleting: The interconnect is in the process of being deleted.
//
//    * Deleted: The interconnect has been deleted.
const (
	// InterconnectStateRequested is a InterconnectState enum value
	InterconnectStateRequested = "requested"

	// InterconnectStatePending is a InterconnectState enum value
	InterconnectStatePending = "pending"

	// InterconnectStateAvailable is a InterconnectState enum value
	InterconnectStateAvailable = "available"

	// InterconnectStateDown is a InterconnectState enum value
	InterconnectStateDown = "down"

	// InterconnectStateDeleting is a InterconnectState enum value
	InterconnectStateDeleting = "deleting"

	// InterconnectStateDeleted is a InterconnectState enum value
	InterconnectStateDeleted = "deleted"
)

// The state of the LAG.
//
//    * Requested: The initial state of a LAG. The LAG stays in the requested
//    state until the Letter of Authorization (LOA) is available.
//
//    * Pending: The LAG has been approved, and is being initialized.
//
//    * Available: The network link is established, and the LAG is ready for
//    use.
//
//    * Down: The network link is down.
//
//    * Deleting: The LAG is in the process of being deleted.
//
//    * Deleted: The LAG has been deleted.
const (
	// LagStateRequested is a LagState enum value
	LagStateRequested = "requested"

	// LagStatePending is a LagState enum value
	LagStatePending = "pending"

	// LagStateAvailable is a LagState enum value
	LagStateAvailable = "available"

	// LagStateDown is a LagState enum value
	LagStateDown = "down"

	// LagStateDeleting is a LagState enum value
	LagStateDeleting = "deleting"

	// LagStateDeleted is a LagState enum value
	LagStateDeleted = "deleted"
)

// A standard media type indicating the content type of the LOA-CFA document.
// Currently, the only supported value is "application/pdf".
//
// Default: application/pdf
const (
	// LoaContentTypeApplicationPdf is a LoaContentType enum value
	LoaContentTypeApplicationPdf = "application/pdf"
)

// State of the virtual interface.
//
//    * Confirming: The creation of the virtual interface is pending confirmation
//    from the virtual interface owner. If the owner of the virtual interface
//    is different from the owner of the connection on which it is provisioned,
//    then the virtual interface will remain in this state until it is confirmed
//    by the virtual interface owner.
//
//    * Verifying: This state only applies to public virtual interfaces. Each
//    public virtual interface needs validation before the virtual interface
//    can be created.
//
//    * Pending: A virtual interface is in this state from the time that it
//    is created until the virtual interface is ready to forward traffic.
//
//    * Available: A virtual interface that is able to forward traffic.
//
//    * Down: A virtual interface that is BGP down.
//
//    * Deleting: A virtual interface is in this state immediately after calling
//    DeleteVirtualInterface until it can no longer forward traffic.
//
//    * Deleted: A virtual interface that cannot forward traffic.
//
//    * Rejected: The virtual interface owner has declined creation of the virtual
//    interface. If a virtual interface in the 'Confirming' state is deleted
//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
//    state.
const (
	// VirtualInterfaceStateConfirming is a VirtualInterfaceState enum value
	VirtualInterfaceStateConfirming = "confirming"

	// VirtualInterfaceStateVerifying is a VirtualInterfaceState enum value
	VirtualInterfaceStateVerifying = "verifying"

	// VirtualInterfaceStatePending is a VirtualInterfaceState enum value
	VirtualInterfaceStatePending = "pending"

	// VirtualInterfaceStateAvailable is a VirtualInterfaceState enum value
	VirtualInterfaceStateAvailable = "available"

	// VirtualInterfaceStateDown is a VirtualInterfaceState enum value
	VirtualInterfaceStateDown = "down"

	// VirtualInterfaceStateDeleting is a VirtualInterfaceState enum value
	VirtualInterfaceStateDeleting = "deleting"

	// VirtualInterfaceStateDeleted is a VirtualInterfaceState enum value
	VirtualInterfaceStateDeleted = "deleted"

	// VirtualInterfaceStateRejected is a VirtualInterfaceState enum value
	VirtualInterfaceStateRejected = "rejected"
)
